static char dqs_start_PVM_rcsid[]="$Id: dqs_start_PVM.c,v 1.1.1.1 1998/08/18 14:39:13 green Exp $";

/*----------------------------------------------------
 * dqs_start_PVM.c Neil Lincoln Mon Jan  18 16:10:07 CST 1995
 *
 * Copyright 1995
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * Aug 1995, Michael Gates increased support to do PVM cleanup prior to
 * the job, and to start the daemons for the user. This works for PVM
 * versions 3.2 and 3.3, and requires a companion script called
 * pvmcleanup to exist in conf.dqs_bin directory. The macro PVM_ROOT
 * needs to be defined in SRC/dqs.h. It should point to the directory
 * where PVM is installed on the platform for which DQS is being
 * compiled.
 *
 
 * $Log: dqs_start_PVM.c,v $
 * Revision 1.1.1.1  1998/08/18 14:39:13  green
 * DQS 3.2.0.5 WIP Import
 *
 * Revision 1.2  1997/08/08 15:17:15  decker
 * Added David Geldreich Patch:
 *
 * Revision 1.1.1.1  1997/04/10 15:10:34  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.4  1996/11/20 23:04:33  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.3  1996/06/17  02:29:12  nrl
 * Updtaes from Guntram Wolski, Ron Lee, John Makosky and
 * Bodo Beckebach
 *
 * Revision 3.2  1995/02/19  22:37:53  nrl
 * Simplified pvm and tcgmsg interface to a minimalist scheme requiring
 * user scripts to start the daemons
 *
 * Revision 3.1  1995/02/17  02:58:53  nrl
 * Subroutine skeletons for PVM and TCGMSG modes
 *
 *
 *--------------------------------------------------*/


#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"
#include "prognames.h"


/************************************************************************/
void dqs_start_PVM(shell_path,job,queue)
     char           *shell_path;
     dqs_job_type   *job;
     dqs_queue_type *queue;
     
     /*
       dqs_start_PVM - is used soley by the dqs_execd.
       
       this routine is responsible for starting the remote PVM processes
       prior to the execl of the "master" script.
       
     */
     
{
  
  string        tmpstr, cmdstr, tmpstr1;
  dqs_list_type *lp;
  FILE *pvmpipe;
  
  DENTER((DQS_EVENT,"dqs_start_PVM"));
  
  
  
  lp=job->granted_destin_identifier_list;
  
  if (!job->granted_destin_identifier_list->str3)
    job->granted_destin_identifier_list->str3=dqs_malloc(MAX_STRING_SIZE);
  
  strcpy(job->granted_destin_identifier_list->str3," -pvmhosts");
  strcpy(tmpstr,"");
  
  while (lp)
    {
      strcat(job->granted_destin_identifier_list->str3," ");
      strcat(job->granted_destin_identifier_list->str3,lp->str1);
      
      if (lp != job->granted_destin_identifier_list){
	strcat(tmpstr," ");
	strcat(tmpstr,lp->str1);
      }
      lp=lp->next;
    }
  
  /* This prevents the reaper from being called when the pipes below
     are closed (sigcld_ovec is the original handler). */
  
  sigaction(SIGCHLD,&sigcld_ovec,&sigcld_vec);
  
  /* Clean up any debris from previous pvm sessions on the chosen
     machines. */
  
  DTRACE;
  sprintf(cmdstr,"/bin/sh -c \"%s/pvmcleanup.sh %s\"",
	  conf.dqs_bin,job->granted_destin_identifier_list->str3);
  DPRINTF((DQS_EVENT,"dqs_start_PVM(): cmdstr=%s",cmdstr));
  
  pvmpipe = popen(cmdstr,"w");
  fflush(pvmpipe);				/* Flush the stream */
  pclose(pvmpipe);
  
  /* Start pvm via it's own console program. */
  
  dqs_setenv("PVM_ROOT=",PVM_ROOT,1);
  DPRINTF((DQS_EVENT,"dqs_start_PVM(): PVM_ROOT=%s",PVM_ROOT));
  sprintf(tmpstr1,"%s/lib/pvmd", PVM_ROOT);
  /*The rest of patch from David Geldreich*/
  dqs_setenv("PVM_DPATH=",tmpstr1,1);
  /*Start PVM Daemon directly to get the master hostname right on mult network computer*/
  sprintf(cmdstr,"%s/lib/pvmd -n%s &",PVM_ROOT,
	  job->granted_destin_identifier_list->str1);
  system(cmdstr);
  sleep(1);
  /*End of Patch*/
  dqs_setenv("PVM_DPATH=", tmpstr1, 1);
  
  sprintf(cmdstr,"%s/lib/pvm",PVM_ROOT);
  DPRINTF((DQS_EVENT,"dqs_start_PVM(): cmdstr=%s",cmdstr));
  
  pvmpipe = popen(cmdstr,"w");
  DPRINTF((DQS_EVENT,"add %s",tmpstr));
  fprintf(pvmpipe,"add %s",tmpstr);
  fflush(pvmpipe);				/* Flush the stream */
  pclose(pvmpipe);
  
  
  DEXIT;
  return;
  
}
