/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Routine:
  AFdataio.h

Description:
  Function prototypes for the TSP library AF data I/O internal routines

Author / revision:
  P. Kabal  Copyright (C) 1997
  $Revision: 1.6 $  $Date: 1997/10/15 12:16:26 $

----------------------------------------------------------------------*/

#ifndef AFdataio_h_
#define AFdataio_h_

#include <stdio.h>	/* typedef for FILE */

#ifdef __STDC__
#  define p_(params)	params
#else
#  define const				/* Define const for K&R C */
#  define p_(params)	()
#endif

#ifndef	AFILE_t_
#  define AFILE_t_
typedef struct AF_filepar AFILE;	/* Audio file parameters */
#endif

#include <limits.h>
#define AF_SEEK_END	LONG_MIN	/* Used as a flag to AFseek */

#ifdef __cplusplus
extern "C" {
#endif

char *
AFgetLine p_((FILE *fp, int *ErrCode));
int
AFquant p_((double x, const float Xq[], int Nreg));
int
AFrdAlaw p_((AFILE *AFp, float Fbuff[], int Nreq));
int
AFrdF4 p_((AFILE *AFp, float Fbuff[], int Nreq));
int
AFrdF8 p_((AFILE *AFp, float Fbuff[], int Nreq));
int
AFrdI1 p_((AFILE *AFp, float Fbuff[], int Nreq));
int
AFrdI2 p_((AFILE *AFp, float Fbuff[], int Nreq));
int
AFrdMulaw p_((AFILE *AFp, float Fbuff[], int Nreq));
int
AFrdTA p_((AFILE *AFp, float Fbuff[], int Nreq));
int
AFrdU1 p_((AFILE *AFp, float Fbuff[], int Nreq));
int
AFseek p_((FILE *fp, long int pos, int *ErrCode));
long int
AFtell p_((FILE *fp, int *ErrCode));
int
AFwrAlaw p_((AFILE *AFp, const float Fbuff[], int Nval));
int
AFwrF4 p_((AFILE *AFp, const float Fbuff[], int Nval));
int
AFwrF8 p_((AFILE *AFp, const float Fbuff[], int Nval));
int
AFwrI1 p_((AFILE *AFp, const float Fbuff[], int Nval));
int
AFwrI2 p_((AFILE *AFp, const float Fbuff[], int Nval));
int
AFwrMulaw p_((AFILE *AFp, const float Fbuff[], int Nval));
int
AFwrTA p_((AFILE *AFp, const float Fbuff[], int Nval));
int
AFwrU1 p_((AFILE *AFp, const float Fbuff[], int Nval));
int
AFwrite p_((FILE *fp, const void *Buf, int Size, int Nv, int *ErrCode));

#ifdef __cplusplus
}
#endif

#endif /* AFdataio_h_ */
