/*
 *   mwmparse.h
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#ifndef MW_MWMPARSE
#define MW_MWMPARSE
  #define DISCRIM_FILENAME "MCIPHONE.DRV"
  #define  MWM_ENTRY  FAR PASCAL

#include <mwave.h>
#include <unidiags.h>
#include <string.h>
#include <stdio.h>
#include <meio_api.h>
#include <mhandles.h>
#include <stdlib.h>
#include <ctype.h>



#define CURRENT_PRF_VERSION          4        /*$1 current .prf file version*/
#define CURRENT_PRF_MAJOR_RELEASE    0        /*$1 current .prf maj release*/
#define CURRENT_PRF_MINOR_RELEASE    3        /*$1 current .prf min release*/

#define DEFAULT_S7_VALUE            90        /* Default Carrier Wait Time*/
#define DEFAULT_S32_VALUE           17        /* Default XON character*/
#define DEFAULT_S33_VALUE           19        /* Default XOFF character*/
#define DEFAULT_WCOMMAND_VALUE      1         /* Default ATW value*/
#define DEFAULT_PLUSA8E_0_VALUE     1         /*$1 enable v.8 origination negotiation*/
#define DEFAULT_PLUSA8E_1_VALUE     1         /*$1 enable v.8 answer negotiation*/
#define DEFAULT_PLUSA8E_2_VALUE   0x0C1       /*$1 data mode*/
#define DEFAULT_PLUSES_0_VALUE      0         //$1 note:  can we init to 6??? /*$3*/
#define DEFAULT_PLUSES_1_VALUE      0         //$1                            /*$3*/
#define DEFAULT_PLUSES_2_VALUE      0         //$1 note:  can we init to 8??? /*$3*/
#define DEFAULT_PLUSESA_0_VALUE     0         /*$1*/
#define DEFAULT_PLUSESA_1_VALUE     0         /*$1*/
#define DEFAULT_PLUSESA_2_VALUE     0         /*$1*/
#define DEFAULT_PLUSESA_3_VALUE     0         /*$1*/
#define DEFAULT_PLUSESA_4_VALUE     0         /*$1*/
#define DEFAULT_PLUSESA_5_VALUE     0         /*$1*/
#define DEFAULT_PLUSESA_6_VALUE   0xFF        /*$1*/
#define DEFAULT_PLUSESA_7_VALUE   0xFF        /*$1*/
#define DEFAULT_PLUSITF_0_VALUE   154         /*$1 80% of transmit buffer (uart + mac gpcs)*/
#define DEFAULT_PLUSITF_1_VALUE    38         /*$1 20% of transmit buffer (uare + mac gpcs)*/
#define DEFAULT_PLUSITF_2_VALUE     0         /*$1*/
#define DEFAULT_PLUSIBC_0_VALUE     0         /*$1*/

#define PLUS_A8E_PARMS_SUPPORTED    3         /*$2*/
#define PLUS_ES_PARMS_SUPPORTED     3         /*$2*/
#define PLUS_ESA_PARMS_SUPPORTED    8         /*$2 $?*/
#define PLUS_IBC_PARMS_SUPPORTED    1         /*$2*/
#define PLUS_ITF_PARMS_SUPPORTED    3         /*$2*/

typedef struct                    /*$1*/
{
  USHORT       usFCLASS;
  USHORT       usReserved[5];     /*$2*/
  USHORT       usSubclass;
} MWM_FCLASS_SUBCLASS, *PMWM_FCLASS_SUBCLASS;

/*****************************************************************************/
/* Include the constants used in the messages.  The command parser doesn't   */
/* contain the messages, instead, it Sends a message to the APP asking it    */
/* to retrieve and display a specific message.                               */
/*****************************************************************************/
#include <mwmmsg.h>

/*****************************************************************************/
/* Constants for messages to calling window or dialog procedures.            */
/*****************************************************************************/
#define WM_MWMPARSERERROR          WM_USER+1
#define WM_MWM_MODEM_IPC           WM_USER+2
#define WM_MWM_PARSER_CALLBACK     WM_USER+3
#define WM_MWM_SPEAKERCHANGE       WM_USER+4
#define WM_MWM_UPDATE_STATUS       WM_USER+5  /* DCR 2922 (for modem status text)*/
#define WM_MWM_DISCRIM_STATUS      WM_USER+6
#define WM_MWM_ERROR               WM_USER+7
#define WM_MWM_V34_IPC             WM_USER+8
#define WM_MWM_DEBUG_MESSAGE       WM_USER+9
#define WM_MWM_VOLTAGE_ERROR       WM_USER+10
#define WM_MWM_TABLE_CHANGED       WM_USER+11
#define WM_MWM_POUNDUD_UPDATE      WM_USER+12
#define MWM_LAST_PARSER_MSG_NUM    WM_USER+12


/*****************************************************************************/
/* Error structure for passing messages from the LIB (command parser) to     */
/* the APP.                                                                 */
/*****************************************************************************/
typedef struct
{
  ULONG   ulPrimaryCode;
  ULONG   ulSecondaryCode;
  SHORT   sLine;
  char    achFile[MWM_MAX_FILENAME_LENGTH];
} MWMERROR, *PMWMERROR;



/*****************************************************************************/
/* MTS 2416                                                                  */
/* Add status text operators for alternately displaying different things     */
/* on the second line of the modem status window.                            */
/*****************************************************************************/
#define MWM_STATUS_USE_NOTHING           0
#define MWM_STATUS_USE_PROTOCOL          1
#define MWM_STATUS_USE_TEXT_CONSTANT     2
#define MWM_STATUS_USE_FAX_PROTOCOL      3




/*****************************************************************************/
/* MDMCTL Buffer Sizes.                                                      */
/*****************************************************************************/
#define  AT_CMD_BUFFER_SIZE             80
#define  PP_CMD_BUFFER_SIZE            100
#define  PP_BUFFER_THRESHOLD       PP_CMD_BUFFER_SIZE - 3


/*****************************************************************************/
/* mwmParseCallback subcommands.                                             */
/* When mwmParseCallback is called, it needs to know which command it is     */
/* supposed to execute.  This subcommand is passed as mp1 with the message.  */
/* mp2 will be a pointer to the data to work with.                           */
/*****************************************************************************/
#define MWM_WRITE_PROFILE0               1
#define MWM_WRITE_PROFILE1               2
#define MWM_WRITE_PROFILE_TO_LOAD        3
#define MWM_WRITE_PROFILE_PHONE_NUM0     4
#define MWM_WRITE_PROFILE_PHONE_NUM1     5
#define MWM_WRITE_PROFILE_PHONE_NUM2     6
#define MWM_WRITE_PROFILE_PHONE_NUM3     7



/*****************************************************************************/
/* DCR 2487                                                                  */
/* Definitions for various features that should be loaded at startup...      */
/*****************************************************************************/
#define FEATURE_AUTOMODE       0x0007 /* mask for any of the high speed pumps*/
#define FEATURE_V32            0x0001
#define FEATURE_V32BIS         0x0002
#define FEATURE_V32TER         0x0004
#define FEATURE_V34            0x0008
#define FEATURE_DISCRIM        0x0010
#define FEATURE_CLASS2         0x0020
#define FEATURE_MNP            0x0040
#define FEATURE_MNP5           0x0080
#define FEATURE_V42BIS         0x0f00 /* Mask to determine if feature is available*/
#define FEATURE_V42BIS_512     0x0100 /* These say which one to load...*/
#define FEATURE_V42BIS_1024    0x0200 /**/
#define FEATURE_V42BIS_2048    0x0400 /**/
#define FEATURE_V42BIS_4096    0x0800 /**/
#define FEATURE_V42            0x1000
#define FEATURE_MNPPRELOAD     0x2000 /* PRELOADPROBLEM*/
#define FEATURE_SLIMBASE       0x4000  // SLIMBASE               /* MTS=SB*/
#define FEATURE_V80            0x8000 /* V.80 loaded (set in ulFeaturesToLoad) $1*/
#define FEATURE_V8            0x20000 /* V.8 Support*/
#define FEATURE_V42PRELOAD    0x40000 /* Preload V.42 like MNPPRELOAD MTS 4192*/
#define FEATURE_GETSIZE       0x80000 /* Query resource usage (debug) at different load states.*/
#define FEATURE_CLASS1       0x100000 /* Class 1 Fax.*/
#define FEATURE_V23          0x800000 /* V.23*/
#define FEATURE_V34EM       0x1000000 /* V.34 Enhanced Mode*/
#define FEATURE_V32BISSTUB  0x4000000 /* V.32bis Stub Task*/
#define FEATURE_PCM         0x8000000 /* V.PCM*/


/*****************************************************************************/
/* The following constants define which mode the Parser is running.          */
/* Currently, 2 modes are supported, Class 2 Fax, and regular modem.         */
/* These modes are placed in the psi->usParserMode variable depending on     */
/* which type of PP Command we wish the parser to generate.                  */
/*****************************************************************************/
#define MWM_MODE_REGULAR_MODEM       0
#define MWM_MODE_CLASS2_FAX     0x1000



/*****************************************************************************/
/* The following definitions are used by mwmParseQueryModemRegisters to know */
/* how many words to get for each of the storage types.  First, it reads all */
/* of the S-register values, then it reads all of the other values.          */
/* If any registers are added, these values need to be adjusted accordingly. */
/* The values are given in "words".  If you add a USHORT register, then add  */
/* 1 to the value.                                                           */
/*****************************************************************************/
#define  MWM_NUM_S_REGISTERS            30      /*    S0-S29 as before*/
#define  MWM_NUM_V34_REGISTERS          5       /*    S30-S34->S49-S53*/
/**/
#define  MWM_NUM_OTHER_REGISTERS        36      /*$2 $?*/
/*****************************************************************************/
/* Structure to imitate the modem registers.  We could use an array for the  */
/* S Registers, and earlier versions did.  However, this allows retrieval of */
/* ALL S Registers with only one dspMemTransfer.                             */
/*                                                                           */
/*         *** Y O U R   A T T E N T I O N  P L E A S E ! ! ! ***            */
/*                                                                           */
/* When you change the REGISTERS structure please follow these rules:        */
/* 1. Always add fields at the end of the structure.                         */
/* 2. When you add fields to the structure please check to see if there      */
/*    are any elements in the "Reserved" array.  If there are any elements   */
/*    in the "Reserved" array then decrease the number of array elements     */
/*    to compensate exactly for the size of the fields you are adding.  This */
/*    will prevent the size of the structure from growing unnecessarily.     */
/* 3. If there are not enough "Reserved" elements available only then increase    */
/*    the size of the array by simply adding your new field to the end of    */
/*    the structure.  If you must increase the size of the structure to      */
/*    accommodate your new field then it would be a good idea at this time   */
/*    to add new "Reserved" elements (this should rarely be necessary).      */
/* 4. When you increase the number of other register fields you must update  */
/*    MWM_NUM_OTHER_REGISTERS.                                               */
/* 5. To provide default values for any new fields that you add you should   */
/*    update MWMMEM.C.                                                       */
/* 6. If you increase the size of this structure you MUST do the following:  */
/*    6.1 Copy the current structure and rename it to a new name containing  */
/*        the modem profile version with which it is associated.             */
/*    6.2 In MWMPARSE.C modify the mwmParseReadModemProfile routine to       */
/*        convert any existing profiles to the updated structure.            */
/*    6.3 Update the CURRENT_PRF_* values in this file (MWMPARSE.H)          */
/*****************************************************************************/
typedef struct
{
  USHORT    S[MWM_NUM_S_REGISTERS];
  USHORT    SV34[MWM_NUM_V34_REGISTERS];        /* MTS6384 - this array remains*/
                                                /*  remains continguous with S[*/
  USHORT    SlashA;
  USHORT    SlashK;
  USHORT    SlashL;
  USHORT    SlashN;
  USHORT    SlashT;                             /* MTS6384 - S30 updates here*/
  USHORT    PercentA;
  USHORT    PercentC;
  USHORT    QuoteH;
  USHORT    QuoteN;
  USHORT    QuoteO;
  USHORT    AmpN;              /* PTR 592*/
  USHORT    PercentE;
  USHORT    DashJ;             /* DCR 2823*/
  USHORT    SlashQ;            /* MTS 3017*/
  USHORT    DashSSE;
  USHORT    StarTH;            /* MTS 4594  (v3.02 of mwmmem.prf)*/
  USHORT    PoundCID;          /* Caller ID setting 0,1,2*/
  USHORT    PlusA8E[PLUS_A8E_PARMS_SUPPORTED];        /*$2*/
  USHORT    PlusES[PLUS_ES_PARMS_SUPPORTED];          /*$2*/
  USHORT    PlusESA[PLUS_ESA_PARMS_SUPPORTED];        /*$2*/
  USHORT    PlusITF[PLUS_ITF_PARMS_SUPPORTED];        /*$2*/
  USHORT    PlusIBC[PLUS_IBC_PARMS_SUPPORTED];        /*$2*/
  USHORT    DashSDR;           /* distinctive ring setting*/
  USHORT    S32;               /* MTS 6555 - XON Character*/
  USHORT    S33;               /* MTS 6555 - XOFF Character*/
  USHORT    WCommand;          /* Value for ATW command*/
  USHORT    S60;               /* CMVC #915 - a-law/mu-law flag*/
  USHORT    Reserved[17];      /* Add Reserved space...if command is added,           $1*/
                               /* use this reserved space so that older*/
                               /* .prf files won't totally break the system.*/
                               /* This reserved idea is implemented as of v3.02 mwmmem.prf*/
} REGISTERS, *PREGISTERS;

typedef struct
{
  USHORT    S[MWM_NUM_S_REGISTERS];
  USHORT    SV34[MWM_NUM_V34_REGISTERS];        /* MTS6384 - this array remains*/
                                                /*  remains continguous with S[*/
  USHORT    SlashA;
  USHORT    SlashK;
  USHORT    SlashL;
  USHORT    SlashN;
  USHORT    SlashT;                             /* MTS6384 - S30 updates here*/
  USHORT    PercentA;
  USHORT    PercentC;
  USHORT    QuoteH;
  USHORT    QuoteN;
  USHORT    QuoteO;
  USHORT    AmpN;              /* PTR 592*/
  USHORT    PercentE;
  USHORT    DashJ;             /* DCR 2823*/
  USHORT    SlashQ;            /* MTS 3017*/
  USHORT    DashSSE;
  USHORT    StarTH;            /* MTS 4594  (v3.02 of mwmmem.prf)*/
  USHORT    PoundCID;          /* Caller ID setting 0,1,2*/
  USHORT    PlusA8E[PLUS_A8E_PARMS_SUPPORTED];        /*$2*/
  USHORT    PlusES[PLUS_ES_PARMS_SUPPORTED];          /*$2*/
  USHORT    PlusESA[PLUS_ESA_PARMS_SUPPORTED];        /*$2*/
  USHORT    PlusITF[PLUS_ITF_PARMS_SUPPORTED];        /*$2*/
  USHORT    PlusIBC[PLUS_IBC_PARMS_SUPPORTED];        /*$2*/
  USHORT    DashSDR;           /* distinctive ring setting*/
  USHORT    S32;               /* MTS 6555 - XON Character*/
  USHORT    S33;               /* MTS 6555 - XOFF Character*/
  USHORT    Reserved[19];      /* Add Reserved space...if command is added,           $1*/
                               /* use this reserved space so that older*/
                               /* .prf files won't totally break the system.*/
                               /* This reserved idea is implemented as of v3.02 mwmmem.prf*/
} REGISTERS_V400, *PREGISTERS_V400;

typedef struct
{
  USHORT    S[30];
  USHORT    SV34[5];
                                                /*  remains continguous with S[*/
  USHORT    SlashA;
  USHORT    SlashK;
  USHORT    SlashL;
  USHORT    SlashN;
  USHORT    SlashT;                             /* MTS6384 - S30 updates here*/
  USHORT    PercentA;
  USHORT    PercentC;
  USHORT    QuoteH;
  USHORT    QuoteN;
  USHORT    QuoteO;
  USHORT    AmpN;              /* PTR 592*/
  USHORT    PercentE;
  USHORT    DashJ;             /* DCR 2823*/
  USHORT    SlashQ;            /* MTS 3017*/
  USHORT    DashSSE;
  USHORT    StarTH;            /* MTS 4594  (v3.02 of mwmmem.prf)*/
  USHORT    PoundCID;          /* Caller ID setting 0,1,2*/
  USHORT    S32;               /* MTS 6555 - XON Character*/
  USHORT    S33;               /* MTS 6555 - XOFF Character*/
  USHORT    Reserved[7];       /* Add Reserved space...if command is added,*/
                               /* use this reserved space so that older*/
                               /* .prf files won't totally break the system.*/
                               /* This reserved idea is implemented as of v3.02 mwmmem.prf*/
} REGISTERS_V304, *PREGISTERS_V304;

typedef struct
{
  USHORT    S[30];
  USHORT    SV34[5];
                                                /*  remains continguous with S[*/
  USHORT    SlashA;
  USHORT    SlashK;
  USHORT    SlashL;
  USHORT    SlashN;
  USHORT    SlashT;                             /* MTS6384 - S30 updates here*/
  USHORT    PercentA;
  USHORT    PercentC;
  USHORT    QuoteH;
  USHORT    QuoteN;
  USHORT    QuoteO;
  USHORT    AmpN;              /* PTR 592*/
  USHORT    PercentE;
  USHORT    DashJ;             /* DCR 2823*/
  USHORT    SlashQ;            /* MTS 3017*/
  USHORT    DashSSE;
  USHORT    StarTH;            /* MTS 4594  (v3.02 of mwmmem.prf)*/
  USHORT    PoundCID;          /* Caller ID setting 0,1,2*/
  USHORT    Reserved[9];       /* Add Reserved space...if command is added,*/
                               /* use this reserved space so that older*/
                               /* .prf files won't totally break the system.*/
                               /* This reserved idea is implemented as of v3.02 mwmmem.prf*/
} REGISTERS_V303, *PREGISTERS_V303;

/*****************************************************************************/
/* This structure is the Modem's non-volatile memory.  The contents will     */
/* be retrieved from the INI file when the modem is initialized.             */
/* It will be updated when a profile is written, so that the profile need    */
/* not be read again just for retrieval purposes.  In other words, this      */
/* structure is ALWAYS current.                                              */
/*****************************************************************************/
typedef struct
{
  /***************************************************************************/
  /* The elements of this array are to be filled in as follows:              */
  /*                                                                         */
  /*  0 - Information from Profile 0                                         */
  /*  1 - Information from Profile 1                                         */
  /*  2 - Factory Defaults                                                   */
  /*  3 - Current Settings                                                   */
  /***************************************************************************/
  USHORT     usVersion;
  USHORT     usMajorRelease;
  USHORT     usMinorRelease;
  REGISTERS  aStoredRegs[4];
  char       aachStoredNumbers[4][AT_CMD_BUFFER_SIZE];
  USHORT     usStartupProfile;
} MODEMMEMORY, *PMODEMMEMORY;

typedef struct
{
  /***************************************************************************/
  /* The elements of this array are to be filled in as follows:              */
  /*                                                                         */
  /*  0 - Information from Profile 0                                         */
  /*  1 - Information from Profile 1                                         */
  /*  2 - Factory Defaults                                                   */
  /*  3 - Current Settings                                                   */
  /***************************************************************************/
  USHORT     usVersion;
  USHORT     usMajorRelease;
  USHORT     usMinorRelease;
  REGISTERS_V400  aStoredRegs[4];
  char       aachStoredNumbers[4][AT_CMD_BUFFER_SIZE];
  USHORT     usStartupProfile;
} MODEMMEMORY_V400, *PMODEMMEMORY_V400;

typedef struct
{
  /***************************************************************************/
  /* The elements of this array are to be filled in as follows:              */
  /*                                                                         */
  /*  0 - Information from Profile 0                                         */
  /*  1 - Information from Profile 1                                         */
  /*  2 - Factory Defaults                                                   */
  /*  3 - Current Settings                                                   */
  /***************************************************************************/
  USHORT     usVersion;
  USHORT     usMajorRelease;
  USHORT     usMinorRelease;
  REGISTERS_V304  aStoredRegs[4];
  char       aachStoredNumbers[4][AT_CMD_BUFFER_SIZE];
  USHORT     usStartupProfile;
} MODEMMEMORY_V304, *PMODEMMEMORY_V304;

typedef struct
{
  /***************************************************************************/
  /* The elements of this array are to be filled in as follows:              */
  /*                                                                         */
  /*  0 - Information from Profile 0                                         */
  /*  1 - Information from Profile 1                                         */
  /*  2 - Factory Defaults                                                   */
  /*  3 - Current Settings                                                   */
  /***************************************************************************/
  USHORT     usVersion;
  USHORT     usMajorRelease;
  USHORT     usMinorRelease;
  REGISTERS_V303  aStoredRegs[4];
  char       aachStoredNumbers[4][AT_CMD_BUFFER_SIZE];
  USHORT     usStartupProfile;
} MODEMMEMORY_V303, *PMODEMMEMORY_V303;


#define MWM_VERSION_STRING_LENGTH  40
#define MWM_SPEED_STRING_LENGTH    6

typedef struct
{
  ULONG          ulWTTAF1;     /* World Trade Parms*/
  ULONG          ulWTTAF2;     /* .*/
  ULONG          ulWTTDTADS;   /* . Read at initialization*/
  ULONG          ulWTTDMODE;   /* . and stored so that I don't*/
  ULONG          ulWTTCPM;     /* . call WtQuery routines at*/
  ULONG          ulWTTAMD;     /* . Interrupt Time.*/
  ULONG          ulWTTRNGS;    /* .*/
  ULONG          ulWTTBDWT;    /* .*/
  ULONG          ulWTTBDWTX;   /* .*/
  ULONG          ulWTTCW;      /* .*/
  ULONG          ulWTTCWX;     /* .*/
  ULONG          ulWTTCWD;     /* .*/
  ULONG          ulWTTLCW;     /* .*/
  ULONG          ulWTTLCWX;    /* .*/
  ULONG          ulWTTDTSD;    /* .*/
  ULONG          ulWTT34FBR;   /* .*/
} MWM_WTPARMS, *PMWM_WTPARMS;


extern HANDLE      hModemMutex;
#define MODEM_MUTEX  "Modem_Mutex"
#define MODEM_TIMEOUT      5000

typedef struct {
  UINT uMsg;
  LONG wParam;
  LONG lParam;
} MSG_STRUCT, *PMSG_STRUCT;

ULONG  MWM_ENTRY mwmClss2ParseDCSFrame(USHORT *ausDCSFrame,char *achString, USHORT usDCSFlag);

ULONG  MWM_ENTRY mwmClss1ConvertXratToSpeed(USHORT usXrat); /* MTS 7813*/


/*****************************************************************************/
/* The following routines are exported from mwmparse.c                       */
/*****************************************************************************/
ULONG MWM_ENTRY mwmParseConnectIPC(HMTASK hTask , HIPC *phIPC , USHORT usTaskType);
ULONG MWM_ENTRY mwmParseCallback(ULONG mp1, ULONG mp2);
ULONG MWM_ENTRY mwmParseCleanupParser( VOID );
ULONG MWM_ENTRY mwmParseGetTaskInfo( HMTASK  hMCTLTask, HMTASK hmtProtSupr );
ULONG MWM_ENTRY mwmParseInitializeParser( HWND ulWindowHandle,
                                          PVOID INIFile );
ULONG MWM_ENTRY mwmParseQueryBlacklistStatus(USHORT *pusBlackListStatus);

ULONG MWM_ENTRY mwmParseQueryDebugSettings(USHORT *pusDebugWindow);

ULONG MWM_ENTRY mwmParseQueryHookStatus(USHORT *pusHandsetStatus, USHORT *pusHookStatus);
ULONG MWM_ENTRY mwmParseQueryModemRegisters(REGISTERS *pRegisters);
ULONG MWM_ENTRY mwmParseQueryNumberDialed(char *pszNumberDialed);
ULONG MWM_ENTRY mwmParseQueryParserMode(PUSHORT pusParserMode);
ULONG MWM_ENTRY mwmParseSaveModemRegisters( void );
ULONG MWM_ENTRY mwmParseSetDRVRSTAT(USHORT usValue);
ULONG MWM_ENTRY mwmParseSetFeatures(ULONG ulInstalledFeatures, ULONG ulFeaturesToLoad);
ULONG MWM_ENTRY mwmParseSetModemRegisters(REGISTERS *pRegisters);
ULONG MWM_ENTRY mwmParseSetNumberDialed(char *pszNumberDialed);
ULONG MWM_ENTRY mwmParseSetDCSAddress(ULONG ulDCSAddress);
ULONG MWM_ENTRY mwmParseSetCAPBUFFAddress(ULONG ulCAPBUFFAddress);
ULONG MWM_ENTRY mwmParseSetMYIDAddress(ULONG ulMYIDAddress);
ULONG MWM_ENTRY mwmParseSetMYCIGAddress(ULONG ulMYCIGAddress);
ULONG MWM_ENTRY mwmParseSetFAXERR(USHORT usValue);
ULONG MWM_ENTRY mwmParseSetParserMode(USHORT usParserMode);
ULONG MWM_ENTRY mwmParseSetSpeaker(USHORT usAndMask, USHORT usOrMask);
ULONG MWM_ENTRY mwmParseSetSuspendFlag(USHORT usSuspendFlag);
ULONG MWM_ENTRY mwmParseSetWTChangeFlag(USHORT usWTChangeFlag);
ULONG MWM_ENTRY mwmParseWTChangeFlagValue();
ULONG MWM_ENTRY mwmParseSetWTParms(PMWM_WTPARMS pwt);
ULONG MWM_ENTRY mwmParseSetQuoteN(USHORT usQuoteNValue);
USHORT MWM_ENTRY mwmParseGetWValue(void);
void  MWM_ENTRY mwmParsePostMessage( UINT uMsg, LONG wParam, LONG lParam );
ULONG MWM_ENTRY mwmParseSetADPCMaddr(ULONG, ULONG, ULONG);
void  MWM_ENTRY mwmParseActivateDebugWindow( BOOL bActivateFlag );
void  MWM_ENTRY mwmParseActivateTimeStamp( BOOL bTimeStampFlag );
void  MWM_ENTRY mwmParseSetPipeHandle( HANDLE hPipe );


/* PARSE LIB exports for caller ID */
ULONG MWM_ENTRY mwmCidpInitCid(USHORT bCapability, ULONG ulDspAddrCIDLength, ULONG ulDspAddrCIDData);
ULONG MWM_ENTRY mwmCidpQueryCid(void);

/* PARSE LIB exports for distinctive ring */
ULONG MWM_ENTRY mwmCidpInitDRing(USHORT bCapability);
ULONG MWM_ENTRY mwmCidpQueryDRing(void);

/* PARSE LIB  exports for the Unimodem diagnostic command (#UD) */
BOOL MWM_ENTRY mwmPoundUDFillBuffer(void);
BOOL MWM_ENTRY mwmPoundUDClearCallStatus(BOOL bModemInit);
BOOL MWM_ENTRY mwmPoundUDGetCallStatusBuffer(UNIDIAG* *pUniDiag);

extern USHORT pdbg;
#endif // MW_MWMPARSE
