// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepLib_MakePolygon_HeaderFile
#define _BRepLib_MakePolygon_HeaderFile

#ifndef _TopoDS_Vertex_HeaderFile
#include <TopoDS_Vertex.hxx>
#endif
#ifndef _TopoDS_Edge_HeaderFile
#include <TopoDS_Edge.hxx>
#endif
#ifndef _BRepLib_MakeShape_HeaderFile
#include <BRepLib_MakeShape.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class StdFail_NotDone;
class gp_Pnt;
class TopoDS_Vertex;
class TopoDS_Edge;
class TopoDS_Wire;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Class to build polygonal wires. <br>
//! <br>
//!          A polygonal wire may be build from <br>
//! <br>
//!          - 2,4,3 points. <br>
//! <br>
//!          - 2,3,4 vertices. <br>
//! <br>
//!          - any number of points. <br>
//! <br>
//!          - any number of vertices. <br>
//! <br>
//! <br>
//!          When a point or vertex is added to the  polygon if <br>
//!          it is identic  to the previous  point no  edge  is <br>
//!          built. The method added can be used to test it. <br>
class BRepLib_MakePolygon  : public BRepLib_MakeShape {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates an empty MakePolygon. <br>
Standard_EXPORT BRepLib_MakePolygon();


Standard_EXPORT BRepLib_MakePolygon(const gp_Pnt& P1,const gp_Pnt& P2);


Standard_EXPORT BRepLib_MakePolygon(const gp_Pnt& P1,const gp_Pnt& P2,const gp_Pnt& P3,const Standard_Boolean Close = Standard_False);


Standard_EXPORT BRepLib_MakePolygon(const gp_Pnt& P1,const gp_Pnt& P2,const gp_Pnt& P3,const gp_Pnt& P4,const Standard_Boolean Close = Standard_False);


Standard_EXPORT BRepLib_MakePolygon(const TopoDS_Vertex& V1,const TopoDS_Vertex& V2);


Standard_EXPORT BRepLib_MakePolygon(const TopoDS_Vertex& V1,const TopoDS_Vertex& V2,const TopoDS_Vertex& V3,const Standard_Boolean Close = Standard_False);


Standard_EXPORT BRepLib_MakePolygon(const TopoDS_Vertex& V1,const TopoDS_Vertex& V2,const TopoDS_Vertex& V3,const TopoDS_Vertex& V4,const Standard_Boolean Close = Standard_False);


Standard_EXPORT   void Add(const gp_Pnt& P) ;


Standard_EXPORT   void Add(const TopoDS_Vertex& V) ;

//! Returns  True if  the last   vertex  or point  was <br>
//!          succesfully added. <br>
Standard_EXPORT   Standard_Boolean Added() const;


Standard_EXPORT   void Close() ;


Standard_EXPORT  const TopoDS_Vertex& FirstVertex() const;


Standard_EXPORT  const TopoDS_Vertex& LastVertex() const;

//! Returns the last edge added to the polygon. <br>
//! <br>
Standard_EXPORT  const TopoDS_Edge& Edge() const;
Standard_EXPORT operator TopoDS_Edge() const;


Standard_EXPORT  const TopoDS_Wire& Wire() const;
Standard_EXPORT operator TopoDS_Wire() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopoDS_Vertex myFirstVertex;
TopoDS_Vertex myLastVertex;
TopoDS_Edge myEdge;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
