// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GeomLib_HeaderFile
#define _GeomLib_HeaderFile

#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Geom_BoundedCurve_HeaderFile
#include <Handle_Geom_BoundedCurve.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Geom_BoundedSurface_HeaderFile
#include <Handle_Geom_BoundedSurface.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfReal_HeaderFile
#include <Handle_TColStd_HArray1OfReal.hxx>
#endif
#ifndef _Handle_Geom_BSplineSurface_HeaderFile
#include <Handle_Geom_BSplineSurface.hxx>
#endif
class Geom_Curve;
class gp_Ax2;
class Geom2d_Curve;
class gp_GTrsf2d;
class Adaptor3d_CurveOnSurface;
class Geom_BoundedCurve;
class gp_Pnt;
class gp_Vec;
class Geom_BoundedSurface;
class TColgp_Array1OfPnt;
class gp_Dir;
class TColStd_Array1OfReal;
class TColStd_HArray1OfReal;
class TColStd_SequenceOfReal;
class Adaptor3d_Curve;
class Geom_BSplineSurface;
class GeomLib_Array1OfMat;
class GeomLib_MakeCurvefromApprox;
class GeomLib_Interpolate;
class GeomLib_DenominatorMultiplier;
class GeomLib_CheckBSplineCurve;
class GeomLib_Check2dBSplineCurve;
class GeomLib_IsPlanarSurface;
class GeomLib_Tool;
class GeomLib_PolyFunc;
class GeomLib_LogSample;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Geom    Library.    This   package   provides   an <br>
//!          implementation of  functions for basic computation <br>
//!          on geometric entity from packages Geom and Geom2d. <br>
class GeomLib  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Computes     the  curve  3d    from  package  Geom <br>
//!          corresponding to curve 2d  from package Geom2d, on <br>
//!          the plan defined with the local coordinate system <br>
//!          Position. <br>
Standard_EXPORT static  Handle_Geom_Curve To3d(const gp_Ax2& Position,const Handle(Geom2d_Curve)& Curve2d) ;

//! Computes the    curve    3d  from   package   Geom <br>
//!          corresponding  to the curve  3d from package Geom, <br>
//!          transformed with the transformation <GTrsf> <br>
//!          WARNING : this method may return a null Handle if <br>
//!          it's impossible to compute the transformation of <br>
//!          a curve. It's not implemented when : <br>
//!          1) the curve is an infinite parabola or hyperbola <br>
//!          2) the curve is an offsetcurve <br>
Standard_EXPORT static  Handle_Geom2d_Curve GTransform(const Handle(Geom2d_Curve)& Curve,const gp_GTrsf2d& GTrsf) ;

//! Make the curve Curve2dPtr have the imposed <br>
//!          range First to List the most economic way, <br>
//!          that is if it can change the range without <br>
//!          changing the nature of the curve it will try <br>
//!          to do that. Otherwise it will produce a Bspline <br>
//!          curve that has the required range <br>
Standard_EXPORT static  void SameRange(const Standard_Real Tolerance,const Handle(Geom2d_Curve)& Curve2dPtr,const Standard_Real First,const Standard_Real Last,const Standard_Real RequestedFirst,const Standard_Real RequestedLast,Handle(Geom2d_Curve)& NewCurve2dPtr) ;


Standard_EXPORT static  void BuildCurve3d(const Standard_Real Tolerance,Adaptor3d_CurveOnSurface& CurvePtr,const Standard_Real FirstParameter,const Standard_Real LastParameter,Handle(Geom_Curve)& NewCurvePtr,Standard_Real& MaxDeviation,Standard_Real& AverageDeviation,const GeomAbs_Shape Continuity = GeomAbs_C1,const Standard_Integer MaxDegree = 14,const Standard_Integer MaxSegment = 30) ;


Standard_EXPORT static  void AdjustExtremity(Handle(Geom_BoundedCurve)& Curve,const gp_Pnt& P1,const gp_Pnt& P2,const gp_Vec& T1,const gp_Vec& T2) ;

//! Extends the bounded curve Curve to the point Point. <br>
//! The extension is built: <br>
//! -      at the end of the curve if After equals true, or <br>
//! -      at the beginning of the curve if After equals false. <br>
//!   The extension is performed according to a degree of <br>
//! continuity equal to Cont, which in its turn must be equal to 1, 2 or 3. <br>
//! This function converts the bounded curve Curve into a BSpline curve. <br>
//! Warning <br>
//! -   Nothing is done, and Curve is not modified if Cont is <br>
//!   not equal to 1, 2 or 3. <br>
//! -   It is recommended that the extension should not be <br>
//!   too large with respect to the size of the bounded <br>
//!   curve Curve: Point must not be located too far from <br>
//!   one of the extremities of Curve. <br>
Standard_EXPORT static  void ExtendCurveToPoint(Handle(Geom_BoundedCurve)& Curve,const gp_Pnt& Point,const Standard_Integer Cont,const Standard_Boolean After) ;


//! Extends the bounded surface Surf along one of its <br>
//! boundaries. The chord length of the extension is equal to Length. <br>
//! The direction of the extension is given as: <br>
//! -   the u parametric direction of Surf, if InU equals true,   or <br>
//! -   the v parametric direction of Surf, if InU equals false. <br>
//! In this parametric direction, the extension is built on the side of: <br>
//! -   the last parameter of Surf, if After equals true, or <br>
//! -   the first parameter of Surf, if After equals false. <br>
//! The extension is performed according to a degree of <br>
//! continuity equal to Cont, which in its turn must be equal to 1, 2 or 3. <br>
//! This function converts the bounded surface Surf into a BSpline surface. <br>
//! Warning <br>
//! -   Nothing is done, and Surf is not modified if Cont is <br>
//!   not equal to 1, 2 or 3. <br>
//! -   It is recommended that Length, the size of the <br>
//!   extension should not be too large with respect to the <br>
//!  size of the bounded surface Surf. <br>
//! -   Surf must not be a periodic BSpline surface in the <br>
//!   parametric direction corresponding to the direction of extension. <br>
Standard_EXPORT static  void ExtendSurfByLength(Handle(Geom_BoundedSurface)& Surf,const Standard_Real Length,const Standard_Integer Cont,const Standard_Boolean InU,const Standard_Boolean After) ;

//! Compute   axes of inertia,  of some  points --  -- -- <br>
//!          <Axe>.Location() is the   BaryCentre -- -- --   -- -- <br>
//!          <Axe>.XDirection is the axe of upper inertia -- -- -- <br>
//!          -- <Axe>.Direction is the Normal to the average plane <br>
//!          -- -- -- IsSingular is True if  points are on line -- <br>
//!          Tol is used to determine singular cases. <br>
Standard_EXPORT static  void AxeOfInertia(const TColgp_Array1OfPnt& Points,gp_Ax2& Axe,Standard_Boolean& IsSingular,const Standard_Real Tol = 1.0e-7) ;

//!  Compute principale axes  of  inertia, and dispertion <br>
//!            value  of some  points. <br>
Standard_EXPORT static  void Inertia(const TColgp_Array1OfPnt& Points,gp_Pnt& Bary,gp_Dir& XDir,gp_Dir& YDir,Standard_Real& Xgap,Standard_Real& YGap,Standard_Real& ZGap) ;

//! Warning!  This assume that the InParameter is an increasing sequence <br>
//!          of real number and it will not check for that : Unpredictable <br>
//!          result can happen if this is not satisfied. It is the caller <br>
//!          responsability to check for that property. <br>
Standard_EXPORT static  void RemovePointsFromArray(const Standard_Integer NumPoints,const TColStd_Array1OfReal& InParameters,Handle(TColStd_HArray1OfReal)& OutParameters) ;

//! this  makes sure that there  is at least MinNumPoints <br>
//!          in OutParameters taking into account the parameters in <br>
//!          the InParameters array provided those are in order, <br>
//!          that is the sequence of real in the InParameter is strictly <br>
//!          non decreasing <br>
//! <br>
Standard_EXPORT static  void DensifyArray1OfReal(const Standard_Integer MinNumPoints,const TColStd_Array1OfReal& InParameters,Handle(TColStd_HArray1OfReal)& OutParameters) ;


Standard_EXPORT static  void FuseIntervals(const TColStd_Array1OfReal& Interval1,const TColStd_Array1OfReal& Interval2,TColStd_SequenceOfReal& Fusion,const Standard_Real Confusion = 1.0e-9) ;

//!  this  will compute   the   maximum distance  at  the <br>
//!          parameters  given    in   the Parameters  array    by <br>
//!          evaluating each parameter  the two curves  and taking <br>
//!          the maximum of the evaluated distance <br>
Standard_EXPORT static  void EvalMaxParametricDistance(const Adaptor3d_Curve& Curve,const Adaptor3d_Curve& AReferenceCurve,const Standard_Real Tolerance,const TColStd_Array1OfReal& Parameters,Standard_Real& MaxDistance) ;

//! this will compute the maximum distancef at the parameters <br>
//!          given in the Parameters array by projecting from the Curve <br>
//!          to the reference curve and taking the minimum distance <br>
//!          Than the maximum will be taken on those minimas. <br>
Standard_EXPORT static  void EvalMaxDistanceAlongParameter(const Adaptor3d_Curve& Curve,const Adaptor3d_Curve& AReferenceCurve,const Standard_Real Tolerance,const TColStd_Array1OfReal& Parameters,Standard_Real& MaxDistance) ;

//! Cancel,on the boudaries,the denominator  first derivative <br>
//!          in  the directions wished by the user and set its value to 1. <br>
Standard_EXPORT static  void CancelDenominatorDerivative(Handle(Geom_BSplineSurface)& BSurf,const Standard_Boolean UDirection,const Standard_Boolean VDirection) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class GeomLib_Array1OfMat;
friend class GeomLib_MakeCurvefromApprox;
friend class GeomLib_Interpolate;
friend class GeomLib_DenominatorMultiplier;
friend class GeomLib_CheckBSplineCurve;
friend class GeomLib_Check2dBSplineCurve;
friend class GeomLib_IsPlanarSurface;
friend class GeomLib_Tool;
friend class GeomLib_PolyFunc;
friend class GeomLib_LogSample;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
