// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Graphic3d_Texture2Dplane_HeaderFile
#define _Graphic3d_Texture2Dplane_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Graphic3d_Texture2Dplane_HeaderFile
#include <Handle_Graphic3d_Texture2Dplane.hxx>
#endif

#ifndef _Graphic3d_NameOfTexturePlane_HeaderFile
#include <Graphic3d_NameOfTexturePlane.hxx>
#endif
#ifndef _Graphic3d_Texture2D_HeaderFile
#include <Graphic3d_Texture2D.hxx>
#endif
#ifndef _Handle_Graphic3d_StructureManager_HeaderFile
#include <Handle_Graphic3d_StructureManager.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Graphic3d_NameOfTexture2D_HeaderFile
#include <Graphic3d_NameOfTexture2D.hxx>
#endif
#ifndef _Standard_ShortReal_HeaderFile
#include <Standard_ShortReal.hxx>
#endif
class Graphic3d_StructureManager;


//! This class allows the management of a 2D texture defined from a plane equation <br>
//! Use the SetXXX() methods for positioning the texture as you want. <br>
class Graphic3d_Texture2Dplane : public Graphic3d_Texture2D {

public:
 // Methods PUBLIC
 // 

//!  Creates a texture from a file <br>
Standard_EXPORT Graphic3d_Texture2Dplane(const Handle(Graphic3d_StructureManager)& SM,const Standard_CString FileName);

//!  Creates a texture from a predefined texture name set. <br>
Standard_EXPORT Graphic3d_Texture2Dplane(const Handle(Graphic3d_StructureManager)& SM,const Graphic3d_NameOfTexture2D NOT);

//!  Defines the texture projection plane for texture coordinate S <br>
//! default is <1.0, 0.0, 0.0, 0.0> <br>
Standard_EXPORT   void SetPlaneS(const Standard_ShortReal A,const Standard_ShortReal B,const Standard_ShortReal C,const Standard_ShortReal D) ;

//! Defines the texture projection plane for texture coordinate T <br>
//! default is <0.0, 1.0, 0.0, 0.0> <br>
Standard_EXPORT   void SetPlaneT(const Standard_ShortReal A,const Standard_ShortReal B,const Standard_ShortReal C,const Standard_ShortReal D) ;

//!  Defines the texture projection plane for both S and T texture coordinate <br>
//! default is NOTP_XY meaning: <br>
//!      <1.0, 0.0, 0.0, 0.0> for S <br>
//! and  <0.0, 1.0, 0.0, 0.0> for T <br>
Standard_EXPORT   void SetPlane(const Graphic3d_NameOfTexturePlane APlane) ;

//! Defines the texture scale for the S texture coordinate <br>
//! much easier than recomputing the S plane equation <br>
//! but the result is the same <br>
//! default to 1.0 <br>
Standard_EXPORT   void SetScaleS(const Standard_ShortReal val) ;

//! Defines the texture scale for the T texture coordinate <br>
//! much easier than recompution the T plane equation <br>
//! but the result is the same <br>
//! default to 1.0 <br>
Standard_EXPORT   void SetScaleT(const Standard_ShortReal val) ;

//! Defines the texture translation for the S texture coordinate <br>
//! you can obtain the same effect by modifying the S plane <br>
//! equation but its not easier. <br>
//! default to 0.0 <br>
Standard_EXPORT   void SetTranslateS(const Standard_ShortReal val) ;

//!  Defines the texture translation for the T texture coordinate <br>
//! you can obtain the same effect by modifying the T plane <br>
//! equation but its not easier. <br>
//! default to 0.0 <br>
Standard_EXPORT   void SetTranslateT(const Standard_ShortReal val) ;

//! Sets the rotation angle of the whole texture. <br>
//! the same result might be achieved by recomputing the <br>
//! S and T plane equation but it's not the easiest way... <br>
//! the angle is expressed in degres <br>
//! default is 0.0 <br>
Standard_EXPORT   void SetRotation(const Standard_ShortReal val) ;

//! Returns the current texture plane name or NOTP_UNKNOWN <br>
//! when the plane is user defined. <br>
Standard_EXPORT   Graphic3d_NameOfTexturePlane Plane() const;

//! Returns the current texture plane S equation <br>
Standard_EXPORT   void PlaneS(Standard_ShortReal& A,Standard_ShortReal& B,Standard_ShortReal& C,Standard_ShortReal& D) const;

//! Returns   the current texture plane T equation <br>
Standard_EXPORT   void PlaneT(Standard_ShortReal& A,Standard_ShortReal& B,Standard_ShortReal& C,Standard_ShortReal& D) const;

//! Returns  the current texture S translation value <br>
Standard_EXPORT   void TranslateS(Standard_ShortReal& val) const;

//! Returns the current texture T translation value <br>
Standard_EXPORT   void TranslateT(Standard_ShortReal& val) const;

//! Returns the current texture S scale value <br>
Standard_EXPORT   void ScaleS(Standard_ShortReal& val) const;

//! Returns the current texture T scale value <br>
Standard_EXPORT   void ScaleT(Standard_ShortReal& val) const;

//! Returns the current texture rotation angle <br>
Standard_EXPORT   void Rotation(Standard_ShortReal& val) const;
//Standard_EXPORT ~Graphic3d_Texture2Dplane();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Graphic3d_NameOfTexturePlane myPlaneName;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
