/* MARCIN.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"
#ifdef WNT
#include <MathBase.h>
#else 
#define  __MathBase_API
#endif
/* Subroutine */ __MathBase_API int mmarcin_(ndimax, ndim, ncoeff, crvold, u0, u1, crvnew, 
	iercod)
integer *ndimax, *ndim, *ncoeff;
doublereal *crvold, *u0, *u1, *crvnew;
integer *iercod;
{
    /* System generated locals */
    integer crvold_dim1, crvold_offset, crvnew_dim1, crvnew_offset, i__1, 
	    i__2, i__3;
    doublereal d__1;

    /* Local variables */
    static doublereal x0, x1;
    static integer nd;
    static doublereal tabaux[61];
    static integer ibb;
    static doublereal bid;
    static integer ncf;
    extern /* Subroutine */ int mmveps3_();
    static integer ncj;
    extern integer mnfndeb_();
    extern /* Subroutine */ int maermsg_(), mgenmsg_(), mgsomsg_(), mmcvstd_()
	    , mmcvinv_();
    static doublereal eps3;



/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ********************************************************************** 
*/

/*     FONCTION : */
/*     ---------- */
/*     Creation de la courbe C2(v) definie sur [U0,U1] identique a */
/*     la courbe C1(u) definie sur [-1,1] (changement du parametre */
/*     d' une courbe) avec INVERSION des indices du tableau resultat. */

/*     MOTS CLES : */
/*     ----------- */
/*        LIMITATION GENERALISEE,RESTRICTION,INVERSION,COURBE */

/*     ARGUMENTS D'ENTREE : */
/*     ------------------ */
/*   NDIMAX : Dimensionnement maximal de l' espace. */
/*   NDIM   : Dimension de la courbe. */
/*   NCOEFF : Nbre de coefficients de la courbe. */
/*   CRVOLD : La courbe a limiter. */
/*   U0     : Borne min de l' intervalle de restriction de la courbe. */
/*   U1     : Borne max de l' intervalle de restriction de la courbe. */

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */
/*   CRVNEW : La courbe relimitee, definie dans [U0,U1] et egale a */
/*            CRVOLD definie dans [-1,1]. */
/*   IERCOD : = 0, OK */
/*            =10, Nbre de coeff. <1 ou > 61. */
/*            =13, L' intervalle de variation demande est nul. */

/*     COMMONS UTILISES   : */
/*     ---------------- */

/*     REFERENCES APPELEES   : */
/*     ----------------------- */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */

/* $    HISTORIQUE DES MODIFICATIONS   : */
/*     -------------------------------- */
/*        21-11-1989 : RBD ; Correction Trait. general parametre X1. */
/*        12-04-1989 : RBD ; Creation d' apres MMARC41. */
/* > */
/* ********************************************************************** 
*/

/*   Le nom de la routine */

/*   Tableau auxiliaire des coefficients de X1*T+X0 a */
/*   la puissance N=1 a NCOEFF-1. */


    /* Parameter adjustments */
    crvnew_dim1 = *ndimax;
    crvnew_offset = crvnew_dim1 + 1;
    crvnew -= crvnew_offset;
    crvold_dim1 = *ncoeff;
    crvold_offset = crvold_dim1 + 1;
    crvold -= crvold_offset;

    /* Function Body */
    ibb = mnfndeb_();
    if (ibb >= 2) {
	mgenmsg_("MMARCIN", 7L);
    }

/* On teste au zero machine que l' intervalle d' arrivee n' est pas nul */

    mmveps3_(&eps3);
    if ((d__1 = *u1 - *u0, abs(d__1)) < eps3) {
	*iercod = 13;
	goto L9999;
    }
    *iercod = 0;

/* ********************************************************************** 
*/
/*                CAS OU LE TRAITEMENT NE PEUT ETRE FAIT */
/* ********************************************************************** 
*/
    if (*ncoeff > 61 || *ncoeff < 1) {
	*iercod = 10;
	goto L9999;
    }
/* ********************************************************************** 
*/
/*          SI PAS DE CHANGEMENT DE L' INTERVALLE DE DEFINITION */
/*          (SEULEMENT INVERSION DES INDICES DU TABLEAU CRVOLD) */
/* ********************************************************************** 
*/
    if (*ndim == *ndimax && *u0 == -1. && *u1 == 1.) {
	mmcvinv_(ndim, ncoeff, ndim, &crvold[crvold_offset], &crvnew[
		crvnew_offset]);
	goto L9999;
    }
/* ********************************************************************** 
*/
/*          CAS OU LE NOUVEL INTERVALLE DE DEFINITION EST [0,1] */
/* ********************************************************************** 
*/
    if (*u0 == 0. && *u1 == 1.) {
	mmcvstd_(ncoeff, ndimax, ncoeff, ndim, &crvold[crvold_offset], &
		crvnew[crvnew_offset]);
	goto L9999;
    }
/* ********************************************************************** 
*/
/*                          TRAITEMENT GENERAL */
/* ********************************************************************** 
*/
/* -------------------------- Initialisations --------------------------- 
*/

    x0 = -(*u1 + *u0) / (*u1 - *u0);
    x1 = 2. / (*u1 - *u0);
    i__1 = *ndim;
    for (nd = 1; nd <= i__1; ++nd) {
	crvnew[nd + crvnew_dim1] = crvold[nd * crvold_dim1 + 1];
/* L100: */
    }
    if (*ncoeff == 1) {
	goto L9999;
    }
    tabaux[0] = x0;
    tabaux[1] = x1;

/* ----------------------- Calcul des coeff. de CRVNEW ------------------ 
*/

    i__1 = *ncoeff - 1;
    for (ncf = 2; ncf <= i__1; ++ncf) {

/* ------------ Prise en compte du NCF-ieme coeff. de CRVOLD --------
---- */

	i__2 = ncf - 1;
	for (ncj = 1; ncj <= i__2; ++ncj) {
	    bid = tabaux[ncj - 1];
	    i__3 = *ndim;
	    for (nd = 1; nd <= i__3; ++nd) {
		crvnew[nd + ncj * crvnew_dim1] += crvold[ncf + nd * 
			crvold_dim1] * bid;
/* L400: */
	    }
/* L300: */
	}

	bid = tabaux[ncf - 1];
	i__2 = *ndim;
	for (nd = 1; nd <= i__2; ++nd) {
	    crvnew[nd + ncf * crvnew_dim1] = crvold[ncf + nd * crvold_dim1] * 
		    bid;
/* L500: */
	}

/* --------- Calcul des (NCF+1) coeff. de [X1*t + X0]**(NCF) --------
---- */

	tabaux[ncf] = tabaux[ncf - 1] * x1;
	for (ncj = ncf; ncj >= 2; --ncj) {
	    tabaux[ncj - 1] = tabaux[ncj - 1] * x0 + tabaux[ncj - 2] * x1;
/* L600: */
	}
	tabaux[0] *= x0;

/* L200: */
    }

/* -------------- Prise en compte du dernier coeff. de CRVOLD ----------- 
*/

    i__1 = *ncoeff - 1;
    for (ncj = 1; ncj <= i__1; ++ncj) {
	bid = tabaux[ncj - 1];
	i__2 = *ndim;
	for (nd = 1; nd <= i__2; ++nd) {
	    crvnew[nd + ncj * crvnew_dim1] += crvold[*ncoeff + nd * 
		    crvold_dim1] * bid;
/* L800: */
	}
/* L700: */
    }
    i__1 = *ndim;
    for (nd = 1; nd <= i__1; ++nd) {
	crvnew[nd + *ncoeff * crvnew_dim1] = crvold[*ncoeff + nd * 
		crvold_dim1] * tabaux[*ncoeff - 1];
/* L900: */
    }

/* ---------------------------- The end --------------------------------- 
*/

L9999:
    if (*iercod > 0) {
	maermsg_("MMARCIN", iercod, 7L);
    }
    if (ibb >= 2) {
	mgsomsg_("MMARCIN", 7L);
    }
    return 0;
} /* mmarcin_ */

