/*
 * DialogAbout
 * about box
 *
 * created: mpichler, 19970117
 *
 * changed: mpichler, 19970924
 *
 * $Id: DialogAbout.java,v 1.14 1997/09/29 12:53:20 mpichler Exp $
 */


package iicm.vrml.vrwave;

import iicm.widgets.Fontify;

import java.awt.*;


/**
 * DialogAbout - about box
 * Copyright (c) 1997 IICM
 *
 * @author Michael Pichler
 * @version 0.5, latest change:  3 Feb 97
 */


class DialogAbout extends Frame
{
  public DialogAbout ()
  {
    super ("About VRwave");
    setLayout (new BorderLayout ());

    Component title = centerLabel ("VRwave");
    title.setFont (new Font ("TimesRoman", Font.BOLD, 36));
    add ("North", title);
    title.setForeground (new Color (0x05ba));  // "Harmony blue"
    title.setBackground (Color.white);

    add ("Center", infoLines ());

    add ("South", new Button ("close"));

    setFont (Fontify.fntLabel1);
    pack();
  }

  private Panel infoLines ()
  {
    Panel lpanel = new Panel ();

    lpanel.setLayout (new GridLayout (0, 1, 0, 0));  // tight "vbox" of equally sized components
    lpanel.add (centerLabel ("VRML 2.0 Browser. Version " + VRwave.VERSION + " of " + VRwave.DATE));
    lpanel.add (centerLabel ("Copyright (c) 1996-1997 IICM"));
    lpanel.add (centerLabel ("Graz University of Technology - All rights reserved"));
    lpanel.add (centerLabel ("info: " + VRwave.HOMEURL));
    lpanel.add (centerLabel ("<vrwave-info@iicm.edu> <vrwave-bugs@iicm.edu>"));
    lpanel.add (centerLabel (""));
    lpanel.add (centerLabel ("Core, X11: Michael Pichler <mpichler@iicm.edu>"));
    lpanel.add (centerLabel ("Bahaviour: Andreas Pesendorfer <apesen@iicm.edu>"));
    lpanel.add (centerLabel ("Rendering, EAI: Karl Heinz Wagenbrunn <kwagen@iicm.edu>"));
    lpanel.add (centerLabel ("Windows port: Josef Wolte <jwolte@iicm.edu>"));
    lpanel.add (centerLabel ("Parser basics: Karin Roschker; Mac port: Marcus R. Popetz"));
    lpanel.add (centerLabel ("Project Leader: Keith Andrews <kandrews@iicm.edu>"));
    lpanel.setBackground (Color.white);

    return lpanel;

  } // infoLines

  final static LayoutManager centerLayout = new FlowLayout (FlowLayout.CENTER, 0, 0);  // no padding

  /**
   * centered label
   */

  Component centerLabel (String str)  // into widgets?
  {
    Panel panel = new Panel ();
    panel.setLayout (centerLayout);
    panel.add (new Label (str));
    return panel;
  }

  public boolean mouseDown (Event e, int x, int y)
  {
    return action (e, null);  // click anywhere to close
  }

  public boolean action (Event e, Object arg)
  {
    hide ();  // close window
    return true;  // handled
  }

} // DialogAbout
