/*
 * <copyright>
 *
 * Copyright (c) 1997
 * Institute for Information Processing and Computer Supported New Media (IICM),
 * Graz University of Technology, Austria.
 *
 * This file is part of the VRwave Java-EAI implementation.
 *
 * </copyright>
 */
/*
 * created: kwagen, 19970801
 *
 * changed: kwagen, 19970916
 *
 * $Id: EventOut.java,v 1.1 1997/09/17 11:52:53 kwagen Exp $
 */

package vrml.external.field;

import iicm.vrml.pw.Field;
import iicm.vrml.vrwave.Scene;

import java.util.Vector;

public class EventOut implements iicm.vrml.pw.GotEventCallback
{
  /**
   * Get the type of this EventOut (specified in FieldTypes.java).
   */

  public int getType ()
  {
    return fieldtype_;
  }


  /**
   * Mechanism for setting up an observer for this field.
   * The EventOutObserver's callback gets called when the
   * EventOut's value changes.
   */

  public void advise (EventOutObserver f, Object userData)
  {
    if (eventoutobs_ == null)
    {
      eventoutobs_ = new Vector ();
      userdata_ = new Vector ();
      eventoutobs_.addElement (f);
      userdata_.addElement (userData);
      eventout_.setEventCallback (this);
      return;
    }
    eventoutobs_.addElement (f);
    userdata_.addElement (userData);
  }


  /** VRwave implementation. do not call from applets */

  protected Field eventout_;
  protected Scene scene_;
  protected int fieldtype_;
  protected Vector eventoutobs_;
  protected Vector userdata_;

  public void initialize (Field eventout, int fieldtype, Scene scene)
  {
    eventout_ = eventout;
    scene_ = scene;
    fieldtype_ = fieldtype;
  }

  public void gotEventCB (Field field, double timestamp)
  {
    for (int i = 0; i < eventoutobs_.size (); i++)
      ((EventOutObserver) eventoutobs_.elementAt (i)).callback (this, timestamp, userdata_.elementAt (i));
  }
}
