// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file member_id.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__MEMBER_ID_HPP
#define FAST_DDS_GENERATED__MEMBER_ID_HPP

#include <cstdint>
#include <utility>

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(MEMBER_ID_SOURCE)
#define MEMBER_ID_DllAPI __declspec( dllexport )
#else
#define MEMBER_ID_DllAPI __declspec( dllimport )
#endif // MEMBER_ID_SOURCE
#else
#define MEMBER_ID_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define MEMBER_ID_DllAPI
#endif // _WIN32

/*!
 * @brief This class represents the structure FixId defined by the user in the IDL file.
 * @ingroup member_id
 */
class FixId
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport FixId()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~FixId()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object FixId that will be copied.
     */
    eProsima_user_DllExport FixId(
            const FixId& x)
    {
                    m_o = x.m_o;

                    m_s = x.m_s;

                    m_l = x.m_l;

                    m_ll = x.m_ll;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object FixId that will be copied.
     */
    eProsima_user_DllExport FixId(
            FixId&& x) noexcept
    {
        m_o = x.m_o;
        m_s = x.m_s;
        m_l = x.m_l;
        m_ll = x.m_ll;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object FixId that will be copied.
     */
    eProsima_user_DllExport FixId& operator =(
            const FixId& x)
    {

                    m_o = x.m_o;

                    m_s = x.m_s;

                    m_l = x.m_l;

                    m_ll = x.m_ll;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object FixId that will be copied.
     */
    eProsima_user_DllExport FixId& operator =(
            FixId&& x) noexcept
    {

        m_o = x.m_o;
        m_s = x.m_s;
        m_l = x.m_l;
        m_ll = x.m_ll;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x FixId object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const FixId& x) const
    {
        return (m_o == x.m_o &&
           m_s == x.m_s &&
           m_l == x.m_l &&
           m_ll == x.m_ll);
    }

    /*!
     * @brief Comparison operator.
     * @param x FixId object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const FixId& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member o
     * @param _o New value for member o
     */
    eProsima_user_DllExport void o(
            uint8_t _o)
    {
        m_o = _o;
    }

    /*!
     * @brief This function returns the value of member o
     * @return Value of member o
     */
    eProsima_user_DllExport uint8_t o() const
    {
        return m_o;
    }

    /*!
     * @brief This function returns a reference to member o
     * @return Reference to member o
     */
    eProsima_user_DllExport uint8_t& o()
    {
        return m_o;
    }


    /*!
     * @brief This function sets a value in member s
     * @param _s New value for member s
     */
    eProsima_user_DllExport void s(
            int16_t _s)
    {
        m_s = _s;
    }

    /*!
     * @brief This function returns the value of member s
     * @return Value of member s
     */
    eProsima_user_DllExport int16_t s() const
    {
        return m_s;
    }

    /*!
     * @brief This function returns a reference to member s
     * @return Reference to member s
     */
    eProsima_user_DllExport int16_t& s()
    {
        return m_s;
    }


    /*!
     * @brief This function sets a value in member l
     * @param _l New value for member l
     */
    eProsima_user_DllExport void l(
            int32_t _l)
    {
        m_l = _l;
    }

    /*!
     * @brief This function returns the value of member l
     * @return Value of member l
     */
    eProsima_user_DllExport int32_t l() const
    {
        return m_l;
    }

    /*!
     * @brief This function returns a reference to member l
     * @return Reference to member l
     */
    eProsima_user_DllExport int32_t& l()
    {
        return m_l;
    }


    /*!
     * @brief This function sets a value in member ll
     * @param _ll New value for member ll
     */
    eProsima_user_DllExport void ll(
            int64_t _ll)
    {
        m_ll = _ll;
    }

    /*!
     * @brief This function returns the value of member ll
     * @return Value of member ll
     */
    eProsima_user_DllExport int64_t ll() const
    {
        return m_ll;
    }

    /*!
     * @brief This function returns a reference to member ll
     * @return Reference to member ll
     */
    eProsima_user_DllExport int64_t& ll()
    {
        return m_ll;
    }



private:

    uint8_t m_o{0};
    int16_t m_s{0};
    int32_t m_l{0};
    int64_t m_ll{0};

};
/*!
 * @brief This class represents the structure FixHexId defined by the user in the IDL file.
 * @ingroup member_id
 */
class FixHexId
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport FixHexId()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~FixHexId()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object FixHexId that will be copied.
     */
    eProsima_user_DllExport FixHexId(
            const FixHexId& x)
    {
                    m_ho = x.m_ho;

                    m_hs = x.m_hs;

                    m_hl = x.m_hl;

                    m_ll = x.m_ll;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object FixHexId that will be copied.
     */
    eProsima_user_DllExport FixHexId(
            FixHexId&& x) noexcept
    {
        m_ho = x.m_ho;
        m_hs = x.m_hs;
        m_hl = x.m_hl;
        m_ll = x.m_ll;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object FixHexId that will be copied.
     */
    eProsima_user_DllExport FixHexId& operator =(
            const FixHexId& x)
    {

                    m_ho = x.m_ho;

                    m_hs = x.m_hs;

                    m_hl = x.m_hl;

                    m_ll = x.m_ll;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object FixHexId that will be copied.
     */
    eProsima_user_DllExport FixHexId& operator =(
            FixHexId&& x) noexcept
    {

        m_ho = x.m_ho;
        m_hs = x.m_hs;
        m_hl = x.m_hl;
        m_ll = x.m_ll;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x FixHexId object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const FixHexId& x) const
    {
        return (m_ho == x.m_ho &&
           m_hs == x.m_hs &&
           m_hl == x.m_hl &&
           m_ll == x.m_ll);
    }

    /*!
     * @brief Comparison operator.
     * @param x FixHexId object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const FixHexId& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member ho
     * @param _ho New value for member ho
     */
    eProsima_user_DllExport void ho(
            uint8_t _ho)
    {
        m_ho = _ho;
    }

    /*!
     * @brief This function returns the value of member ho
     * @return Value of member ho
     */
    eProsima_user_DllExport uint8_t ho() const
    {
        return m_ho;
    }

    /*!
     * @brief This function returns a reference to member ho
     * @return Reference to member ho
     */
    eProsima_user_DllExport uint8_t& ho()
    {
        return m_ho;
    }


    /*!
     * @brief This function sets a value in member hs
     * @param _hs New value for member hs
     */
    eProsima_user_DllExport void hs(
            int16_t _hs)
    {
        m_hs = _hs;
    }

    /*!
     * @brief This function returns the value of member hs
     * @return Value of member hs
     */
    eProsima_user_DllExport int16_t hs() const
    {
        return m_hs;
    }

    /*!
     * @brief This function returns a reference to member hs
     * @return Reference to member hs
     */
    eProsima_user_DllExport int16_t& hs()
    {
        return m_hs;
    }


    /*!
     * @brief This function sets a value in member hl
     * @param _hl New value for member hl
     */
    eProsima_user_DllExport void hl(
            int32_t _hl)
    {
        m_hl = _hl;
    }

    /*!
     * @brief This function returns the value of member hl
     * @return Value of member hl
     */
    eProsima_user_DllExport int32_t hl() const
    {
        return m_hl;
    }

    /*!
     * @brief This function returns a reference to member hl
     * @return Reference to member hl
     */
    eProsima_user_DllExport int32_t& hl()
    {
        return m_hl;
    }


    /*!
     * @brief This function sets a value in member ll
     * @param _ll New value for member ll
     */
    eProsima_user_DllExport void ll(
            int64_t _ll)
    {
        m_ll = _ll;
    }

    /*!
     * @brief This function returns the value of member ll
     * @return Value of member ll
     */
    eProsima_user_DllExport int64_t ll() const
    {
        return m_ll;
    }

    /*!
     * @brief This function returns a reference to member ll
     * @return Reference to member ll
     */
    eProsima_user_DllExport int64_t& ll()
    {
        return m_ll;
    }



private:

    uint8_t m_ho{0};
    int16_t m_hs{0};
    int32_t m_hl{0};
    int64_t m_ll{0};

};
/*!
 * @brief This class represents the structure FixHashidDefault defined by the user in the IDL file.
 * @ingroup member_id
 */
class FixHashidDefault
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport FixHashidDefault()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~FixHashidDefault()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object FixHashidDefault that will be copied.
     */
    eProsima_user_DllExport FixHashidDefault(
            const FixHashidDefault& x)
    {
                    m_o = x.m_o;

                    m_s = x.m_s;

                    m_l = x.m_l;

                    m_ll = x.m_ll;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object FixHashidDefault that will be copied.
     */
    eProsima_user_DllExport FixHashidDefault(
            FixHashidDefault&& x) noexcept
    {
        m_o = x.m_o;
        m_s = x.m_s;
        m_l = x.m_l;
        m_ll = x.m_ll;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object FixHashidDefault that will be copied.
     */
    eProsima_user_DllExport FixHashidDefault& operator =(
            const FixHashidDefault& x)
    {

                    m_o = x.m_o;

                    m_s = x.m_s;

                    m_l = x.m_l;

                    m_ll = x.m_ll;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object FixHashidDefault that will be copied.
     */
    eProsima_user_DllExport FixHashidDefault& operator =(
            FixHashidDefault&& x) noexcept
    {

        m_o = x.m_o;
        m_s = x.m_s;
        m_l = x.m_l;
        m_ll = x.m_ll;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x FixHashidDefault object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const FixHashidDefault& x) const
    {
        return (m_o == x.m_o &&
           m_s == x.m_s &&
           m_l == x.m_l &&
           m_ll == x.m_ll);
    }

    /*!
     * @brief Comparison operator.
     * @param x FixHashidDefault object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const FixHashidDefault& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member o
     * @param _o New value for member o
     */
    eProsima_user_DllExport void o(
            uint8_t _o)
    {
        m_o = _o;
    }

    /*!
     * @brief This function returns the value of member o
     * @return Value of member o
     */
    eProsima_user_DllExport uint8_t o() const
    {
        return m_o;
    }

    /*!
     * @brief This function returns a reference to member o
     * @return Reference to member o
     */
    eProsima_user_DllExport uint8_t& o()
    {
        return m_o;
    }


    /*!
     * @brief This function sets a value in member s
     * @param _s New value for member s
     */
    eProsima_user_DllExport void s(
            int16_t _s)
    {
        m_s = _s;
    }

    /*!
     * @brief This function returns the value of member s
     * @return Value of member s
     */
    eProsima_user_DllExport int16_t s() const
    {
        return m_s;
    }

    /*!
     * @brief This function returns a reference to member s
     * @return Reference to member s
     */
    eProsima_user_DllExport int16_t& s()
    {
        return m_s;
    }


    /*!
     * @brief This function sets a value in member l
     * @param _l New value for member l
     */
    eProsima_user_DllExport void l(
            int32_t _l)
    {
        m_l = _l;
    }

    /*!
     * @brief This function returns the value of member l
     * @return Value of member l
     */
    eProsima_user_DllExport int32_t l() const
    {
        return m_l;
    }

    /*!
     * @brief This function returns a reference to member l
     * @return Reference to member l
     */
    eProsima_user_DllExport int32_t& l()
    {
        return m_l;
    }


    /*!
     * @brief This function sets a value in member ll
     * @param _ll New value for member ll
     */
    eProsima_user_DllExport void ll(
            int64_t _ll)
    {
        m_ll = _ll;
    }

    /*!
     * @brief This function returns the value of member ll
     * @return Value of member ll
     */
    eProsima_user_DllExport int64_t ll() const
    {
        return m_ll;
    }

    /*!
     * @brief This function returns a reference to member ll
     * @return Reference to member ll
     */
    eProsima_user_DllExport int64_t& ll()
    {
        return m_ll;
    }



private:

    uint8_t m_o{0};
    int16_t m_s{0};
    int32_t m_l{0};
    int64_t m_ll{0};

};
/*!
 * @brief This class represents the structure FixHashid defined by the user in the IDL file.
 * @ingroup member_id
 */
class FixHashid
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport FixHashid()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~FixHashid()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object FixHashid that will be copied.
     */
    eProsima_user_DllExport FixHashid(
            const FixHashid& x)
    {
                    m_o = x.m_o;

                    m_s = x.m_s;

                    m_l = x.m_l;

                    m_ll = x.m_ll;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object FixHashid that will be copied.
     */
    eProsima_user_DllExport FixHashid(
            FixHashid&& x) noexcept
    {
        m_o = x.m_o;
        m_s = x.m_s;
        m_l = x.m_l;
        m_ll = x.m_ll;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object FixHashid that will be copied.
     */
    eProsima_user_DllExport FixHashid& operator =(
            const FixHashid& x)
    {

                    m_o = x.m_o;

                    m_s = x.m_s;

                    m_l = x.m_l;

                    m_ll = x.m_ll;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object FixHashid that will be copied.
     */
    eProsima_user_DllExport FixHashid& operator =(
            FixHashid&& x) noexcept
    {

        m_o = x.m_o;
        m_s = x.m_s;
        m_l = x.m_l;
        m_ll = x.m_ll;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x FixHashid object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const FixHashid& x) const
    {
        return (m_o == x.m_o &&
           m_s == x.m_s &&
           m_l == x.m_l &&
           m_ll == x.m_ll);
    }

    /*!
     * @brief Comparison operator.
     * @param x FixHashid object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const FixHashid& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member o
     * @param _o New value for member o
     */
    eProsima_user_DllExport void o(
            uint8_t _o)
    {
        m_o = _o;
    }

    /*!
     * @brief This function returns the value of member o
     * @return Value of member o
     */
    eProsima_user_DllExport uint8_t o() const
    {
        return m_o;
    }

    /*!
     * @brief This function returns a reference to member o
     * @return Reference to member o
     */
    eProsima_user_DllExport uint8_t& o()
    {
        return m_o;
    }


    /*!
     * @brief This function sets a value in member s
     * @param _s New value for member s
     */
    eProsima_user_DllExport void s(
            int16_t _s)
    {
        m_s = _s;
    }

    /*!
     * @brief This function returns the value of member s
     * @return Value of member s
     */
    eProsima_user_DllExport int16_t s() const
    {
        return m_s;
    }

    /*!
     * @brief This function returns a reference to member s
     * @return Reference to member s
     */
    eProsima_user_DllExport int16_t& s()
    {
        return m_s;
    }


    /*!
     * @brief This function sets a value in member l
     * @param _l New value for member l
     */
    eProsima_user_DllExport void l(
            int32_t _l)
    {
        m_l = _l;
    }

    /*!
     * @brief This function returns the value of member l
     * @return Value of member l
     */
    eProsima_user_DllExport int32_t l() const
    {
        return m_l;
    }

    /*!
     * @brief This function returns a reference to member l
     * @return Reference to member l
     */
    eProsima_user_DllExport int32_t& l()
    {
        return m_l;
    }


    /*!
     * @brief This function sets a value in member ll
     * @param _ll New value for member ll
     */
    eProsima_user_DllExport void ll(
            int64_t _ll)
    {
        m_ll = _ll;
    }

    /*!
     * @brief This function returns the value of member ll
     * @return Value of member ll
     */
    eProsima_user_DllExport int64_t ll() const
    {
        return m_ll;
    }

    /*!
     * @brief This function returns a reference to member ll
     * @return Reference to member ll
     */
    eProsima_user_DllExport int64_t& ll()
    {
        return m_ll;
    }



private:

    uint8_t m_o{0};
    int16_t m_s{0};
    int32_t m_l{0};
    int64_t m_ll{0};

};
/*!
 * @brief This class represents the structure FixMix defined by the user in the IDL file.
 * @ingroup member_id
 */
class FixMix
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport FixMix()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~FixMix()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object FixMix that will be copied.
     */
    eProsima_user_DllExport FixMix(
            const FixMix& x)
    {
                    m_o = x.m_o;

                    m_ho = x.m_ho;

                    m_s = x.m_s;

                    m_l = x.m_l;

                    m_ll = x.m_ll;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object FixMix that will be copied.
     */
    eProsima_user_DllExport FixMix(
            FixMix&& x) noexcept
    {
        m_o = x.m_o;
        m_ho = x.m_ho;
        m_s = x.m_s;
        m_l = x.m_l;
        m_ll = x.m_ll;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object FixMix that will be copied.
     */
    eProsima_user_DllExport FixMix& operator =(
            const FixMix& x)
    {

                    m_o = x.m_o;

                    m_ho = x.m_ho;

                    m_s = x.m_s;

                    m_l = x.m_l;

                    m_ll = x.m_ll;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object FixMix that will be copied.
     */
    eProsima_user_DllExport FixMix& operator =(
            FixMix&& x) noexcept
    {

        m_o = x.m_o;
        m_ho = x.m_ho;
        m_s = x.m_s;
        m_l = x.m_l;
        m_ll = x.m_ll;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x FixMix object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const FixMix& x) const
    {
        return (m_o == x.m_o &&
           m_ho == x.m_ho &&
           m_s == x.m_s &&
           m_l == x.m_l &&
           m_ll == x.m_ll);
    }

    /*!
     * @brief Comparison operator.
     * @param x FixMix object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const FixMix& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member o
     * @param _o New value for member o
     */
    eProsima_user_DllExport void o(
            uint8_t _o)
    {
        m_o = _o;
    }

    /*!
     * @brief This function returns the value of member o
     * @return Value of member o
     */
    eProsima_user_DllExport uint8_t o() const
    {
        return m_o;
    }

    /*!
     * @brief This function returns a reference to member o
     * @return Reference to member o
     */
    eProsima_user_DllExport uint8_t& o()
    {
        return m_o;
    }


    /*!
     * @brief This function sets a value in member ho
     * @param _ho New value for member ho
     */
    eProsima_user_DllExport void ho(
            uint8_t _ho)
    {
        m_ho = _ho;
    }

    /*!
     * @brief This function returns the value of member ho
     * @return Value of member ho
     */
    eProsima_user_DllExport uint8_t ho() const
    {
        return m_ho;
    }

    /*!
     * @brief This function returns a reference to member ho
     * @return Reference to member ho
     */
    eProsima_user_DllExport uint8_t& ho()
    {
        return m_ho;
    }


    /*!
     * @brief This function sets a value in member s
     * @param _s New value for member s
     */
    eProsima_user_DllExport void s(
            int16_t _s)
    {
        m_s = _s;
    }

    /*!
     * @brief This function returns the value of member s
     * @return Value of member s
     */
    eProsima_user_DllExport int16_t s() const
    {
        return m_s;
    }

    /*!
     * @brief This function returns a reference to member s
     * @return Reference to member s
     */
    eProsima_user_DllExport int16_t& s()
    {
        return m_s;
    }


    /*!
     * @brief This function sets a value in member l
     * @param _l New value for member l
     */
    eProsima_user_DllExport void l(
            int32_t _l)
    {
        m_l = _l;
    }

    /*!
     * @brief This function returns the value of member l
     * @return Value of member l
     */
    eProsima_user_DllExport int32_t l() const
    {
        return m_l;
    }

    /*!
     * @brief This function returns a reference to member l
     * @return Reference to member l
     */
    eProsima_user_DllExport int32_t& l()
    {
        return m_l;
    }


    /*!
     * @brief This function sets a value in member ll
     * @param _ll New value for member ll
     */
    eProsima_user_DllExport void ll(
            int64_t _ll)
    {
        m_ll = _ll;
    }

    /*!
     * @brief This function returns the value of member ll
     * @return Value of member ll
     */
    eProsima_user_DllExport int64_t ll() const
    {
        return m_ll;
    }

    /*!
     * @brief This function returns a reference to member ll
     * @return Reference to member ll
     */
    eProsima_user_DllExport int64_t& ll()
    {
        return m_ll;
    }



private:

    uint8_t m_o{0};
    uint8_t m_ho{0};
    int16_t m_s{0};
    int32_t m_l{0};
    int64_t m_ll{0};

};
/*!
 * @brief This class represents the structure AutoidDefault defined by the user in the IDL file.
 * @ingroup member_id
 */
class AutoidDefault
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AutoidDefault()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AutoidDefault()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AutoidDefault that will be copied.
     */
    eProsima_user_DllExport AutoidDefault(
            const AutoidDefault& x)
    {
                    m_c = x.m_c;

                    m_o = x.m_o;

                    m_s = x.m_s;

                    m_l = x.m_l;

                    m_ll = x.m_ll;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AutoidDefault that will be copied.
     */
    eProsima_user_DllExport AutoidDefault(
            AutoidDefault&& x) noexcept
    {
        m_c = x.m_c;
        m_o = x.m_o;
        m_s = x.m_s;
        m_l = x.m_l;
        m_ll = x.m_ll;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AutoidDefault that will be copied.
     */
    eProsima_user_DllExport AutoidDefault& operator =(
            const AutoidDefault& x)
    {

                    m_c = x.m_c;

                    m_o = x.m_o;

                    m_s = x.m_s;

                    m_l = x.m_l;

                    m_ll = x.m_ll;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AutoidDefault that will be copied.
     */
    eProsima_user_DllExport AutoidDefault& operator =(
            AutoidDefault&& x) noexcept
    {

        m_c = x.m_c;
        m_o = x.m_o;
        m_s = x.m_s;
        m_l = x.m_l;
        m_ll = x.m_ll;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AutoidDefault object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AutoidDefault& x) const
    {
        return (m_c == x.m_c &&
           m_o == x.m_o &&
           m_s == x.m_s &&
           m_l == x.m_l &&
           m_ll == x.m_ll);
    }

    /*!
     * @brief Comparison operator.
     * @param x AutoidDefault object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AutoidDefault& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member c
     * @param _c New value for member c
     */
    eProsima_user_DllExport void c(
            char _c)
    {
        m_c = _c;
    }

    /*!
     * @brief This function returns the value of member c
     * @return Value of member c
     */
    eProsima_user_DllExport char c() const
    {
        return m_c;
    }

    /*!
     * @brief This function returns a reference to member c
     * @return Reference to member c
     */
    eProsima_user_DllExport char& c()
    {
        return m_c;
    }


    /*!
     * @brief This function sets a value in member o
     * @param _o New value for member o
     */
    eProsima_user_DllExport void o(
            uint8_t _o)
    {
        m_o = _o;
    }

    /*!
     * @brief This function returns the value of member o
     * @return Value of member o
     */
    eProsima_user_DllExport uint8_t o() const
    {
        return m_o;
    }

    /*!
     * @brief This function returns a reference to member o
     * @return Reference to member o
     */
    eProsima_user_DllExport uint8_t& o()
    {
        return m_o;
    }


    /*!
     * @brief This function sets a value in member s
     * @param _s New value for member s
     */
    eProsima_user_DllExport void s(
            int16_t _s)
    {
        m_s = _s;
    }

    /*!
     * @brief This function returns the value of member s
     * @return Value of member s
     */
    eProsima_user_DllExport int16_t s() const
    {
        return m_s;
    }

    /*!
     * @brief This function returns a reference to member s
     * @return Reference to member s
     */
    eProsima_user_DllExport int16_t& s()
    {
        return m_s;
    }


    /*!
     * @brief This function sets a value in member l
     * @param _l New value for member l
     */
    eProsima_user_DllExport void l(
            int32_t _l)
    {
        m_l = _l;
    }

    /*!
     * @brief This function returns the value of member l
     * @return Value of member l
     */
    eProsima_user_DllExport int32_t l() const
    {
        return m_l;
    }

    /*!
     * @brief This function returns a reference to member l
     * @return Reference to member l
     */
    eProsima_user_DllExport int32_t& l()
    {
        return m_l;
    }


    /*!
     * @brief This function sets a value in member ll
     * @param _ll New value for member ll
     */
    eProsima_user_DllExport void ll(
            int64_t _ll)
    {
        m_ll = _ll;
    }

    /*!
     * @brief This function returns the value of member ll
     * @return Value of member ll
     */
    eProsima_user_DllExport int64_t ll() const
    {
        return m_ll;
    }

    /*!
     * @brief This function returns a reference to member ll
     * @return Reference to member ll
     */
    eProsima_user_DllExport int64_t& ll()
    {
        return m_ll;
    }



private:

    char m_c{0};
    uint8_t m_o{0};
    int16_t m_s{0};
    int32_t m_l{0};
    int64_t m_ll{0};

};
/*!
 * @brief This class represents the structure AutoidSequential defined by the user in the IDL file.
 * @ingroup member_id
 */
class AutoidSequential
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AutoidSequential()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AutoidSequential()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AutoidSequential that will be copied.
     */
    eProsima_user_DllExport AutoidSequential(
            const AutoidSequential& x)
    {
                    m_c = x.m_c;

                    m_o = x.m_o;

                    m_s = x.m_s;

                    m_l = x.m_l;

                    m_ll = x.m_ll;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AutoidSequential that will be copied.
     */
    eProsima_user_DllExport AutoidSequential(
            AutoidSequential&& x) noexcept
    {
        m_c = x.m_c;
        m_o = x.m_o;
        m_s = x.m_s;
        m_l = x.m_l;
        m_ll = x.m_ll;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AutoidSequential that will be copied.
     */
    eProsima_user_DllExport AutoidSequential& operator =(
            const AutoidSequential& x)
    {

                    m_c = x.m_c;

                    m_o = x.m_o;

                    m_s = x.m_s;

                    m_l = x.m_l;

                    m_ll = x.m_ll;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AutoidSequential that will be copied.
     */
    eProsima_user_DllExport AutoidSequential& operator =(
            AutoidSequential&& x) noexcept
    {

        m_c = x.m_c;
        m_o = x.m_o;
        m_s = x.m_s;
        m_l = x.m_l;
        m_ll = x.m_ll;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AutoidSequential object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AutoidSequential& x) const
    {
        return (m_c == x.m_c &&
           m_o == x.m_o &&
           m_s == x.m_s &&
           m_l == x.m_l &&
           m_ll == x.m_ll);
    }

    /*!
     * @brief Comparison operator.
     * @param x AutoidSequential object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AutoidSequential& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member c
     * @param _c New value for member c
     */
    eProsima_user_DllExport void c(
            char _c)
    {
        m_c = _c;
    }

    /*!
     * @brief This function returns the value of member c
     * @return Value of member c
     */
    eProsima_user_DllExport char c() const
    {
        return m_c;
    }

    /*!
     * @brief This function returns a reference to member c
     * @return Reference to member c
     */
    eProsima_user_DllExport char& c()
    {
        return m_c;
    }


    /*!
     * @brief This function sets a value in member o
     * @param _o New value for member o
     */
    eProsima_user_DllExport void o(
            uint8_t _o)
    {
        m_o = _o;
    }

    /*!
     * @brief This function returns the value of member o
     * @return Value of member o
     */
    eProsima_user_DllExport uint8_t o() const
    {
        return m_o;
    }

    /*!
     * @brief This function returns a reference to member o
     * @return Reference to member o
     */
    eProsima_user_DllExport uint8_t& o()
    {
        return m_o;
    }


    /*!
     * @brief This function sets a value in member s
     * @param _s New value for member s
     */
    eProsima_user_DllExport void s(
            int16_t _s)
    {
        m_s = _s;
    }

    /*!
     * @brief This function returns the value of member s
     * @return Value of member s
     */
    eProsima_user_DllExport int16_t s() const
    {
        return m_s;
    }

    /*!
     * @brief This function returns a reference to member s
     * @return Reference to member s
     */
    eProsima_user_DllExport int16_t& s()
    {
        return m_s;
    }


    /*!
     * @brief This function sets a value in member l
     * @param _l New value for member l
     */
    eProsima_user_DllExport void l(
            int32_t _l)
    {
        m_l = _l;
    }

    /*!
     * @brief This function returns the value of member l
     * @return Value of member l
     */
    eProsima_user_DllExport int32_t l() const
    {
        return m_l;
    }

    /*!
     * @brief This function returns a reference to member l
     * @return Reference to member l
     */
    eProsima_user_DllExport int32_t& l()
    {
        return m_l;
    }


    /*!
     * @brief This function sets a value in member ll
     * @param _ll New value for member ll
     */
    eProsima_user_DllExport void ll(
            int64_t _ll)
    {
        m_ll = _ll;
    }

    /*!
     * @brief This function returns the value of member ll
     * @return Value of member ll
     */
    eProsima_user_DllExport int64_t ll() const
    {
        return m_ll;
    }

    /*!
     * @brief This function returns a reference to member ll
     * @return Reference to member ll
     */
    eProsima_user_DllExport int64_t& ll()
    {
        return m_ll;
    }



private:

    char m_c{0};
    uint8_t m_o{0};
    int16_t m_s{0};
    int32_t m_l{0};
    int64_t m_ll{0};

};
/*!
 * @brief This class represents the structure AutoidHash defined by the user in the IDL file.
 * @ingroup member_id
 */
class AutoidHash
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AutoidHash()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AutoidHash()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AutoidHash that will be copied.
     */
    eProsima_user_DllExport AutoidHash(
            const AutoidHash& x)
    {
                    m_c = x.m_c;

                    m_o = x.m_o;

                    m_s = x.m_s;

                    m_l = x.m_l;

                    m_ll = x.m_ll;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AutoidHash that will be copied.
     */
    eProsima_user_DllExport AutoidHash(
            AutoidHash&& x) noexcept
    {
        m_c = x.m_c;
        m_o = x.m_o;
        m_s = x.m_s;
        m_l = x.m_l;
        m_ll = x.m_ll;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AutoidHash that will be copied.
     */
    eProsima_user_DllExport AutoidHash& operator =(
            const AutoidHash& x)
    {

                    m_c = x.m_c;

                    m_o = x.m_o;

                    m_s = x.m_s;

                    m_l = x.m_l;

                    m_ll = x.m_ll;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AutoidHash that will be copied.
     */
    eProsima_user_DllExport AutoidHash& operator =(
            AutoidHash&& x) noexcept
    {

        m_c = x.m_c;
        m_o = x.m_o;
        m_s = x.m_s;
        m_l = x.m_l;
        m_ll = x.m_ll;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AutoidHash object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AutoidHash& x) const
    {
        return (m_c == x.m_c &&
           m_o == x.m_o &&
           m_s == x.m_s &&
           m_l == x.m_l &&
           m_ll == x.m_ll);
    }

    /*!
     * @brief Comparison operator.
     * @param x AutoidHash object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AutoidHash& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member c
     * @param _c New value for member c
     */
    eProsima_user_DllExport void c(
            char _c)
    {
        m_c = _c;
    }

    /*!
     * @brief This function returns the value of member c
     * @return Value of member c
     */
    eProsima_user_DllExport char c() const
    {
        return m_c;
    }

    /*!
     * @brief This function returns a reference to member c
     * @return Reference to member c
     */
    eProsima_user_DllExport char& c()
    {
        return m_c;
    }


    /*!
     * @brief This function sets a value in member o
     * @param _o New value for member o
     */
    eProsima_user_DllExport void o(
            uint8_t _o)
    {
        m_o = _o;
    }

    /*!
     * @brief This function returns the value of member o
     * @return Value of member o
     */
    eProsima_user_DllExport uint8_t o() const
    {
        return m_o;
    }

    /*!
     * @brief This function returns a reference to member o
     * @return Reference to member o
     */
    eProsima_user_DllExport uint8_t& o()
    {
        return m_o;
    }


    /*!
     * @brief This function sets a value in member s
     * @param _s New value for member s
     */
    eProsima_user_DllExport void s(
            int16_t _s)
    {
        m_s = _s;
    }

    /*!
     * @brief This function returns the value of member s
     * @return Value of member s
     */
    eProsima_user_DllExport int16_t s() const
    {
        return m_s;
    }

    /*!
     * @brief This function returns a reference to member s
     * @return Reference to member s
     */
    eProsima_user_DllExport int16_t& s()
    {
        return m_s;
    }


    /*!
     * @brief This function sets a value in member l
     * @param _l New value for member l
     */
    eProsima_user_DllExport void l(
            int32_t _l)
    {
        m_l = _l;
    }

    /*!
     * @brief This function returns the value of member l
     * @return Value of member l
     */
    eProsima_user_DllExport int32_t l() const
    {
        return m_l;
    }

    /*!
     * @brief This function returns a reference to member l
     * @return Reference to member l
     */
    eProsima_user_DllExport int32_t& l()
    {
        return m_l;
    }


    /*!
     * @brief This function sets a value in member ll
     * @param _ll New value for member ll
     */
    eProsima_user_DllExport void ll(
            int64_t _ll)
    {
        m_ll = _ll;
    }

    /*!
     * @brief This function returns the value of member ll
     * @return Value of member ll
     */
    eProsima_user_DllExport int64_t ll() const
    {
        return m_ll;
    }

    /*!
     * @brief This function returns a reference to member ll
     * @return Reference to member ll
     */
    eProsima_user_DllExport int64_t& ll()
    {
        return m_ll;
    }



private:

    char m_c{0};
    uint8_t m_o{0};
    int16_t m_s{0};
    int32_t m_l{0};
    int64_t m_ll{0};

};
/*!
 * @brief This class represents the structure DerivedAutoidDefault defined by the user in the IDL file.
 * @ingroup member_id
 */
class DerivedAutoidDefault : public AutoidDefault
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport DerivedAutoidDefault()
        : AutoidDefault()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~DerivedAutoidDefault()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object DerivedAutoidDefault that will be copied.
     */
    eProsima_user_DllExport DerivedAutoidDefault(
            const DerivedAutoidDefault& x)
        : AutoidDefault(x)
    {
                    m_cd = x.m_cd;

                    m_od = x.m_od;

                    m_sd = x.m_sd;

                    m_ld = x.m_ld;

                    m_lld = x.m_lld;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object DerivedAutoidDefault that will be copied.
     */
    eProsima_user_DllExport DerivedAutoidDefault(
            DerivedAutoidDefault&& x) noexcept
        : AutoidDefault(std::move(x))

    {
        m_cd = x.m_cd;
        m_od = x.m_od;
        m_sd = x.m_sd;
        m_ld = x.m_ld;
        m_lld = x.m_lld;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object DerivedAutoidDefault that will be copied.
     */
    eProsima_user_DllExport DerivedAutoidDefault& operator =(
            const DerivedAutoidDefault& x)
    {
        AutoidDefault::operator =(x);

                    m_cd = x.m_cd;

                    m_od = x.m_od;

                    m_sd = x.m_sd;

                    m_ld = x.m_ld;

                    m_lld = x.m_lld;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object DerivedAutoidDefault that will be copied.
     */
    eProsima_user_DllExport DerivedAutoidDefault& operator =(
            DerivedAutoidDefault&& x) noexcept
    {
        AutoidDefault::operator =(std::move(x));

        m_cd = x.m_cd;
        m_od = x.m_od;
        m_sd = x.m_sd;
        m_ld = x.m_ld;
        m_lld = x.m_lld;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x DerivedAutoidDefault object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const DerivedAutoidDefault& x) const
    {
        if (AutoidDefault::operator !=(x))
                {
                    return false;
                }
        return (m_cd == x.m_cd &&
           m_od == x.m_od &&
           m_sd == x.m_sd &&
           m_ld == x.m_ld &&
           m_lld == x.m_lld);
    }

    /*!
     * @brief Comparison operator.
     * @param x DerivedAutoidDefault object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const DerivedAutoidDefault& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member cd
     * @param _cd New value for member cd
     */
    eProsima_user_DllExport void cd(
            char _cd)
    {
        m_cd = _cd;
    }

    /*!
     * @brief This function returns the value of member cd
     * @return Value of member cd
     */
    eProsima_user_DllExport char cd() const
    {
        return m_cd;
    }

    /*!
     * @brief This function returns a reference to member cd
     * @return Reference to member cd
     */
    eProsima_user_DllExport char& cd()
    {
        return m_cd;
    }


    /*!
     * @brief This function sets a value in member od
     * @param _od New value for member od
     */
    eProsima_user_DllExport void od(
            uint8_t _od)
    {
        m_od = _od;
    }

    /*!
     * @brief This function returns the value of member od
     * @return Value of member od
     */
    eProsima_user_DllExport uint8_t od() const
    {
        return m_od;
    }

    /*!
     * @brief This function returns a reference to member od
     * @return Reference to member od
     */
    eProsima_user_DllExport uint8_t& od()
    {
        return m_od;
    }


    /*!
     * @brief This function sets a value in member sd
     * @param _sd New value for member sd
     */
    eProsima_user_DllExport void sd(
            int16_t _sd)
    {
        m_sd = _sd;
    }

    /*!
     * @brief This function returns the value of member sd
     * @return Value of member sd
     */
    eProsima_user_DllExport int16_t sd() const
    {
        return m_sd;
    }

    /*!
     * @brief This function returns a reference to member sd
     * @return Reference to member sd
     */
    eProsima_user_DllExport int16_t& sd()
    {
        return m_sd;
    }


    /*!
     * @brief This function sets a value in member ld
     * @param _ld New value for member ld
     */
    eProsima_user_DllExport void ld(
            int32_t _ld)
    {
        m_ld = _ld;
    }

    /*!
     * @brief This function returns the value of member ld
     * @return Value of member ld
     */
    eProsima_user_DllExport int32_t ld() const
    {
        return m_ld;
    }

    /*!
     * @brief This function returns a reference to member ld
     * @return Reference to member ld
     */
    eProsima_user_DllExport int32_t& ld()
    {
        return m_ld;
    }


    /*!
     * @brief This function sets a value in member lld
     * @param _lld New value for member lld
     */
    eProsima_user_DllExport void lld(
            int64_t _lld)
    {
        m_lld = _lld;
    }

    /*!
     * @brief This function returns the value of member lld
     * @return Value of member lld
     */
    eProsima_user_DllExport int64_t lld() const
    {
        return m_lld;
    }

    /*!
     * @brief This function returns a reference to member lld
     * @return Reference to member lld
     */
    eProsima_user_DllExport int64_t& lld()
    {
        return m_lld;
    }



private:

    char m_cd{0};
    uint8_t m_od{0};
    int16_t m_sd{0};
    int32_t m_ld{0};
    int64_t m_lld{0};

};
/*!
 * @brief This class represents the structure DerivedEmptyAutoidSequential defined by the user in the IDL file.
 * @ingroup member_id
 */
class DerivedEmptyAutoidSequential : public AutoidSequential
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport DerivedEmptyAutoidSequential()
        : AutoidSequential()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~DerivedEmptyAutoidSequential()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object DerivedEmptyAutoidSequential that will be copied.
     */
    eProsima_user_DllExport DerivedEmptyAutoidSequential(
            const DerivedEmptyAutoidSequential& x)
        : AutoidSequential(x)
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object DerivedEmptyAutoidSequential that will be copied.
     */
    eProsima_user_DllExport DerivedEmptyAutoidSequential(
            DerivedEmptyAutoidSequential&& x) noexcept
        : AutoidSequential(std::move(x))

    {
        static_cast<void>(x);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object DerivedEmptyAutoidSequential that will be copied.
     */
    eProsima_user_DllExport DerivedEmptyAutoidSequential& operator =(
            const DerivedEmptyAutoidSequential& x)
    {
        AutoidSequential::operator =(x);

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object DerivedEmptyAutoidSequential that will be copied.
     */
    eProsima_user_DllExport DerivedEmptyAutoidSequential& operator =(
            DerivedEmptyAutoidSequential&& x) noexcept
    {
        AutoidSequential::operator =(std::move(x));

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x DerivedEmptyAutoidSequential object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const DerivedEmptyAutoidSequential& x) const
    {
        if (AutoidSequential::operator !=(x))
                {
                    return false;
                }
        static_cast<void>(x);
        return true;
    }

    /*!
     * @brief Comparison operator.
     * @param x DerivedEmptyAutoidSequential object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const DerivedEmptyAutoidSequential& x) const
    {
        return !(*this == x);
    }



private:


};
/*!
 * @brief This class represents the structure DerivedAutoidSequential defined by the user in the IDL file.
 * @ingroup member_id
 */
class DerivedAutoidSequential : public DerivedEmptyAutoidSequential
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport DerivedAutoidSequential()
        : DerivedEmptyAutoidSequential()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~DerivedAutoidSequential()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object DerivedAutoidSequential that will be copied.
     */
    eProsima_user_DllExport DerivedAutoidSequential(
            const DerivedAutoidSequential& x)
        : DerivedEmptyAutoidSequential(x)
    {
                    m_cd = x.m_cd;

                    m_od = x.m_od;

                    m_sd = x.m_sd;

                    m_ld = x.m_ld;

                    m_lld = x.m_lld;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object DerivedAutoidSequential that will be copied.
     */
    eProsima_user_DllExport DerivedAutoidSequential(
            DerivedAutoidSequential&& x) noexcept
        : DerivedEmptyAutoidSequential(std::move(x))

    {
        m_cd = x.m_cd;
        m_od = x.m_od;
        m_sd = x.m_sd;
        m_ld = x.m_ld;
        m_lld = x.m_lld;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object DerivedAutoidSequential that will be copied.
     */
    eProsima_user_DllExport DerivedAutoidSequential& operator =(
            const DerivedAutoidSequential& x)
    {
        DerivedEmptyAutoidSequential::operator =(x);

                    m_cd = x.m_cd;

                    m_od = x.m_od;

                    m_sd = x.m_sd;

                    m_ld = x.m_ld;

                    m_lld = x.m_lld;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object DerivedAutoidSequential that will be copied.
     */
    eProsima_user_DllExport DerivedAutoidSequential& operator =(
            DerivedAutoidSequential&& x) noexcept
    {
        DerivedEmptyAutoidSequential::operator =(std::move(x));

        m_cd = x.m_cd;
        m_od = x.m_od;
        m_sd = x.m_sd;
        m_ld = x.m_ld;
        m_lld = x.m_lld;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x DerivedAutoidSequential object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const DerivedAutoidSequential& x) const
    {
        if (DerivedEmptyAutoidSequential::operator !=(x))
                {
                    return false;
                }
        return (m_cd == x.m_cd &&
           m_od == x.m_od &&
           m_sd == x.m_sd &&
           m_ld == x.m_ld &&
           m_lld == x.m_lld);
    }

    /*!
     * @brief Comparison operator.
     * @param x DerivedAutoidSequential object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const DerivedAutoidSequential& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member cd
     * @param _cd New value for member cd
     */
    eProsima_user_DllExport void cd(
            char _cd)
    {
        m_cd = _cd;
    }

    /*!
     * @brief This function returns the value of member cd
     * @return Value of member cd
     */
    eProsima_user_DllExport char cd() const
    {
        return m_cd;
    }

    /*!
     * @brief This function returns a reference to member cd
     * @return Reference to member cd
     */
    eProsima_user_DllExport char& cd()
    {
        return m_cd;
    }


    /*!
     * @brief This function sets a value in member od
     * @param _od New value for member od
     */
    eProsima_user_DllExport void od(
            uint8_t _od)
    {
        m_od = _od;
    }

    /*!
     * @brief This function returns the value of member od
     * @return Value of member od
     */
    eProsima_user_DllExport uint8_t od() const
    {
        return m_od;
    }

    /*!
     * @brief This function returns a reference to member od
     * @return Reference to member od
     */
    eProsima_user_DllExport uint8_t& od()
    {
        return m_od;
    }


    /*!
     * @brief This function sets a value in member sd
     * @param _sd New value for member sd
     */
    eProsima_user_DllExport void sd(
            int16_t _sd)
    {
        m_sd = _sd;
    }

    /*!
     * @brief This function returns the value of member sd
     * @return Value of member sd
     */
    eProsima_user_DllExport int16_t sd() const
    {
        return m_sd;
    }

    /*!
     * @brief This function returns a reference to member sd
     * @return Reference to member sd
     */
    eProsima_user_DllExport int16_t& sd()
    {
        return m_sd;
    }


    /*!
     * @brief This function sets a value in member ld
     * @param _ld New value for member ld
     */
    eProsima_user_DllExport void ld(
            int32_t _ld)
    {
        m_ld = _ld;
    }

    /*!
     * @brief This function returns the value of member ld
     * @return Value of member ld
     */
    eProsima_user_DllExport int32_t ld() const
    {
        return m_ld;
    }

    /*!
     * @brief This function returns a reference to member ld
     * @return Reference to member ld
     */
    eProsima_user_DllExport int32_t& ld()
    {
        return m_ld;
    }


    /*!
     * @brief This function sets a value in member lld
     * @param _lld New value for member lld
     */
    eProsima_user_DllExport void lld(
            int64_t _lld)
    {
        m_lld = _lld;
    }

    /*!
     * @brief This function returns the value of member lld
     * @return Value of member lld
     */
    eProsima_user_DllExport int64_t lld() const
    {
        return m_lld;
    }

    /*!
     * @brief This function returns a reference to member lld
     * @return Reference to member lld
     */
    eProsima_user_DllExport int64_t& lld()
    {
        return m_lld;
    }



private:

    char m_cd{0};
    uint8_t m_od{0};
    int16_t m_sd{0};
    int32_t m_ld{0};
    int64_t m_lld{0};

};
/*!
 * @brief This class represents the structure DerivedAutoidHash defined by the user in the IDL file.
 * @ingroup member_id
 */
class DerivedAutoidHash : public AutoidHash
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport DerivedAutoidHash()
        : AutoidHash()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~DerivedAutoidHash()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object DerivedAutoidHash that will be copied.
     */
    eProsima_user_DllExport DerivedAutoidHash(
            const DerivedAutoidHash& x)
        : AutoidHash(x)
    {
                    m_cd = x.m_cd;

                    m_od = x.m_od;

                    m_sd = x.m_sd;

                    m_ld = x.m_ld;

                    m_lld = x.m_lld;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object DerivedAutoidHash that will be copied.
     */
    eProsima_user_DllExport DerivedAutoidHash(
            DerivedAutoidHash&& x) noexcept
        : AutoidHash(std::move(x))

    {
        m_cd = x.m_cd;
        m_od = x.m_od;
        m_sd = x.m_sd;
        m_ld = x.m_ld;
        m_lld = x.m_lld;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object DerivedAutoidHash that will be copied.
     */
    eProsima_user_DllExport DerivedAutoidHash& operator =(
            const DerivedAutoidHash& x)
    {
        AutoidHash::operator =(x);

                    m_cd = x.m_cd;

                    m_od = x.m_od;

                    m_sd = x.m_sd;

                    m_ld = x.m_ld;

                    m_lld = x.m_lld;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object DerivedAutoidHash that will be copied.
     */
    eProsima_user_DllExport DerivedAutoidHash& operator =(
            DerivedAutoidHash&& x) noexcept
    {
        AutoidHash::operator =(std::move(x));

        m_cd = x.m_cd;
        m_od = x.m_od;
        m_sd = x.m_sd;
        m_ld = x.m_ld;
        m_lld = x.m_lld;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x DerivedAutoidHash object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const DerivedAutoidHash& x) const
    {
        if (AutoidHash::operator !=(x))
                {
                    return false;
                }
        return (m_cd == x.m_cd &&
           m_od == x.m_od &&
           m_sd == x.m_sd &&
           m_ld == x.m_ld &&
           m_lld == x.m_lld);
    }

    /*!
     * @brief Comparison operator.
     * @param x DerivedAutoidHash object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const DerivedAutoidHash& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member cd
     * @param _cd New value for member cd
     */
    eProsima_user_DllExport void cd(
            char _cd)
    {
        m_cd = _cd;
    }

    /*!
     * @brief This function returns the value of member cd
     * @return Value of member cd
     */
    eProsima_user_DllExport char cd() const
    {
        return m_cd;
    }

    /*!
     * @brief This function returns a reference to member cd
     * @return Reference to member cd
     */
    eProsima_user_DllExport char& cd()
    {
        return m_cd;
    }


    /*!
     * @brief This function sets a value in member od
     * @param _od New value for member od
     */
    eProsima_user_DllExport void od(
            uint8_t _od)
    {
        m_od = _od;
    }

    /*!
     * @brief This function returns the value of member od
     * @return Value of member od
     */
    eProsima_user_DllExport uint8_t od() const
    {
        return m_od;
    }

    /*!
     * @brief This function returns a reference to member od
     * @return Reference to member od
     */
    eProsima_user_DllExport uint8_t& od()
    {
        return m_od;
    }


    /*!
     * @brief This function sets a value in member sd
     * @param _sd New value for member sd
     */
    eProsima_user_DllExport void sd(
            int16_t _sd)
    {
        m_sd = _sd;
    }

    /*!
     * @brief This function returns the value of member sd
     * @return Value of member sd
     */
    eProsima_user_DllExport int16_t sd() const
    {
        return m_sd;
    }

    /*!
     * @brief This function returns a reference to member sd
     * @return Reference to member sd
     */
    eProsima_user_DllExport int16_t& sd()
    {
        return m_sd;
    }


    /*!
     * @brief This function sets a value in member ld
     * @param _ld New value for member ld
     */
    eProsima_user_DllExport void ld(
            int32_t _ld)
    {
        m_ld = _ld;
    }

    /*!
     * @brief This function returns the value of member ld
     * @return Value of member ld
     */
    eProsima_user_DllExport int32_t ld() const
    {
        return m_ld;
    }

    /*!
     * @brief This function returns a reference to member ld
     * @return Reference to member ld
     */
    eProsima_user_DllExport int32_t& ld()
    {
        return m_ld;
    }


    /*!
     * @brief This function sets a value in member lld
     * @param _lld New value for member lld
     */
    eProsima_user_DllExport void lld(
            int64_t _lld)
    {
        m_lld = _lld;
    }

    /*!
     * @brief This function returns the value of member lld
     * @return Value of member lld
     */
    eProsima_user_DllExport int64_t lld() const
    {
        return m_lld;
    }

    /*!
     * @brief This function returns a reference to member lld
     * @return Reference to member lld
     */
    eProsima_user_DllExport int64_t& lld()
    {
        return m_lld;
    }



private:

    char m_cd{0};
    uint8_t m_od{0};
    int16_t m_sd{0};
    int32_t m_ld{0};
    int64_t m_lld{0};

};

#endif // _FAST_DDS_GENERATED_MEMBER_ID_HPP_


