
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <AppBlend_Approx.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_AppBlend_enums(py::module &main_module) {


py::module m = main_module.def_submodule("AppBlend", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums

//Python trampoline classes
    class Py_AppBlend_Approx : public AppBlend_Approx{
    public:
        using AppBlend_Approx::AppBlend_Approx;


        // public pure virtual
        Standard_Boolean IsDone() const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,IsDone,) };
        void Surface(TColgp_Array2OfPnt & TPoles,TColStd_Array2OfReal & TWeights,TColStd_Array1OfReal & TUKnots,TColStd_Array1OfReal & TVKnots,TColStd_Array1OfInteger & TUMults,TColStd_Array1OfInteger & TVMults) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,Surface,TPoles,TWeights,TUKnots,TVKnots,TUMults,TVMults) };
        Standard_Integer UDegree() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,UDegree,) };
        Standard_Integer VDegree() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,VDegree,) };
         const TColgp_Array2OfPnt & SurfPoles() const  override { using return_type =  const TColgp_Array2OfPnt &;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,SurfPoles,) };
         const TColStd_Array2OfReal & SurfWeights() const  override { using return_type =  const TColStd_Array2OfReal &;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,SurfWeights,) };
         const TColStd_Array1OfReal & SurfUKnots() const  override { using return_type =  const TColStd_Array1OfReal &;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,SurfUKnots,) };
         const TColStd_Array1OfReal & SurfVKnots() const  override { using return_type =  const TColStd_Array1OfReal &;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,SurfVKnots,) };
         const TColStd_Array1OfInteger & SurfUMults() const  override { using return_type =  const TColStd_Array1OfInteger &;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,SurfUMults,) };
         const TColStd_Array1OfInteger & SurfVMults() const  override { using return_type =  const TColStd_Array1OfInteger &;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,SurfVMults,) };
        Standard_Integer NbCurves2d() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,NbCurves2d,) };
        void Curve2d( const Standard_Integer Index,TColgp_Array1OfPnt2d & TPoles,TColStd_Array1OfReal & TKnots,TColStd_Array1OfInteger & TMults) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,Curve2d,Index,TPoles,TKnots,TMults) };
        Standard_Integer Curves2dDegree() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,Curves2dDegree,) };
         const TColgp_Array1OfPnt2d & Curve2dPoles( const Standard_Integer Index) const  override { using return_type =  const TColgp_Array1OfPnt2d &;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,Curve2dPoles,Index) };
         const TColStd_Array1OfReal & Curves2dKnots() const  override { using return_type =  const TColStd_Array1OfReal &;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,Curves2dKnots,) };
         const TColStd_Array1OfInteger & Curves2dMults() const  override { using return_type =  const TColStd_Array1OfInteger &;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,Curves2dMults,) };
        Standard_Real TolCurveOnSurf( const Standard_Integer Index) const  override { using return_type = Standard_Real;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,TolCurveOnSurf,Index) };
        void SurfShape(Standard_Integer & UDegree,Standard_Integer & VDegree,Standard_Integer & NbUPoles,Standard_Integer & NbVPoles,Standard_Integer & NbUKnots,Standard_Integer & NbVKnots) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,SurfShape,UDegree,VDegree,NbUPoles,NbVPoles,NbUKnots,NbVKnots) };
        void Curves2dShape(Standard_Integer & Degree,Standard_Integer & NbPoles,Standard_Integer & NbKnots) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,Curves2dShape,Degree,NbPoles,NbKnots) };
        void TolReached(Standard_Real & Tol3d,Standard_Real & Tol2d) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,TolReached,Tol3d,Tol2d) };


        // protected pure virtual


        // private pure virtual

    };

// pre-register typdefs+classes (topologically sorted)
    py::class_<AppBlend_Approx , shared_ptr<AppBlend_Approx> ,Py_AppBlend_Approx >(m,"AppBlend_Approx",R"#(Bspline approximation of a surface.)#");

};

// user-defined post-inclusion per module

// user-defined post
