
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Storage_BaseDriver.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TCollection_AsciiString.hxx>
#include <Storage_Data.hxx>
#include <CDM_Document.hxx>
#include <Message_Messenger.hxx>
#include <Storage_BaseDriver.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TCollection_AsciiString.hxx>
#include <Storage_Data.hxx>
#include <CDM_Document.hxx>
#include <Message_Messenger.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <CDM_Document.hxx>
#include <CDM_Application.hxx>
#include <PCDM_ReaderFilter.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <CDM_Document.hxx>
#include <CDM_MetaData.hxx>
#include <CDM_Application.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <CDM_MetaData.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <CDM_Document.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <CDM_Document.hxx>
#include <TCollection_ExtendedString.hxx>

// module includes
#include <PCDM.hxx>
#include <PCDM_BaseDriverPointer.hxx>
#include <PCDM_Document.hxx>
#include <PCDM_DOMHeaderParser.hxx>
#include <PCDM_DriverError.hxx>
#include <PCDM_Reader.hxx>
#include <PCDM_ReaderFilter.hxx>
#include <PCDM_ReaderStatus.hxx>
#include <PCDM_ReadWriter.hxx>
#include <PCDM_ReadWriter_1.hxx>
#include <PCDM_Reference.hxx>
#include <PCDM_ReferenceIterator.hxx>
#include <PCDM_RetrievalDriver.hxx>
#include <PCDM_SequenceOfDocument.hxx>
#include <PCDM_SequenceOfReference.hxx>
#include <PCDM_StorageDriver.hxx>
#include <PCDM_StoreStatus.hxx>
#include <PCDM_TypeOfFileDriver.hxx>
#include <PCDM_Writer.hxx>

// template related includes

#include "NCollection_tmpl.hxx"

#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_PCDM_enums(py::module &main_module) {


py::module m = main_module.def_submodule("PCDM", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums
    py::enum_<PCDM_TypeOfFileDriver>(m, "PCDM_TypeOfFileDriver",R"#()#")
        .value("PCDM_TOFD_File",PCDM_TypeOfFileDriver::PCDM_TOFD_File)
        .value("PCDM_TOFD_CmpFile",PCDM_TypeOfFileDriver::PCDM_TOFD_CmpFile)
        .value("PCDM_TOFD_XmlFile",PCDM_TypeOfFileDriver::PCDM_TOFD_XmlFile)
        .value("PCDM_TOFD_Unknown",PCDM_TypeOfFileDriver::PCDM_TOFD_Unknown).export_values();
    py::enum_<PCDM_StoreStatus>(m, "PCDM_StoreStatus",R"#(Status of storage of a document on disk. If it is PCDM_SS_OK, the document is successfully saved on disk. Else - there is an error.)#")
        .value("PCDM_SS_OK",PCDM_StoreStatus::PCDM_SS_OK)
        .value("PCDM_SS_DriverFailure",PCDM_StoreStatus::PCDM_SS_DriverFailure)
        .value("PCDM_SS_WriteFailure",PCDM_StoreStatus::PCDM_SS_WriteFailure)
        .value("PCDM_SS_Failure",PCDM_StoreStatus::PCDM_SS_Failure)
        .value("PCDM_SS_Doc_IsNull",PCDM_StoreStatus::PCDM_SS_Doc_IsNull)
        .value("PCDM_SS_No_Obj",PCDM_StoreStatus::PCDM_SS_No_Obj)
        .value("PCDM_SS_Info_Section_Error",PCDM_StoreStatus::PCDM_SS_Info_Section_Error)
        .value("PCDM_SS_UserBreak",PCDM_StoreStatus::PCDM_SS_UserBreak)
        .value("PCDM_SS_UnrecognizedFormat",PCDM_StoreStatus::PCDM_SS_UnrecognizedFormat).export_values();
    py::enum_<PCDM_ReaderStatus>(m, "PCDM_ReaderStatus",R"#(Status of reading of a document. The following values are accessible: - PCDM_RS_OK: the document was successfully read; - PCDM_RS_NoDriver: driver is not found for the defined file format; - PCDM_RS_UnknownFileDriver: check of the file failed (file doesn't exist, for example); - PCDM_RS_OpenError: attempt to open the file failed; - PCDM_RS_NoVersion: document version of the file is out of scope; - PCDM_RS_NoSchema: NOT USED; - PCDM_RS_NoDocument: document is empty (failed to be read correctly); - PCDM_RS_ExtensionFailure: NOT USED; - PCDM_RS_WrongStreamMode: file is not open for reading (a mistaken mode); - PCDM_RS_FormatFailure: mistake in document data structure; - PCDM_RS_TypeFailure: data type is unknown; - PCDM_RS_TypeNotFoundInSchema: data type is not found in schema (STD file format); - PCDM_RS_UnrecognizedFileFormat: document data structure is wrong (binary file format); - PCDM_RS_MakeFailure: conversion of data from persistent to transient attributes failed (XML file format); - PCDM_RS_PermissionDenied: file can't be opened because permission is denied; - PCDM_RS_DriverFailure: something went wrong (a general mistake of reading of a document); - PCDM_RS_AlreadyRetrievedAndModified: document is already retrieved and modified in current session; - PCDM_RS_AlreadyRetrieved: document is already in current session (already retrieved); - PCDM_RS_UnknownDocument: file doesn't exist on disk; - PCDM_RS_WrongResource: wrong resource file (.RetrievalPlugin); - PCDM_RS_ReaderException: no shape section in the document file (binary file format); - PCDM_RS_NoModel: NOT USED; - PCDM_RS_UserBreak: user stopped reading of the document;)#")
        .value("PCDM_RS_OK",PCDM_ReaderStatus::PCDM_RS_OK)
        .value("PCDM_RS_NoDriver",PCDM_ReaderStatus::PCDM_RS_NoDriver)
        .value("PCDM_RS_UnknownFileDriver",PCDM_ReaderStatus::PCDM_RS_UnknownFileDriver)
        .value("PCDM_RS_OpenError",PCDM_ReaderStatus::PCDM_RS_OpenError)
        .value("PCDM_RS_NoVersion",PCDM_ReaderStatus::PCDM_RS_NoVersion)
        .value("PCDM_RS_NoSchema",PCDM_ReaderStatus::PCDM_RS_NoSchema)
        .value("PCDM_RS_NoDocument",PCDM_ReaderStatus::PCDM_RS_NoDocument)
        .value("PCDM_RS_ExtensionFailure",PCDM_ReaderStatus::PCDM_RS_ExtensionFailure)
        .value("PCDM_RS_WrongStreamMode",PCDM_ReaderStatus::PCDM_RS_WrongStreamMode)
        .value("PCDM_RS_FormatFailure",PCDM_ReaderStatus::PCDM_RS_FormatFailure)
        .value("PCDM_RS_TypeFailure",PCDM_ReaderStatus::PCDM_RS_TypeFailure)
        .value("PCDM_RS_TypeNotFoundInSchema",PCDM_ReaderStatus::PCDM_RS_TypeNotFoundInSchema)
        .value("PCDM_RS_UnrecognizedFileFormat",PCDM_ReaderStatus::PCDM_RS_UnrecognizedFileFormat)
        .value("PCDM_RS_MakeFailure",PCDM_ReaderStatus::PCDM_RS_MakeFailure)
        .value("PCDM_RS_PermissionDenied",PCDM_ReaderStatus::PCDM_RS_PermissionDenied)
        .value("PCDM_RS_DriverFailure",PCDM_ReaderStatus::PCDM_RS_DriverFailure)
        .value("PCDM_RS_AlreadyRetrievedAndModified",PCDM_ReaderStatus::PCDM_RS_AlreadyRetrievedAndModified)
        .value("PCDM_RS_AlreadyRetrieved",PCDM_ReaderStatus::PCDM_RS_AlreadyRetrieved)
        .value("PCDM_RS_UnknownDocument",PCDM_ReaderStatus::PCDM_RS_UnknownDocument)
        .value("PCDM_RS_WrongResource",PCDM_ReaderStatus::PCDM_RS_WrongResource)
        .value("PCDM_RS_ReaderException",PCDM_ReaderStatus::PCDM_RS_ReaderException)
        .value("PCDM_RS_NoModel",PCDM_ReaderStatus::PCDM_RS_NoModel)
        .value("PCDM_RS_UserBreak",PCDM_ReaderStatus::PCDM_RS_UserBreak).export_values();

//Python trampoline classes
    class Py_PCDM_ReadWriter : public PCDM_ReadWriter{
    public:
        using PCDM_ReadWriter::PCDM_ReadWriter;


        // public pure virtual
        TCollection_AsciiString Version() const  override { using return_type = TCollection_AsciiString;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_ReadWriter,Version,) };
        void WriteReferenceCounter( const handle<Storage_Data> & aData, const handle<CDM_Document> & aDocument) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_ReadWriter,WriteReferenceCounter,aData,aDocument) };
        void WriteReferences( const handle<Storage_Data> & aData, const handle<CDM_Document> & aDocument, const TCollection_ExtendedString & theReferencerFileName) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_ReadWriter,WriteReferences,aData,aDocument,theReferencerFileName) };
        void WriteExtensions( const handle<Storage_Data> & aData, const handle<CDM_Document> & aDocument) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_ReadWriter,WriteExtensions,aData,aDocument) };
        void WriteVersion( const handle<Storage_Data> & aData, const handle<CDM_Document> & aDocument) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_ReadWriter,WriteVersion,aData,aDocument) };
        Standard_Integer ReadReferenceCounter( const TCollection_ExtendedString & theFileName, const handle<Message_Messenger> & theMsgDriver) const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_ReadWriter,ReadReferenceCounter,theFileName,theMsgDriver) };
        void ReadReferences( const TCollection_ExtendedString & aFileName,PCDM_SequenceOfReference & theReferences, const handle<Message_Messenger> & theMsgDriver) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_ReadWriter,ReadReferences,aFileName,theReferences,theMsgDriver) };
        void ReadExtensions( const TCollection_ExtendedString & aFileName,TColStd_SequenceOfExtendedString & theExtensions, const handle<Message_Messenger> & theMsgDriver) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_ReadWriter,ReadExtensions,aFileName,theExtensions,theMsgDriver) };
        Standard_Integer ReadDocumentVersion( const TCollection_ExtendedString & aFileName, const handle<Message_Messenger> & theMsgDriver) const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_ReadWriter,ReadDocumentVersion,aFileName,theMsgDriver) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_PCDM_Reader : public PCDM_Reader{
    public:
        using PCDM_Reader::PCDM_Reader;


        // public pure virtual
        void Read( const TCollection_ExtendedString & aFileName, const handle<CDM_Document> & aNewDocument, const handle<CDM_Application> & anApplication, const handle<PCDM_ReaderFilter> & theFilter, const Message_ProgressRange & theProgress) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_Reader,Read,aFileName,aNewDocument,anApplication,theFilter,theProgress) };
        void Read(Standard_IStream & theIStream, const handle<Storage_Data> & theStorageData, const handle<CDM_Document> & theDoc, const handle<CDM_Application> & theApplication, const handle<PCDM_ReaderFilter> & theFilter, const Message_ProgressRange & theProgress) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_Reader,Read,theIStream,theStorageData,theDoc,theApplication,theFilter,theProgress) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_PCDM_Writer : public PCDM_Writer{
    public:
        using PCDM_Writer::PCDM_Writer;


        // public pure virtual
        void Write( const handle<CDM_Document> & aDocument, const TCollection_ExtendedString & aFileName, const Message_ProgressRange & theRange) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_Writer,Write,aDocument,aFileName,theRange) };
        void Write( const handle<CDM_Document> & theDocument,Standard_OStream & theOStream, const Message_ProgressRange & theRange) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_Writer,Write,theDocument,theOStream,theRange) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_PCDM_RetrievalDriver : public PCDM_RetrievalDriver{
    public:
        using PCDM_RetrievalDriver::PCDM_RetrievalDriver;


        // public pure virtual

        void Read( const TCollection_ExtendedString & aFileName, const handle<CDM_Document> & aNewDocument, const handle<CDM_Application> & anApplication, const handle<PCDM_ReaderFilter> & theFilter, const Message_ProgressRange & theProgress) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_Reader,Read,aFileName,aNewDocument,anApplication,theFilter,theProgress) };
        void Read(Standard_IStream & theIStream, const handle<Storage_Data> & theStorageData, const handle<CDM_Document> & theDoc, const handle<CDM_Application> & theApplication, const handle<PCDM_ReaderFilter> & theFilter, const Message_ProgressRange & theProgress) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,PCDM_Reader,Read,theIStream,theStorageData,theDoc,theApplication,theFilter,theProgress) };

        // protected pure virtual


        // private pure virtual

    };

// pre-register typdefs+classes (topologically sorted)
    py::class_<PCDM , shared_ptr<PCDM>  >(m,"PCDM",R"#()#");
    py::class_<PCDM_Reference , shared_ptr<PCDM_Reference>  >(m,"PCDM_Reference",R"#()#");
    py::class_<PCDM_Document ,opencascade::handle<PCDM_Document>  , Standard_Persistent >(m,"PCDM_Document",R"#()#");
    py::class_<PCDM_ReadWriter ,opencascade::handle<PCDM_ReadWriter> ,Py_PCDM_ReadWriter , Standard_Transient >(m,"PCDM_ReadWriter",R"#()#");
    py::class_<PCDM_Reader ,opencascade::handle<PCDM_Reader> ,Py_PCDM_Reader , Standard_Transient >(m,"PCDM_Reader",R"#()#");
    py::class_<PCDM_ReaderFilter ,opencascade::handle<PCDM_ReaderFilter>  , Standard_Transient >(m,"PCDM_ReaderFilter",R"#(Class represents a document reading filter.Class represents a document reading filter.Class represents a document reading filter.)#");
    py::class_<PCDM_ReferenceIterator ,opencascade::handle<PCDM_ReferenceIterator>  , Standard_Transient >(m,"PCDM_ReferenceIterator",R"#()#");
    preregister_template_NCollection_Sequence<opencascade::handle<PCDM_Document>>(m,"PCDM_SequenceOfDocument");
    preregister_template_NCollection_Sequence<PCDM_Reference>(m,"PCDM_SequenceOfReference");
    py::class_<PCDM_Writer ,opencascade::handle<PCDM_Writer> ,Py_PCDM_Writer , Standard_Transient >(m,"PCDM_Writer",R"#()#");
    py::class_<PCDM_ReadWriter_1 ,opencascade::handle<PCDM_ReadWriter_1>  , PCDM_ReadWriter >(m,"PCDM_ReadWriter_1",R"#()#");
    py::class_<PCDM_RetrievalDriver ,opencascade::handle<PCDM_RetrievalDriver> ,Py_PCDM_RetrievalDriver , PCDM_Reader >(m,"PCDM_RetrievalDriver",R"#()#");
    py::class_<PCDM_StorageDriver ,opencascade::handle<PCDM_StorageDriver>  , PCDM_Writer >(m,"PCDM_StorageDriver",R"#(persistent implementation of storage.persistent implementation of storage.persistent implementation of storage.)#");

};

// user-defined post-inclusion per module

// user-defined post
