//! Converted to Rust from the original C code generated by https://github.com/corsix/fast-crc32/
//! with the help of Claude.ai.
//!
//! MIT licensed.

#![cfg(target_arch = "x86_64")]

/// Converted to Rust from the original C code generated by https://github.com/corsix/fast-crc32/
/// with the help of Claude.ai using:
///
/// ./generate -i avx512 -p crc32c -a v4s3x3
///
/// Modified as necessary for this Rust implementation.
///
/// Uses AVX-512 instructions so only available after Rust 1.89 (when AVX-512 stabilized)
#[rustversion::since(1.89)]
#[inline]
#[target_feature(enable = "avx512vl,pclmulqdq")]
pub unsafe fn crc32_iscsi_avx512_v4s3x3(mut crc0: u32, mut buf: *const u8, mut len: usize) -> u32 {
    use crate::fusion::x86::*;

    // Align to 8-byte boundary using hardware CRC32C instructions
    while len > 0 && (buf as usize & 7) != 0 {
        crc0 = _mm_crc32_u8(crc0, *buf);
        buf = buf.add(1);
        len -= 1;
    }

    // Handle 8-byte alignment
    if (buf as usize & 8) != 0 && len >= 8 {
        crc0 = _mm_crc32_u64(crc0.into(), *(buf as *const u64)) as u32;
        buf = buf.add(8);
        len -= 8;
    }

    if len >= 144 {
        let blk = (len - 8) / 136;
        let klen = blk * 24;
        let buf2 = buf;
        let mut crc1 = 0u32;
        let mut crc2 = 0u32;

        // First vector chunk - load four 128-bit vectors (64 bytes total)
        let mut x0 = _mm_loadu_si128(buf2 as *const __m128i);
        let mut x1 = _mm_loadu_si128(buf2.add(16) as *const __m128i);
        let mut x2 = _mm_loadu_si128(buf2.add(32) as *const __m128i);
        let mut x3 = _mm_loadu_si128(buf2.add(48) as *const __m128i);

        // iSCSI-specific folding constant (different from ISO-HDLC)
        let mut k = _mm_setr_epi32(0x740eef02u32 as i32, 0, 0x9e4addf8u32 as i32, 0);

        // XOR the CRC into the first vector's low 32 bits
        x0 = _mm_xor_si128(_mm_cvtsi32_si128(crc0 as i32), x0);
        crc0 = 0;

        let mut buf2 = buf2.add(64);
        len -= 136;
        buf = buf.add(blk * 64);

        // Main loop - process 144 bytes at a time
        while len >= 144 {
            let y0 = clmul_lo_sse(x0, k);
            x0 = clmul_hi_sse(x0, k);
            let y1 = clmul_lo_sse(x1, k);
            x1 = clmul_hi_sse(x1, k);
            let y2 = clmul_lo_sse(x2, k);
            x2 = clmul_hi_sse(x2, k);
            let y3 = clmul_lo_sse(x3, k);
            x3 = clmul_hi_sse(x3, k);

            // XOR with next chunk of data using ternary logic (A XOR B XOR C)
            x0 = _mm_ternarylogic_epi64(x0, y0, _mm_loadu_si128(buf2 as *const __m128i), 0x96);
            x1 = _mm_ternarylogic_epi64(
                x1,
                y1,
                _mm_loadu_si128(buf2.add(16) as *const __m128i),
                0x96,
            );
            x2 = _mm_ternarylogic_epi64(
                x2,
                y2,
                _mm_loadu_si128(buf2.add(32) as *const __m128i),
                0x96,
            );
            x3 = _mm_ternarylogic_epi64(
                x3,
                y3,
                _mm_loadu_si128(buf2.add(48) as *const __m128i),
                0x96,
            );

            // Process scalar data in parallel using hardware CRC32C
            crc0 = _mm_crc32_u64(crc0.into(), *(buf as *const u64)) as u32;
            crc1 = _mm_crc32_u64(crc1.into(), *(buf.add(klen) as *const u64)) as u32;
            crc2 = _mm_crc32_u64(crc2.into(), *(buf.add(klen * 2) as *const u64)) as u32;
            crc0 = _mm_crc32_u64(crc0.into(), *(buf.add(8) as *const u64)) as u32;
            crc1 = _mm_crc32_u64(crc1.into(), *(buf.add(klen + 8) as *const u64)) as u32;
            crc2 = _mm_crc32_u64(crc2.into(), *(buf.add(klen * 2 + 8) as *const u64)) as u32;
            crc0 = _mm_crc32_u64(crc0.into(), *(buf.add(16) as *const u64)) as u32;
            crc1 = _mm_crc32_u64(crc1.into(), *(buf.add(klen + 16) as *const u64)) as u32;
            crc2 = _mm_crc32_u64(crc2.into(), *(buf.add(klen * 2 + 16) as *const u64)) as u32;

            buf = buf.add(24);
            buf2 = buf2.add(64);
            len -= 136;
        }

        // Reduce x0 ... x3 to just x0 using iSCSI-specific constants
        k = _mm_setr_epi32(0xf20c0dfeu32 as i32, 0, 0x493c7d27u32 as i32, 0);

        let y0 = clmul_lo_sse(x0, k);
        x0 = clmul_hi_sse(x0, k);
        let y2 = clmul_lo_sse(x2, k);
        x2 = clmul_hi_sse(x2, k);

        x0 = _mm_ternarylogic_epi64(x0, y0, x1, 0x96);
        x2 = _mm_ternarylogic_epi64(x2, y2, x3, 0x96);

        k = _mm_setr_epi32(0x3da6d0cbu32 as i32, 0, 0xba4fc28eu32 as i32, 0);

        let y0 = clmul_lo_sse(x0, k);
        x0 = clmul_hi_sse(x0, k);
        x0 = _mm_ternarylogic_epi64(x0, y0, x2, 0x96);

        // Final scalar chunk
        crc0 = _mm_crc32_u64(crc0.into(), *(buf as *const u64)) as u32;
        crc1 = _mm_crc32_u64(crc1.into(), *(buf.add(klen) as *const u64)) as u32;
        crc2 = _mm_crc32_u64(crc2.into(), *(buf.add(klen * 2) as *const u64)) as u32;
        crc0 = _mm_crc32_u64(crc0.into(), *(buf.add(8) as *const u64)) as u32;
        crc1 = _mm_crc32_u64(crc1.into(), *(buf.add(klen + 8) as *const u64)) as u32;
        crc2 = _mm_crc32_u64(crc2.into(), *(buf.add(klen * 2 + 8) as *const u64)) as u32;
        crc0 = _mm_crc32_u64(crc0.into(), *(buf.add(16) as *const u64)) as u32;
        crc1 = _mm_crc32_u64(crc1.into(), *(buf.add(klen + 16) as *const u64)) as u32;
        crc2 = _mm_crc32_u64(crc2.into(), *(buf.add(klen * 2 + 16) as *const u64)) as u32;
        buf = buf.add(24);

        let vc0 = crc_shift_iscsi_sse(crc0, klen * 2 + 8);
        let vc1 = crc_shift_iscsi_sse(crc1, klen + 8);
        let mut vc = _mm_extract_epi64(_mm_xor_si128(vc0, vc1), 0) as u64;

        // Reduce 128 bits to 32 bits, and multiply by x^32
        let x0_low = _mm_extract_epi64(x0, 0) as u64;
        let x0_high = _mm_extract_epi64(x0, 1) as u64;
        let vec_crc = _mm_crc32_u64(_mm_crc32_u64(0, x0_low), x0_high);
        vc ^= _mm_extract_epi64(crc_shift_iscsi_sse(vec_crc as u32, klen * 3 + 8), 0) as u64;

        // Final 8 bytes
        buf = buf.add(klen * 2);
        crc0 = crc2;
        crc0 = _mm_crc32_u64(crc0.into(), *(buf as *const u64) ^ vc) as u32;
        buf = buf.add(8);
        len -= 8;
    }

    // Process remaining 8-byte chunks using hardware CRC32C
    while len >= 8 {
        crc0 = _mm_crc32_u64(crc0.into(), *(buf as *const u64)) as u32;
        buf = buf.add(8);
        len -= 8;
    }

    // Process remaining bytes using hardware CRC32C
    while len > 0 {
        crc0 = _mm_crc32_u8(crc0, *buf);
        buf = buf.add(1);
        len -= 1;
    }

    crc0
}
