# 2021-11-09 Triage Log

Largely a positive week despite taking a significant performance hit from turning on incremental compilation verification for a subsection of the total queries that the compiler does in order to more quickly catch bugs in incremental compilation. Luckily optimizations in bidi detection brought large performance improvements.

Triage done by **@rylev**.
Revision range: [6384dca100f3cedfa031a9204586f94f8612eae5..eee8b9c7bafade55981d155dae71657f1cc55a22](https://perf.rust-lang.org/?start=6384dca100f3cedfa031a9204586f94f8612eae5&end=eee8b9c7bafade55981d155dae71657f1cc55a22&absolute=false&stat=instructions%3Au)

2 Regressions, 4 Improvements, 4 Mixed; 1 of them in rollups
45 comparisons made in total

#### Regressions

Implement `RefUnwindSafe` for `Rc<T>` [#87467](https://github.com/rust-lang/rust/issues/87467)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=0b4ac62ddaf9ee01b8aaf9dd7097f1f541d64551&end=4061c0407978a00c5c2518d898ad8406da28c106&stat=instructions:u) (up to 1.1% on `full` builds of `cargo`)
- Unsurprising regression in one instance of a rustdoc run since `get_auto_trait_impls` has bad algoritmic complexity. This issue is being tracked somewhat [here](https://github.com/rust-lang/rust/issues/90512).

Enable verification for 1/32th of queries loaded from disk [#90361](https://github.com/rust-lang/rust/issues/90361)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=3e3890c9d4064253aaa8c51f5d5458d2dc6dab77&end=495322d776fd6f679cd8cd4ca02b8fa834da654b&stat=instructions:u) (up to 6.3% on `incr-unchanged` builds of `coercions`)
- Allows for verification of incremental compilation results to more easily catch bugs (which have unfortunately been a bit too common in the past).
- As noted in the PR this is a regression of at most 7% on coercions opt incr-unchanged, and typically less than 0.5% on other benchmarks (largely limited to incr-unchanged).
- The PR author and reviewer reviewed the regression impact and it was deemed acceptable.

#### Improvements

Optimize bidi character detection. [#90559](https://github.com/rust-lang/rust/issues/90559)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=3326f19e8982ce033e04c163ddc520a76e42c737&end=5ec7d1dad6dead949a49c76c8ca0425a6e46a223&stat=instructions:u) (up to -11.6% on `incr-unchanged` builds of `coercions`)


Fix ICE when rustdoc is scraping examples inside of a proc macro [#90583](https://github.com/rust-lang/rust/issues/90583)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=045612b8b97b344d55c13b9aad3cfb3e98405b77&end=0d1754e8bf6942b4c1d24d7c923438782129ba5a&stat=instructions:u) (up to -0.7% on `full` builds of `webrender`)


Replace some uses of vec.drain(..) with vec.into_iter() [#90655](https://github.com/rust-lang/rust/issues/90655)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=5ec7d1dad6dead949a49c76c8ca0425a6e46a223&end=0727994435c75fdedd3e9d226cf434089b0ab585&stat=instructions:u) (up to -0.5% on `full` builds of `deeply-nested-async`)


rustdoc: Cleanup `clean::Impl` and other parts of `clean` [#90675](https://github.com/rust-lang/rust/issues/90675)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=b3074819f615758da44a667bf3cb98c59227e2f9&end=3e3890c9d4064253aaa8c51f5d5458d2dc6dab77&stat=instructions:u) (up to -0.7% on `full` builds of `deeply-nested`)


#### Mixed

rustdoc: Add `DocVisitor` and use it where possible [#90475](https://github.com/rust-lang/rust/issues/90475)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=baba6687df3e83fdb15cc6ec239b4a1c75a30505&end=4ff90232a0c0c6adb9d2052da2206b26c3c723e4&stat=instructions:u) (up to -0.8% on `full` builds of `serde`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=baba6687df3e83fdb15cc6ec239b4a1c75a30505&end=4ff90232a0c0c6adb9d2052da2206b26c3c723e4&stat=instructions:u) (up to 0.5% on `full` builds of `webrender`)
- The regressions have [already been justified](https://github.com/rust-lang/rust/pull/90475#issuecomment-959808629), but in short the improvements outweigh the regressions, and the code is much cleaner as a result.


 Improve error when an .rlib can't be parsed [#88368](https://github.com/rust-lang/rust/issues/88368)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=46b8e7488eae116722196e8390c1bd2ea2e396cf&end=5fa94f3c57e27a339bc73336cd260cd875026bd1&stat=instructions:u) (up to -0.3% on `full` builds of `externs`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=46b8e7488eae116722196e8390c1bd2ea2e396cf&end=5fa94f3c57e27a339bc73336cd260cd875026bd1&stat=instructions:u) (up to 0.5% on `incr-unchanged` builds of `helloworld`)
- It was pointed out that this could be simply due to a different binary layout impacting performance.
- When taking into account significance factor, the improvements outweigh the regressions, and so it's likely not worth it to investigate deeper.


Rollup of 4 pull requests [#90695](https://github.com/rust-lang/rust/issues/90695)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=515472757d2991e280965d7c1d235cfbb6ceb006&end=c57704f3eb4319cc93513c232e9c434a73af46d2&stat=instructions:u) (up to -0.5% on `full` builds of `deeply-nested-async`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=515472757d2991e280965d7c1d235cfbb6ceb006&end=c57704f3eb4319cc93513c232e9c434a73af46d2&stat=instructions:u) (up to 0.3% on `incr-unchanged` builds of `html5ever`)
- Nothing jumps out as a possible cause for this but luckily the perf changes in question are small.


Don't destructure args tuple in format_args! [#90485](https://github.com/rust-lang/rust/issues/90485)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=c57704f3eb4319cc93513c232e9c434a73af46d2&end=60952bc3da442cf2ea11dcc9c80a461a659bbcd7&stat=instructions:u) (up to -4.0% on `incr-unchanged` builds of `inflate`)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=c57704f3eb4319cc93513c232e9c434a73af46d2&end=60952bc3da442cf2ea11dcc9c80a461a659bbcd7&stat=instructions:u) (up to 1.3% on `incr-patched: println` builds of `html5ever`)
- The regressions seem to be coming in `expand_crate` which might be impacted by this change. However, nothing stands out immediately as a definite cause for concern.
- Left a [comment](https://github.com/rust-lang/rust/pull/90485#issuecomment-964330008) for the author and reviewer to ask if they have an ideas before we investigate more.


#### Untriaged Pull Requests

- [#90695 Rollup of 4 pull requests](https://github.com/rust-lang/rust/pull/90695)
- [#90485 Don't destructure args tuple in format_args!](https://github.com/rust-lang/rust/pull/90485)
- [#90462 [master] Fix CVE-2021-42574](https://github.com/rust-lang/rust/pull/90462)
- [#90422 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/90422)
- [#90235 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/90235)
- [#90183 Show all Deref implementations recursively](https://github.com/rust-lang/rust/pull/90183)
- [#90067 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/90067)
- [#89939 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/89939)
- [#89858 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/89858)
- [#89695 Move top part of print_item to Tera templates](https://github.com/rust-lang/rust/pull/89695)
- [#89608 Rollup of 12 pull requests](https://github.com/rust-lang/rust/pull/89608)
- [#89534 Introduce `tcx.get_diagnostic_name`](https://github.com/rust-lang/rust/pull/89534)
- [#89435 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/89435)
- [#89405 Fix clippy lints](https://github.com/rust-lang/rust/pull/89405)
- [#89263 Suggest both of immutable and mutable trait implementations](https://github.com/rust-lang/rust/pull/89263)
- [#89165 Fix read_to_end to not grow an exact size buffer](https://github.com/rust-lang/rust/pull/89165)
- [#89125 Don't use projection cache or candidate cache in intercrate mode](https://github.com/rust-lang/rust/pull/89125)
- [#89124 Index and hash HIR as part of lowering](https://github.com/rust-lang/rust/pull/89124)
- [#89103 Migrate in-tree crates to 2021](https://github.com/rust-lang/rust/pull/89103)
- [#89100 resolve: Use `NameBinding` for local variables and generic parameters](https://github.com/rust-lang/rust/pull/89100)
- [#89047 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/89047)
- [#89030 Introduce `Rvalue::ShallowInitBox`](https://github.com/rust-lang/rust/pull/89030)
- [#88945 Remove concept of 'completion' from the projection cache](https://github.com/rust-lang/rust/pull/88945)
- [#88880 Rework HIR API to make invocations of the hir_crate query harder.](https://github.com/rust-lang/rust/pull/88880)
- [#88824 Rollup of 15 pull requests](https://github.com/rust-lang/rust/pull/88824)
- [#88804 Revise never type fallback algorithm](https://github.com/rust-lang/rust/pull/88804)
- [#88719 Point at argument instead of call for their obligations](https://github.com/rust-lang/rust/pull/88719)
- [#88703 Gather module items after lowering.](https://github.com/rust-lang/rust/pull/88703)
- [#88627 Do not preallocate HirIds](https://github.com/rust-lang/rust/pull/88627)

