(in-package "ACL2")

(include-book "irepsproofs")
(include-book "rnd")

;add to lib?
;can save you from having to :use fp-rep
(defthm fp-rep-cancel-expo
  (implies (rationalp x)
           (equal (* x (expt 2 (- (expo x))))
                  (* (sgn x) (sig x))))
  :hints (("Goal" :use (fp-rep))))


;add to lib?
;can save you from having to :use fp-rep
(defthm fp-rep-cancel-sig
  (implies (and 
            (rationalp x)
            (not (= x 0)))
           (equal (/ x (sig x))
                  (* (sgn x) (expt 2 (expo x)))))
  :hints (("Goal" :use (fp-rep))))

(in-theory (disable fp-rep-cancel-expo fp-rep-cancel-sig))

; needed below
;useful?
; could be made more general?
(defthm sig-x+2**k-non-neg
  (implies (and (integerp k)
                (rationalp x)
                (<= 0 x)
                (< x (expt 2 k)))
           (equal
            (sig (+ (expt 2 k) x))
            (+ 1 (/ x (expt 2 k)))))
  :hints (("Goal" :in-theory (disable already-sig)
           :use ((:instance sig-shift
                            (x (+ 1 (/ x (expt 2 k))))
                            (n k))
                 (:instance already-sig
                            (x (+ 1 (/ x (expt 2 k)))))))))
;needed below
(defthm expo-x+a*2**k-aux
        (implies (and (integerp k)
                      (rationalp x)
                      (> x 0)
                      (integerp a)
                      (> a 0)
                      (< (expo x) k))
                 (> (expt 2 (+ 1 (expo (* a (expt 2 k)))))
                    (+ x (* a (expt 2 k)))))
        :rule-classes nil :instructions
        (:promote (:claim (< x (expt 2 k))
                          :hints
                          (("goal" :use (:instance expo>= (n k)))))
                  (:claim (< (+ x (* a (expt 2 k)))
                             (+ (expt 2 k) (* a (expt 2 k)))))
                  (:claim (= (+ (expt 2 k) (* a (expt 2 k)))
                             (* (+ a 1) (expt 2 k))))
                  (:claim (> (expt 2 (+ 1 (expo a))) a)
                          :hints
                          (("goal" :use
                                   (:instance expo-upper-bound (x a)))))
                  (:claim (>= (expt 2 (+ 1 (expo a))) (+ a 1)))
                  (:claim (<= (* (expt 2 k) (+ a 1))
                              (* (expt 2 k) (expt 2 (+ 1 (expo a))))))
                  (:claim (= (expt 2 (+ k 1 (expo a)))
                             (* (expt 2 k) (expt 2 (+ 1 (expo a)))))
                          :hints
                          (("goal" :use
                                   (:instance a15 (i 2)
                                              (j1 k)
                                              (j2 (+ 1 (expo a)))))))
                  (:claim (= (+ k (expo a))
                             (expo (* a (expt 2 k))))
                          :hints
                          (("goal" :use
                                   (:instance expo-shift (x a) (n k)))))
                  :prove))

;could this just be done with expo-squeeze?
(defthm expo-x+a*2**k
  (implies (and (integerp k)
                (rationalp x)
                (> x 0)
                (integerp a)
                (> a 0)
                (< (expo x) k))
           (equal (expo (+ x (* a (expt 2 k))))
                  (expo (* a (expt 2 k)))))
  :hints (("goal" :use (expo-x+a*2**k-aux
                        (:instance expo-lower-bound (x (* a (expt 2 k))))
                        (:instance expo-squeeze 
                                   (x (+ x (* a (expt 2 k)))) (n (expo (* a (expt 2 k))))))))
  :otf-flg t)



(defthm plus-trunc-corollary-aux
  (implies (and (rationalp x)
                (> x 0)
                (rationalp y)
                (>= y 0)
                (integerp n)
                (exactp x n)
                (< y (expt 2 (- (1+ (expo x)) n))))
           (equal (expo (+ x y))
                  (expo x)
                  ))
  :hints (("Goal" :use ((:instance a15 (i 2) (j1 1) (j2 (+ (EXPO X) (* -1 N))))
                        (:instance expo<= (x y) (n (+ (EXPO X) (* -1 N))))
                        (:instance fp-rep-cancel-expo)
                        (:instance
                         expo-x+a*2**k
                         (x y)
                         (k (+ (expo x) (- n) 1))
                         (a (/ x (expt 2 (+ (expo x) (- n) 1)))))
                        ))
          ("Subgoal 1" :in-theory (enable exactp sgn)))
  :rule-classes nil
  )


;add to lib?  (alternate form of plus-trunc)
(defthm plus-trunc-alt
  (implies (and (rationalp x)
                (>= x 0)
                (rationalp y)
                (>= y 0)
                (integerp j)
                (exactp x (+ j (expo x) (- (expo (+ x y))))))
           (= (trunc (+ x y) j)
              (+ x (trunc y (+ j (- (expo (+ x y))) (expo y))))))
  :rule-classes ()
  :hints (("goal" 
           :use (:instance plus-trunc
                           (k (+ j (- (expo (+ x y))) (expo y)))))))

;add to lib?
(defthm plus-trunc-corollary
  (implies (and (rationalp x)
                (> x 0)
                (rationalp y)
                (>= y 0)
                (integerp n)
                (exactp x n)
                (< y (expt 2 (- (1+ (expo x)) n))))
           (= (trunc (+ x y) n)
              x))
  :hints (("Goal"  :in-theory (disable trunc-pos-rewrite-eric)
           :cases ((= y 0)))
          ("Subgoal 1" :use (  
                             (:instance only-0-is-0-or-negative-exact) 
                             (:instance trunc-exactp-a)))
          ("Subgoal 2" :use (plus-trunc-corollary-aux 
                             (:instance a15 (i 2) (j1 1) (j2 (+ (EXPO X) (* -1 N))))
                             (:instance expo<=
                                        (x y)
                                        (n (+ (EXPO X) (* -1 N))))
                             (:instance trunc-to-0-or-fewer-bits (x y)
                                        (n (+ N (EXPO Y) (* -1 (EXPO (+ X Y))))))
                             (:instance plus-trunc-alt
                                        (j n))))))

(in-theory (enable bias))

(defthm away-pos-rewrite-eric
  (implies (and (rationalp x)
                (>= x 0)
                (integerp n))
           (equal (away x n)
                  (* (cg (* (expt 2 (- (1- n) (expo x))) x))
                     (expt 2 (- (1+ (expo x)) n)))))
  :hints (("goal" :in-theory (enable away sgn)
           :use fp-abs)))

(defthm plus-away-2
    (implies (and (rationalp x)
		  (>= x 0)
		  (rationalp y)
		  (>= y 0)
		  (integerp k)
		  (exactp x (+ k (- (expo x) (expo y)))))
	     (equal (+ x (away y k))
		    (* (cg (* (+ x y) (expt 2 (- (1- k) (expo y)))))
		       (expt 2 (- (1+ (expo y)) k)))))
  :rule-classes ()
  :hints (("goal" :in-theory (union-theories
                              (set-difference-theories
                               (current-theory 'trunc-pos-rewrite-eric)
                               '(fl+int-rewrite int-fl-rules
                                 expo away-pos-rewrite away-rewrite))
                              '(away-pos-rewrite-eric exactp2))
		  :use ((:instance cg+int-rewrite 
				   (x (* y (expt 2 (- (1- k) (expo y)))))
				   (n (* x (expt 2 (- (1- k) (expo y))))))))))

(defthm plus-away
    (implies (and (rationalp x)
		  (>= x 0)
		  (rationalp y)
		  (>= y 0)
		  (integerp k)
		  (exactp x (+ k (- (expo x) (expo y)))))
	     (= (+ x (away y k))
		(away (+ x y) (+ k (- (expo (+ x y)) (expo y))))))
  :rule-classes ()
  :hints (("goal" :in-theory(union-theories
                              (set-difference-theories
                               (current-theory 'trunc-pos-rewrite-eric)
                               '(expo))
                              '(away-pos-rewrite-eric))
		  :use ((:instance plus-away-2)
			(:instance expo-monotone (y (+ x y)))))))

;add to lib? alternate form of the above
(defthm plus-away-alt
  (implies (and (rationalp x)
                (>= x 0)
                (rationalp y)
                (>= y 0)
                (integerp j)
                (exactp x (+ j (expo x) (- (expo (+ x y))))))
           (= (away (+ x y) j)
              (+ x (away y (+ j (- (expo (+ x y))) (expo y))))))
  :rule-classes ()
  :hints (("goal" 
           :use (:instance plus-away
                           (k (+ j (- (expo (+ x y))) (expo y)))))))

; isn't nice for y=0
(defthm plus-away-corollary
  (implies (and (rationalp x)
                (> x 0)
                (rationalp y)
                (> y 0)
                (integerp n)
                (exactp x n)
                (< y (expt 2 (- (1+ (expo x)) n))))
           (= (away (+ x y) n)
              (fp+ x n)))
  :hints (("goal"  :in-theory (set-difference-theories
                               (enable sgn)
                               '(away-pos-rewrite-eric))
           :use (  
                 (:instance only-0-is-0-or-negative-exact) 
                 (:instance away-exactp-a)
                 plus-trunc-corollary-aux 
                 (:instance a15 (i 2) (j1 1) (j2 (+ (expo x) (* -1 n))))
                 (:instance expo<=
                            (x y)
                            (n (+ (expo x) (* -1 n))))
                 (:instance away-to-0-or-fewer-bits (x y)
                            (n (+ n (expo y) (* -1 (expo (+ x y))))))
                 (:instance plus-away-alt
                            (j n)))))
  :otf-flg t)

;corollaries like this for inf, minf, rnd?

(in-theory (disable trunc-pos-rewrite-eric away-pos-rewrite-eric))

(defthm plus-inf
    (implies (and (rationalp x)
		  (>= x 0)
		  (rationalp y)
		  (>= y 0)
		  (integerp k)
		  (exactp x (+ k (- (expo x) (expo y)))))
	     (= (+ x (inf y k))
		(inf (+ x y) (+ k (- (expo (+ x y)) (expo y))))))
  :rule-classes ()
  :hints (("goal" :in-theory (enable inf)
           :use plus-away)))

(defthm plus-minf
    (implies (and (rationalp x)
		  (>= x 0)
		  (rationalp y)
		  (>= y 0)
		  (integerp k)
		  (exactp x (+ k (- (expo x) (expo y)))))
	     (= (+ x (minf y k))
		(minf (+ x y) (+ k (- (expo (+ x y)) (expo y))))))
  :rule-classes ()
  :hints (("goal" :in-theory (enable minf)
           :use plus-trunc)))

(defthm plus-near-1
        (implies (and (rationalp x)
                      (>= x 0)
                      (rationalp y)
                      (>= y 0)
                      (integerp k)
                      (exactp x (+ k (- (expo x) (expo y)))))
                 (= (re (* (expt 2 (1- k)) (sig y)))
                    (re (* (expt 2
                                 (1- (+ k (- (expo (+ x y)) (expo y)))))
                           (sig (+ x y))))))
        :rule-classes nil :instructions
        ((:dv 2 1)
         :expand :up (:dv 2)
         :expand :up (:dv 2 1)
         (:dv 1)
         :s (:dv 2)
         (:dive 2 2)
         (:rewrite commutativity-of-+)
         :up (:rewrite commutativity-of-+)
         :up (:rewrite a1)
         (:rewrite associativity-of-+)
         :up :top :promote :s (:dv 2)
         (:dv 2)
         (:= (* (expt 2 (+ -1 k (* -1 (expo y))))
                (expt 2 (+ (expo (+ x y))))))
         (:rewrite commutativity-of-*)
         (:dv 1)
         :s :up :up (:rewrite a5)
         (:dv 1)
         (:= (* (sig (+ x y))
                (expt 2 (expo (+ x y))))
             (abs (+ x y))
             :hints
             (("goal" :use (:instance fp-abs (x (+ x y))))))
         :up :up (:dv 1 3 1)
         (:dv 2)
         (:= (* (expt 2 (+ -1 k (* -1 (expo y))))
                (expt 2 (+ (expo (+ x y))))))
         (:rewrite commutativity-of-*)
         :up (:dv 2)
         :s :up :up (:rewrite a5)
         (:dv 1)
         (:= (* (sig (+ x y))
                (expt 2 (expo (+ x y))))
             (abs (+ x y))
             :hints
             (("goal" :use (:instance fp-abs (x (+ x y))))))
         :up :up :up :top (:dv 2 1)
         (:= (+ x y))
         :up :up (:dv 2)
         (:rewrite a9)
         :top (:dv 1 3 1)
         (:dv 1)
         (:= (+ x y))
         :up (:rewrite a9)
         :top (:dv 1 3)
         (:dv 1)
         (:rewrite commutativity-of-+)
         :up (:rewrite fl+int-rewrite)
         (:change-goal nil t)
         (:prove :hints
                 (("goal" :use
                          (:instance exactp2
                                     (n (+ k (expo x) (* -1 (expo y))))))))
         :top
         (:= (equal (+ (* (sig y) (expt 2 (+ -1 k)))
                       (* -1 (fl (* (sig y) (expt 2 (+ -1 k)))))
                       (fl (* y (expt 2 (+ -1 k (* -1 (expo y))))))
                       (* x (expt 2 (+ -1 k (* -1 (expo y))))))
                    (+ (* x (expt 2 (+ -1 k (* -1 (expo y)))))
                       (* y (expt 2 (+ -1 k (* -1 (expo y)))))))
             (equal (+ (* (sig y) (expt 2 (+ -1 k)))
                       (* -1 (fl (* (sig y) (expt 2 (+ -1 k)))))
                       (fl (* y (expt 2 (+ -1 k (* -1 (expo y)))))))
                    (+ (* y (expt 2 (+ -1 k (* -1 (expo y))))))))
         (:dv 1 3 1 1)
         (:= y (* (sig y) (expt 2 (expo y)))
             :hints
             (("goal" :use (:instance fp-abs (x y)))))
         :up :s :top (:dv 2 2 1)
         (:= y (* (sig y) (expt 2 (expo y)))
             :hints
             (("goal" :use (:instance fp-abs (x y)))))
         :top :prove))


(local (defthm evenp--k-lemma
  (equal (equal (integerp x) (integerp y))
         (iff (integerp x) (integerp y)))))


(local (defthm evenp-+-even
         (implies (evenp j) (equal (evenp (+ i j)) (evenp i)))
         :hints (("goal" :in-theory (enable evenp)))
         :rule-classes nil))

(defthm plus-near-2
        (implies (and (rationalp x)
                      (>= x 0)
                      (rationalp y)
                      (>= y 0)
                      (integerp k)
                      (exactp x (+ -1 k (- (expo x) (expo y)))))
                 (iff (evenp (fl (* (expt 2 (1- k)) (sig y))))
                      (evenp (fl (* (expt 2
                                          (1- (+ k (- (expo (+ x y)) (expo y)))))
                                    (sig (+ x y)))))))
        :rule-classes nil 
        :instructions
        (:promote (:dv 2 1 1 1)
                  (:= (expt 2 (+ -1 k (expo (+ x y)) (- (expo y))))
                      (* (expt 2 (+ -1 k (- (expo y))))
                         (expt 2 (expo (+ x y)))))
                  (:rewrite commutativity-of-*)
                  :up (:rewrite commutativity-of-*)
                  (:rewrite a5)
                  (:dv 1)
                  (:= (* (sig (+ x y))
                         (expt 2 (expo (+ x y))))
                      (abs (+ x y))
                      :hints
                      (("goal" :use (:instance fp-abs (x (+ x y))))))
                  (:= (+ x y))
                  :up (:rewrite a9)
                  (:rewrite commutativity-of-+)
                  :up (:rewrite fl+int-rewrite)
                  (:change-goal nil t)
                  (:prove :hints
                          (("goal" :use
                                   ((:instance exactp2 (n (+ k (expo x) (- (expo y)))))
                                    (:instance exactp-<=
                                               (m (+ -1 k (expo x) (- (expo y))))
                                               (n (+ k (expo x) (- (expo y)))))))))
                  (:dv 1)
                  (:dv 1 1)
                  (:= y (* (sig y) (expt 2 (expo y)))
                      :hints
                      (("goal" :use (:instance fp-abs (x y)))))
                  :up :s :top
                  (:claim (integerp (* x (expt 2 (+ -2 k (* -1 (expo y))))))
                          :hints
                          (("goal" :use
                                   (:instance exactp2
                                              (n (+ -1 k (expo x) (- (expo y))))))))
                  (:claim (evenp (* x (expt 2 (+ -1 k (- (expo y))))))
                          0)
                  (:change-goal nil t)
                  :expand (:dv 1)
                  (:rewrite associativity-of-*)
                  (:dv 2)
                  :up
                  (:= (* (expt 2 (+ -1 k (- (expo y)))) 1/2)
                      (expt 2 (+ -2 k (- (expo y))))
                      :hints
                      (("goal" :use
                               (:instance a15 (i 2)
                                          (j1 -1)
                                          (j2 (+ -1 k (- (expo y))))))))
                  :top :prove :prove))

(defthm plus-near
  (implies (and (rationalp x)
                (>= x 0)
                (rationalp y)
                (>= y 0)
                (integerp k)
                (exactp x (+ -1 k (- (expo x) (expo y)))))
           (= (+ x (near y k))
              (near (+ x y)
                    (+ k (- (expo (+ x y)) (expo y))))))
  :rule-classes nil
  :instructions
  (:promote (:casesplit (< (re (* (expt 2 (1- k)) (sig y)))
                           1/2))
            (:prove :hints
                    (("goal" :in-theory
                      (set-difference-theories (enable near)
                                               '(re))
                      :use
                      (plus-trunc plus-near-1
                                  (:instance exactp-<=
                                             (m (+ -1 k (expo x) (* -1 (expo y))))
                                             (n (+ k (expo x) (* -1 (expo y)))))))))
            (:casesplit (> (re (* (expt 2 (1- k)) (sig y)))
                           1/2))
            (:prove :hints
                    (("goal" :in-theory
                      (set-difference-theories (enable near)
                                               '(re))
                      :use
                      (plus-away plus-near-1
                                 (:instance exactp-<=
                                            (m (+ -1 k (expo x) (* -1 (expo y))))
                                            (n (+ k (expo x) (* -1 (expo y)))))))))
            (:prove :hints
                    (("goal" :in-theory
                      (set-difference-theories (enable near)
                                               '(re))
                      :use
                      (plus-away plus-trunc plus-near-1 plus-near-2
                                 (:instance exactp-<=
                                            (m (+ -1 k (expo x) (* -1 (expo y))))
                                            (n (+ k (expo x) (* -1
                                                                (expo y)))))))))))


(in-theory (disable inf minf trunc away near))

;make alt form too?
; add to lib?
(defthm plus-rnd
  (implies (and (rationalp x)
                (>= x 0)
                (rationalp y)
                (>= y 0)
                (integerp k)
                (exactp x (+ -1 k (- (expo x) (expo y))))
                (rounding-mode-p mode))
           (= (+ x (rnd y mode k))
              (rnd (+ x y)
                   mode
                   (+ k (- (expo (+ x y)) (expo y))))))
  :rule-classes nil
  :hints (("Goal" :in-theory (enable rnd ieee-mode-p) 
           :use (plus-near 
                 plus-away
                 plus-trunc 
                 plus-minf 
                 plus-inf
                 (:instance exactp-<= (m (+ -1 k (- (expo x) (expo y))))
                            (n (+  k (- (expo x) (expo y)))))))))

(defthm rationalp-rnd
  (implies (rounding-mode-p m)
           (rationalp (rnd x m n)))
  :hints (("Goal" :in-theory (enable rnd ieee-mode-p)))
  :rule-classes (:rewrite :TYPE-PRESCRIPTION))


;beginning of Eric's drnd lemmas.  Throughout, n is the number of significand bits
;(counting the implicit leading zero), and k is the number of exponent bits.

;it doesn't make sense for n to be 0 (no bits of significand).  Since n counts the
;implicit 0, n=1 is also questionable.

;It doesn't make sense for k to be 0 (no bits of exponent).  Having k=1 is also
;questionable, since that would allow only 2 possible exponent values, both
;reserved (one reserved for denormals).


(defun smallest-positive-normal (k)
  (expt 2 (- 1 (bias k))))

(defthm positive-spn
  (implies (and (integerp n)
                (> n 0)
                (integerp k)
                (> k 1))
           (> (smallest-positive-normal k) 0))
  :rule-classes (:rewrite :linear))

(defthm nrepp-spn
  (implies (and (integerp n)
                (> n 0)
                (integerp k)
                (> k 1))
           (nrepp (smallest-positive-normal k) n k))
  :hints (("goal" :in-theory (enable nrepp)
           :use ((:instance exactp-2**n
                            (n (+ 1 (* -1 (bias k))))
                            (m n))
                 (:instance expt-strong-monotone
                            (n 1)
                            (m k))))))

(defthm smallest-spn
  (implies (and (integerp n)
                (> n 0)
                (integerp k)
                (> k 1)
                (nrepp x n k))
           (>= (abs x) (smallest-positive-normal k)))
  :hints (("goal" :in-theory (enable nrepp bias)
           :use (fp-abs
                 sig-lower-bound
                 (:instance expt-weak-monotone
                            (n (- 1 (bias k)))
                            (m (expo x)))))))


(defthm drnd-spn
  (implies (and (= x (smallest-positive-normal k))
                (rounding-mode-p mode)
                (integerp n)
                (> n 0)
                (integerp k)
                (> k 0))
           (equal (drnd x mode n k)
                  (rnd x 
                       mode
                       (+ n (- (expo (smallest-positive-normal k))) (expo x)))))
  :hints (("goal" :in-theory (enable drnd sgn)
           :use ((:instance rnd-exactp-a (x (expt 2 (+ 3 (* -1 (expt 2 (+ -1 k)))))))
                 (:instance rnd-exactp-a (x (expt 2 (+ 2 (* -1 (expt 2 (+ -1 k)))))))
                 (:instance exactp-2**n (n (+ 3 (* -1 (expt 2 (+ -1 k))))) (m n))
                 (:instance a15
                            (i 2)
                            (j1 (+ 2 (* -1 (expt 2 (+ -1 k)))))
                            (j2 1))
                 (:instance exactp-2**n
                            (n (+ 2 (* -1 (expt 2 (+ -1 k)))))
                            (m n)
                            )))))

(in-theory (disable drnd-spn))

(in-theory (enable ieee-mode-p rounding-mode-p))

(local (defthm drnd-rewrite-1
         (implies (and (rationalp x)
                       (<= 0 x)
                       (< x (smallest-positive-normal k))
                       (rounding-mode-p mode)
                       (integerp n)
                       (> n 1)
                       (integerp k)
                       (> k 0))
                  (equal (drnd x mode n k)
                         (rnd x 
                              mode
                              (+ n (- (expo (smallest-positive-normal k))) (expo x)))))
         :hints (("goal" :in-theory (set-difference-theories
                                     (enable drnd sgn rounding-mode-p ieee-mode-p)
                                     '(expo-x+2**k))
                  :use (
                        (:instance exactp-2**n
                                   (n (+ 2 (* -1 (expt 2 (+ -1 k)))))
                                   (m (+ -1 n)))
                        (:instance plus-rnd
                                   (y x)
                                   (x (smallest-positive-normal k))
                                   (k (+ n (expo x) (- (expo
                                                        (smallest-positive-normal k))))))
                                    (:instance expo-x+2**k
                                               (k (+ 2 (* -1 (expt 2 (+ -1 k))))))
                                    (:instance expo<=
                                               (n (+ 1 (* -1 (expt 2 (+ -1
                                                                        k)))))))))
         :otf-flg t))

(local (in-theory (disable drnd-rewrite-1)))

(local 
 (defthm drnd-rewrite-pos
  (implies (and (rationalp x)
                (<= 0 x)
                (<= x (smallest-positive-normal k))
                (rounding-mode-p mode)
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0))
           (equal (drnd x mode n k)
                  (rnd x 
                       mode
                       (+ n (- (expo (smallest-positive-normal k))) (expo x)))))
  :hints (("goal" :in-theory (disable drnd)
           :use (drnd-rewrite-1 drnd-spn)))))

(local
 (defthm drnd-rewrite-neg
  (implies (and (rationalp x)
                (<= (- (smallest-positive-normal k)) x)
                (<= x 0)
                (rounding-mode-p mode)
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0))
           (equal (drnd x mode n k)
                  (rnd x 
                       mode
                       (+ n (- (expo (smallest-positive-normal k))) (expo x)))))
  :hints (("goal" :in-theory (disable drnd)
           :use ((:instance drnd-rewrite-pos
                            (x (- x)))
                 (:instance 
                  drnd-flip (m mode))
                 expo-minus
                 (:instance 
                  rnd-flip (m mode)
                  (n (+ -2 n (expo x) (expt 2 (+ -1 k))))))))))


(defthm drnd-rewrite
  (implies (and (rationalp x)
                (<= (abs x) (smallest-positive-normal k))
                (rounding-mode-p mode)
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0))
           (equal (drnd x mode n k)
                  (rnd x 
                       mode
                       (+ n 
                          (- (expo (smallest-positive-normal k))) 
                          (expo x))))))

(in-theory (disable drnd-rewrite))


(defthm drepp-range
        (implies (and (integerp n)
                      (> n 0)
                      (integerp k)
                      (> k 0)
                      (drepp x n k))
                 (<= (abs x)
                     (smallest-positive-normal k)))
        :rule-classes nil :instructions
        ((:dv 1 5)
         :expand :top :promote
         (:claim (<= (expo x) (- (bias k))))
         (:claim (< (expo x) (- 1 (bias k))))
         (:casesplit (> x 0))
         (:claim (< x (expt 2 (+ 1 (- (bias k)))))
                 :hints
                 (("goal" :use
                          (:instance expo>= (n (+ 1 (- (bias k))))))))
         :prove
         (:claim (= (expo x) (expo (- x)))
                 :hints (("goal" :use expo-minus)))
         (:claim (< (- x) (expt 2 (+ 1 (- (bias k)))))
                 :hints
                 (("goal" :use
                          (:instance expo>= (x (- x))
                                     (n (+ 1 (- (bias k))))))))
         :prove))



(defthm drnd-of-drepp-is-NOP
  (implies (and (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (drepp x n k)
                (rounding-mode-p mode))
           (= (drnd x mode n k)
              x))
  :hints (("Goal" :in-theory (enable drepp)
           :use (drnd-rewrite
                 drepp-range
                 (:instance rnd-exactp-a
                            (n (+ n 
                                  (- (expo (smallest-positive-normal k))) 
                                  (expo x))))))))

(local (in-theory (disable drnd-rewrite-pos drnd-rewrite-neg)))

(defthm spn-1-exact
  (implies (and (integerp k)
                (> k 0))
           (exactp (smallest-positive-normal k) 1))
  :hints (("Goal" :use (:instance exactp-shift (x 1)
                                  (m 1)
                                     (N (+ 2 (* -1 (EXPT 2 (+ -1 K)))))))))

(in-theory (enable drnd-spn))

(defthm drnd-spn-is-spn
  (implies (and (rounding-mode-p mode)
                (integerp n)
                (>= n 1)
                (integerp k)
                (> k 0))
           (= (drnd (smallest-positive-normal k) mode n k)
              (smallest-positive-normal k))
           )
  :hints (("Goal" :in-theory (disable spn-1-exact)
           :use ( drnd-spn
                  (:instance exactp-<= (m 1)
                             (x (smallest-positive-normal k)))
                  (:instance spn-1-exact)
                  (:instance rnd-exactp 
                             (x (smallest-positive-normal k))
                             (m mode)
                             (n n))))))

(defthm drnd-spn-is-spn-general
  (implies (and (rounding-mode-p mode)
                (integerp n)
                (>= n 1)
                (integerp k)
                (> k 0)
                (rationalp x)
                (= (abs x) (smallest-positive-normal k)))
           (= (drnd x mode n k)
              x)
           )
  :hints (("Goal" :in-theory (disable smallest-positive-normal drnd-rewrite drnd-spn)
           :use (:instance drnd-flip (m mode)))))

(in-theory (disable drnd-spn))

(in-theory (enable drnd-rewrite))



(defthm drnd-trunc-never-goes-away-from-zero
  (implies (and (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (rationalp x)
                (<= (abs x) (smallest-positive-normal k)))
           (<= (abs (drnd x 'trunc n k))
               (abs x)))
  :hints (("Goal" :in-theory (enable rnd)
           :use (:instance trunc-upper-bound
                                  (n (+ -2 N (EXPO X) (EXPT 2 (+ -1 K))))))))

(defthm drnd-away-never-goes-toward-zero
  (implies (and (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (rationalp x)
                (<= (abs x) (smallest-positive-normal k)))
           (>= (abs (drnd x 'away n k))
               (abs x)))
  :hints (("Goal" :in-theory (enable rnd)
           :use (:instance away-lower-bound
                                  (n (+ -2 N (EXPO X) (EXPT 2 (+ -1 K))))))))

;add to lib?
(defthm inf-lower-bound
  (implies (and (rationalp x)
                (integerp n))
           (>= (inf x n) x))
  :hints (("Goal" :in-theory (enable inf)
           :use trunc-upper-bound))
  :rule-classes :linear)

;add to lib?
(defthm minf-upper-bound
  (implies (and (rationalp x)
                (integerp n))
           (<= (minf x n) x))
    :hints (("Goal" :in-theory (set-difference-theories
                                (enable minf)
                                '(abs-away))
             :use away-lower-bound))
 :rule-classes :linear)

(defthm drnd-inf-never-goes-down
  (implies (and (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (rationalp x)
                (<= (abs x) (smallest-positive-normal k)))
           (>= (drnd x 'inf n k)
               x))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable rnd)
                              '(expo-2**n abs-pos))
           :use (:instance inf-lower-bound
                           (n (+ N (EXPO X)
                                 (* -1
                                    (EXPO (EXPT 2 (+ 2 (* -1 (EXPT 2 (+ -1
                                                                        K)))))))))))))
(defthm drnd-minf-never-goes-up
  (implies (and (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (rationalp x)
                (<= (abs x) (smallest-positive-normal k)))
           (<= (drnd x 'minf n k)
               x))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable rnd)
                              '(expo-2**n abs-pos))
           :use (:instance minf-upper-bound
                           (n (+ N (EXPO X)
                                 (* -1
                                    (EXPO (EXPT 2 (+ 2 (* -1 (EXPT 2 (+ -1 K)))))))))))))


(defthm exactp-minus-eric
  (= (exactp (* -1 x) n)
     (exactp x n))
  :hints (("Goal" :in-theory (enable exactp acl2::sig-minus))))

(in-theory (enable trunc-minus))

;t-p?
(defthm fl-not-0
  (implies (and (rationalp x)
                (>= x 1))
           (not (= (fl x)
                   0))))

(defthm cg-not-0
  (implies (and (rationalp x)
                (> x 0))
           (not (= (cg x)
                   0))))

(defthm trunc-rarely-zero
  (implies (and (rationalp x)
                (not (= x 0))
                (integerp k)
                (> k 0))
           (not (equal (trunc x k) 0)))
  :rule-classes (:rewrite (:type-prescription :typed-term (trunc x k)))
  :hints (("Goal" :in-theory (enable trunc sgn)
           :use (
                 sig-lower-bound ;elim?
                 (:instance fl-not-0 (x (* (SIG X) (EXPT 2 (+ -1 K)))))))))

(defthm away-rarely-zero
  (implies (and (rationalp x)
                (not (= x 0))
                (integerp k)
                (> k 0))
           (not (equal (away x k) 0)))
  :rule-classes (:rewrite (:type-prescription :typed-term (away x k)))
  :hints (("Goal" :in-theory (enable away sgn)
           :use (sig-lower-bound ;elim?
                 (:instance cg-not-0 (x (* (SIG X) (EXPT 2 (+ -1 K)))))))))


(defthm rnd-rarely-zero
  (implies (and (rationalp x)
                (not (= x 0))
                (integerp k)
                (> k 0)
                (rounding-mode-p m)
                )
           (not (equal (rnd x m k) 0)))
  :rule-classes (:rewrite (:type-prescription :typed-term (rnd x m k)))
  :hints (("Goal" :in-theory (enable rnd minf inf near))))

(defthm trunc-exactp-c-eric
    (implies (and (rationalp x)
		  (integerp n)
		  (rationalp a)
		  (exactp a n)
		  (<= (abs a) (abs x)))
	     (<= (abs a) (abs (trunc x n))))
  :hints (("goal" :in-theory (disable expo exactp2 abs-trunc trunc-rewrite trunc-exactp-b)
		  :use (trunc-exactp-c
                        trunc-upper-bound
                        (:instance trunc-rarely-zero (k n))
                        (:instance trunc-exactp-c (x (- x)) (a a))
                        (:instance trunc-exactp-c (x x) (a (- a)))
                        (:instance trunc-exactp-c (x (- x)) (a (- a))))))
  :otf-flg t)


(defthm drnd-trunc-skips-no-denormals
  (implies (and (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (rationalp x)
                (<= (abs x) (smallest-positive-normal k))
                (drepp a n k)
                (<= (abs a) (abs x))
                )
           (<= (abs a)
               (abs (drnd x 'trunc n k))))
  :hints (("Goal" :in-theory (enable rnd drepp)
           :use (
                 (:instance exactp-<=
                            (x a)
                            (m (+ -2 N (EXPO A) (EXPT 2 (+ -1 K))))
                            (n (+ -2 N (EXPO x) (EXPT 2 (+ -1 K)))))
                 (:instance trunc-exactp-c-eric (n (+ -2 N (EXPO X) (EXPT 2 (+ -1 K)))))
                 (:instance expo-monotone (x a) (y x))))))


(defthm drnd-trunc-skips-no-rep-numbers
  (implies (and (integerp n)
                (> n 1)
                (integerp k)
                (> k 1)
                (rationalp x)
                (<= (abs x) (smallest-positive-normal k))
                (irepp a n k)
                (<= (abs a) (abs x))
                )
           (<= (abs a)
               (abs (drnd x 'trunc n k))))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable irepp)
                              '(smallest-positive-normal drnd-rewrite))
           :cases ((< (abs x) (smallest-positive-normal k))))
          ("subgoal 1" :use (:instance smallest-spn (x a)))
          ("subgoal 1'" :cases ((nrepp a n k) (drepp a n k)) )
          ("subgoal 1.1'" :use drnd-trunc-skips-no-denormals)))



(defun smallest-positive-denormal (n k)
     (expt 2 (+ 2 (- (bias k)) (- n))))

(defthm positive-spd
  (implies (and (integerp n)
                (> n 1)
                (integerp k)
                (> k 0))
           (> (smallest-positive-denormal n k) 0))
  :hints (("goal" :in-theory (enable drepp bias)
           :use (:instance exactp-2**n 
                           (n (+ 3 (* -1 n) (* -1 (expt 2 (+ -1 k)))))
                           (m 1)))))

(defthm drepp-spd
  (implies (and (integerp n)
                (> n 1)
                (integerp k)
                (> k 0))
           (drepp (smallest-positive-denormal n k) n k))
  :hints (("goal" :in-theory (enable drepp bias)
           :use (:instance exactp-2**n 
                           (n (+ 3 (* -1 n) (* -1 (expt 2 (+ -1 k)))))
                           (m 1)))))


(defthm smallest-spd
  (implies (and (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (drepp x n k))
           (>= (abs x) (smallest-positive-denormal n k)))
  :hints (("goal" :in-theory (enable drepp)
           :use (sig-lower-bound 
                 fp-abs
                 (:instance expt-weak-monotone
                            (n (+ 2 (* -1 n) (* -1 (bias k))))
                            (m (expo x)))))))


(defthm drnd-trunc-of-low-range
  (implies (and (rationalp x)
                (< (abs x) (abs (smallest-positive-denormal n k)))
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0))
           (= (drnd x 'trunc n k)
              0))
  :hints (("Goal" :in-theory (enable drnd-rewrite rnd sgn)
           :use ((:instance expt-strong-monotone 
                            (n (expo (smallest-positive-denormal n k)))
                            (m (expo (smallest-positive-normal k))))
                 (:instance trunc-to-0-or-fewer-bits
                            (n (+ -2 N (EXPO X) (EXPT 2 (+ -1 K)))))
                 (:instance a15 (i 2) (j1 1) (j2 (+ 2 (* -1 N)
                                                    (* -1 (EXPT 2 (+ -1 K))))))
                 (:instance expo<= (n (+ 2 (* -1 N)
                                         (* -1 (EXPT 2 (+ -1 K))))))
                 (:instance expo<= (x (- x))
                            (n (+ 2 (* -1 N)
                                  (* -1 (EXPT 2 (+ -1 K))))))))))

(defthm drnd-away-of-low-range
  (implies (and (rationalp x)
                (< (abs x) (abs (smallest-positive-denormal n k)))
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0))
           (= (drnd x 'away n k)
              (* (sgn x) (smallest-positive-denormal n k))))
  :hints (("Goal"  :in-theory (enable drnd-rewrite rnd sgn)
           :use ((:instance expt-strong-monotone 
                            (n (expo (smallest-positive-denormal n k)))
                            (m (expo (smallest-positive-normal k))))
                 (:instance away-to-0-or-fewer-bits
                            (n (+ -2 N (EXPO X) (EXPT 2 (+ -1 K)))))
                 (:instance a15 (i 2) (j1 1) (j2 (+ 2 (* -1 N)
                                                    (* -1 (EXPT 2 (+ -1 K))))))
                 (:instance expo<= (n (+ 2 (* -1 N)
                                         (* -1 (EXPT 2 (+ -1 K))))))
                 (:instance expo<= (x (- x))
                            (n (+ 2 (* -1 N)
                                  (* -1 (EXPT 2 (+ -1 K))))))))))


(defthm spd-<-spn
  (implies (and (integerp n)
                (> n 1)
                (> k 0)
                (integerp k))
  (< (smallest-positive-denormal n k)
     (smallest-positive-normal k)))
  :rule-classes :linear
  :hints (("Goal" :use (:instance expt-strong-monotone 
                                  (n (+ 3 (* -1 N) (* -1 (EXPT 2 (+ -1 K)))))
                                  (m (+ 2          (* -1 (EXPT 2 (+ -1
                                                                    K)))))))))

(defthm abs-spd-<-abs-spn
  (implies (and (integerp n)
                (> n 1)
                (> k 0)
                (integerp k))
  (< (abs (smallest-positive-denormal n k))
     (abs (smallest-positive-normal k))))
  :rule-classes :linear
  :hints (("Goal" :in-theory (disable smallest-positive-denormal smallest-positive-normal))))

(defthm abs-prod
  (implies (and
            (rationalp x)
            (rationalp y))
           (= (abs (* x y))
              (* (abs x) (abs y))))
  :hints (("Goal" :in-theory (enable sgn))))

(defthm drnd-of-low-range
  (implies (and (rationalp x)
                (< (abs x) (abs (smallest-positive-denormal n k)))
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (rounding-mode-p mode))
           (or (= (drnd x mode n k) 0)
               (= (abs (drnd x mode n k)) (smallest-positive-denormal n k))))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable rnd inf minf near ieee-mode-p sgn)
                              '(smallest-positive-denormal
                                smallest-positive-normal 
                                abs
                                abs-away
                                 drnd-away-of-low-range
                                 drnd-trunc-of-low-range
                                 rearrange-negative-coefs-equal))
           :use (drnd-rewrite drnd-away-of-low-range drnd-trunc-of-low-range)))
  :rule-classes nil)

(in-theory (disable abs-away))

(defthm drnd-spd-is-spd
  (implies (and (rounding-mode-p mode)
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0))
           (= (drnd (smallest-positive-denormal n k) mode n k)
              (smallest-positive-denormal n k))
           )
  :hints (("Goal" :in-theory (disable smallest-positive-denormal))))

(in-theory (enable expo-minus))

(defthm drepp-minus
  (implies (and (rationalp x)
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0))
           (= (drepp (* -1 x) n k) (drepp x n k)))
  :hints (("Goal" :in-theory (enable drepp))))

;add to lib?
(defthm flip-flip
  (implies (rounding-mode-p mode)
           (= (flip (flip mode))
              mode))
  :hints (("Goal" :in-theory (enable flip))))

(defthm drnd-spd-is-spd-general
  (implies (and (rounding-mode-p mode)
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (rationalp x)
                (= (abs x) (smallest-positive-denormal n k)))
           (= (drnd x mode n k)
              x)
           )
  :hints (("Goal" :in-theory (disable smallest-positive-denormal drnd-rewrite
                                      DRND-OF-DREPP-IS-NOP)
           :use ((:instance drepp-spd)
                 (:instance DRND-OF-DREPP-IS-NOP (x (- x)))
                 (:instance DRND-OF-DREPP-IS-NOP )))))




(defun largest-positive-denormal (n k)
  (- (smallest-positive-normal k)
     (smallest-positive-denormal n k)))


(defthm positive-lpd
  (implies (and (integerp n)
                (> n 1)
                (integerp k)
                (> k 0))
           (> (largest-positive-denormal n k) 0))
  :hints (("goal" :in-theory (enable drepp bias)
           :use 
           (:instance expt-strong-monotone (n (+ 3 (* -1 n) (* -1 (EXPT 2 (+ -1
                                                                             k)))))
                      (m (+ 2 (* -1 (EXPT 2 (+ -1 k))))))))
  :rule-classes (:rewrite :linear)
)


;better proof?
(defthm expo-2**k-x
  (implies (and (integerp k)
                (rationalp x)
                (> x 0)
                (<= x (expt 2 (- k 1))))
           (equal (expo (- (expt 2 k) x))
                  (- k 1)))
  :hints (("Goal" :use (
                        (:instance expo-squeeze (x (- (expt 2 k) x)) (n (- k 1)))
                        )))
  :otf-flg t)


(defthm expo-2**k-x-rewrite
  (implies (and (integerp k)
                (rationalp x)
                (> x 0)
                (<= x (expt 2 (- k 1))))
           (equal (expo (+ (expt 2 k) (* -1 x)))
                  (- k 1)))
  :hints (("Goal" :use (expo-2**k-x))))

(defthm expo-lpd
  (implies (and (integerp n)
                (> n 1)
                (integerp k)
                (> k 0))
           (= (expo (largest-positive-denormal n k))
              (+ -1 (expo (smallest-positive-normal k)))))
  
  :hints (("Goal" :in-theory (disable expo-2**k-x expo-2**k-x-rewrite )
           :use (
                        (:instance expt-strong-monotone (n (+ 3 (* -1 n) (* -1 (EXPT 2 (+ -1
                                                                                          k)))))
                                   (m (+ 2 (* -1 (EXPT 2 (+ -1 k))))))
   
                        (:instance expo-2**k-x
                                   (k (+ 2 (* -1 (EXPT 2 (+ -1 K)))))
                                   (x (EXPT 2
                                            (+ 3 (* -1 N)
                                               (* -1 (EXPT 2 (+ -1 K)))))))

                        (:instance expt-strong-monotone (n (+ 2 (* -1 N))) (m 0))
                        (:instance expo-squeeze
                                   (x (+ 2 (* -1 (EXPT 2 (+ 2 (* -1 N))))))
                                   (n 0))
                        (:instance a15 (i 2) (j1 1) (j2   (+ 3 (* -1 N) (* -1 (EXPT 2 (+ -1 K))))))
                        (:instance expt-monotone
                                   (m (+ 2 (* -1 (EXPT 2 (+ -1 K)))))
                                   (n (+ 4 (* -1 N)
                                         (* -1 (EXPT 2 (+ -1 K))))))
                        ))))


(defthm exactp-diff-of-powers-of-2
  (implies (and (integerp m)
                (integerp n)
                (> m n) ; remove?
                )
           (exactp (+ (expt 2 m) (* -1 (expt 2 n)))
                   (- m n)))
  :hints (("Goal" :in-theory (disable  INTEGERP-EXPT-TYPE)
           :use ((:instance expt-strong-monotone (n m) (m n))
                 (:instance exactp2-lemma (x (- (expt 2 m) (expt 2 n)))
                               (n (- m n)))
                 (:instance integerp-expt-type (n (- m n)))
                 (:instance  expo-2**k-x (k m)
                             (x (EXPT 2 N)))))))


(defthm exactness-of-lpd
  (implies (and (integerp n)
                (> n 1)
                (integerp k)
                (> k 0))
           (exactp (largest-positive-denormal n k)
                   (+ -1 n)))
  :hints (("Goal" :use (:instance
                        exactp-diff-of-powers-of-2
                        (m (expo (smallest-positive-normal k)))
                        (n (expo (smallest-positive-denormal n k)))))))


(defthm drepp-lpd
  (implies (and (integerp n)
                (> n 1)
                (integerp k)
                (> k 0))
           (drepp (largest-positive-denormal n k) n k))
  :hints (("goal" :in-theory (enable drepp bias)
           :use ( (:instance expo-lpd)
                  (:instance exactness-of-lpd)
                  
                  (:instance expt-strong-monotone 
                             (n (+ 3 (* -1 n) (* -1 (EXPT 2 (+ -1 k)))))
                             (m (+ 2 (* -1 (EXPT 2 (+ -1 k))))))))))


(in-theory (enable exactp-2**n))

;nice rules to have in lib?
(defthm expo<=-2
  (implies (and (rationalp x)
                (> x 0)
                (integerp n)
                (<= (expo x) (- n 1)))
           (<= x (expt 2 n)))
  :hints (("Goal" :use expo-upper-bound))
  :rule-classes (:rewrite :linear))

(defthm expo>=-2
  (implies (and (rationalp x)
                (> x 0)
                (integerp n)
                (>= (expo x) n))
           (>= x (expt 2 n)))
  :hints (("Goal" :use expo-lower-bound))
  :rule-classes (:rewrite :linear))



(defthm expo>
  (implies (and (rationalp x)
                (integerp n)
                (> x (expt 2 (+ n 1))))
           (> (expo x) n))
  :rule-classes :linear
  :hints (("goal" :use (expo-upper-bound))))

(defthm expo<
  (implies (and (rationalp x)
                (> x 0)
                (integerp n)
                (< x (expt 2 n)))
           (< (expo x) n))
  :rule-classes :linear
  :hints (("goal" :use (expo-lower-bound
			(:instance expo+ (m 1))
			(:instance expt-monotone (n (1+ n)) (m (expo x)))))))

(defthm largest-lpd
  (implies (and (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (drepp x n k)
                (> x 0)
                )
           (<= x (largest-positive-denormal n k)))
  :hints (("goal" :in-theory (set-difference-theories
                              (enable drepp)
                              '(expo<=-2))
           :use ((:instance expo<=-2 (n (+ 2 (* -1 (EXPT 2 (+ -1 k))))))
                 (:instance fp+1
                            (y (EXPT 2 (+ 2 (* -1 (EXPT 2 (+ -1 k))))))
                            (n (+ -2 n (EXPO X) (EXPT 2 (+ -1 k))))
                            )))))

(in-theory (enable trunc-to-0-or-fewer-bits))

;add?
(defthm rnd-exactp-eric
    (implies (and (rationalp x)
		  (rounding-mode-p m)
		  (integerp n) 
		  (> n 0))
	     (exactp (rnd x m n) n))
  :hints (("Goal" :use rnd-exactp)))

(local (in-theory (disable expo-monotone)))
(local (in-theory (disable expo>=-2)))
(local (in-theory (disable expo<=-2)))
(local (in-theory (disable expt-monotone-linear)))

(defthm drepp-drnd-exactness
  (implies (and (rationalp x)
                (< (smallest-positive-denormal n k) x)
                (< x (smallest-positive-normal k))
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (rounding-mode-p m))
           (exactp (drnd x m n k) (+ -2 n (expt 2 (- k 1)) (expo (drnd x m n k)))))
  :hints (("Goal" :in-theory (disable expo>)
           :use ((:instance expo-rnd (mode m) (n (+ -2 N (EXPO X)
                              (EXPT 2 (+ -1 K)))))
                 (:instance expo> (n (+ 2 (- n ) (- (expt 2 (- k 1))))))))))


(defthm drepp-drnd-expo-1
  (implies (and (rationalp x)
                (< (smallest-positive-denormal n k) x)
                (< x (smallest-positive-normal k))
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (rounding-mode-p m))
           (<= (- 2 n) (+ (expo (drnd x m n k)) (bias k))))
  :hints (("Goal" :in-theory (disable expo>=)
           :use ((:instance expo-rnd (mode m) (n (+ -2 N (EXPO X)
                                                    (EXPT 2 (+ -1 K)))))
                 (:instance expo>= (n (+ 3 (- n ) (- (expt 2 (- k 1))))))))))




(local 
 (defthm hack3
   (implies (and (equal (+ (expo x) (expt 2 (+ -1 k))) 1)
                 (rationalp x)
                 (integerp n)
                 (< 1 n)
                 (integerp k)
                 (< 0 k))
            (> (+ (expt 2 (+ 1 (expo x)))
                  (expt 2
                        (+ 3 (* -1 n)
                           (* -1 (expt 2 (+ -1 k))))))
               (expt 2 (+ 2 (* -1 (expt 2 (+ -1 k)))))))
   :rule-classes nil :instructions
   (:promote (:dv 2 1 2)
             (:= (+ 1 (expo x))
                 (+ 2 (* -1 (expt 2 (+ -1 k)))))
             :top :prove)))




(in-theory (disable ieee-mode-p rounding-mode-p))


(defthm drepp-drnd-expo-2
  (implies (and (rationalp x)
                (< (smallest-positive-denormal n k) x)
                (< x (largest-positive-denormal n k))
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (rounding-mode-p m))
           (<= (+ (expo (drnd x m n k)) (bias k)) 0))
  :hints (("goal" :in-theory (set-difference-theories  ;; RBK:
                              (enable ;expt-split
                                      )
                              '( expo>= expo>=-2; expo-2**k-x
                                      rnd-exactp-c; expt-compare
                                       exactp-diff-of-powers-of-2
;                                      a15;expt-split
                                      ))
           :use ((:instance expo-rnd (mode m)
                            (n (+ -2 n (expo x) (expt 2 (+ -1 k)))))
                 (:instance expo< (n (+ 3 (- n ) (- (expt 2 (- k 1))))))
                 (:instance expo< (n (+ 2 (* -1 (expt 2 (+ -1 k))))))
                 (:instance expo>= (n (+ 3 (- n ) (- (expt 2 (- k 1))))))
     
                 (:instance exactp-diff-of-powers-of-2
                            (m (+ 2 (* -1 (expt 2 (+ -1 k)))))
                            (n (+ 3 (* -1 n)
                                  (* -1 (expt 2 (+ -1 k))))))
                 (:instance rnd-exactp-c (a (largest-positive-denormal n k))
                            (mode m)
                            (n (+ -1 n)))
                 hack3

                 ))
          )
  :otf-flg t
)


(defthm drepp-drnd-not-0
  (implies (and (rationalp x)
                (< (smallest-positive-denormal n k) x)
                (< x (largest-positive-denormal n k))
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (rounding-mode-p m))
           (not (equal (drnd x m n k) 0)))
  :hints (("goal" :in-theory (enable rnd inf minf near)
           :use ((:instance drepp-spd)
                 (:instance drnd-trunc-skips-no-denormals
                             (a (expt 2
                                      (+ 3 (* -1 n) (* -1 (expt 2 (+ -1 k)))))))))))


(defthm drepp-drnd-mid-range-1
  (implies (and (rationalp x)
                (< (smallest-positive-denormal n k) x)
                (< x (largest-positive-denormal n k))
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (rounding-mode-p m))
           (drepp (drnd x m n k) n k))
  :hints (("goal" :in-theory (set-difference-theories
                              (enable drepp)
                              '(drnd-rewrite))
           :use ( drepp-drnd-expo-2  drepp-drnd-expo-1))))

(defthm rnd-flip-rewrite
  (implies (rounding-mode-p m)
           (= (rnd (* -1 x) m n)
              (* -1 (rnd x (flip m) n))))
  :hints (("Goal" :in-theory (enable rnd ieee-mode-p rounding-mode-p)
           :use (near-minus trunc-minus away-minus minf-minus inf-minus))))

(defthm drnd-flip-rewrite
  (implies (and (rationalp x)
                (rounding-mode-p m)
                (integerp n)
                (integerp k))
           (= (drnd (* -1 x) m n k)
              (* -1 (drnd x (flip m) n k))))
  :hints (("goal" :in-theory (enable drnd)
           :use ((:instance rnd-flip-rewrite
                            (x (+ x
                                  (* (sgn x)
                                     (expt 2 (- 2 (expt 2 (1- k))))))))))))

(defthm drepp-drnd-mid-range
  (implies (and (rationalp x)
                (< (smallest-positive-denormal n k) (abs x))
                (< (abs x) (largest-positive-denormal n k))
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (rounding-mode-p m))
           (drepp (drnd x m n k) n k))
  :hints (("goal" :in-theory (disable drnd-rewrite  DREPP-DRND-MID-RANGE-1 flip) 
           :use (drepp-drnd-mid-range-1
                 (:instance drepp-drnd-mid-range-1 (m (flip m)) (x (- x)))))))

(defthm expo-of-high-range-1
  (implies (and (rationalp x)
                (< (largest-positive-denormal n k) x)
                (< x (smallest-positive-normal k))
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0))
           (> x 0))
  :hints (("goal" :in-theory (disable largest-positive-denormal positive-lpd)
           :use (:instance positive-lpd))))



(defthm expo-of-high-range-2-2
  (implies (and
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0))
           (<= (* 2
                   (expt 2
                         (+ 3 (* -1 n)
                            (* -1 (expt 2 (+ -1 k))))))
               (expt 2 (+ 2 (* -1 (expt 2 (+ -1 k)))))))
  :hints (("goal" :in-theory (disable expo>=-2)
           :use ((:instance a15 (i 2) (j1 1) (j2 (+ 3 (* -1 n) (* -1 (expt 2 (+ -1 k))))))
                 (:instance expt-weak-monotone (n (+ 4 (* -1 n)
                         (* -1 (expt 2 (+ -1 k)))))
                                  (m (+ 2 (* -1 (expt 2 (+ -1 k))))))))))

(local
 (defthm +-preserves-<=
  (implies (and (rationalp a)
                (rationalp b)
                (rationalp c)
                (<= a b)
                )
           (<= (+ a c) (+ b c)))))


(defthm expo-of-high-range-2-1
  (implies (and
            (integerp n)
            (> n 1)
            (integerp k)
            (> k 0))
           (<= (expt 2 (- (expo (smallest-positive-normal k)) 1)) 
               (largest-positive-denormal n k)))
  :hints (("goal" :use (:instance  +-preserves-<=
                                   (a (* 2
                                         (expt 2
                                               (+ 3 (* -1 n)
                                                  (* -1 (expt 2 (+ -1 k)))))))
                                   (b (expt 2 (+ 2 (* -1 (expt 2 (+ -1 k))))))
                                   (c (expt 2 (+ 2 (* -1 (expt 2 (+ -1
                                                                    k))))))))))


(defthm expo-of-high-range-2
  (implies (and (rationalp x)
                (< (largest-positive-denormal n k) x)
                (< x (smallest-positive-normal k))
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0))
           (< (expt 2 (- (expo (smallest-positive-normal k)) 1)) x))
  :hints (("goal" :in-theory (disable expo>=-2
                                      expo-of-high-range-2-1
                                      smallest-positive-normal
                                      largest-positive-denormal)
           :use  expo-of-high-range-2-1)))   


(defthm expo-of-high-range
    (implies (and (rationalp x)
                  (< (largest-positive-denormal n k) x)
                  (< x (smallest-positive-normal k))
                  (integerp n)
                  (> n 1)
                  (integerp k)
                  (> k 0))
             (= (expo x)
                (- (expo (smallest-positive-normal k)) 1)))
    :hints (("goal" :in-theory (disable
                                 expo-of-high-range-2
                                positive-lpd)
             :use ( expo-of-high-range-2
                    (:instance positive-lpd)
                   (:instance expo-squeeze (n (- (expo (smallest-positive-normal k)) 1)))))))

(defthm drnd-trunc-of-high-range-3
  (implies (and (integerp n)
                (> n 1)
                (integerp k)
                (> k 0))
           (equal (fp+ (largest-positive-denormal n k) (- n 1))
                  (smallest-positive-normal k)))
  :hints (("Goal" :in-theory (enable expo>=-2))))
                       
(defthm drnd-trunc-of-high-range-1
  (implies (and (rationalp x)
                (< (largest-positive-denormal n k) x)
                (< x (smallest-positive-normal k))
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0))
           (>= (drnd x 'trunc n k)
               (largest-positive-denormal n k)))
  :hints (("goal" :in-theory (set-difference-theories
                              (enable rnd drnd-rewrite)
                              '(
                                smallest-positive-normal
                                largest-positive-denormal
                                rnd-exactp-d
                                ))
           :use ((:instance drnd-trunc-skips-no-denormals 
                            (a (largest-positive-denormal n k))
                            )))))


(defthm drnd-trunc-of-high-range-2
  (implies (and (rationalp x)
                (< (largest-positive-denormal n k) x)
                (< x (smallest-positive-normal k))
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0))
           (<= (drnd x 'trunc n k)
               (largest-positive-denormal n k)))
  :hints (("goal" :in-theory (set-difference-theories
                              (enable rnd drnd-rewrite)
                              '(
                                smallest-positive-normal
                                largest-positive-denormal
                                rnd-exactp-d
                                ;; expo-of-high-range
                                ))
           :use ((:instance fp+1 
                            (y (trunc x (+ n 
                                                (- (expo (smallest-positive-normal k))) 
                                                (expo x))))
                            (x (largest-positive-denormal n k))
                            (n (- n 1)))))))

(defthm drnd-trunc-of-high-range-pos
  (implies (and (rationalp x)
                (< (largest-positive-denormal n k) x)
                (< x (smallest-positive-normal k))
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0))
           (= (drnd x 'trunc n k)
               (largest-positive-denormal n k)))
  :hints (("goal" :in-theory (disable smallest-positive-normal
                                      drnd-rewrite
                                      largest-positive-denormal
                                      drnd-trunc-of-high-range-2
                                      drnd-trunc-of-high-range-1
                                      )
           :use (drnd-trunc-of-high-range-2 drnd-trunc-of-high-range-1))))


(defthm drnd-trunc-of-high-range
  (implies (and (rationalp x)
                (< (largest-positive-denormal n k) (abs x))
                (< (abs x) (smallest-positive-normal k))
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0))
           (= (drnd x 'trunc n k)
               (* (sgn x) (largest-positive-denormal n k))))
  :hints (("goal" :in-theory (set-difference-theories
                              (enable sgn)
                              '(smallest-positive-normal
                                drnd-rewrite
                                largest-positive-denormal
                                drnd-trunc-of-high-range-pos))
           :use (drnd-trunc-of-high-range-pos
                 (:instance drnd-trunc-of-high-range-pos (x (- x)))))))

(defthm drnd-away-of-high-range-1
  (implies (and (rationalp x)
                (< (largest-positive-denormal n k) x)
                (< x (smallest-positive-normal k))
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0))
           (<= (drnd x 'away n k)
               (smallest-positive-normal k)))
  :hints (("goal" :in-theory (set-difference-theories
                              (enable rnd drnd-rewrite)
                              '(spn-1-exact
                                smallest-positive-normal
                                largest-positive-denormal
                                rnd-exactp-d))
           :use ( spn-1-exact
                  (:instance exactp-<= (x (smallest-positive-normal k)) (m 1) (n (- n 1)))
                  (:instance away-exactp-c (a (smallest-positive-normal k))
                             (n (+ n 
                                   (- (expo (smallest-positive-normal k))) 
                                   (expo x))))))))

(defthm drnd-away-of-high-range-2
  (implies (and (rationalp x)
                (< (largest-positive-denormal n k) x)
                (< x (smallest-positive-normal k))
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0))
           (>= (drnd x 'away n k)
               (smallest-positive-normal k)))
  :hints (("goal" :in-theory (set-difference-theories
                              (enable rnd drnd-rewrite)
                              '(smallest-positive-normal
                                largest-positive-denormal
                                rnd-exactp-d))
           :use ((:instance exactp-<= (x (smallest-positive-normal k)) (m 1) (n
                                                                              (- n 1)))
                 (:instance fp+1 
                            (y (away x (+ n 
                                          (- (expo (smallest-positive-normal k))) 
                                          (expo x))))
                            (x (largest-positive-denormal n k))
                            (n (- n 1)))))))

(defthm drnd-away-of-high-range-pos
  (implies (and (rationalp x)
                (< (largest-positive-denormal n k) x)
                (< x (smallest-positive-normal k))
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0))
           (= (drnd x 'away n k)
               (smallest-positive-normal k)))
  :hints (("goal" :in-theory (disable 
                              drnd-rewrite
                              smallest-positive-normal
                              largest-positive-denormal
                               DRND-AWAY-OF-HIGH-RANGE-1
                                DRND-AWAY-OF-HIGH-RANGE-2)
           :use (drnd-away-of-high-range-2 drnd-away-of-high-range-1))))


(defthm drnd-away-of-high-range
  (implies (and (rationalp x)
                (< (largest-positive-denormal n k) (abs x))
                (< (abs x) (smallest-positive-normal k))
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0))
           (= (drnd x 'away n k)
               (* (sgn x) (smallest-positive-normal k))))
  :hints (("goal" :in-theory (set-difference-theories
                              (enable sgn)
                              '(smallest-positive-normal
                                drnd-rewrite
                                largest-positive-denormal
                                drnd-away-of-high-range-pos))
           :use (drnd-away-of-high-range-pos
                 (:instance drnd-away-of-high-range-pos (x (- x)))
                 ))))


;add? make a rnd-choice?
(defthm drnd-choice
  (implies (rounding-mode-p mode)
           (or (equal (drnd x mode n k) (drnd x 'away n k))
               (equal (drnd x mode n k) (drnd x 'trunc n k))))
  :hints (("Goal" :in-theory (enable drnd rnd inf minf near rounding-mode-p ieee-mode-p)))
  :rule-classes nil)


(defthm drnd-of-high-range
  (implies (and (rationalp x)
                (< (largest-positive-denormal n k) (abs x))
                (< (abs x) (smallest-positive-normal k))
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (rounding-mode-p mode))
           (or (= (drnd x mode n k) (* (sgn x) (largest-positive-denormal n k)))
               (= (drnd x mode n k) (* (sgn x) (smallest-positive-normal k)))))
  :hints (("goal" :in-theory (set-difference-theories
                              (enable rnd inf minf near ieee-mode-p rounding-mode-p sgn)
                              '(smallest-positive-denormal
                                drnd-rewrite
                                smallest-positive-normal 
                                abs-away
                                rounding-mode-p
                                rearrange-negative-coefs-equal))
           :use (drnd-choice)))
  :rule-classes nil) 

;add to lib?
;make t-p?
(defthm rnd-non-neg
    (implies (and (rationalp x)
		  (>= x 0)
		  (integerp n)
		  (rounding-mode-p mode))
	     (>= (rnd x mode n) 0))
  :hints (("goal" :in-theory (enable ieee-mode-p near rnd inf minf near)
		  :use (trunc-pos
                        away-pos
                        trunc-to-0-or-fewer-bits
                        away-to-0-or-fewer-bits))))

(defthm rnd-non-pos
    (implies (and (rationalp x)
		  (<= x 0)
		  (integerp n)
		  (rounding-mode-p mode))
	     (<= (rnd x mode n) 0))
  :hints (("goal" :in-theory (enable ieee-mode-p near rnd inf minf near)
		  :use (trunc-neg
                        away-neg
                        trunc-to-0-or-fewer-bits
                        away-to-0-or-fewer-bits)))
  :rule-classes (:rewrite :type-prescription))

;add?
(defthm drnd-non-neg
    (implies (and (rationalp x)
                  (<= x (smallest-positive-normal k))
                  (>= x 0)
                  (integerp n)
                  (> n 1)
                  (integerp k)
                  (> k 0)
		  (rounding-mode-p mode))
	     (>= (drnd x mode n k) 0)))
;add?
(defthm drnd-non-pos
    (implies (and (rationalp x)
                  (<= (abs x) (smallest-positive-normal k))
                  (<= x 0)
                  (integerp n)
                  (> n 1)
                  (integerp k)
                  (> k 0)
		  (rounding-mode-p mode))
	     (<= (drnd x mode n k) 0))
 :rule-classes (:rewrite :type-prescription))

(defthm drnd-type-pos
  (implies (and (rationalp x)
                (<= 0 x)
                (<= x (smallest-positive-normal k))
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (rounding-mode-p mode))
           (or (drepp (drnd x mode n k) n k)
               (= (drnd x mode n k) 0)
               (= (drnd x mode n k) (smallest-positive-normal k))))
  :hints (("goal" :in-theory (set-difference-theories
                              (enable sgn)
                              '(drnd-rewrite 
                                drepp-drnd-mid-range
                                drnd-spd-is-spd-general
                                smallest-positive-denormal
                                largest-positive-denormal
                                smallest-positive-normal
                                drepp-drnd-mid-range-1))
           :use (drnd-of-high-range
                 drnd-of-low-range
                 (:instance drepp-drnd-mid-range (m mode)))))
  :rule-classes nil)


(defthm drnd-type
  (implies (and (rationalp x)
                (<= (abs x) (smallest-positive-normal k))
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (rounding-mode-p mode))
           (or (drepp (drnd x mode n k) n k)
               (= (drnd x mode n k) 0)
               (= (drnd x mode n k) (* (sgn x) (smallest-positive-normal k)))))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable sgn)
                              '(drnd-rewrite
                                DRND-SPD-IS-SPD-GENERAL ; for efficiency
                                smallest-positive-normal))
           :use (drnd-type-pos
                 (:instance drnd-type-pos (mode (flip mode)) (x (- x))))))
  :rule-classes nil)

   
;add to lib?
(defthm rnd-diff
    (implies (and (rationalp x)
		  (integerp n)
		  (> n 0)
                  (rounding-mode-p mode))
	     (< (abs (- x (rnd x mode n))) (expt 2 (- (1+ (expo x)) n))))
  :hints (("Goal" :in-theory (enable rnd near inf minf ieee-mode-p rounding-mode-p)
           :use (trunc-diff away-diff))))


(in-theory (enable trunc-to-0-or-fewer-bits))

;better proof?
(defthm drnd-diff
  (implies (and (rationalp x)
                (<= (ABS X) (SMALLEST-POSITIVE-NORMAL K))
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (rounding-mode-p mode))
           (< (abs (- x (drnd x mode n k))) (smallest-positive-denormal n k)))
  :hints (("Goal" 
           :cases ((> (+ n 
                         (- (expo (smallest-positive-normal k))) 
                         (expo x)) 0)))
          ("subgoal 2" :in-theory (set-difference-theories
                                   (enable rnd inf minf near sgn)
                                   '(EXPO<=-2 EXPO>=-2))
           :use ( (:instance expo-upper-bound (x (- x)))
                  (:instance expo-upper-bound)
                  (:instance expt-monotone (n (+ 1 (expo x))) (M (+ 3 (* -1 N)
                                                                    (* -1 (EXPT 2 (+ -1 K))))))))
          ("subgoal 1" :in-theory (disable  EXPO<=-2  EXPO>=-2)
           :use (:instance rnd-diff (n (+ N (EXPO X)
                                          (* -1 (EXPO (SMALLEST-POSITIVE-NORMAL
                                                       K)))))))))


(defthm drepp-rationalp
  (implies (drepp x n k)
           (rationalp x))
  :hints (("Goal" :in-theory (enable drepp))))

;just an intermediate step in the proofs
(defun next-denormal-2 (x n k)
  (fp+ x (+ -1 n (expo x) (bias k))))

(defun next-denormal (x n k)
  (+ x (smallest-positive-denormal n k))) 

(defthm denormals-same
  (equal (next-denormal-2 x n k) 
         (next-denormal x n k)))

(in-theory (disable denormals-same))


(defthm fp+-expo
  (implies (and (rationalp x)
                (< 0 x)
                (< x y)
                (rationalp y)
                (exactp x n)
                (integerp n)
                (> n 0)
                (< y (fp+ x n)))
           (= (expo y)
              (expo x)))
  :hints (("Goal" :use ((:instance expo-squeeze (x y) (n (expo x)))
           (:instance fp+2-1)))))

;remove x>=0 hyp?
(defthm denormal-spacing-1
  (implies (and (integerp n)
                (integerp k)
                (> k 0)
                (> n 1)
                (drepp x n k)
                (drepp x+ n k)
                (>= x 0)
                (> x+ x))
           (>= x+ (next-denormal-2 x n k)))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable drepp)
                              '(fp+))
           :use ((:instance fp+-expo (y x+)
                            (n (+ -2 N (EXPO X) (EXPT 2 (+ -1 K)))))
                 (:instance fp+1 
                            (y x+)
                            (n (+ -1 n (expo x) (bias k))))))))

(defthm denormal-spacing
  (implies (and (integerp n)
                (integerp k)
                (> k 0)
                (> n 1)
                (drepp x n k)
                (drepp x+ n k)
                (>= x 0)
                (> x+ x))
           (>= x+ (next-denormal x n k)))
  :hints (("Goal" :in-theory (disable denormal-spacing-1)
           :use (denormal-spacing-1
                 (:instance denormals-same)))))


(defthm drnd-away-skips-no-denormals-pos
  (implies (and (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (rationalp x)
                (<= 0 x)
                (<= x (smallest-positive-normal k))
                (drepp a n k)
                (>= a x)
                )
           (>= a (drnd x 'away n k)))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable sgn)
                              '(drnd-diff
                                drnd-rewrite
                                DRND-SPD-IS-SPD-GENERAL ;these two for efficiency
                                DRND-SPN-IS-SPN-GENERAL ;
                                 ))
           :use ((:instance largest-lpd (x a))
                 (:instance drnd-diff (mode 'away))
                 (:instance drnd-type (mode 'away))
                 (:instance denormal-spacing
                            (x a)
                            (x+ (drnd x 'away n k)))))))

; all 4 use hints seem necessary
(defthm drnd-away-skips-no-denormals
  (implies (and (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (rationalp x)
                (<= (abs x) (smallest-positive-normal k))
                (drepp a n k)
                (>= (abs a) (abs x))
                )
           (>= (abs a) (abs (drnd x 'away n k))))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable sgn)
                              '(drnd-diff
                                DRND-AWAY-OF-HIGH-RANGE
                                DRND-AWAY-OF-HIGH-RANGE-POS
                                DRND-AWAY-OF-LOW-RANGE
                                DREPP-DRND-MID-RANGE
                                drnd-non-pos
                                drnd-rewrite
                                smallest-positive-normal
                                DRND-AWAY-SKIPS-NO-DENORMALS-pos
                                DRND-SPD-IS-SPD-GENERAL ;these two for efficiency
                                DRND-SPN-IS-SPN-GENERAL))
           :use ((:instance drnd-non-pos (mode 'away))
                 (:instance drnd-away-skips-no-denormals-pos)
                 (:instance drnd-away-skips-no-denormals-pos (a (- a)) (x (- x)))
                 (:instance drnd-away-skips-no-denormals-pos (x (- x)))
                 (:instance drnd-away-skips-no-denormals-pos (a (- a)))))))
  

(defthm drnd-inf-skips-no-denormals
  (implies (and (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (rationalp x)
                (<= (abs x) (smallest-positive-normal k))
                (drepp a n k)
                (>= a x))
           (>= a (drnd x 'inf n k)))
  :hints (("Goal" :in-theory (enable rnd drepp inf)
          :use ((:instance drnd-away-skips-no-denormals)
                (:instance drnd-trunc-skips-no-denormals (x (- x)))))))

(defthm drnd-minf-skips-no-denormals
  (implies (and (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (rationalp x)
                (<= (abs x) (smallest-positive-normal k))
                (drepp a n k)
                (<= a x))
           (<= a (drnd x 'minf n k)))
  :hints (("Goal" :in-theory (enable rnd drepp minf)
          :use ((:instance drnd-away-skips-no-denormals (x (- x)))
                (:instance drnd-trunc-skips-no-denormals)))))



(defthm near1-a-negative-n
  (implies (and (rationalp x)
                (>= x 0)
                (integerp n)
                (<= n 0)
                (< (- x (trunc x n)) (- (away x n) x)))
           (= (near x n) (trunc x n)))
  :rule-classes ()
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable sgn near expo>=-2)
                              '( expo sig trunc-pos-rewrite away-pos-rewrite))
           :use ((:instance expt-weak-monotone (n n) (m 0))
                 (:instance expt-weak-monotone (n n) (m -1))
                 sig-upper-bound
                 (:instance fl-unique (x (* 1/2 (SIG X) (EXPT 2 N))) (n
                                                                      0))))
          ("goal'" :cases ((= n 0)))
          ("subgoal 2" :in-theory (set-difference-theories
                                   (enable sgn near)
                                   '(expo sig trunc-pos-rewrite
                                          away-pos-rewrite expo>=-2))
           :use (:instance expt-weak-monotone (n n) (m -1)))))

;could replace the version in near.lisp 
(defthm near1-a-eric
    (implies (and (rationalp x)
		  (>= x 0)
		  (integerp n)
		 ; (> n 0)
		  (< (- x (trunc x n)) (- (away x n) x)))
	     (= (near x n) (trunc x n)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable near trunc away)
		  :use (near1-a near1-a-negative-n))))

(local (defthm hack
  (implies (and (rationalp a)
                (rationalp b)
                (rationalp c))
           (implies (= a b)
                    (= (* a c) (* b c))))
  :rule-classes nil))

(defthm sig-x-1-implies-x-power-of-2
  (implies (and (rationalp x)
                (> x 0)
                (equal (sig x) 1))
           (equal (expt 2 (expo x)) x))
  :hints (("Goal" :in-theory (enable sig)
                              
           :use ((:instance hack (c (EXPT 2 (EXPO X)))
                            (a (* X (/ (EXPT 2 (EXPO X)))))
                            (b 1))))))

(local 
 (defthm hack1
   (implies (and (rationalp x)
                 (integerp n)
                 (< n 0)
                 (>= x 0))
            (>= (EXPT 2 (+ (EXPO X) (* -1 N)))
                X))
   :hints (("Goal" :in-theory (enable expo<=-2)))))


(local 
 (defthm hack2
   (implies (and (rationalp x)
                 (integerp n)
                 (< n 0)
                 (>= x 0))
            (>= (EXPT 2 (+ 1 (EXPO X) (* -1 N)))
               (* 2 X)))
 :hints (("Goal" :in-theory (disable hack1 expo<=-2)
          :use (hack1
                       (:instance a15 (i 2) (j1 1) (j2 (+ (EXPO X) (* -1 N)))))))))


(local (defthm near1-b-negative-n
  (implies (and (rationalp x)
                (>= x 0)
                (integerp n)
                (<= n 0)
                (> (- x (trunc x n)) (- (away x n) x)))
           (= (near x n) (away x n)))
  :rule-classes ()
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable sgn near)
                              '( expo sig trunc-pos-rewrite away-pos-rewrite))
           :use ((:instance expt-weak-monotone (n n) (m 0))
                 (:instance expt-weak-monotone (n n) (m -1))
                 sig-upper-bound
   
                 (:instance fl-unique (x (* 1/2 (SIG X) (EXPT 2 N))) (n
                                                                      0))))
          ("goal'" :cases ((= n 0)))
          ("subgoal 1" :use (:instance a15 (i 2) (j1 1) (j2 (EXPO X))))
          ("subgoal 2" :in-theory (set-difference-theories
                                   (enable sgn near)
                                   '(hack2 expo sig trunc-pos-rewrite
                                          away-pos-rewrite expo>=-2 expo<=-2))
           :use (expo-upper-bound
                 hack2
                 (:instance expt-strong-monotone (m (+ (EXPO X) (* -1 N))) (n (EXPO X)))
                 (:instance a15 (i 2) (j1 1) (j2 (+ (EXPO X) (* -1 N)))))))))

;could replace the version in near.lisp 
(defthm near1-b-eric
    (implies (and (rationalp x)
		  (>= x 0)
		  (integerp n)
		  (> (- x (trunc x n)) (- (away x n) x)))
	     (= (near x n) (away x n)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable near away trunc)
		  :use (near1-b
                        near1-b-negative-n))))

(defthm drnd-near-2-1
  (implies (and (rationalp x)
                (<= x (smallest-positive-normal k))
                (rationalp a)
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (> x 0)
                (drepp a n k)
                (= (drnd x 'near n k) (drnd x 'trunc n k)))
           (>= (abs (- x a)) (abs (- x (drnd x 'trunc n k)))))
  :rule-classes ()
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable rnd)
                              '( expo sig exactp2 trunc-pos-rewrite away-exactp-c 
				      near trunc-exactp-c away-pos-rewrite))
           :use ((:instance near1-b-eric (n (+ -2 N (EXPO X) (EXPT 2 (+ -1 K)))))
                 (:instance away-lower-pos (n (+ -2 N (EXPO X) (EXPT 2 (+ -1 K)))))
                 (:instance trunc-upper-pos (n (+ -2 N (EXPO X) (EXPT 2 (+ -1 K)))))
                 (:instance drnd-away-skips-no-denormals )
                 (:instance drnd-trunc-skips-no-denormals)))))

(defthm drnd-near-2-2
  (implies (and (rationalp x)
                (<= x (smallest-positive-normal k))
                (rationalp a)
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (> x 0)
                (drepp a n k)
                (= (drnd x 'near n k) (drnd x 'away n k)))
           (>= (abs (- x a)) (abs (- x (drnd x 'away n k)))))
  :rule-classes ()
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable rnd)
                              '( expo sig exactp2 trunc-pos-rewrite away-exactp-c 
				      near trunc-exactp-c away-pos-rewrite))
           :use ((:instance near1-a-eric (n (+ -2 N (EXPO X) (EXPT 2 (+ -1 K)))))
                 (:instance away-lower-pos (n (+ -2 N (EXPO X) (EXPT 2 (+ -1 K)))))
                 (:instance trunc-upper-pos (n (+ -2 N (EXPO X) (EXPT 2 (+ -1 K)))))
                 (:instance drnd-away-skips-no-denormals )
                 (:instance drnd-trunc-skips-no-denormals)))))

(defthm drnd-near-choice
  (implies (and (rationalp x)
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (<= (abs x) (smallest-positive-normal k)))
           (or (= (drnd x 'near n k) (drnd x 'trunc n k))
               (= (drnd x 'near n k) (drnd x 'away n k))))
  :hints (("Goal" :in-theory (enable rnd near)))
  :rule-classes ())

(defthm no-denormal-is-closer-than-what-drnd-near-returns-pos
  (implies (and (rationalp x)
                (>= x 0)
                (<= x (smallest-positive-normal k))
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (drepp a n k))
           (>= (abs (- x a)) (abs (- x (drnd x 'near n k)))))
  :hints (("Goal" :in-theory (disable
                              drnd-rewrite
                              drnd-non-neg
                              DRND-AWAY-SKIPS-NO-DENORMALS-POS)
           :use ((:instance drnd-near-2-1)
                 (:instance drnd-near-2-2)
                 (:instance drnd-near-choice)))))

(defthm no-denormal-is-closer-than-what-drnd-near-returns-neg
  (implies (and (rationalp x)
                (<= x 0)
                (<= (abs x) (smallest-positive-normal k))
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (drepp a n k))
           (>= (abs (- x a)) (abs (- x (drnd x 'near n k)))))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable)
                              '(drnd-rewrite
                                drnd-non-pos
                                drnd-non-neg
                                smallest-positive-normal
                                DRND-AWAY-SKIPS-NO-DENORMALS-POS))
           :use ((:instance no-denormal-is-closer-than-what-drnd-near-returns-pos
                            (x (- x)) (a (- a)))))))


(defthm no-denormal-is-closer-than-what-drnd-near-returns
  (implies (and (rationalp x)
                (<= (abs x) (smallest-positive-normal k))
                (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (drepp a n k))
           (>= (abs (- x a)) (abs (- x (drnd x 'near n k)))))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable)
                              '(drnd-rewrite
                                drnd-non-pos
                                drnd-non-neg
                                smallest-positive-normal
                                DRND-AWAY-SKIPS-NO-DENORMALS-POS
                                no-denormal-is-closer-than-what-drnd-near-returns-pos
                                no-denormal-is-closer-than-what-drnd-near-returns-neg))
           :use (no-denormal-is-closer-than-what-drnd-near-returns-pos
                 no-denormal-is-closer-than-what-drnd-near-returns-neg))))

;could speed up the above with a :cases hint instead of :use hints?




#|
;remove these?
(defthm drnd-trunc-never-goes-up-for-pos-args
  (implies (and (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (rationalp x)
                (<= 0 x)
                (<= x (smallest-positive-normal k)))
           (<= (drnd x 'trunc n k)
               x))
  :hints (("Goal" :in-theory (enable rnd)
           :use (:instance trunc-upper-bound
                                  (n (+ -2 N (EXPO X) (EXPT 2 (+ -1 K))))))))


(defthm drnd-away-never-goes-down-for-pos-args
  (implies (and (integerp n)
                (> n 1)
                (integerp k)
                (> k 0)
                (rationalp x)
                (<= 0 x)
                (<= x (smallest-positive-normal k)))
           (>= (drnd x 'away n k)
               x))
  :hints (("Goal" :in-theory (enable rnd)
           :use (:instance away-lower-bound
                                  (n (+ -2 N (EXPO X) (EXPT 2 (+ -1 K))))))))
|#

(in-theory (disable expo>=-2 expo<=-2 expo< expo> drnd-spd-is-spd drnd-spd-is-spd-general))




 