/**********************************************************************
 ** DirRead class: Reads in a directory and provides methods for displaying
 **                elements in a directory
 **
 **
 **
 ** Last reviewed:
 **
 **
 ** Copyright (C) 2000, 2001 George Noel (Slate)
 **
 **   This program is free software; you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as
 **   published by the Free Software Foundation; either version 2 of the 
 **   License, or any later version. 
 **
 **   This program is distributed in the hope that it will be useful, but 
 **   WITHOUT ANY WARRANTY; without even the implied warranty of 
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 **   General Public License for more details. 
 ** 
 **   You should have received a copy of the GNU General Public License 
 **   along with this program (in the docs dir); if not, write to the Free
 **   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 **
 **********************************************************************/

#ifndef DIRREAD_C
#define DIRREAD_C

#include "dirread.h"
#include <afxwin.h>

/***********************************************************************
 ** DirRead (constructor) - Opens the directory
 **
 ** Parameters: None
 **
 ** Returns: Nothing
 **
 ***********************************************************************/

DirRead::DirRead(char *dirname)
{
   dirpath = dirname;
   valid = 1;
}


/***********************************************************************
 ** ~DirRead (destructor) - closes the directory
 **
 ** Parameters: None
 **
 ** Returns: Nothing
 **
 ***********************************************************************/

DirRead::~DirRead()
{ 
}


/***********************************************************************
 ** get_next - gets the next file in the directory
 **
 ** Parameters: pattern - the pattern to search for in a filename
 **
 ** Returns: pointer to the filename if success
 **
 ***********************************************************************/

char *DirRead::get_next(char *pattern)
{
	CString holder;

	if (valid == 0)
		return NULL;

	if ((last_pattern.str_show() == NULL) && (pattern != NULL))
	{
	   last_pattern.sprintf("%s*%s", dirpath.str_show(), pattern);
 	   if (!dir.FindFile(last_pattern.str_show(), 0))
	   {
		  valid = 0;
	      return NULL;
	   }
	}


	if (!dir.FindNextFile())
	{	
		valid = 0;
	}

	results = (char *) LPCTSTR(dir.GetFileName());
	return results.str_show();
}

char *DirRead::get_next()
{
  return get_next(NULL);
}


/***********************************************************************
 ** is_valid - is the log valid (no errors opening, etc) 
 **
 ** Returns: 1 for valid, 0 for not
 **
 ***********************************************************************/

int DirRead::is_valid()
{
  return valid;
}


/***********************************************************************
 ** rewind - start the directory at the beginning
 **
 ***********************************************************************/

void DirRead::rewind()
{
   if (dir.FindFile(last_pattern.str_show(), 0))
	   valid = 1;
}


#endif


