# ----------------------------------------------------------------------------
# - aleph-rule                                                               -
# - aleph generic rule makefile configuration                                -
# ----------------------------------------------------------------------------
# - This program is  free software;  you can  redistribute it and/or  modify -
# - it provided that this copyright notice is kept intact.                   -
# -                                                                          -
# - This  program  is  distributed in the hope  that it  will be useful, but -
# - without  any   warranty;  without  even   the   implied    warranty   of -
# - merchantability  or fitness for a particular purpose. In not event shall -
# - the copyright holder be  liable for  any direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.      -
# ----------------------------------------------------------------------------
# - copyright (c) 2000-2003 amaury darsch                                    -
# ----------------------------------------------------------------------------

ifeq ($(CCMODE),debug)
  CPPFLAGS      = $(STDCCFLAGS) $(PLTCCFLAGS) $(CPPCCFLAGS) $(DEBUGFLAGS)
  CXXFLAGS      = $(STDCCFLAGS) $(PLTCCFLAGS) $(CXXCCFLAGS) $(DEBUGFLAGS)
  CCDEFINE      = $(STDDEFINES) $(PLTDEFINES) $(DBGDEFINES)
endif

ifeq ($(CCMODE),optimized)
  CPPFLAGS      = $(STDCCFLAGS) $(PLTCCFLAGS) $(CPPCCFLAGS) $(OPTCCFLAGS)
  CXXFLAGS      = $(STDCCFLAGS) $(PLTCCFLAGS) $(CXXCCFLAGS) $(OPTCCFLAGS)
  CCDEFINE      = $(STDDEFINES) $(PLTDEFINES) $(OPTDEFINES)
endif

ifeq ($(CCMODE),profiled)
  CPPFLAGS      = $(STDCCFLAGS) $(PLTCCFLAGS) $(CPPCCFLAGS) $(PFLCCFLAGS)
  CXXFLAGS      = $(STDCCFLAGS) $(PLTCCFLAGS) $(CXXCCFLAGS) $(PFLCCFLAGS)
  CCDEFINE      = $(STDDEFINES) $(PLTDEFINES) $(DBGDEFINES)
endif

ifeq ($(CCMODE),coverage)
  CPPFLAGS      = $(STDCCFLAGS) $(PLTCCFLAGS) $(CPPCCFLAGS) $(COVCCFLAGS)
  CXXFLAGS      = $(STDCCFLAGS) $(PLTCCFLAGS) $(CXXCCFLAGS) $(COVCCFLAGS)
  CCDEFINE      = $(STDDEFINES) $(PLTDEFINES) $(DBGDEFINES)
endif

PPFLAGS         = $(CPPFLAGS)   $(EXTCPPFLAGS)
XXFLAGS         = $(CXXFLAGS)   $(EXTCXXFLAGS)
DEFINES         = $(CCDEFINE)   $(EXTCCDEFINE)
PPINCLS		= $(STDINCLUDE) $(INCLUDE)
XXINCLS		= $(STDINCLUDE) $(EXTINCLUDES) $(INCLUDE)

CPPOBJS         = $(CPPSRCS:.cpp=.o)
CXXOBJS         = $(CXXSRCS:.cxx=.o)
OBJECTS         = $(CPPOBJS) $(CXXOBJS)

# ----------------------------------------------------------------------------
# - project file rules                                                       -
# ----------------------------------------------------------------------------

HPPSRCS		= $(wildcard *.hpp)
CPPSRCS		= $(wildcard *.cpp)
CXXSRCS		= $(wildcard *.cxx)

ifneq ($(TRGLIB),)
ARLIB		= lib$(TRGLIB).a
SOLIB		= lib$(TRGLIB).so
endif

ifeq ($(LKMODE),soname)
SONAME		= $(SOLIB).$(MAJOR).$(MINOR)
SOVERS		= $(SOLIB).$(MAJOR).$(MINOR).$(PATCH)
endif

# ----------------------------------------------------------------------------
# - compilation rules                                                        -
# ----------------------------------------------------------------------------

-include *.d

%.o   : %.cpp 
	$(CC) $(PPFLAGS) $(DEFINES) $(PPINCLS) -o $@ -c $<

%.o   : %.cxx 
	$(CC) $(XXFLAGS) $(DEFINES) $(XXINCLS) -o $@ -c $<

# ----------------------------------------------------------------------------
# - archive rules                                                            -
# ----------------------------------------------------------------------------

ifneq ($(ARLIB),)
$(ARLIB) : $(OBJECTS)
	$(AR) $@ $(OBJECTS)
	@$(MKDIR) $(BLDLIB)
	@$(CP) $@ $(BLDLIB)

install-arlib: $(ARLIB)
	@$(MKDIR) $(LIBDIR)
	@$(CP)    $(ARLIB) $(LIBDIR)
.PHONY: install-arlib
else
install-arlib: $(ARLIB)
	@$(MKDIR) $(LIBDIR)
.PHONY: install-arlib
endif

# ----------------------------------------------------------------------------
# - dynamic linking and soname rules                                         -
# ----------------------------------------------------------------------------

ifneq ($(SOLIB),)
# use generic linking mode
ifeq  ($(LKMODE),generic)
$(SOLIB) : $(OBJECTS)
	$(LD) $(LDFLAGS) -o $@ $(OBJECTS) $(EXTLIB)
	@$(MKDIR) $(BLDLIB)
	@$(CP) $@ $(BLDLIB)

install-solib : $(SOLIB)
	@$(MKDIR)       $(LIBDIR)
	@$(CP) $(SOLIB) $(LIBDIR)
.PHONY: install-solib
endif

# use soname linking mode
ifeq  ($(LKMODE),soname)
$(SOVERS) : $(OBJECTS)
	$(LD) $(LDFLAGS) -o $(SOVERS) $(OBJECTS) $(EXTLIB)

$(SOLIB) : $(SOVERS)
	@$(MKDIR)        $(BLDLIB)
	@$(CP) $(SOVERS) $(BLDLIB)
	@$(RM) $(BLDLIB)/$(SOLIB)
	@$(RM) $(BLDLIB)/$(SONAME)
	@$(LN) $(SOVERS) $(BLDLIB)/$(SONAME)
	@$(LN) $(SONAME) $(BLDLIB)/$(SOLIB)

install-solib : $(SOVERS)
	@$(MKDIR)        $(LIBDIR)
	@$(CP) $(SOVERS) $(LIBDIR)
	@$(RM) $(LIBDIR)/$(SONAME)
	@$(RM) $(LIBDIR)/$(SOLIB)
	@$(LN) $(SOVERS) $(LIBDIR)/$(SONAME)
	@$(LN) $(SONAME) $(LIBDIR)/$(SOLIB)
.PHONY: install-solib
endif
else
install-solib:
	@$(MKDIR) $(LIBDIR)
.PHONY: install-solib
endif

install-lib: install-arlib install-solib
.PHONY: install-lib

# ----------------------------------------------------------------------------
# - library rules                                                            -
# ----------------------------------------------------------------------------

ifneq ($(TRGLIB),)
ifeq  ($(LKTYPE),dynamic)
$(TRGLIB) : $(ARLIB) $(SOLIB)
	@$(MKDIR) $(BLDHDR)/$(TRGDIR)
	@for i in *.hpp; do\
           $(CMP) $$i $(BLDHDR)/$(TRGDIR)/$$i || \
	   $(CP)  $$i $(BLDHDR)/$(TRGDIR)/$$i; \
         done
endif
ifeq  ($(LKTYPE),static)
$(TRGLIB) : $(ARLIB)
	@$(MKDIR) $(BLDHDR)/$(TRGDIR)
	@for i in *.hpp; do\
           $(CMP) $$i $(BLDHDR)/$(TRGDIR)/$$i || \
	   $(CP)  $$i $(BLDHDR)/$(TRGDIR)/$$i; \
         done
endif
endif

# ----------------------------------------------------------------------------
# - target rules                                                             -
# ----------------------------------------------------------------------------

ifneq ($(TARGETS),)
targets: $(TARGETS)
	@$(MKDIR) $(BLDBIN)
	@$(CP)    $(TARGETS) $(BLDBIN)
.PHONY: targets

ifeq ($(LKTYPE),dynamic)
$(TARGETS) : $(OBJECTS)
	$(LK) $(LKFLAGS) -o $@ $(OBJECTS) $(EXELIBS) $(EXESLIB)
endif
ifeq ($(LKTYPE),static)
$(TARGETS) : $(OBJECTS)
	$(LK) $(LKFLAGS) -o $@ $(OBJECTS) $(STALIBS) $(EXESLIB)
endif
endif

# ----------------------------------------------------------------------------
# - testers rules                                                            -
# ----------------------------------------------------------------------------

ifneq ($(TESTERS),)
$(TESTERS) : % : %.o
	$(LK) $(LKFLAGS) -o $@ $@.o $(EXELIBS) $(EXESLIB)

test: $(TESTERS:%=%.run)
$(TESTERS:%=%.run): %.run : %
	@$(BTEST) $(ALPLIB) $<
.PHONY: test $(TESTERS:%=%.run)
endif

ifneq ($(TESTALS),)
test: $(TESTALS)
$(TESTALS): %.als : dummy
	@$(ATEST) $(ALPBLD) $@
.PHONY: test dummy
endif

# ----------------------------------------------------------------------------
# - generic clean                                                            -
# ----------------------------------------------------------------------------

clean::
	@$(RM) *.o *.d *~ core *.core *.so *.so.* *.a *.bb *.bbg *.da
.PHONY: clean
