/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __MP3WRITER_H__
#define __MP3WRITER_H__

#include "processmgr.h"

/*========================================================*/

class ArsonAudioDecoderProcess;
class ArsonFileListFileItem;
class ArsonAudioFile;
class ArsonTocFile;
class ArsonFifo;

class ArsonAudioWriter : public ArsonCdWriter
{
	enum {
		flagNormalized = 0x01,
		flagWritten = 0x02,
		flagDecoded = 0x04,
	};

	class Track
	{
	public:
		Track (void) { }
		Track (const QString &path);
		Track (const Track &track);
		~Track (void);

		uint estimatedFileSize (void) const;
		bool burnable (void) const;

		const QString &filename (void) const { return m_filename; }

		const QString &decodedPath (void) const;
		uint lengthInSeconds (void) const;
		bool createFifo (void);
		void deleteFifo (void);

		Track &operator= (const Track &track);

	private:
		QString m_filename;
		QString m_decoded;
		ArsonFifo *m_pFifo;
		uint m_length;
	};

	typedef QValueList<Track> TRACKLIST;

public:
	ArsonAudioWriter (ArsonProcessUI *pUI);

	virtual void abort (void);

	void addTrack (ArsonFileListFileItem *pi);
	uint totalMinutes (void) const;

	bool normalized (void) const { return (m_flags & flagNormalized) != 0; }
	bool written (void) const { return (m_flags & flagWritten) != 0; }
	bool decoded (void) const { return (m_flags & flagDecoded) != 0; }
	uint trackCount (void) const { return m_tracks.count(); }		

protected:
	virtual ArsonAudioDecoderProcess *createDecoder(
		int trackNo, ArsonAudioFile &af, const QString &wav);

	void setNormalized (void) { m_flags |= flagNormalized; }
	void setWritten (void) { m_flags |= flagWritten; }
	void setDecoded (void) { m_flags |= flagDecoded; }

	const Track &track (int index) const { return m_tracks[index]; }
	Track &track (int index) { return m_tracks[index]; }

	ArsonAudioDecoderProcess *nextDecodableTrack (void);
	bool successful (ArsonProcess *ptr);
	bool decodeAudio (void);
	bool checkAudio (void);
	void normalize (void);
	void nextTask (void);
	void reset (void);

	TRACKLIST m_tracks;
	int m_currentTrack;
	uint m_flags;
};

/*========================================================*/

class ArsonCdInfo;

class ArsonDaoWriter : public ArsonAudioWriter
{
public:
	ArsonDaoWriter (ArsonProcessUI *pUI);
	virtual ~ArsonDaoWriter (void);

	virtual void begin (const ArsonProcessOpts &opts);
	virtual void taskComplete (ArsonProcess *ptr);

	void setCdInfo (const ArsonCdInfo *pi) { m_pCdInfo = pi; }

private:
	virtual ArsonWriterProcess *createWriterProcess (void);

	const ArsonCdInfo *m_pCdInfo;
	ArsonTocFile *m_pTOC;
};

/*========================================================*/

class ArsonFifo;

class ArsonTaoWriter : public ArsonAudioWriter
{
	typedef QValueList<ArsonFifo*> FIFOLIST;

public:
	ArsonTaoWriter (ArsonProcessUI *pUI);

	virtual void abort (void);
	virtual void begin (const ArsonProcessOpts &opts);
	virtual void taskComplete (ArsonProcess *ptr);

private:
	virtual ArsonAudioDecoderProcess *createDecoder(
		int trackNo, ArsonAudioFile &af, const QString &wav);

	virtual ArsonWriterProcess *createWriterProcess (void);

	void deleteFifos (void);
	bool setupFifos (void);
};

/*========================================================*/
#endif	/*	__MP3WRITER_H__	*/
