/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __CDCOPYDLG_H__
#define __CDCOPYDLG_H__

#include "_cdcopydlg.h"

#include "processmgr.h"

/*==================================*/
/*	DEFINES
 *==================================*/

#define ARSON_WIZARD_CDCOPY		"cdcopy"

/*========================================================*/

struct ArsonCopyOpts
{
	void load (void);
	void save (void) const;

	QString temppath;		//	Temp file location
	QString srcdev;			//	Source device
	bool bDirect;			//	On the fly copy?
	bool bDelete;			//	Delete temp img?
};

/*========================================================*/

class ArsonDeviceUiList;

class ArsonCdCopyDlg : public ArsonCdCopyDlgBase
{
	Q_OBJECT
	
public:
	ArsonCdCopyDlg (QWidget *parent, const char *name = NULL);
	virtual ~ArsonCdCopyDlg (void);

	bool directCopy (void) const;
	
protected:
	virtual void browse_clicked (void);

	ArsonDeviceUiList *m_devs;

private slots:
	void slotPageChange (QWidget *was, QWidget *now);
};

/*========================================================*/

class ArsonCdCopyMgr : public ArsonProcessMgr
{
protected:
	ArsonCdCopyMgr (ArsonProcessUI *pUI, const ArsonCopyOpts &opts);

	ArsonCopyOpts m_opts;
};

/*========================================================*/

class ArsonLongCopyMgr : public ArsonCdCopyMgr
{
public:
	ArsonLongCopyMgr (ArsonProcessUI *pUI, const ArsonCopyOpts &opts);

protected:
	virtual void taskComplete (ArsonProcess *ptr);
	virtual void begin (const ArsonProcessOpts &opts);
	virtual void abort (void);

	void removeImg (void);

	uint m_stage;

	enum {
		stageBegin,
		stageRead,
		stageWrite,
	};
};

/*========================================================*/

class ArsonDirectCopyMgr : public ArsonCdCopyMgr
{
public:
	ArsonDirectCopyMgr (ArsonProcessUI *pUI, const ArsonCopyOpts &opts);

protected:
	virtual void begin (const ArsonProcessOpts &opts);
};

/*========================================================*/

class ArsonCdrdaoCopyMgr : public ArsonCdCopyMgr
{
public:
	ArsonCdrdaoCopyMgr (ArsonProcessUI *pUI, const ArsonCopyOpts &opts);

protected:
	virtual void begin (const ArsonProcessOpts &opts);
};

/*========================================================*/
#endif	/*	__CDCOPYDLG_H__	*/
