;*=====================================================================*/
;*    serrano/prgm/project/bigloo/fthread/src/_exc.scm                 */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Feb 18 14:43:41 2002                          */
;*    Last change :  Wed Mar  6 08:58:17 2002 (serrano)                */
;*    Copyright   :  2002 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    Fair exception private.                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __ft_%exception

   (import __ft_types
	   __ft_%types
	   __ft_thread)
   
   (export *join-timeout-exception*
	   *abandoned-mutex-exception*
	   *terminated-thread-exception*

	   (uncaught-exception-hdl ::obj)))

;*---------------------------------------------------------------------*/
;*    Exceptions                                                       */
;*---------------------------------------------------------------------*/
(define *join-timeout-exception* (cons 'exception 'join-timeout))
(define *abandoned-mutex-exception* (cons 'exception 'abandoned-mutex))
(define *terminated-thread-exception* (cons 'exception 'terminated-thread))

;*---------------------------------------------------------------------*/
;*    uncaught-exception-hdl ...                                       */
;*---------------------------------------------------------------------*/
(define (uncaught-exception-hdl x)
   (let ((t (current-thread))
	 (v (instantiate::%uncaught-exception
	       (reason x))))
      (if (thread? t)
	  (with-access::thread t (%exc-result %exc-raised)
	     (set! %exc-result v)
	     (set! %exc-raised #t)))
      v))
