/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Jlib/client_socket.java      */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Dec  5 10:53:03 2000                          */
/*    Last change :  Mon Apr 29 10:49:54 2002 (serrano)                */
/*    Copyright   :  2000-02 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    The Client Socket implementation for the JVM back-end.           */
/*=====================================================================*/
package bigloo;
import bigloo.*;
import java.io.*;
import java.net.*;

/*---------------------------------------------------------------------*/
/*    SOCKET ...                                                       */
/*---------------------------------------------------------------------*/
public final class client_socket extends socket
{
  /*--- public fields ---------------------------------------------------*/
  private Socket socket;
  private final boolean blocking;

  /*--- constructors ----------------------------------------------------*/
  // This is a client socket creation
  public client_socket( final byte[]   hostname,
                        final int      port,
                        final boolean  blocking )
  {
    super();

    this.blocking= blocking;

    try
    {
      socket= new Socket( new String( hostname ), port );
      set_socket_io_ports( socket, blocking );
    }
    catch (final UnknownHostException e)
    {
      socket_error( "make-client-socket",
                    "unknown or misspelled host name",
                    hostname );
    }
    catch (final IOException e)
    {
      socket_error( "make-client-socket",
                    "cannot create socket",
                    hostname );
    }
  }

  protected client_socket( final Socket   socket,
                           final boolean  blocking )
  {
    super();

    this.blocking= blocking;
    this.socket= socket;

    try
    {
      set_socket_io_ports( socket, blocking );
    }
    catch (final IOException _)
    {
      socket_error( "make-client-socket",
                    "cannot create socket",
                    unspecified.unspecified );
    }
  }

  /*--- public methods --------------------------------------------------*/
  public Object HOSTNAME()
  {
    return socket.getInetAddress().getHostName().getBytes();
  }

  public Object HOSTIP()
  {
    return socket.getInetAddress().getHostAddress().getBytes();
  }

  public byte[] local_addr()
  {
    return socket.getLocalAddress().getHostAddress().getBytes();
  }

  public socket socket_dup()
  {
    return new client_socket( socket, blocking );
  }

  public Object shutdown( final boolean  close_socket )
    throws IOException
  {
    close();
    down= true;
    return bigloo.foreign.BUNSPEC;
  }

  public Object close()
    throws IOException
  {
    socket.close();
    return super.close();
  }

  public int PORT()
  {
    return socket.getPort();
  }

  public void write( final output_port  p )
  {
    Object    hostname= HOSTNAME();

    if (hostname instanceof byte[])
      hostname= new String( (byte[])hostname );

    p.write( "#<socket:" + hostname.toString() + "." + PORT() + ">" );
  }
}
