<?php
/*
 * $Id: class.dbViews.inc.php,v 1.2 2001/09/23 21:33:38 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('db');

class dbViews extends dclDB
{
	var $viewid;
	var $whoid;
	var $name;
	var $ispublic;
	var $viewurl;
	var $tablename;

	function dbViews()
	{
           // Table Fields
		$this->fieldArray = array('viewid', 'whoid', 'name', 'ispublic', 'viewurl', 'tablename');

           // Foreign Keys
		$this->foreignKeys = array();

		$this->cache = array();
		$this->cacheEnabled = true;

		$this->dclDB();
	}

	function Add()
	{
		$idSQL = $this->GetNewIDSQLForTable('views');
		$query = 'INSERT INTO views (';
		if ($idSQL != '')
			$query .= 'viewid,';
		$query .= 'whoid,name,ispublic,viewurl,tablename)';
		$query .= ' VALUES (';
		if ($idSQL != '')
			$query .= $idSQL . ',';
		$query .= $this->whoid . ',';
		$query .= '\'' . $this->DBAddSlashes($this->name) . '\',';
		$query .= '\'' . $this->ispublic . '\',';
		$query .= '\'' . $this->DBAddSlashes($this->viewurl) . '\',';
		$query .= '\'' . $this->DBAddSlashes($this->tablename) . '\')';

		if ($this->Insert($query) == -1)
		{
			echo '<BR>' . sprintf(STR_DB_VIEWINSERTERR, $query) . '<BR>';
		}
	}

	function Edit()
	{
		$query = 'UPDATE views SET ';
		$query .= 'whoid=' . $this->whoid . ',';
		$query .= 'name=\'' . $this->DBAddSlashes($this->name) . '\',';
		$query .= 'ispublic=\'' . $this->ispublic . '\',';
		$query .= 'viewurl=\'' . $this->DBAddSlashes($this->viewurl) . '\',';
		$query .= 'tablename=\'' . $this->DBAddSlashes($this->tablename) . '\'';
		$query .= ' WHERE viewid=' . $this->viewid;

		$this->Execute($query);
	}

	function Delete()
	{
		$query = 'DELETE FROM views WHERE viewid=' . $this->viewid;
		return $this->Execute($query);
	}

	function GetRow()
	{
		if (!$this->res)
			return -1;

		if (count($this->Record) > 0)
		{
			$this->viewid = $this->f('viewid');
			$this->whoid = $this->f('whoid');
			$this->name = trim($this->f('name'));
			$this->ispublic = $this->f('ispublic');
			$this->viewurl = trim($this->f('viewurl'));
			$this->tablename = trim($this->f('tablename'));

			if ($this->cacheEnabled)
				$this->CacheRow($this->viewid);
		}
		else
			$this->Clear();
	}

	function Load($id)
	{
		$this->Clear();

		if ($this->cacheEnabled && $this->LoadCache($id) != -1)
			return 0;

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = "SELECT * FROM views WHERE viewid=$id";
		if (!$this->Query($sql))
			return -1;

		$this->next_record();
		return $this->GetRow();
	}

	function Clear()
	{
		$this->viewid = 0;
		$this->whoid = 0;
		$this->name = '';
		$this->ispublic = '';
		$this->viewurl = '';
		$this->tablename = '';
	}
}
?>
