/* $Id: prefs.c,v 1.1.1.1 2000/10/13 06:45:03 kitame Exp $

  DEdit preferences.

  Copyright (C) 1999-2000  Takuo KITAME

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License with
  the Debian GNU/Linux distribution in file /usr/doc/copyright/GPL;
  if not, write to the Free Software Foundation, Inc., 59 Temple Place,
  Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnome.h>

#include "dedit.h"
#include "callbacks.h"
#include "mdi.h"
#include "prefs.h"

extern DEditPrefs *prefs;
extern GnomeMDI *DEmdi;

static GtkWidget *pbox = NULL;

#define DEFAULT_FONT "-adobe-courier-medium-r-normal-*-14-*-*-*-m-*-iso8859-1"
#define DEFAULT_FONTSET "-*-*-medium-r-normal-*-14-*-*-*-*-*-*-*,*"

static gboolean
prefs_determine_use_fontset(void)
{
	GtkWidget *dummy_widget;
	gboolean retval;
    
	dummy_widget = gtk_text_new (NULL, NULL);
	gtk_widget_ensure_style (dummy_widget);
	if (dummy_widget->style->font->type == GDK_FONT_FONTSET)
		retval = TRUE;
	else
		retval = FALSE;
    
	gtk_widget_unref (dummy_widget);
    
	return retval;
}

static gpointer 
prefs_pbox_get_data(const gchar *key)
{
    gpointer data;

    g_return_val_if_fail(pbox != NULL, NULL);
    g_return_val_if_fail(key != NULL, NULL);
    
    data = gtk_object_get_data(GTK_OBJECT(pbox), key);
    
    return data;
}

static void
prefs_pbox_remove_data(const gchar *key)
{
    g_return_if_fail(pbox != NULL);
    g_return_if_fail(key != NULL);

    gtk_object_remove_data(GTK_OBJECT(pbox), key);

    return;
}

static void
prefs_pbox_set_data(const gchar *key, gpointer data)
{
    g_return_if_fail(pbox != NULL);
    g_return_if_fail(data != NULL);
    g_return_if_fail(key != NULL);

    prefs_pbox_remove_data(key);
    
    gtk_object_set_data(GTK_OBJECT(pbox), key, data);
    
    return;
}

static void
prefs_pbox_changed_cb(GtkWidget *w, gpointer data)
{
    
    gnome_dialog_set_sensitive(GNOME_DIALOG(pbox), 1, TRUE);

    return;
}

/* Object Data handlers */
static gint
gtk_option_menu_get_active_index(GtkWidget *omenu)
{
	GtkMenu *menu;
	GtkWidget *active;
	GtkWidget *child;
	GList *children;
	gint i = 0;

	menu = GTK_MENU(gtk_option_menu_get_menu(GTK_OPTION_MENU(omenu)));
	active = gtk_menu_get_active(menu);
	
	child = NULL;
	children = GTK_MENU_SHELL(menu)->children;
	while (children) {
		child = children->data;
		children = children->next;
        
		if(child == active)
			return i;
		else
			i++;
	}
    
	return 0;
}

/* Property Box Value Handlig */
static gint
prefs_pbox_get_int(const gchar *key)
{
    gint ret = 0;
    GtkWidget *w;
    gchar *tmp;

    g_return_val_if_fail(pbox != NULL, 0);
    g_return_val_if_fail(key != NULL, 0);
    
    w = prefs_pbox_get_data(key);
    
    if(GTK_IS_OPTION_MENU(w))
        ret = gtk_option_menu_get_active_index(w);
    else {
        tmp = gtk_entry_get_text(GTK_ENTRY(w));
        ret = (gint)strtol(tmp, NULL, 10);
    }

    return ret;
}

/* not needed
static gchar *
prefs_pbox_get_string(const gchar *key)
{
    gchar *ret = NULL;
    GtkWidget *e;

    g_return_val_if_fail(pbox != NULL, NULL);
    g_return_val_if_fail(key != NULL, NULL);

    e = prefs_pbox_get_data(key);
    ret = g_strdup(gtk_entry_get_text(GTK_ENTRY(e)));

    return ret;
}
*/

static gboolean
prefs_pbox_get_bool(const gchar *key)
{
    gboolean ret = FALSE;
    GtkWidget *t;

    g_return_val_if_fail(pbox != NULL, FALSE);
    g_return_val_if_fail(key != NULL, FALSE);

    t = prefs_pbox_get_data(key);
    ret = GTK_TOGGLE_BUTTON(t)->active;

    return ret;
}

/* not needed
static void
prefs_pbox_set_int(const gchar *key, gint i)
{
    static char c[11];
    GtkWidget *e;

    g_return_if_fail(pbox != NULL);
    g_return_if_fail(key != NULL);

    e = prefs_pbox_get_data(key);
    g_snprintf(c, 11, "%d", i);
    gtk_entry_set_text(GTK_ENTRY(e), c);
    
    return;
}

static void
prefs_pbox_set_string(const gchar *key, gchar *str)
{
    GtkWidget *e;

    g_return_if_fail(pbox != NULL);
    g_return_if_fail(key != NULL);

    e = prefs_pbox_get_data(key);
    gtk_entry_set_text(GTK_ENTRY(e), str);

    return;
}
*/

static void
prefs_pbox_set_bool(const gchar *key, gboolean b)
{
    GtkWidget *t;

    g_return_if_fail(pbox != NULL);
    g_return_if_fail(key != NULL);

    t = prefs_pbox_get_data(key);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(t), b);
    
    return;
}

static void
create_font_page(GtkWidget *vbox)
{
    GtkWidget *obj;
    GtkWidget *hbox;
    GtkWidget *vbox1;
    GtkWidget *table;
    GtkWidget *frame;

	GtkStyle *style;
	GdkColor *c;
    DEdit *doc;

    /* Font */
    frame = gtk_frame_new(_("Font Setting"));
    gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);    
    gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 5);

    vbox1 = gtk_vbox_new(FALSE, 0);
    gtk_container_set_border_width(GTK_CONTAINER(vbox1), 5);
    gtk_container_add(GTK_CONTAINER(frame), vbox1);
    
    /* */
    hbox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox1), hbox, FALSE, FALSE, 2);
    gtk_container_set_border_width(GTK_CONTAINER(hbox), 2);

    obj = gtk_label_new(_("Text Font:"));
    gtk_box_pack_start(GTK_BOX(hbox), obj, FALSE, FALSE, 2);
    gtk_misc_set_alignment(GTK_MISC(obj), 0, 0.5);

    obj = gnome_font_picker_new();
    gtk_box_pack_start(GTK_BOX(hbox), obj, FALSE, FALSE, 2);
    gtk_widget_set_usize(obj, 200, -1);
    prefs_pbox_set_data("font_set", obj);
    gnome_font_picker_set_mode(GNOME_FONT_PICKER(obj), GNOME_FONT_PICKER_MODE_FONT_INFO);
    gnome_font_picker_fi_set_use_font_in_label(GNOME_FONT_PICKER(obj), TRUE, 14);
    gnome_font_picker_fi_set_show_size(GNOME_FONT_PICKER(obj), TRUE);

    if(prefs->fontset)
        gnome_font_picker_set_font_name(GNOME_FONT_PICKER(obj), prefs->fontset);
    gtk_signal_connect(GTK_OBJECT(obj), "font_set",
                       GTK_SIGNAL_FUNC(prefs_pbox_changed_cb), NULL);

    /* fontset */
    obj = gtk_check_button_new_with_label(_("Use fontset"));
    gtk_box_pack_start(GTK_BOX(vbox1), obj, FALSE, FALSE, 2);
    prefs_pbox_set_data("use_fontset", obj);
    prefs_pbox_set_bool("use_fontset", prefs->use_fontset);
    gtk_signal_connect(GTK_OBJECT(obj), "toggled",
                       GTK_SIGNAL_FUNC(prefs_pbox_changed_cb), NULL);

    /* Color */
    frame = gtk_frame_new(_("Color Setting"));
    gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);        
    gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 5);

    vbox1 = gtk_vbox_new(FALSE, 0);
    gtk_container_set_border_width(GTK_CONTAINER(vbox1), 5);
    gtk_container_add(GTK_CONTAINER(frame), vbox1);
    
    /* */
    table = gtk_table_new(2, 2, FALSE);
    gtk_box_pack_start(GTK_BOX(vbox1), table, TRUE, TRUE, 2);

    obj = gtk_label_new(_("Foreground color:"));
    gtk_misc_set_alignment(GTK_MISC(obj), 0, 0.5);
    gtk_table_attach(GTK_TABLE(table), obj, 0, 1, 0, 1,
                     GTK_FILL, GTK_FILL, 2, 2);
    
    obj = gnome_color_picker_new();
    prefs_pbox_set_data("fg", obj);
    gtk_table_attach(GTK_TABLE(table), obj, 1, 2, 0, 1,
                     GTK_FILL, GTK_FILL, 2, 2);
    doc = get_doc_from_mdi_child();

	if(doc)
		style = gtk_style_copy(gtk_widget_get_style(doc->text));
	else
		style = gtk_style_new();

	c = &style->text[0];
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(obj),
                               c->red, c->green, c->blue, 0);
    gtk_signal_connect(GTK_OBJECT(obj), "color_set",
                       GTK_SIGNAL_FUNC(prefs_pbox_changed_cb), NULL);
    
    obj = gtk_label_new(_("Background color:"));
    gtk_misc_set_alignment(GTK_MISC(obj), 0, 0.5);
    gtk_table_attach(GTK_TABLE(table), obj, 0, 1, 1, 2,
                     GTK_FILL, GTK_FILL, 2, 2);

    obj = gnome_color_picker_new();
    prefs_pbox_set_data("bg", obj);
    gtk_table_attach(GTK_TABLE(table), obj, 1, 2, 1, 2,
                     GTK_FILL, GTK_FILL, 2, 2);

	c = &style->base[0];
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(obj),
                               c->red, c->green, c->blue, 0);
    gtk_signal_connect(GTK_OBJECT(obj), "color_set",
                       GTK_SIGNAL_FUNC(prefs_pbox_changed_cb), NULL);
    
    /* end */
	gtk_style_unref(style);    

    return;
}

static void
create_general_page(GtkWidget *vbox)
{
    GtkWidget *obj;
    GtkWidget *hbox;
    GtkWidget *vbox1;
    GtkWidget *frame;

    GtkWidget *table;
    
    GtkWidget *opmenu;
    GtkWidget *menu;
    GtkWidget *item;


    /* MDI */
    frame = gtk_frame_new(_("MDI Setting"));
    gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
    gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 5);

    vbox1 = gtk_vbox_new(FALSE, 0);
    gtk_container_set_border_width(GTK_CONTAINER(vbox1), 5);
    gtk_container_add(GTK_CONTAINER(frame), vbox1);

    /* */
    table = gtk_table_new(2, 2, TRUE);
    gtk_box_pack_start(GTK_BOX(vbox1), table, TRUE, TRUE, 2);
    
    obj = gtk_label_new(_("MDI Window Style:"));
    gtk_misc_set_alignment(GTK_MISC(obj), 1, 0.5);
    gtk_table_attach(GTK_TABLE(table), obj, 0, 1, 0, 1,
                     GTK_FILL, GTK_FILL, 2, 2);    

    opmenu = gtk_option_menu_new();
    prefs_pbox_set_data("mdimode", opmenu);
    menu = gtk_menu_new();

    item = gtk_menu_item_new_with_label(_("Note Book"));
    gtk_menu_append(GTK_MENU(menu), item);
    item = gtk_menu_item_new_with_label(_("Top Level"));
    gtk_menu_append(GTK_MENU(menu), item);
    item = gtk_menu_item_new_with_label(_("Modal"));
    gtk_menu_append(GTK_MENU(menu), item);
    item = gtk_menu_item_new_with_label(_("Default"));
    gtk_menu_append(GTK_MENU(menu), item);
    gtk_option_menu_set_menu(GTK_OPTION_MENU(opmenu), menu);
    gtk_option_menu_set_history(GTK_OPTION_MENU(opmenu), prefs->mdimode);
    gtk_table_attach(GTK_TABLE(table), opmenu, 1, 2, 0, 1,
                     GTK_FILL, 0, 1, 0);
    gtk_signal_connect(GTK_OBJECT(GTK_MENU_SHELL(gtk_option_menu_get_menu
                                                 (GTK_OPTION_MENU(opmenu)))),
                       "selection-done",
                       GTK_SIGNAL_FUNC(prefs_pbox_changed_cb), NULL);
    
    /* Note Book */
    obj = gtk_label_new(_("Note Book Tab:"));
    gtk_misc_set_alignment(GTK_MISC(obj), 1, 0.5);
    gtk_table_attach(GTK_TABLE(table), obj, 0, 1, 1, 2,
                     GTK_FILL, GTK_FILL, 2, 2);
    
    opmenu = gtk_option_menu_new();
    prefs_pbox_set_data("notebook", opmenu);
    menu = gtk_menu_new();

    item = gtk_menu_item_new_with_label(_("Left"));
    gtk_menu_append(GTK_MENU(menu), item);
    item = gtk_menu_item_new_with_label(_("Right"));
    gtk_menu_append(GTK_MENU(menu), item);
    item = gtk_menu_item_new_with_label(_("Top"));
    gtk_menu_append(GTK_MENU(menu), item);
    item = gtk_menu_item_new_with_label(_("Bottom"));
    gtk_menu_append(GTK_MENU(menu), item);
    gtk_option_menu_set_menu(GTK_OPTION_MENU(opmenu), menu);
    gtk_option_menu_set_history(GTK_OPTION_MENU(opmenu), prefs->tabpos);
    gtk_table_attach(GTK_TABLE(table), opmenu, 1, 2, 1, 2,
                     GTK_FILL, 0, 1, 0);
    gtk_signal_connect(GTK_OBJECT(GTK_MENU_SHELL(gtk_option_menu_get_menu
                                                 (GTK_OPTION_MENU(opmenu)))),
                       "selection-done",
                       GTK_SIGNAL_FUNC(prefs_pbox_changed_cb), NULL);

    hbox = gtk_hbox_new(FALSE, 0);
    gtk_container_set_border_width(GTK_CONTAINER(hbox), 0);

    /* Toolbar */
    frame = gtk_frame_new(_("Toolbar Setting"));
    gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
    gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 5);

    vbox1 = gtk_vbox_new(FALSE, 0);
    gtk_container_set_border_width(GTK_CONTAINER(vbox1), 5);
    gtk_container_add(GTK_CONTAINER(frame), vbox1);

    /* */
    obj = gtk_check_button_new_with_label(_("Hide toolbar"));    
    gtk_box_pack_start(GTK_BOX(vbox1), obj, TRUE, TRUE, 2);
    prefs_pbox_set_data("toolbar", obj);
    prefs_pbox_set_bool("toolbar", prefs->toolbar ? FALSE : TRUE);
    gtk_signal_connect(GTK_OBJECT(obj), "toggled",
                       GTK_SIGNAL_FUNC(prefs_pbox_changed_cb), NULL);
    /* */
    hbox = gtk_hbox_new(FALSE, 0);
    gtk_container_set_border_width(GTK_CONTAINER(hbox), 0);
    gtk_box_pack_start(GTK_BOX(vbox1), hbox, TRUE, TRUE, 2);

    obj = gtk_label_new(_("Toolbar Style:"));
    gtk_box_pack_start(GTK_BOX(hbox), obj, FALSE, FALSE, 2);
    {
        GtkWidget *opmenu;
        GtkWidget *menu;
        GtkWidget *item;

        opmenu = gtk_option_menu_new();
        prefs_pbox_set_data("toolbar_style", opmenu);
        gtk_widget_set_usize(opmenu, 150, -1);
        gtk_box_pack_start(GTK_BOX(hbox), opmenu, FALSE, FALSE, 2);
        menu = gtk_menu_new();

        item = gtk_menu_item_new_with_label(_("System setting"));
        gtk_menu_append(GTK_MENU(menu), item);
        item = gtk_menu_item_new_with_label(_("Icon only"));
        gtk_menu_append(GTK_MENU(menu), item);
        item = gtk_menu_item_new_with_label(_("Text only"));
        gtk_menu_append(GTK_MENU(menu), item);
        item = gtk_menu_item_new_with_label(_("Icon and Text"));
        gtk_menu_append(GTK_MENU(menu), item);
        gtk_option_menu_set_menu(GTK_OPTION_MENU(opmenu), menu);
        gtk_option_menu_set_history(GTK_OPTION_MENU(opmenu),
                                    prefs->toolbar_style);
        gtk_signal_connect(GTK_OBJECT(GTK_MENU_SHELL
                                      (gtk_option_menu_get_menu
                                       (GTK_OPTION_MENU(opmenu)))),
                           "selection-done",
                           GTK_SIGNAL_FUNC(prefs_pbox_changed_cb), NULL);
    }
    
    return;
}

static GtkWidget *
create_page(GtkWidget *book, gchar *book_label, GtkWidget *ctree,
            gchar *tree_label, GtkCTreeNode *parent, GtkCTreeNode **node,
            gint page_index)
{
    GtkWidget *vbox;
    GtkWidget *frame;
    GtkWidget *label;
    GtkWidget *vvbox;

    gchar *titles[1];

    vvbox = gtk_vbox_new(FALSE, 0);
    
    frame = gtk_frame_new(NULL);
    gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_OUT);
    gtk_box_pack_start(GTK_BOX(vvbox), frame, FALSE, TRUE, 0);
    
    label = gtk_label_new(book_label);
    gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
    gtk_misc_set_padding(GTK_MISC(label), 2, 1);
    gtk_container_add(GTK_CONTAINER(frame), label);

    vbox = gtk_vbox_new(FALSE, 2);
    gtk_container_set_border_width(GTK_CONTAINER(vbox), 4);
    gtk_container_add (GTK_CONTAINER (vvbox), vbox);
    
    titles[0] = tree_label;

    *node = gtk_ctree_insert_node(GTK_CTREE (ctree), parent, NULL, titles, 0,
                                  NULL, NULL, NULL, NULL, FALSE, FALSE);
    gtk_ctree_node_set_row_data(GTK_CTREE(ctree), *node,
                                (gpointer)page_index);

    gtk_notebook_append_page(GTK_NOTEBOOK(book), vvbox, NULL);
    
    return vbox;
}

static void
ctree_select(GtkWidget *ctree, GtkCTreeNode *node)
{
    GtkWidget *book;
    gint page;

    if(!GTK_CLIST(ctree)->selection)
        return;
    
    book = GTK_WIDGET(gtk_object_get_user_data(GTK_OBJECT(ctree)));
    page = (gint)gtk_ctree_node_get_row_data(GTK_CTREE(ctree), node);
    
    gtk_notebook_set_page(GTK_NOTEBOOK(book), page);

    return;
}

static void
destroy_cb(GtkWidget *w, gpointer data)
{
	gtk_widget_destroy(GTK_WIDGET(pbox));
	pbox = NULL;
    return;
}

static void
apply_cb(GtkWidget *w, gpointer *data)
{
    GtkWidget *obj;
    gint mdimode[] = {
        GNOME_MDI_NOTEBOOK,
        GNOME_MDI_TOPLEVEL,
        GNOME_MDI_MODAL,
        GNOME_MDI_DEFAULT_MODE
    };
    gint tabpos[] = {
        GTK_POS_LEFT,
        GTK_POS_RIGHT,
        GTK_POS_TOP,
        GTK_POS_BOTTOM
    };
    GtkStyle *s;
    GdkColor *c;

    gnome_dialog_set_sensitive(GNOME_DIALOG(pbox), 1, FALSE);
    obj = prefs_pbox_get_data("font_set");
    prefs->fontset = g_strdup(gnome_font_picker_get_font_name(GNOME_FONT_PICKER(obj)));
    prefs->use_fontset = prefs_pbox_get_bool("use_fontset");
    
    prefs->mdimode = mdimode[prefs_pbox_get_int("mdimode")];
    prefs->tabpos = tabpos[prefs_pbox_get_int("notebook")];
    prefs->toolbar = prefs_pbox_get_bool("toolbar") ? FALSE : TRUE;
    prefs->toolbar_style = prefs_pbox_get_int("toolbar_style");
    
    s = gtk_style_new ();
    c = &s->base[0];

    obj = prefs_pbox_get_data("fg");
    gnome_color_picker_get_i16(GNOME_COLOR_PICKER(obj),
                               &c->red, &c->green, &c->blue, 0);

    prefs->fg[0] = c->red;
    prefs->fg[1] = c->green;
    prefs->fg[2] = c->blue;
    
    c = &s->text[0];
    obj = prefs_pbox_get_data("bg");
    gnome_color_picker_get_i16(GNOME_COLOR_PICKER(obj),
                               &c->red, &c->green, &c->blue, 0);
    prefs->bg[0] = c->red;
    prefs->bg[1] = c->green;
    prefs->bg[2] = c->blue;

    gtk_style_unref(s);

    prefs_save();
    prefs_apply();

    return;
}

static void
ok_cb(GtkWidget *w, gpointer data)
{
    apply_cb(w, data);
    destroy_cb(w, data);

    return;
}

/* */
void
prefs_apply(void)
{
    DEdit *doc;
    GList *children = DEmdi->children;
//    GList *windows = DEmdi->windows;
    
    DEmdi->tab_pos = prefs->tabpos;
    gnome_mdi_set_mode(DEmdi, prefs->mdimode);
    
	// prefs->use_fontset = prefs_determine_use_fontset();

    if(prefs->fontset == NULL) {
        if(prefs->use_fontset)
			prefs->fontset = DEFAULT_FONTSET;
		else
			prefs->fontset = DEFAULT_FONT;
    }
    
    while(children) {
        doc = (DEdit *)gtk_object_get_data(GTK_OBJECT(children->data),
                                           "DEditDoc");
        if(doc) {
            dedit_doc_set_font(doc, prefs->fontset);
            dedit_doc_set_prefs_color(doc);
        }
        children = g_list_next(children);
    }
    
    /*
    if(prefs->toolbar)
        while(windows) {
            windows = g_list_next(windows);
        }
    else
        while(windows) {
            windows = g_list_next(windows);
        }
    */
    dedit_set_prefs_toolbar();

    return;
}

void
prefs_create_dialog(void)
{
    GtkWidget *ctree;
    GtkWidget *hbox;
    GtkWidget *frame;
    GtkWidget *book;
    gchar *titles[1];
    gint page = 0;
    GtkWidget *vbox;
    GtkCTreeNode *last_top;


    if(pbox != NULL) return;

    pbox = gnome_dialog_new(_("DEdit: Preferences"),
                            GNOME_STOCK_BUTTON_OK,
                            GNOME_STOCK_BUTTON_APPLY,
                            GNOME_STOCK_BUTTON_CLOSE,
                            NULL);

    gtk_window_set_modal(GTK_WINDOW(pbox), TRUE);
    gnome_dialog_set_parent(GNOME_DIALOG(pbox),
                            GTK_WINDOW(DEmdi->active_window));

    /* prepare the action area */
    gtk_container_set_border_width
        (GTK_CONTAINER(GNOME_DIALOG(pbox)->action_area), 2);
    gtk_box_set_homogeneous(GTK_BOX(GNOME_DIALOG(pbox)->action_area), FALSE);
    gtk_box_set_spacing(GTK_BOX(GNOME_DIALOG(pbox)->action_area), 0);
    gnome_dialog_set_default(GNOME_DIALOG(pbox), 0);
    gnome_dialog_set_sensitive(GNOME_DIALOG(pbox), 1, FALSE);

    gnome_dialog_button_connect(GNOME_DIALOG(pbox), 0, ok_cb, NULL);
    gnome_dialog_button_connect(GNOME_DIALOG(pbox), 1, apply_cb, NULL);
    gnome_dialog_button_connect(GNOME_DIALOG(pbox), 2, destroy_cb, NULL);                   
    
    /* the main hbox */
    hbox = gtk_hbox_new(FALSE, 6);
    gtk_container_set_border_width(GTK_CONTAINER(hbox), 6);
    gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(pbox)->vbox),
                       hbox, TRUE, TRUE, 0);
    /* the tree */
    titles[0] = _ ("Categories");
    ctree = gtk_ctree_new_with_titles(1, 0, titles);
    gtk_clist_set_selection_mode(GTK_CLIST(ctree), GTK_SELECTION_BROWSE);
    gtk_ctree_set_indent(GTK_CTREE(ctree), 10);
    gtk_widget_set_usize(ctree, 150, 100);
    gtk_box_pack_start(GTK_BOX(hbox), ctree, FALSE, FALSE, 0);
    
    /* the preferences frame */
    frame = gtk_frame_new(NULL);
    gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
    gtk_box_pack_start(GTK_BOX(hbox), frame, TRUE, TRUE, 0);

    /* the notebook */
    book = gtk_notebook_new();
    gtk_notebook_set_show_tabs(GTK_NOTEBOOK(book), FALSE);
    gtk_notebook_set_show_border(GTK_NOTEBOOK (book), FALSE);
    gtk_container_add(GTK_CONTAINER(frame), book);
    gtk_object_set_user_data(GTK_OBJECT(ctree), book);

    gtk_signal_connect(GTK_OBJECT(ctree), "tree_select_row",
                       GTK_SIGNAL_FUNC(ctree_select), NULL);
 
    vbox = create_page(book, _("Application Interface Settings"),
                       ctree, _("General Settings"),
                       NULL, &last_top, page++);
    gtk_container_set_border_width(GTK_CONTAINER(vbox), 8);
    create_general_page(vbox);
    gtk_widget_show_all(vbox);
    
    gtk_ctree_select(GTK_CTREE(ctree), last_top);

    vbox = create_page(book, _("Font & Color Settings"),
                       ctree, _("Text Settings"),
                       NULL, &last_top, page++);
    gtk_container_set_border_width(GTK_CONTAINER(vbox), 8);
    create_font_page(vbox);
    gtk_widget_show_all(vbox);
    
    /* since they all fit in the window, why not expand them all */
    gtk_ctree_expand_recursive(GTK_CTREE(ctree), 0);
    gtk_clist_select_row(GTK_CLIST(ctree), 0, 0);
    
	gtk_signal_connect(GTK_OBJECT(pbox), "destroy",
                       GTK_SIGNAL_FUNC(destroy_cb), NULL);
	gtk_signal_connect(GTK_OBJECT(pbox), "delete_event",
                       GTK_SIGNAL_FUNC(gtk_false), NULL);

    gtk_widget_show_all(pbox);

    return;
}

void
prefs_save(void)
{
    gnome_config_push_prefix("/dedit/Global/");

    gnome_config_set_int("mdimode", prefs->mdimode);
    gnome_config_set_int("tabpos", prefs->tabpos);

    // gnome_config_set_bool("menubar", prefs->menubar);
    gnome_config_set_bool("toolbar", prefs->toolbar);
    gnome_config_set_int("toolbarstyle", prefs->toolbar_style);

    gnome_config_set_string("fontset", prefs->fontset);
    gnome_config_set_bool("usefontset", prefs->use_fontset);
    
	gnome_config_set_int("bgr", prefs->bg[0]);
	gnome_config_set_int("bgg", prefs->bg[1]);
	gnome_config_set_int("bgb", prefs->bg[2]);
	gnome_config_set_int("fgr", prefs->fg[0]);
	gnome_config_set_int("fgg", prefs->fg[1]);
	gnome_config_set_int("fgb", prefs->fg[2]);
    
    gnome_config_sync_file("/dedit/");
    gnome_config_pop_prefix();
    
    return;
}
void
prefs_load(void)
{
    gchar *font, use_fontset[17];

    prefs = g_new(DEditPrefs, 1);

	prefs->use_fontset = prefs_determine_use_fontset();

    if(prefs->use_fontset) {
        font = g_strdup_printf("fontset=%s", DEFAULT_FONTSET);
        g_snprintf(use_fontset, sizeof(use_fontset), "usefontset=true");
    } else {
        font = g_strdup_printf("fontset=%s", DEFAULT_FONT);
        g_snprintf(use_fontset, sizeof(use_fontset), "usefontset=false");
    }

    gnome_config_push_prefix("/dedit/Global/");

    prefs->mdimode = gnome_config_get_int_with_default("mdimode=0", NULL);
    prefs->tabpos = gnome_config_get_int_with_default("tabpos=0", NULL);    

    prefs->menubar = gnome_config_get_bool_with_default("menubar=false", NULL);
    prefs->toolbar = gnome_config_get_bool_with_default("toolbar=true", NULL);

    prefs->toolbar_style = gnome_config_get_int_with_default("toolbarstyle=0", NULL);

    prefs->fontset =
        gnome_config_get_string_with_default(font, NULL);
    prefs->use_fontset = gnome_config_get_bool_with_default(use_fontset, NULL);

    prefs->fg[0] = gnome_config_get_int_with_default("fgr=0", NULL);
    prefs->fg[1] = gnome_config_get_int_with_default("fgg=0", NULL);
    prefs->fg[2] = gnome_config_get_int_with_default("fgb=0", NULL);

    prefs->bg[0] = gnome_config_get_int_with_default("bgr=65535", NULL);
    prefs->bg[1] = gnome_config_get_int_with_default("bgg=65535", NULL);
    prefs->bg[2] = gnome_config_get_int_with_default("bgb=65535", NULL);
    
    gnome_config_pop_prefix();

    g_free(font);

    return;
}
