
#include "ptg_gen.h"
#include "envmod.h"
#include "idn.h"
#include "csm.h"
#include "PTGNodeList.h"

int EmptyStrIndex;

#if defined(__STDC__) || defined(__cplusplus)
void
InitEbnf (void)
#else
void
InitEbnf ()
#endif
{
  int t;

  mkidn("", 0, &t, &EmptyStrIndex);
}

#if defined(__STDC__) || defined(__cplusplus)
int
StrCat2 (char *str1, char *str2)
#else
int
StrCat2 (str1, str2)
char *str1;
char *str2;
#endif
{
  int t, i;

  obstack_strgrow(Csm_obstk, str1);
  CsmStrPtr = obstack_strcpy(Csm_obstk, str2);
  mkidn(CsmStrPtr, strlen(CsmStrPtr), &t, &i);
  return i;
}

#if defined(__STDC__) || defined(__cplusplus)
int
StrCat3 (char *str1, char *str2, char *str3)
#else
int
StrCat3 (str1, str2, str3)
char *str1;
char *str2;
char *str3;
#endif
{
  int t, i;

  obstack_strgrow(Csm_obstk, str1);
  obstack_strgrow(Csm_obstk, str2);
  CsmStrPtr = obstack_strcpy(Csm_obstk, str3);
  mkidn(CsmStrPtr, strlen(CsmStrPtr), &t, &i);
  return i;
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode
GenSymbol (Environment env)
#else
PTGNode
GenSymbol (env)
Environment env;
#endif
{
  int t, i, size;
  static int counter = 0;

  CsmStrPtr = (void *)0;
  size = (counter + 1) / 10 + 3;

  do {
    ++counter;
    if (CsmStrPtr && (counter % 10 == 0)) {
      obstack_free(Csm_obstk, CsmStrPtr);
      CsmStrPtr = (void *)0;
      ++size;
    }
    if (!CsmStrPtr)
      CsmStrPtr = obstack_alloc(Csm_obstk, size);
    CsmStrPtr[0] = 'G';
    sprintf(&CsmStrPtr[1], "%d", counter);
    mkidn(CsmStrPtr, strlen(CsmStrPtr), &t, &i);
  } while (KeyInEnv(env, i) != NoKey);

  DefineIdn(env, i);
  return PTGStr(StringTable(i));
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNodeList
MapPTG (PTGNode lhs, PTGNodeList alts, PTGNode (*func)(PTGNode, PTGNode))
#else
PTGNodeList
MapPTG (lhs, alts, func)
PTGNode lhs;
PTGNodeList alts;
PTGNode (*func)();
#endif
{
  if (alts == NULLPTGNodeList)
    return NULLPTGNodeList;
  else
    return ConsPTGNodeList(func(lhs, (PTGNode)HeadPTGNodeList(alts)),
                MapPTG(lhs, TailPTGNodeList(alts), func));
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNodeList
MergeLists (PTGNodeList list1, PTGNodeList list2)
#else
PTGNodeList
MergeLists (list1, list2)
PTGNodeList list1;
PTGNodeList list2;
#endif
{
  if (list1 == NULLPTGNodeList)
    return NULLPTGNodeList;
  else
    return AppPTGNodeList(MapPTG(HeadPTGNodeList(list1), list2, PTGSpcSeq),
                        MergeLists(TailPTGNodeList(list1), list2));
}
