<object name="element_list" default-lang="javascript">

  <!-- Create a few instances of various tags to make sure the modules
       load so we get proper documentation for them -->
  <window name="fake" visible="false">
    <vwrapalign/>
    <sdl-sprite/>
    <glarea/>
    <system-args/>
    <c-code/>
    <perl/>
    <tcl/>
    <python/>
    <javascript/>
  </window>
  
<!-- The main window -->
  <window name="main" width="700" height="600" ondelete="entity:exit"
   title="Supported Element List" border="5">
    <valign spacing="5" expand="true">

      <menubar>
        <menu label="Export">
	  <menuitem label="To HTML" onselect="open_export_to_html_filesel"/>
	</menu>
      </menubar>

      <scrollwindow expand="true" y-scrollbar-policy="always"> 
        <ctree expand="true" name="top" onselect="row_selected" 
         line-style="none" expander-style="none" spacing="0"> 
          <ctree-column title="Element" width="180"/>
          <ctree-column title="Description" width="400"/>
        </ctree> 
      </scrollwindow>

    </valign>
  </window>

  <window title="Supported Attributes" name="element_details" 
   width="900" height="400" dialog="true"
   ondelete="hide_window" border="5" visible="false">
    <valign spacing="5" expand="true">

      <halign>
        <label text="Description" width="100" xalign="0"/>
	<label name="description" text=""/>
      </halign>

      <scrollwindow expand="true" y-scrollbar-policy="always"> 
        <ctree name="details" expand="true" line-style="none" expander-style="none"
         spacing="0"> 
          <ctree-column title="Attribute" width="150"/>
          <ctree-column title="Description" width="500"/>
          <ctree-column title="Value Type" width="75"/>
          <ctree-column title="Possible Values" width="75"/>
        </ctree> 
      </scrollwindow>

      <button label="Close" onclick="hide_window" align="right"/>

    </valign>
  </window>

  <window name="generating_files" title="Generating Files..."
   border="8" position="center" dialog="true" visible="false" 
   ondelete="hide_window">
    <valign spacing="12" expand="true">
      <halign>
        <label name="filename" text="foo.html" expand="true"/>
      </halign>
      <progress name="generating" value="0"/>
    </valign>
  </window>
  
  <window name="generating_complete" dialog="true" position="center"
   border="11" title="File Generation Complete" visible="false"
   ondelete="hide_window">
    <valign expand="true" spacing="19">
      <halign>
        <label text="Generation of HTML documentation complete."
         expand="true"/>
      </halign>
      <halign>
        <button label="OK" width="80" expand="true" fill="false"
	 onclick="hide_window"/>
      </halign>
    </valign>
  </window>
  
  <window name="generating_error" dialog="true" position="center"
   border="8" title="Error!" visible="false" ondelete="hide_window">
    <valign expand="true" spacing="10">
      <halign>
        <label text="Error generating files!" expand="true"/>
      </halign>
      <halign>
        <label text="" expand="true" name="error_message"/>
      </halign>
      <halign>
        <button label="OK" width="80" expand="true" fill="false"
	 onclick="hide_window"/>
      </halign>
    </valign>
  </window>
  
  <filesel title="Save HTML to Directory.." visible="false" onselect="export_to_html"/>
  
  <norender/>
  <system-elements/>

<?javascript
 
supported = enode ("system-elements").list_set_attribs ();
supported.sort ();

ctree = enode ("ctree.top");
ctree.attrib.frozen = "true";

for (element in supported) {
    
    // The only erroneously set attribute will be the nodes name.
    if (element == "name")
	continue;
    row = ctree.new_child ("ctree-row");
    row.attrib.element = element;
    cell = row.new_child ("ctree-cell");
    cell.attrib.text = element;
   
    node = enode ("norender").new_child (element);
    cell = row.new_child ("ctree-cell");
    cell.attrib.text = node.description;
    node.destroy ();
}

ctree.attrib.frozen = "false";

function attribute_descriptions (node, attribute)
{
    ret = new Object;
    
    // Description
    try {
	description = node.attrib_description (attrib);
    } catch (e) {
	description = "";
    }
    ret.description = description;
    
    // Value Type
    try {
	value_type = node.attrib_value_type (attrib);
    } catch (e) {
	value_type = "";
    }
    ret.value_type = value_type;

    // value description
    try {
	value_desc = node.attrib_possible_values (attrib);
    } catch (e) {
	value_desc = "";
    }
    ret.value_desc = value_desc;

    return (ret);
}
    
    
    
function row_selected (ctree, ctree_row)
{
    element = ctree_row.attrib.element;
    enode ("window.element_details").attrib.title = element;
    
    ctree = enode ("ctree.details");
    ctree.attrib.frozen="true";
    
    children = ctree.children ("ctree-row");

    try {
        for (child in children) {
            child.destroy ();
        }
    } catch (e) {}


    node = enode ("norender").new_child (element);
   
    enode ("label.description").attrib.text = node.description;
    
    try {
	attributes = node.supported_attribs ();
	attributes.sort ();
	
	for (attrib in attributes) {
	    row = ctree.new_child ("ctree-row");
	    
	    cell = row.new_child ("ctree-cell");
	    cell.attrib.text = attrib;

	    info = attribute_descriptions (node, attrib);

	    cell = row.new_child ("ctree-cell");
	    cell.attrib.text = info.description;

	    cell = row.new_child ("ctree-cell");
	    cell.attrib.text = info.value_type;

	    cell = row.new_child ("ctree-cell");
	    cell.attrib.text = info.value_desc;
	}
    } catch (e) {}
    
    ctree.attrib.frozen="false"
    
    node.destroy ();
    enode ("window.element_details").attrib.visible = "true";
}

function open_export_to_html_filesel (menuitem)
{
    enode ("filesel").attrib.visible = "true";
}

function export_to_html (filesel, output_dir)
{
    f = new File (output_dir);
    info = f.stat (output_dir);
    if (!(info[2] & 0040000)) {

	enode ("label.error_message").attrib.text = "Selected file is not a directory!";
	enode ("window.generating_error").attrib.visible = "true";
	return;
    }
    f.close ();

    index = new File (output_dir + "/index.html");
    if (!index.open ("w")) {
	enode ("label.error_message").attrib.text = "Error opening index.html for writing: " + 
	    System.strerror (System.errno);
	enode ("window.generating_error").attrib.visible = "true";
	return;
    }
  
    index.write ("<html><body><table>\n");

    supported = enode ("system-elements").list_set_attribs ();
    supported.sort ();

    enode ("window.generating_files").attrib.visible = "true";
    num_elements = supported.length;
    current_element = 0;
    
    for (element in supported) {
	// The only erroneously set attribute will be the nodes name.
	if (element == "name")
	    continue;

	node = enode ("norender").new_child (element);
	
	index.write ('<tr><td><a href="' + element + '.html">' + element + '</a></td><td>' +
		     node.description + '</td></tr>\n');

	f = new File (output_dir + "/" + element + ".html");
	if (!f.open ("w")) {
	    enode ("label.error_message").attrib.text = "Error opening " + element + ".html for writing: " + 
		System.strerror (System.errno);
	    enode ("window.generating_error").attrib.visible = "true";
	    enode ("window.generating_files").attrib.visible = "false";
	    return;
	}

	enode ("label.filename").attrib.text = element + ".html";

	f.write ('<html><body><table width="100%" border="3"><tr><td bgcolor="#a0a0ff">Tag: <b>' +
		 element + '</b></td><td colspan="3">' + node.description + '</td></tr> <tr><td></td></tr>\n');
	f.write ('<tr><td bgcolor="#d0d0ff">Attrib Name</td>\n');
	f.write ('<td bgcolor="#d0d0ff">Type</td>\n');
	f.write ('<td bgcolor="#d0d0ff">Possible Values</td>\n');
	f.write ('<td bgcolor="#d0d0ff">Description</td></tr>\n');

	try {
	    attributes = node.supported_attribs ();
	    attributes.sort ();

	    for (attrib in attributes) {
		info = attribute_descriptions (node, attrib);
		f.write ('<tr><td bgcolor="#bbffaa">' + attrib + '</td>\n');
		f.write ('<td bgcolor="#ffddaa">' + info.value_type + '</td>\n');
		f.write ('<td bgcolor="#dddddd">' + info.value_desc + '</td>\n');
		f.write ('<td bgcolor="#88ddff">' + info.description + '</td></tr>\n');
	    }
	} catch (e) {}

	f.write ('</table></body></html>\n\n');

	f.close ();
	node.destroy ();

	enode ("progress.generating").attrib.value = current_element / num_elements * 100;
	current_element++;
    }
   
    index.write ('</table></body></html>\n');
    index.close (); 
    enode ("window.generating_files").attrib.visible = "false";
    enode ("window.generating_complete").attrib.visible = "true";
}


function hide_window (node)
{
    if (node.type == "window") {
        node.attrib.visible = "false";
    } else {
	window = node.parent ("window");
	window.attrib.visible = "false";
    }
}

?>

</object>
