#!/usr/bin/env entity
<!-- #!/usr/local/bin/entity -->

<object default-lang="python">
  <window ondelete="entity:quit">
    <button name="enode_test"
	    label="Basic ENode Object Test"
	    onclick="enode_test"/>
    <button name="newchild_test"
	    label="Create New Child Test"
	    onclick="newchild_test"/>
    <button name="call_test"
	    label="Call function test"
	    onclick="call_test"/>
    <button name="search_test" 
	    label="Node Search functions Test" 
	    onclick="search_funcs"/>
    <button name="xml_test"
            label="XML function test"
	    onclick="xml_test"/>
  </window>

<?python
import sys, traceback, pprint
def enode_test(node, myval=[0]):
	print "\n\n\n**************************************"

	try:
		print "    I was passed this node:"
		print node
	except:
		print "BUG - this should not trigger an exception."
		type, val, tb =  sys.exc_info()
		traceback.print_exception(type, val, tb)
		
	try:
		foo = enode(53, "meow")
		print "BUG - this line should be skipped."
	except:
		print "GOOD - this should print"
		type, val, tb =  sys.exc_info()
		traceback.print_exception(type, val, tb)

	try:
		foo = enode(53)
		print "BUG - this should be skipped."
	except:
		print "GOOD - this should print"
		type, val, tb =  sys.exc_info()
		traceback.print_exception(type, val, tb)



	
	try:
		label = enode("button.enode_test")
		label.attrib({"label": "Attribute Test (%d)" % myval[0]})
		myval[0] = myval[0] + 1
		print "GOOD All went OK, as far as i can tell."
	except:
		print "BUG something borked in the attribute set/get test."


	try:
		bork = enode("fake.node")
		print "BUG - the previous line should have trapped to an exception."
	except:
		print "GOOD - expected exception was raised."
		type, val, tb =  sys.exc_info()
		traceback.print_exception(type, val, tb)


	try:
		print "    value of this node's 'label' attribute:"
		print  node["label"]
		print "   prefixing that with 'foo':"
		node["label"] = "foo"+node["label"]
		print node["label"]
		print "GOOD - all went OK, as fas as i can tell."
		print "* insure that the buttons title is now: 'fooAttribute Test (%d)'" % myval[0]
	except:
		print "BUG - Got exception while fooling with indexing:"
		type, val, tb =  sys.exc_info()
		traceback.print_exception(type, val, tb)


	print "next line should be an empty string:"	
	print node["this-is-fake"]
	

	try:
		print "type:"
		print node.type()
		print "path:"
		print node.path()
		print "basename:"
		print node.basename()	
		print "description:"
		print node.description()
		print "GOOD - all went ok, as far as i can tell."
		print "* insure that the values above are reasonable."
	except:
		print "BUG - Got exception while doing basic functions:"
		type, val, tb =  sys.exc_info()
		traceback.print_exception(type, val, tb)


	try:
		othernode = enode("button.search_test")
		if (node == othernode):
			print "BUG They compare the same"
		else:
			print "GOOD They compare differently"
	except:
		print "BUG: Somehow, an exception occurred while testing a failing compare."
		type, val, tb =  sys.exc_info()
		traceback.print_exception(type, val, tb)

	try:
		othernode = enode("button.enode_test")
		if (node == othernode):
			print "GOOD They compare the same"
		else:
			print "BUG They compare differently"
	except:
		print "Somehow, an exception occurred while testing a passing match."
		type, val, tb =  sys.exc_info()
		traceback.print_exception(type, val, tb)


def newchild_test(node):
	print "\n***** I will now add a new button to this windows:"
	parent = node.parent()
	parent.new_child("button.foo", {"label":"Test"})
	
	


def search_funcs(node):
	print "\n******** tree functions testing !"

	print "this node is:"
	print node
	print

	print "this node's parent is:"
	print node.parent()
	print

	print "(from now on, we'll use that node to work from.)"
	node = node.parent()
	print node
	print

	print "node's children:"
	print node.children()
	print

	print "regexp'd child finder with exp '.*se.*'"
	print node.children_rx(".*se.*")
	print

	print "result of enode.child('button'):"
	print node.child('button')
	print "result of enode.child('button.search_test'):"
	print node.child('button.search_test')
	print

	print "result of enode.child_rx('.*se.*')"
	print node.child_rx('.*se.*')
	print

	
def xml_test(node):
	print "\n\n--**-- XML of this object:"
	node = node.parent("object")
	print node.get_xml()
	

	print "\n\n--**-- : appending this:"
	object = '<label text="This is appended!"/>'
	print object
	print "-- to xml.."

	node.append_xml(object)

	print "\n\n--**-- XML of this object:"
	print node.get_xml()

def call_test_target(node, str):
	print "*** CALL_TEST_TARGET:"
	print "args are:"
	#pprint.pprint(args)
	print "args are node", node, "string ", str

def call_test(node):
	try:
		node.call("call_test_target","s","test")
	except:
		print "call failed."

?>

</object>
