/*
 * Copyright (C) 2002  Bogdan Surdu (tim@rdsnet.ro)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Revision: 1.6 $
 *
 * $Log: flow_storage.c,v $
 * Revision 1.6  2003/06/19 17:11:20  tim
 * new memory management
 * removed the fragment list
 *
 * Revision 1.5  2003/03/20 20:27:44  tim
 * modified a bit the memory allocation
 *
 * Revision 1.4  2003/03/07 18:56:02  tim
 * *** empty log message ***
 *
 * Revision 1.3  2002/12/13 19:37:39  tim
 * lookup hash function changed
 *
 * Revision 1.2  2002/11/26 09:28:14  tim
 * row level mutex locking
 * cleanup in flow_scan
 *
 * Revision 1.1  2002/11/24 23:13:38  tim
 * Initial revision
 *
 *
 */

#include <stdio.h>
#include <pthread.h>
#include "flow_storage.h"
#include "fprobe.h"


extern pthread_mutex_t mutex_scan[HASH_SLOTS];
extern pthread_mutex_t memory_mutex;
unsigned long active_flows = 0;

void flow_init_item(struct flow_item_t *flow) {

  flow->flow_start = 0;
  flow->last_packet = 0;
  flow->bytes = 0;
  flow->packets = 0;
}

struct flow_item_t *flow_hash_lookup(HASH_TABLE t,unsigned int src_ip, unsigned int dst_ip, unsigned char proto, unsigned short sport, unsigned short dport, unsigned int key) {
  unsigned int slot;
  struct flow_item_t *new_item, *flow;
  struct hash_slot *h;
  char buffer[13];
  int res;

  memcpy(buffer, &src_ip, 4);
  memcpy(buffer+4, &dst_ip, 4);
  memcpy(buffer+8, &key, 4);
  memcpy(buffer+12, &proto, 1);
   
  slot = hash(buffer, 12, 0xa34be5) & (HASH_SLOTS-1);
  res = pthread_mutex_lock(&mutex_scan[slot]);
  if (res) {
    perror("pthread_mutex_lock in flow_storage\n");
    pthread_exit(NULL);
  }

  h = &t[slot]; 
  flow = h->list;
  while(flow) {
    /* TODO match using memcmp */
    //if (flow->src_ip == src_ip && flow->dst_ip == dst_ip 
    //  && flow->proto == proto && flow->key  == key) {
    if (!memcmp(flow, buffer, 13)) {

      /* pthread_mutex_unlock(&mutex_scan[slot]); */
      return flow;
    }
    flow = flow->next;
  } 


  /* create a new entry */
  if (flow == NULL) {
#ifdef DEBUG
    fprintf(stderr,"[%s:%d] Creating new flow entry\n",__FILE__,__LINE__);
#endif
    new_item = (flow_item_t *) flow_get_new();
    if (new_item == NULL) {
       pthread_mutex_unlock(&mutex_scan[slot]);
       return NULL;
    }
    
    flow_init_item(new_item);
    new_item->src_ip = src_ip;
    new_item->dst_ip = dst_ip;
    new_item->proto = proto;
    new_item->sport = sport;
    new_item->dport = dport;
    new_item->key = key;

    new_item->slot = slot;
    flow_status[new_item->particle_id] = FLOW_STATUS_USED;
    new_item->next = h->list;
    h->list = new_item;

    /* pthread_mutex_unlock(&mutex_scan[slot]); */

    return new_item;
  }
  pthread_mutex_unlock(&mutex_scan[slot]);
  return NULL;
}

struct flow_item_t *flow_get_new() {
  struct flow_item_t *flow;
  long i, free;

  pthread_mutex_lock(&memory_mutex);
  flow = flow_pool;
  if (flow) {
    flow_pool = flow->next;
    active_flows++;    
  } else {
    fprintf(stderr,"No free flows in pool. Active: %lu\n", active_flows);
    free = 0;
    for(i=0;i<FLOW_ITEMS;i++) {
      if (flow_status[i] == FLOW_STATUS_FREE) free++;
    }
    if (free) {
      printf("Strange, I found %lu free flows\n", free);
    }
  }
  //printf("\rActive %-10lu", active_flows);
  pthread_mutex_unlock(&memory_mutex);
  return flow;
}

/*
  return the memory to the available pool
 */
void flow_add_pool(struct flow_item_t *new) {
  pthread_mutex_lock(&memory_mutex);
  new->next = flow_pool;
  flow_status[new->particle_id] = FLOW_STATUS_FREE;
  flow_pool = new;
  active_flows--;
  pthread_mutex_unlock(&memory_mutex);
}

void reset_active_counter() {
  active_flows = 0;
}
