//
// $Source: /cvsroot/gambit/gambit/sources/base/gsignal.h,v $
// $Date: 2002/08/26 05:49:59 $
// $Revision: 1.3 $
//
// DESCRIPTION:
// Declaration of abstract signal-handling class
//
// This file is part of Gambit
// Copyright (c) 2002, The Gambit Project
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#ifndef GSIGNAL_H
#define GSIGNAL_H

#include "base/base.h"

class gSignalBreak : public gException {
 public:
  gText Description(void) const { return "User interrupt occurred."; }
};

class gSignal   {
  public:
    virtual ~gSignal()  { }
    virtual void Get(void) const = 0;
    virtual void Reset(void) = 0;
};

extern gSignal &gbreak;

#endif   // GSIGNAL_H
