/* gnome-python - python bindings for gnome-libs
 * Copyright (C) 1998-1999 James Henstridge <james@daa.com.au>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <Python.h>
#include <sys/types.h>
#include <zvt/zvtterm.h>

#include "../pygtk/pygtk.h"

static PyObject *_hack_zvt_term_set_color_scheme(PyObject *self, PyObject *args) {
  PyObject *term, *colours, *item, *color;
  gushort red[18], grn[18], blu[18];
  int i, j;
  long c;

  if (!PyArg_ParseTuple(args, "O!O!:zvt_term_set_color_scheme", &PyGtk_Type,
			&term, &PyList_Type, &colours))
    return NULL;
  if (PyList_Size(colours) < 18) {
    PyErr_SetString(PyExc_TypeError, "list must be 18 elements long");
    return NULL;
  }
  for (i = 0; i < 18; i++) {
    item = PyList_GetItem(colours, i);
    if (PyTuple_Size(item) != 3) {
      PyErr_Clear();
      PyErr_SetString(PyExc_TypeError, "color tuple must be 3 elements long");
      return NULL;
    }
    for (j = 0; j < 3; j++) {
      color = PyTuple_GetItem(item, j);
      c = PyInt_AsLong(color);
      switch (j) {
      case 0:
	red[i] = (gushort) c;
	break;
      case 1:
	grn[i] = (gushort) c;
	break;
      case 2:
	blu[i] = (gushort) c;
	break;
      }
    }
  }
  zvt_term_set_color_scheme(ZVT_TERM(PyGtk_Get(term)), red, grn, blu);
  Py_INCREF(Py_None);
  return Py_None;
}

static PyMethodDef zvtMethods[] = {
    { "set_color_scheme", _hack_zvt_term_set_color_scheme, 1 },
    { NULL, NULL, 0 }
};

void init_zvt_color() {
    PyObject *m, *d;

    m = Py_InitModule("_zvt_color", zvtMethods);

    init_pygtk();

    if (PyErr_Occurred())
        Py_FatalError("can't initialise module _zvt");
}

