/**
 ** preferences.c - preference dialog box
 **
 ** Copyright (C) 2000 Matthew Pratt <mattpratt@yahoo.com>
 **
 ** This software is licensed under the terms of the GNU General 
 ** Public License (GPL). Please see the file LICENSE for details.
 **
 **/

#include "gnomp3.h"
#include "utility.h"
#include "preferences.h"
#include "settings.h"
#include "all_list.h"
#include "mp3_control.h"

#define CP_SET(w) gnome_color_picker_set_i16( GNOME_COLOR_PICKER(prefs.w), gnomp3.w.red, gnomp3.w.green, gnomp3.w.blue, 0)

#define CP_GET(w) gnome_color_picker_get_i16( GNOME_COLOR_PICKER(prefs.w), &gnomp3.w.red, &gnomp3.w.green, &gnomp3.w.blue, NULL)

prefs_t prefs;

void preferences_initialise()
{
    gtk_entry_set_text( GTK_ENTRY(prefs.playlist_dir_entry), gnomp3.playlist_dir);
    gtk_entry_set_text( GTK_ENTRY(prefs.song_file_entry), gnomp3.song_list_file);
    gtk_entry_set_text( GTK_ENTRY(prefs.find_dir_entry), gnomp3.song_search_path);
    gtk_entry_set_text( GTK_ENTRY(prefs.add_song_dir_entry), gnomp3.add_song_dir);

    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON (prefs.song_find_button),
				  gnomp3.song_search );
    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON (prefs.use_id3_check),
				  gnomp3.use_id3 );
    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON (prefs.xmms_button),
				  gnomp3.use_xmms );
    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON (prefs.tight_button),
				  gnomp3.tight_xmms );

    gtk_spin_button_set_value( GTK_SPIN_BUTTON(prefs.random_spin), 
			       gnomp3.random_list_size);

    CP_SET(playing_fg_color);
    CP_SET(playing_bg_color);
    CP_SET(played_fg_color);
    CP_SET(played_bg_color);
    CP_SET(in_playlist_fg_color);
    CP_SET(in_playlist_bg_color);
}

void preferences_load_dialog()
{
    GladeXML *xml;
    
    /* load the main_window decsription */
    xml = glade_xml_new( gnomp3.glade_file, "gnomp3_preferences");
    /* in case we can't load the interface, bail */
    if(!xml) {
	g_warning("We could not load the main_window interface!");
	return;
    }
    
    gnomp3.gnomp3_preferences = glade_xml_get_widget(xml, "gnomp3_preferences");
    
    STORE_PREFS_WIDGET(playlist_dir_entry);
    STORE_PREFS_WIDGET(song_file_entry);
    STORE_PREFS_WIDGET(find_dir_entry);
    STORE_PREFS_WIDGET(song_find_button);
    STORE_PREFS_WIDGET(add_song_dir_entry);
    STORE_PREFS_WIDGET(use_id3_check);
    STORE_PREFS_WIDGET(tight_button);
    STORE_PREFS_WIDGET(xmms_button);
    STORE_PREFS_WIDGET(random_spin);

    STORE_PREFS_WIDGET(playing_fg_color);
    STORE_PREFS_WIDGET(playing_bg_color);
    STORE_PREFS_WIDGET(played_fg_color);
    STORE_PREFS_WIDGET(played_bg_color);
    STORE_PREFS_WIDGET(in_playlist_fg_color);
    STORE_PREFS_WIDGET(in_playlist_bg_color);
    
    preferences_initialise();

    /* autoconnect any signals */
    glade_xml_signal_autoconnect(xml);
    
    /* we don't need the GladeXML object any more, so unref it
       to save some memory */
    gtk_object_unref(GTK_OBJECT(xml));
}

void preferences_changed()
{
    gnome_property_box_changed (GNOME_PROPERTY_BOX(gnomp3.gnomp3_preferences));
}

void preferences_lists_need_reload()
{
    prefs.lists_need_reload = TRUE;
}

void preferences_apply(GnomePropertyBox *box, int page_num, gpointer data)
{
    strncpy( gnomp3.playlist_dir, gtk_entry_get_text(GTK_ENTRY(prefs.playlist_dir_entry)),
	     MAX_PATH);
    strncpy( gnomp3.song_list_file, gtk_entry_get_text(GTK_ENTRY(prefs.song_file_entry)),
	     MAX_PATH);
    strncpy( gnomp3.song_search_path, gtk_entry_get_text(GTK_ENTRY(prefs.find_dir_entry)),
	     MAX_PATH );
    strncpy( gnomp3.add_song_dir, gtk_entry_get_text(GTK_ENTRY(prefs.add_song_dir_entry)),
	     MAX_PATH );

    gnomp3.song_search = GTK_TOGGLE_BUTTON (prefs.song_find_button)->active;
    gnomp3.use_id3 = GTK_TOGGLE_BUTTON (prefs.use_id3_check)->active;
    if(gnomp3.use_xmms != GTK_TOGGLE_BUTTON (prefs.xmms_button)->active){
	mp3_control_stop();
	gnomp3.use_xmms = GTK_TOGGLE_BUTTON (prefs.xmms_button)->active;
    }
    gnomp3.tight_xmms = GTK_TOGGLE_BUTTON (prefs.tight_button)->active;

    gnomp3.random_list_size = gtk_spin_button_get_value_as_int( GTK_SPIN_BUTTON(prefs.random_spin));

    if(  prefs.lists_need_reload ){
	mp3list_reload();
	prefs.lists_need_reload = FALSE;
    }

    CP_GET(playing_fg_color);
    CP_GET(playing_bg_color);
    CP_GET(played_fg_color);
    CP_GET(played_bg_color);
    CP_GET(in_playlist_fg_color);
    CP_GET(in_playlist_bg_color);

    config_save();
}


