<?php
// File           english.inc.php / ibWebAdmin
// Purpose        english strings definitions
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003, 2004 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <02/07/12 21:10:03 lb>       
//
// $Id: english.inc.php,v 1.29 2004/05/20 10:21:26 lbrueckner Exp $

// strings used for the tabfolder menu
$menu_strings = array('Database'    => 'Database',   
                      'Tables'      => 'Tables',     
                      'Accessories' => 'Accessories',
                      'SQL'         => 'SQL',
                      'Data'        => 'Data',       
                      'Users'       => 'Users',      
                      'Admin'       => 'Admin'       
                      );

// the coordinates for the image area used by the tabfolder menu
$menu_coords = array('Database'   => '8,0,89,31',
                     'Tables'     => '91,0,152,31',
                     'Accessories'=> '154,0,256,31',
                     'SQL'        => '258,0,297,31',
                     'Data'       => '299,0,344,31',
                     'Users'      => '346,0,389,31',
                     'Admin'      => '391,0,448,31',
                     );

// strings used as panel titles
$ptitle_strings = array('info'        => 'Info', 
                        'db_login'    => 'Login to Database',  
                        'db_create'   => 'Create Database',
                        'db_delete'   => 'Delete Database',    
                        'db_systable' => 'System Tables',      
                        'db_meta'     => 'Metadata',      
                        'tb_show'     => 'View Tables',
                        'tb_create'   => 'Create New Table',   
                        'tb_modify'   => 'Modify Table',
                        'tb_delete'   => 'Delete Table',       
                        'acc_index'   => 'Indexes',        
                        'acc_gen'     => 'Generators',
                        'acc_trigger' => 'Triggers',          
                        'acc_proc'    => 'Stored Procedures',          
                        'acc_domain'  => 'Domains',
                        'acc_view'    => 'Views',
                        'acc_udf'     => 'User Defined Functions',
                        'acc_exc'     => 'Exceptions',
                        'sql_enter'   => 'Enter Command or Script',
                        'sql_output'  => 'Show Output', 
                        'tb_watch'    => 'Watch Table',
                        'dt_enter'    => 'Enter Data',
                        'dt_csv'      => 'CSV Import/Export',
                        'usr_user'    => 'Users',              
                        'usr_role'    => 'Roles',              
                        'usr_grant'   => 'Grants',
                        'usr_cust'    => 'Customizing',
                        'adm_server'  => 'Server Statistics', 
                        'adm_dbstat'  => 'Database Statistics',
                        'adm_gfix'    => 'Database Maintenance',
                        'adm_backup'  => 'Backup',
                        'adm_restore' => 'Restore',
                        'Open'        => 'open',
                        'Close'       => 'close',
                        'Up'          => 'up',
                        'Top'         => 'top',
                        'Bottom'      => 'bottom',
                        'Down'        => 'down'
                        );

// strings to inscribe buttons
$button_strings = array('Login'    => 'Login',
                        'Logout'   => 'Logout',
                        'Create'   => 'Create',
                        'Delete'   => 'Delete',
                        'Select'   => 'Select',
                        'Save'     => 'Save',
                        'Reset'    => 'Reset',
                        'Cancel'   => 'Cancel',
                        'Add'      => 'Add',
                        'Modify'   => 'Modify',
                        'Ready'    => 'Ready',
                        'Yes'      => 'Yes',
                        'No'       => 'No',
                        'DoQuery'  => 'Perform Query',
                        'QueryPlan'=> 'Query Plan',
                        'Go'       => 'Go',
                        'DisplAll' => 'Display All',
                        'Insert'   => 'Insert',
                        'Export'   => 'Export',
                        'Import'   => 'Import',
                        'Remove'   => 'Remove',
                        'Drop'     => 'Drop',
                        'Set'      => 'Set',
                        'Clear'    => 'Clear',
                        'SweepNow' => 'Sweep Now',
                        'Execute'  => 'Execute',
                        'Backup'   => 'Backup',
                        'Restore'  => 'Restore',
                        'Reload'   => 'Reload',
                        'OpenAll'  => 'Open All',
                        'CloseAll' => 'Close All',
                        'Defaults' => 'Set Defaults',
                        'Load'     => 'Load'
                        );

// strings on the database page
$db_strings = array('Database' => 'Database',
                    'Host'     => 'Host',
                    'Username' => 'Username',
                    'Password' => 'Password',
                    'Role'     => 'Role',
                    'Cache'    => 'Cache',
                    'Charset'  => 'Character Set',
                    'Dialect'  => 'Dialect',
                    'Server'   => 'Server',
                    'NewDB'    => 'New Database',
                    'PageSize' => 'Page Size',
                    'DelDB'    => 'Delete Database',
                    'SysTables'=> 'System Tables',
                    'SysData'  => 'System Data',
                    'FField'   => 'Filter Field',
                    'FValue'   => 'Filter Value',
                    'Refresh'  => 'Refresh',
                    'Seconds'  => 'Seconds'
                    );

// strings on the table page
$tb_strings = array('Name'      => 'Name',
                    'Type'      => 'Type',
                    'Length'    => 'Length',
                    'Prec'      => 'Precision',
                    'PrecShort' => 'Prec',
                    'Scale'     => 'Scale',
                    'Charset'   => 'Char Set',
                    'Collate'   => 'Collate',
                    'Collation' => 'Collation',
                    'NotNull'   => 'Not Null',
                    'Unique'    => 'Unique',
                    'Computed'  => 'Computed',
                    'Default'   => 'Default',
                    'Primary'   => 'Primary',
                    'Foreign'   => 'Foreign',
                    'TbName'    => 'Table Name',
                    'Fields'    => 'Fields',
                    'DefColumn' => 'Definitions for Column',
                    'SelTbMod'  => 'Select table to modify',
                    'DefNewCol' => 'Definitions for New Column',
                    'NewColPos' => 'New Column Position',
                    'SelColDel' => 'Select column to delete',
                    'SelColMod' => 'Select column to modify',
                    'AddCol'    => 'Add column',
                    'SelTbDel'  => 'Select table to delete',
                    'Datatype'  => 'Datatype',
                    'Size'      => 'Size',
                    'Subtype'   => 'Subtype',
                    'SegSiShort'=> 'SegSize',
                    'Domain'    => 'Domain',
                    'CompBy'    => 'Computed by',
                    'Table'     => 'table',
                    'Column'    => 'column',
                    'Source'    => 'Source',
                    'Check'     => 'Check',
                    'Yes'       => 'Yes',
                    'DispCounts'=> 'display record counts',
                    'DropPK'    => 'Drop Primary Key',
                    'DropFK'    => 'Drop Foreign Key',
                    'DropUq'    => 'Drop Unique Constraint',
                    'FKName'    => 'Foreign Key Name',
                    'OnUpdate'  => 'On Update',
                    'OnDelete'  => 'On Delete',
                    'Table1'    => 'Table',
                    'Column1'   => 'Column'
                    );

// strings on the accessories page
$acc_strings = array('CreateIdx' => 'Create New Index',
                     'ModIdx'    => 'Modify Index %s',
                     'Name'      => 'Name',
                     'Active'    => 'Active',
                     'Unique'    => 'Unique',
                     'Sort'      => 'Sort',
                     'Table'     => 'Table',
                     'Columns'   => 'Columns',
                     'SelIdxMod' => 'Select index to modify',
                     'SelIdxDel' => 'Select index to delete',
                     'ColExpl'   => 'Column(s), comma seperated',
                     'Value'     => 'Value',
                     'SetValue'  => 'Set Value',
                     'DropGen'   => 'Drop Generator',
                     'CreateGen' => 'Create New Generator',
                     'StartVal'  => 'Startvalue',
                     'CreateTrig'=> 'Create new trigger',
                     'SelTrigMod'=> 'Select trigger to modify',
                     'SelTrigDel'=> 'Select trigger to delete',
                     'Type'      => 'Type',
                     'Pos'       => 'Pos',
                     'Position'  => 'Position',
                     'Status'    => 'Status',
                     'Source'    => 'Source',
                     'ModTrig'   => 'Modify Trigger %s',
                     'CreateDom' => 'Create New Domain',
                     'SelDomDel' => 'Select domain to delete',
                     'SelDomMod' => 'Select domain to modify',
                     'Size'      => 'Size',
                     'Charset'   => 'Charset',
                     'Collate'   => 'Collate',
                     'PrecShort' => 'Prec',
                     'Scale'     => 'Scale',
                     'Subtype'   => 'Subtype',
                     'SegSiShort'=> 'Segsize',
                     'ModDomain' => 'Modify Domain %s',
                     'Generator' => 'generator',
                     'Index'     => 'index',
                     'Trigger'   => 'trigger',
                     'Domain'    => 'domain',
                     'CreateProc'=> 'Create New Procedure',
                     'ModProc'   => 'Modify Procedure %s',
                     'SelProcMod'=> 'Select procedure to modify',
                     'SelProcDel'=> 'Select procedure to delete',
                     'SP'        => 'stored procedure',
                     'Param'     => 'Parameters',
                     'Return'    => 'Return',
                     'CreateView'=> 'Create New View',
                     'SelViewDel'=> 'Select view to delete',
                     'SelViewMod'=> 'Select view to modify',
                     'CheckOpt'  => 'with check option',
                     'ModView'   => 'Modify View %s',
                     'Yes'       => 'Yes',
                     'No'        => 'No',
                     'Module'    => 'Module',
                     'EPoint'    => 'Entrypoint',
                     'IParams'   => 'Input Parameters',
                     'Returns'   => 'Returns',
                     'UDF'       => 'user defined function',
                     'SelUdfDel' => 'Select function to delete',
                     'Exception' => 'Exception',
                     'Message'   => 'Message',
                     'SelExcDel' => 'Select exception to delete',
                     'CreateExc' => 'Create new exception',
                     'SelExcMod' => 'Select exception to modify',
                     'ModExc'    => 'Modify exception %s'
                     );

// strings on the sql page incl. the watch table panel
$sql_strings = array('DisplBuf' => 'displaying result from buffer',
                     'SelTable' => 'Select Table',
                     'Config'   => 'Config',
                     'Column'   => 'Column',
                     'Show'     => 'Show',
                     'Sort'     => 'Sort',
                     'BlobLink' => 'Blob as Link',
                     'BlobType' => 'Blob Type',
                     'Rows'     => 'Rows',
                     'Start'    => 'Start',
                     'Dir'      => 'Direction',
                     'ELinks'   => 'Edit Links',
                     'DLinks'   => 'Delete Links',
                     'Asc'      => 'Ascending',
                     'Desc'     => 'Descending',
                     'Restrict' => 'Condition to restrict the result, e.g. FIELDNAME>=1000',
                     'Prev'     => 'Prev',
                     'Next'     => 'Next',
                     'End'      => 'End',
                     'Total'    => 'total',
                     'Edit'     => 'edit',
                     'Delete'   => 'delete',
                     'Yes'      => 'Yes',
                     'No'       => 'No',
                     'TBInline' => 'Text Blobs Inline',
                     'TBChars'  => 'Text Blob Characters'
                     );

// strings on the data page
$dt_strings = array('SelTable' => 'Select Table',
                    'Table'    => 'Table',
                    'EditFrom' => '%1$sEdit from table %2$s',
                    'FileName' => 'File Name',
                    'EntName'  => 'Enter Name',
                    'FileForm' => 'File Format',
                    'ConvEmpty'=> 'on import convert empty values to NULL',
                    'CsvForm1' => 'all values are enclosed by quotation marks (") and separated by commas',
                    'CsvForm2' => 'quotation marks within values are doubled',
                    'CsvForm3' => 'data sets are separated by newlines (0x0a)',

                    );

// strings on the user page
$usr_strings = array('CreateUsr' => 'Create New User',
                     'ModUser'   => 'Modify User %s',
                     'UName'     => 'Username',
                     'FName'     => 'Firstname',
                     'MName'     => 'Middlename',
                     'LName'     => 'Lastname',
                     'UserID'    => 'User ID',
                     'GroupID'   => 'Group ID',
                     'SysdbaPW'  => 'SYSDBA password',
                     'Required'  => 'required for create, modify and delete',
                     'USelMod'   => 'Select user to modify',
                     'USelDel'   => 'Select user to delete',
                     'Password'  => 'Password',
                     'RepeatPW'  => 'Password Again',
                     'Name'      => 'Name',
                     'Owner'     => 'Owner',
                     'Members'   => 'Members',
                     'Role'      => 'Role',
                     'User'      => 'User',
                     'CreateRole'=> 'Create new role',
                     'RoleSelDel'=> 'Select role to delete',
                     'RoleAdd'   => 'Add to role',
                     'RoleRem'   => 'Remove from role',
                     'ColSet'    => 'Color Settings',
                     'CBg'       => 'Background',
                     'CPanel'    => 'Panel Frame',
                     'CArea'     => 'Panel Background',
                     'CHeadline' => 'Headline Background',
                     'CMenubrd'  => 'Menuborder',
                     'CLink'     => 'Links',
                     'CHover'    => 'Links while Mouseover',
                     'CSelRow'   => 'Selected Rows',
                     'CSelInput' => 'Selected Input Fields',
                     'CFirstRow' => 'Odd Table Rows',
                     'CSecRow'   => 'Even Table Rows',
                     'Appearance'=> 'Appearance',
                     'Language'  => 'Language',
                     'Fontsize'  => 'Fontsize in Points',
                     'TACols'    => 'Textarea Columns',
                     'TARows'    => 'Textarea Rows',
                     'Attitude'  => 'Attitude',
                     'AskDel'    => 'Confirm deletion of objects and data',
                     'Yes'       => 'Yes',
                     'No'        => 'No'
                    );

// strings on the admin page
$adm_strings = array('SysdbaPW'  => 'SYSDBA password',
                     'Required'  => 'required if you are not the database owner',
                     'Sweeping'  => 'Sweeping',
                     'SetInterv' => 'Set sweep threshold (number transactions)',
                     'DBDialect' => 'DB Dialect',
                     'Buffers'   => 'Cache Buffers',
                     'AccessMode'=> 'Access Mode',
                     'WriteMode' => 'Write Mode',
                     'ReadWrite' => 'read/write',
                     'ReadOnly'  => 'read only',
                     'Sync'      => 'synchronous',
                     'Async'     => 'asynchronous',
                     'DataRepair'=> 'Data Repair',
                     'Validate'  => 'Validate',
                     'Full'      => 'Full',
                     'Mend'      => 'Mend',
                     'NoUpdate'  => 'No Update',
                     'IgnoreChk' => 'Ignore Checksum Errors',
                     'Transact'  => 'Transactions',
                     'Shutdown'  => 'Shutdown',
                     'Commit'    => 'Commit',
                     'Rollback'  => 'Rollback',
                     'TwoPhase'  => 'Two Phase Recovery',
                     'AllLimbo'  => 'all limbo transactions',
                     'NoConns'   => 'No New Connections',
                     'NoTrans'   => 'No New Transactions',
                     'Force'     => 'Force',
                     'ForSeconds'=> 'for/after %s seconds',
                     'Reconnect' => 'Reconnect ibWebAdmin after the shutdown',
                     'PConnect'  => 'You have configured PERSISTENT_CONNECTION=TRUE, this can cause failures.',
                     'Rescind'   => 'Rescind Shutdown',
                     'BTarget'   => 'Backup Target',
                     'FDName'    => 'File or device name',
                     'ServiceMgr'=> 'Service manager',
                     'BlFactor'  => 'Blocking factor',
                     'Options'   => 'Options',
                     'BConvert'  => 'Convert external files as internal tables',
                     'BCreate'   => 'Create a noncompressed backup',
                     'BNoGC'     => 'Do not garbage collect during backup',
                     'BIgnoreCS' => 'Ignore Checksums during backup',
                     'BIgnoreLT' => 'Ignore limbo transactions during backup',
                     'BTransport'=> 'Backup in non transportable format',
                     'BMDOnly'   => 'Backup only metadata',
                     'BMDOStyle' => 'Metadata in old-style format',
                     'RSource'   => 'Restore Source',
                     'RTarget'   => 'Restore Target',
                     'TargetDB'  => 'Target database',
                     'NewFile'   => 'Restore to new file',
                     'RestFile'  => 'Replace existing file',
                     'PageSize'  => 'Page Size',
                     'UseAll'    => 'Restore Database with 100% fill ratio on every data page',
                     'OneAtTime' => 'Restore one table at a time',
                     'IdxInact'  => 'Indexes inactive upon restore',
                     'NoValidity'=> 'Delete validity constraints from restored metadata',
                     'KillShad'  => 'Do not create previously defined shadow files',
                     'ConnAfter' => 'Connect ibWebAdmin to the restored database'
                     );

// strings for the info-panel
$info_strings = array('Connected' => 'connected to Database',
                      'ExtResult' => 'Result from extern command',
                      'IBError'   => 'InterBase Error',
                      'ExtError'  => 'Error from extern command',
                      'Error'     => 'Error',
                      'Warning'   => 'Warning',
                      'Message'   => 'Message',
                      'ComCall'   => 'Command call',
                      'Debug'     => 'Debug output',
                      'PHPError'  => 'PHP Error'
                      );

$MESSAGES = array('BLOB_BROKEN_INFO'      => "Blob support is broken (at least in php4.0.2 and php4.0.3).<br>\n"
                                            ."If you need blob support you have to update your php installation.<br>\n",
                  'SP_CREATE_INFO'        => 'ibWebAdmin has created a stored procedure "'.SP_LIMIT_NAME.'" which is used by the Watch Table function '
                                            ."and saved this inside of your database.<br>\n"
                                            .'If several people are using ibWebAdmin at the same time, please change the value '
                                            ."for WATCHTABLE_METHOD in the file inc/configuration.inc.php.<br>\n",
                  'EDIT_ADD_PRIMARY'      => "If editing is enabled the primary key fields must be selected for showing in the watch table configuration.<br>\n"
                                            ."The program has auto-selected the necessary primary index fields.",
                  'DELETE_CON_DB'         => "You cannot delete a database in use. Now ibWebaAdmin is not longer connected to %s.<br>Please try again.<br>\n",
                  'CSV_IMPORT_COUNT'      => "%1\$d rows imported to table %2\$s<br>\n",
                  'CONFIRM_TABLE_DELETE'  => 'Do you really want to delete the table %s?',
                  'CONFIRM_COLUMN_DELETE' => 'Do you really want to delete the column %1$s from table %2$s?',
                  'CONFIRM_DB_DELETE'     => 'Do you really want to delete the database %s?',
                  'CONFIRM_TRIGGER_DELETE'=> 'Do you really want to delete the trigger %s?',
                  'CONFIRM_DOMAIN_DELETE' => 'Do you really want to delete the domain %s?',
                  'CONFIRM_INDEX_DELETE'  => 'Do you really want to delete the index %s?',
                  'CONFIRM_GEN_DELETE'    => 'Do you really want to delete the generator %s?',
                  'CONFIRM_USER_DELETE'   => 'Do you really want to delete the user %s?',
                  'CONFIRM_ROW_DELETE'    => 'Do you really want to delete from table %s %s?',
                  'CONFIRM_SP_DELETE'     => 'Do you really want to delete the stored procedure %s?',
                  'CONFIRM_VIEW_DELETE'   => 'Do you really want to delete the view %s?',
                  'CONFIRM_UDF_DELETE'    => 'Do you really want to delete the function %s?',
                  'NO_VIEW_SUPPORT'       => "Editing and deleting from views is not supported up to now.<br>\n",
                  'CREATE_DB_SUCCESS'     => "Database %s is successfully created.\n",
                  'HAVE_DEPENDENCIES'     => 'You have to delete the following objects before you can delete the %1$s %2$s: %3$s',
                  'COOKIES_NEEDED'        => 'You have to enable cookies in your browser settings if you want to use the customizing feature!'
                  );

$WARNINGS = array('CAN_NOT_EXPORT_BLOBS'  => "The blob fields in the table you have selected are omitted.<br>\n"
                                            ."Only the csv export of text blobs is supported.<br>\n",
                  'CAN_NOT_IMPORT_BLOBS'  => "The blob fields in the table you have selected are omitted.<br>\n"
                                            ."Only the csv import of text blobs is supported.<br>\n",
                  'SELECT_TABLE_FIRST'    => "Please select a table first<br>\n",
                  'SELECT_FILE_FIRST'     => "Please select an import-file first<br>\n",
                  'CAN_NOT_ALTER_DOMAINS' => "Altering domain based columns is not supported by InterBase.<br>\n"
                                            ."Instead change the domain definition on the Accessories page.<br>\n",
                  'CAN_NOT_EDIT_TABLE'    => "Editing of the selected table is not possible.<br>\n"
                                            ."Only tables with a primary key index are editable.<br>\n",
                  'CAN_NOT_DEL_TABLE'     => "Deleting from the selected table is not possible.<br>\n"
                                            ."Only from tables with a primary key index rows can deleted.<br>\n",
                  'DEL_NO_PERMISSON'      => "You don't have permission for delete/write access to table %s<br>\n",
                  'EDIT_NO_PERMISSON'     => "You don't have permission for update/write access to table %s<br>\n",
                  'CAN_NOT_ACCESS_DIR'    => "The webserver failed to access the directory %s<br>\n",
                  'NAME_IS_KEYWORD'       => "%s is a reserved interbase keyword<br>\n", 
                  'NAMES_ARE_KEYWORDS'    => "%s are reserved interbase keywords<br>\n",
                  'NEED_SYSDBA_PW'        => "SYSDBA's password is required to create, modify or delete users.<br>\n",
                  'PW_REQUIRED'           => "The password is required<br>\n",
                  'UN_REQUIRED'           => "The username is required<br>\n",
                  'PW_WRONG_REPEAT'       => "The password confirmation was incorrect.<br>\n",
                  'BAD_ISQLPATH'          => "The isql binary is not present in %s!<br>\n"
                                            ."Please check the value for BINPATH in inc/configuration.inc.php.<br>\n"
                  );

$ERRORS   = array('CREATE_DB_FAILED'      => 'Creating of the database <b>%s</b> failed!',
                  'NO_DB_SELECTED'        => 'Select a database name first!<br>',
                  'WRONG_DB_SUFFIX'       => 'The database name must end with <b>%s</b>',
                  'DB_NOT_ALLOWED'        => 'Accessing <b>%s</b> is not allowed.<br>'
                                             .'(check $ALLOWED_FILES and $ALLOWED_DIRS in inc/configuration.php)',
                  'NO_IBASE_MODULE'       => '<b>Your php installation misses the interbase support!</b><br>'
                                            .'Recompile php and configure --with-interbase[=DIR]<br>'
                                            .'or edit your php.ini to load interbase.so respectively interbase.dll.',
                  'DISABLED_CMD'          => 'Sql-statements containing "%s" are forbidden by the configuration!',
                  'BAD_BINPATH'           => "Unable to find the command <b>%s</b> !\n"
                                            ."Please check the value for BINPATH in inc/configuration.inc.php.\n"
                  );

// charset encoding  for html output
$charset = 'iso-8859-1';

?>