/* lightlab, Copyright (c) 2002 Jamie Zawinski <jwz@jwz.org>
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations are made about the suitability of this
 * software for any purpose.  It is provided "as is" without express or 
 * implied warranty.
 */

#ifndef __SCENE_H__
#define __SCENE_H__

#include <X11/Xlib.h>

typedef struct scene_data scene_data;

extern Visual *get_gl_visual(Display *dpy, int screen_num);
extern scene_data *init_scene (Display *dpy, Window window);
extern void update_scene (scene_data *);
extern void reshape_scene (scene_data *);
extern void init_texture (scene_data *sd, int width, int height,
                          unsigned char *data);

#endif /* __SCENE_H__ */
