
/* ====================================================================
 *
 * MOD_GZIP.C - Version 1.3.26.1a
 *
 * This program was developed by
 *
 * Remote Communications, Inc.
 * Home page: http://www.RemoteCommunications.com
 *
 * and is currently maintained by
 *
 * Christian Kruse, <ckruse@wwwtech.de> and Michael Schroepl,
 * <michael@schroepl.net>
 * Home page: http://sourceforge.net/projects/mod-gzip/
 *
 * Original author: Kevin Kiley, CTO, Remote Communications, Inc.
 * Email: Kiley@RemoteCommunications.com
 *
 * As of this writing there is an online support forum which
 * anyone may join by following the instructions found at...
 * http://lists.over.net/mailman/listinfo/mod_gzip
 *
 * ====================================================================
 */

/* APACHE LICENSE: START
 *
 * Portions of this software are covered under the following license
 * which, as it states, must remain included in this source code
 * module and may not be altered in any way.
 */

/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * Portions of this software are based upon public domain software
 * originally written at the National Center for Supercomputing Applications,
 * University of Illinois, Urbana-Champaign.
 */

/* APACHE LICENSE: END */

#include "httpd.h"
#include "http_config.h"
#include "http_log.h"

#include "mod_gzip.h"
#include "mod_gzip_debug.h"

#ifdef MOD_GZIP_DEBUG1

server_rec *mod_gzip_server_now = 0;

const char *npp( const char *s )
{
 /* NOTE: This 'Null Pointer Protection' call is really only */
 /* needed for the Solaris Operating System which seems to have */
 /* some kind of problem handling NULL pointers passed to certain */
 /* STDLIB calls. Sloaris will GP fault where all other OS's are OK. */

 if ( s ) return s;
 else     return "NULL";
}

#ifdef MOD_GZIP_LOG_IS_APACHE_LOG

void mod_gzip_printf( const char *fmt, ... )
{
 int   l;

 va_list ap;

 char log_line[2048]; 

 va_start( ap, fmt );

 l = vsprintf( log_line, fmt, ap );

 va_end(ap);

 ap_log_error( "",0,APLOG_NOERRNO|APLOG_DEBUG, mod_gzip_server_now, log_line);

 return;
}

#else 

void mod_gzip_printf( const char *fmt, ... )
{
 int   l;
 char *p1;
 FILE *log;

 va_list ap;

 char logname[256];
 char log_line[4096];

 #ifdef WIN32
 long pid = GetCurrentProcessId();
 #else
 long pid = (long) getpid();
 #endif

 #ifdef WIN32
 sprintf( logname, "c:\\temp\\t%ld.log",(long)pid);
 #else
 sprintf( logname, "/tmp/t%ld.log",(long)pid);
 #endif

 log = fopen( logname,"a" );

 if ( !log ) 
   {
    return; 
   }

 va_start( ap, fmt );

 l = vsprintf(log_line, fmt, ap);

 p1=log_line;
 while((*p1!=0)&&(*p1!=13)&&(*p1!=10)) p1++;
 *p1=0;

 fprintf( log, "%s\n", log_line );

 fclose( log );

 va_end(ap); 

 return; 
}

#endif 

void mod_gzip_hexdump( char *buffer, int buflen )
{
 int i,o1,o2,o3;

 int len1;
 int len2;

 char ch1;
 char ch2;
 char s[40];
 char l1[129];
 char l2[129];
 char l3[300];

 long offset1=0L;

 o1=0;
 o2=0;
 o3=0;

 l1[0] = 0;
 l2[0] = 0;
 l3[0] = 0;

 offset1 = 0;

 for ( i=0; i<buflen; i++ )
    {
     ch1 = (char) *buffer++;

     #define DUMPIT_ASTERISK    42
     #define DUMPIT_LAPOSTROPHE 96
     #define DUMPIT_RAPOSTROPHE 39
     #define DUMPIT_PERIOD      46
     #define DUMPIT_CR          67
     #define DUMPIT_LF          76

     #ifdef MASK_ONLY_CERTAIN_CHARS
          if ( ch1 ==  0 ) ch2 = DUMPIT_PERIOD;
     else if ( ch1 == 13 ) ch2 = DUMPIT_CR;
     else if ( ch1 == 10 ) ch2 = DUMPIT_LF;
     else if ( ch1 ==  9 ) ch2 = DUMPIT_LAPOSTROPHE;
     else                  ch2 = ch1;
     #endif

     #define MASK_ALL_NON_PRINTABLE_CHARS
     #ifdef  MASK_ALL_NON_PRINTABLE_CHARS

          if ( ch1 == 13 ) ch2 = DUMPIT_CR;
     else if ( ch1 == 10 ) ch2 = DUMPIT_LF;
     else if ( ch1 <  32 ) ch2 = DUMPIT_PERIOD;
     else if ( ch1 >  126) ch2 = DUMPIT_LAPOSTROPHE;
     else if ( ch1 == 37 ) ch2 = DUMPIT_ASTERISK; 
     else if ( ch1 == 92 ) ch2 = DUMPIT_ASTERISK; 
     else                  ch2 = ch1;

     #endif

     l2[o2++] = ch2;

     sprintf( s, "%02X", ch1 );

     if ( mod_gzip_strlen(s) > 2 ) s[2]=0; 

     len1 = mod_gzip_strlen(s);
     len2 = mod_gzip_strlen(l1);

     if ( mod_gzip_strlen(l1) < (int)(sizeof(l1) - (len1+1)) )
       {
        strcat( l1, s   );
        strcat( l1, " " );
       }

     if ( o2 >= 16 )
       {
        l2[o2]=0;

        mod_gzip_printf( "%6lu| %-49.49s| %-16.16s |", offset1, l1, l2 );

        offset1 += o2;

        o1=0;
        o2=0;
        o3=0;

        l1[0] = 0;
        l2[0] = 0;
        l3[0] = 0;
       }
    }

 if ( o2 > 0  )
   {
    l2[o2]=0;

    mod_gzip_printf( "%6lu| %-49.49s| %-16.16s |", offset1, l1, l2 );

    offset1 += o2;

    o1 = o2 = o3 = 0;

    l1[0] = 0;
    l2[0] = 0;
    l3[0] = 0;
   }
}

int mod_gzip_log_comerror( request_rec *r, char *p, int error )
{
 int  i=0;      
 char b[3][90]; 

 b[0][0]=0; 
 b[1][0]=0; 
 b[2][0]=0; 

 #if defined(WIN32) || defined(NETWARE)

 if ( error == WSANOTINITIALISED )
   {
    sprintf(b[0],"%s * WSANOTINITIALISED",p);
    sprintf(b[1],"%s * A successful WSAStartup() must occur",p);
    sprintf(b[2],"%s * before using this WINSOCK API call.",p);
   }
 else if ( error == WSAENETDOWN )
   {
    sprintf(b[0],"%s * WSAENETDOWN",p);
    sprintf(b[1],"%s * The Windows Sockets implementation has detected",p);
    sprintf(b[2],"%s * that the network subsystem has failed.",p);
   }
 else if ( error == WSAENOTCONN )
   {
    sprintf(b[0],"%s * WSAENOTCONN",p);
    sprintf(b[1],"%s * The socket is not connected.",p);
   }
 else if ( error == WSAEINTR )
   {
    sprintf(b[0],"%s * WSAEINTR",p);
    sprintf(b[1],"%s * The (blocking) call was cancelled",p);
    sprintf(b[2],"%s * via WSACancelBlockingCall()",p);
   }
 else if ( error == WSAEINPROGRESS )
   {
    sprintf(b[0],"%s * WSAEINPROGRESS",p);
    sprintf(b[1],"%s * A blocking Windows Sockets operation",p);
    sprintf(b[2],"%s * is in progress.",p);
   }
 else if ( error == WSAENOTSOCK )
   {
    sprintf(b[0],"%s * WSAENOTSOCK",p);
    sprintf(b[1],"%s * The descriptor is not a socket.",p);
   }
 else if ( error == WSAEOPNOTSUPP )
   {
    sprintf(b[0],"%s * WSAEOPNOTSUPP",p);
    sprintf(b[1],"%s * MSG_OOB was specified, but the socket is",p);
    sprintf(b[2],"%s * not of type SOCK_STREAM.",p);
   }
 else if ( error == WSAESHUTDOWN )
   {
    sprintf(b[0],"%s * WSAESHUTDOWN",p);
    sprintf(b[1],"%s * The socket has been shutdown.",p);
   }
 else if ( error == WSAEWOULDBLOCK )
   {
    sprintf(b[0],"%s * WSAEWOULDBLOCK",p);
    sprintf(b[1],"%s * The socket is marked as non-blocking",p);
    sprintf(b[2],"%s * and receive operation would block.",p);
   }
 else if ( error == WSAEMSGSIZE )
   {
    sprintf(b[0],"%s * WSAEMSGSIZE",p);
    sprintf(b[1],"%s * The datagram was too large to",p);
    sprintf(b[2],"%s * fit into the specified buffer.",p);
   }
 else if ( error == WSAEINVAL )
   {
    sprintf(b[0],"%s * WSAEINVAL",p);
    sprintf(b[1],"%s * The socket has not been bound with bind().",p);
   }
 else if ( error == WSAECONNABORTED )
   {
    sprintf(b[0],"%s * WSAECONNABORTED",p);
    sprintf(b[1],"%s * The virtual circuit was aborted",p);
    sprintf(b[2],"%s * due to timeout or other failure.",p);
   }
 else if ( error == WSAECONNRESET )
   {
    sprintf(b[0],"%s * WSAECONNRESET",p);
    sprintf(b[1],"%s * The virtual circuit was reset by the remote side.",p);
   }
 else
   {
    sprintf(b[0],"%s * WSA????",p);
    sprintf(b[1],"%s * Unexpected WINSOCK error code %d",p,error);
   }

 #else 

      if ( error == EBADF       ) sprintf(b[0],"%s * EBADF", p );
 else if ( error == EAGAIN      ) sprintf(b[0],"%s * EAGAIN",p );
 else if ( error == EDQUOT      ) sprintf(b[0],"%s * EDQUOT",p );
 else if ( error == EFAULT      ) sprintf(b[0],"%s * EFAULT",p );
 else if ( error == EFBIG       ) sprintf(b[0],"%s * EFBIG", p );
 else if ( error == EINTR       ) sprintf(b[0],"%s * EINTR", p );
 else if ( error == EINVAL      ) sprintf(b[0],"%s * EINVAL",p );
 else if ( error == EIO         ) sprintf(b[0],"%s * EIO",   p );
 else if ( error == ENOSPC      ) sprintf(b[0],"%s * ENOSPC",p );
 else if ( error == ENXIO       ) sprintf(b[0],"%s * ENXIO", p );
 else if ( error == EPIPE       ) sprintf(b[0],"%s * EPIPE", p );
 else if ( error == ERANGE      ) sprintf(b[0],"%s * ERANGE",p );
 else if ( error == EINVAL      ) sprintf(b[0],"%s * EINVAL",p );
 else if ( error == EWOULDBLOCK ) sprintf(b[0],"%s * EWOULDBLOCK",p );

 else 
   {
    sprintf(b[0],"%s * E???? Unexpected error code %d",p,error);
   }

 #endif 

 for ( i=0; i<3; i++ )
    {
     if ( b[i][0] != 0 )
       {
        #ifdef MOD_GZIP_DEBUG1
        mod_gzip_printf("%s",npp(b[i]));
        #endif
       }
    }

 return( 1 );
}

int mod_gzip_translate_comerror( int error, char *buf )
{
 char bb[40]; 

 if ( buf == 0 ) 
   {
    return 0; 
   }

 #if defined(WIN32) || defined(NETWARE)

      if ( error == WSANOTINITIALISED ) sprintf(bb,"WSANOTINITIALISED");
 else if ( error == WSAENETDOWN       ) sprintf(bb,"WSAENETDOWN");
 else if ( error == WSAENOTCONN       ) sprintf(bb,"WSAENOTCONN");
 else if ( error == WSAEINTR          ) sprintf(bb,"WSAEINTR");
 else if ( error == WSAEINPROGRESS    ) sprintf(bb,"WSAEINPROGRESS");
 else if ( error == WSAENOTSOCK       ) sprintf(bb,"WSAENOTSOCK");
 else if ( error == WSAEOPNOTSUPP     ) sprintf(bb,"WSAEOPNOTSUPP");
 else if ( error == WSAESHUTDOWN      ) sprintf(bb,"WSAESHUTDOWN");
 else if ( error == WSAEWOULDBLOCK    ) sprintf(bb,"WSAEWOULDBLOCK");
 else if ( error == WSAEMSGSIZE       ) sprintf(bb,"WSAEMSGSIZE");
 else if ( error == WSAEINVAL         ) sprintf(bb,"WSAEINVAL");
 else if ( error == WSAECONNABORTED   ) sprintf(bb,"WSAECONNABORTED");
 else if ( error == WSAECONNRESET     ) sprintf(bb,"WSAECONNRESET");
 else                                   sprintf(bb,"%d=WSA????",error);

 #else 

      if ( error == EBADF       ) sprintf(bb,"EBADF"  );
 else if ( error == EAGAIN      ) sprintf(bb,"EAGAIN" );
 else if ( error == EDQUOT      ) sprintf(bb,"EDQUOT" );
 else if ( error == EFAULT      ) sprintf(bb,"EFAULT" );
 else if ( error == EFBIG       ) sprintf(bb,"EFBIG"  );
 else if ( error == EINTR       ) sprintf(bb,"EINTR"  );
 else if ( error == EINVAL      ) sprintf(bb,"EINVAL" );
 else if ( error == EIO         ) sprintf(bb,"EIO"    );
 else if ( error == ENOSPC      ) sprintf(bb,"ENOSPC" );
 else if ( error == ENXIO       ) sprintf(bb,"ENXIO"  );
 else if ( error == EPIPE       ) sprintf(bb,"EPIPE"  );
 else if ( error == ERANGE      ) sprintf(bb,"ERANGE" );
 else if ( error == EINVAL      ) sprintf(bb,"EINVAL" );
 else if ( error == EWOULDBLOCK ) sprintf(bb,"EWOULDBLOCK" );
 else                             sprintf(bb,"%d=E????",error);

 #endif 

 mod_gzip_strcpy( buf, bb ); 

 return( 1 );
}

#if defined(MOD_GZIP_DEBUG1_SHOW_REQUEST_RECORD2) || defined(MOD_GZIP_DEBUG1_SHOW_REQUEST_RECORD1)
int mod_gzip_show_request_record(
request_rec *r,
char        *cn
)
{
 mod_gzip_printf( "%s: -------------------------------------------------------------",cn);
 mod_gzip_printf( "%s: REQUEST RECORD SNAPSHOT",cn);
 mod_gzip_printf( "%s: -------------------------------------------------------------",cn);
 mod_gzip_printf( "%s: r = %ld", cn, (long) r );
 mod_gzip_printf( "%s: r->connection->keepalive=%d", cn, r->connection->keepalive );
 mod_gzip_printf( "%s: r->the_request=[%s]", cn, npp(r->the_request) );
 mod_gzip_printf( "%s: -------------------------------------------------------------",cn);
 mod_gzip_printf( "%s: r->next = %ld",cn,(long)r->next);
 mod_gzip_printf( "%s: r->prev = %ld",cn,(long)r->prev);
 mod_gzip_printf( "%s: r->main = %ld",cn,(long)r->main);
 mod_gzip_printf( "%s: -------------------------------------------------------------",cn);
 mod_gzip_printf( "%s: r->sent_bodyct  = %ld",cn,(long)r->sent_bodyct);
 mod_gzip_printf( "%s: r->bytes_sent   = %ld",cn,(long)r->bytes_sent);
 mod_gzip_printf( "%s: r->chunked      = %ld",cn,(long)r->chunked);
 mod_gzip_printf( "%s: r->byterange    = %ld",cn,(long)r->byterange);
 mod_gzip_printf( "%s: r->clength      = %ld (The 'real' content length )",cn,(long)r->clength);
 mod_gzip_printf( "%s: r->byterange    = %ld",cn,(long)r->remaining);
 mod_gzip_printf( "%s: r->read_length  = %ld",cn,(long)r->read_length);
 mod_gzip_printf( "%s: r->read_body    = %ld",cn,(long)r->read_body);
 mod_gzip_printf( "%s: r->read_chunked = %ld",cn,(long)r->read_chunked);
 mod_gzip_printf( "%s: -------------------------------------------------------------",cn);
 mod_gzip_printf( "%s: *IN: r->uri                 =[%s]", cn, npp(r->uri));
 mod_gzip_printf( "%s: *IN: r->unparsed_uri        =[%s]", cn, npp(r->unparsed_uri));
 mod_gzip_printf( "%s: *IN: r->filename            =[%s]", cn, npp(r->filename));
 mod_gzip_printf( "%s: *IN: r->path_info           =[%s]", cn, npp(r->path_info));
 mod_gzip_printf( "%s: *IN: r->args                =[%s]", cn, npp(r->args));
 mod_gzip_printf( "%s: *IN: r->header_only         =%d",   cn, r->header_only );
 mod_gzip_printf( "%s: *IN: r->protocol            =[%s]", cn, npp(r->protocol));
 mod_gzip_printf( "%s: *IN: r->proto_num           =%d",   cn, r->proto_num );
 mod_gzip_printf( "%s: *IN: r->hostname            =[%s]", cn, npp(r->hostname));
 mod_gzip_printf( "%s: *IN: r->the_request         =[%s]", cn, npp(r->the_request));
 mod_gzip_printf( "%s: *IN: r->assbackwards        =%d",   cn, r->assbackwards );
 mod_gzip_printf( "%s: *IN: r->status_line         =[%s]", cn, npp(r->status_line));
 mod_gzip_printf( "%s: *IN: r->status              =%d",   cn, r->status );
 mod_gzip_printf( "%s: *IN: r->method              =[%s]", cn, npp(r->method));
 mod_gzip_printf( "%s: *IN: r->method_number       =%d",   cn, r->method_number );
 mod_gzip_printf( "%s: *IN: r->content_type        =[%s]", cn, npp(r->content_type));
 mod_gzip_printf( "%s: *IN: r->handler             =[%s]", cn, npp(r->handler));
 mod_gzip_printf( "%s: *IN: r->content_encoding    =[%s]", cn, npp(r->content_encoding));
 mod_gzip_printf( "%s: *IN: r->content_language    =[%s]", cn, npp(r->content_language));
 mod_gzip_printf( "%s: -------------------------------------------------------------",cn);
 mod_gzip_printf( "%s: *IN: r->parsed_uri.scheme   =[%s]", cn, npp(r->parsed_uri.scheme));
 mod_gzip_printf( "%s: *IN: r->parsed_uri.hostinfo =[%s]", cn, npp(r->parsed_uri.hostinfo));
 mod_gzip_printf( "%s: *IN: r->parsed_uri.user     =[%s]", cn, npp(r->parsed_uri.user));
 mod_gzip_printf( "%s: *IN: r->parsed_uri.password =[%s]", cn, npp(r->parsed_uri.password));
 mod_gzip_printf( "%s: *IN: r->parsed_uri.hostname =[%s]", cn, npp(r->parsed_uri.hostname));
 mod_gzip_printf( "%s: *IN: r->parsed_uri.port_str =[%s]", cn, npp(r->parsed_uri.port_str));
 mod_gzip_printf( "%s: *IN: r->parsed_uri.port     =%u",   cn, r->parsed_uri.port );
 mod_gzip_printf( "%s: *IN: r->parsed_uri.path     =[%s]", cn, npp(r->parsed_uri.path));
 mod_gzip_printf( "%s: *IN: r->parsed_uri.query    =[%s]", cn, npp(r->parsed_uri.query));
 mod_gzip_printf( "%s: *IN: r->parsed_uri.fragment =[%s]", cn, npp(r->parsed_uri.fragment));
 mod_gzip_printf( "%s: -------------------------------------------------------------",cn);
 mod_gzip_printf( "%s: 'r->headers_in'...",cn);
 mod_gzip_printf( "%s: -------------------------------------------------------------",cn);
 mod_gzip_dump_a_table( r, (_table *) r->headers_in );
 mod_gzip_printf( "%s: -------------------------------------------------------------",cn);
 mod_gzip_printf( "%s: 'r->headers_out'...",cn);
 mod_gzip_printf( "%s: -------------------------------------------------------------",cn);
 mod_gzip_dump_a_table( r, (_table *) r->headers_out );
 mod_gzip_printf( "%s: -------------------------------------------------------------",cn);
 mod_gzip_printf( "%s: 'r->err_headers_out'...",cn);
 mod_gzip_printf( "%s: -------------------------------------------------------------",cn);
 mod_gzip_dump_a_table( r, (_table *) r->err_headers_out );
 mod_gzip_printf( "%s: -------------------------------------------------------------",cn);
 mod_gzip_printf( "%s: 'r->subprocess_env'...",cn);
 mod_gzip_printf( "%s: -------------------------------------------------------------",cn);
 mod_gzip_dump_a_table( r, (_table *) r->subprocess_env );
 mod_gzip_printf( "%s: -------------------------------------------------------------",cn);
 mod_gzip_printf( "%s: 'r->notes'...",cn);
 mod_gzip_printf( "%s: -------------------------------------------------------------",cn);
 mod_gzip_dump_a_table( r, (_table *) r->notes );
 mod_gzip_printf( "%s: -------------------------------------------------------------",cn);

 if ( r->next )
   {
    mod_gzip_printf( "%s: r->next is valid... showing 'r->next' record...",cn);

    mod_gzip_show_request_record( r->next, cn );
   }

 return 1;
}
#endif

int mod_gzip_dump_a_table( request_rec *r, _table *t )
{
 table_entry *elts = (table_entry *) t->a.elts;
 int i;

 char cn[]="mod_gzip_dump_a_table()";

 for ( i = 0; i < t->a.nelts; i++ )
    {
     mod_gzip_printf( "%s: %3.3d key=[%s] val=[%s]",
     cn,i,npp(elts[i].key),npp(elts[i].val));
    }

 return 0;
}

#endif

/* eof */
