/*
                              Floating Prompt
 */

#ifndef FPROMPT_H
#define FPROMPT_H

#include <sys/types.h>

#include <gtk/gtk.h>
#include "guiutils.h"

#ifndef gbool
# define gbool  guchar
#endif


/*
 *	Floating prompt map to codes:
 */
#define FPROMPT_MAP_NO_MOVE		0
#define FPROMPT_MAP_TO_POINTER		1	/* Centered around pointer. */
#define FPROMPT_MAP_TO_POINTER_WINDOW	2	/* Window under pointer. */

/*
 *	Default floating prompt size:
 */
#define FPROMPT_DEF_WIDTH	250
#define FPROMPT_DEF_HEIGHT	30

/*
 *	Floating prompt show flags:
 */
#define FPROMPT_FLAG_LABEL		(1 << 0)
#define FPROMPT_FLAG_BROWSE_BTN		(1 << 1)
#define FPROMPT_FLAG_OK_BTN		(1 << 2)
#define FPROMPT_FLAG_CANCEL_BTN		(1 << 3)


extern gint FPromptInit(void);
extern void FPromptSetTransientFor(GtkWidget *w);
extern gbool FPromptIsQuery(void);
extern void FPromptBreakQuery(void);
extern void FPromptSetPosition(gint x, gint y);
extern gint FPromptMapQuery(
        const gchar *label,
        const gchar *value,
        const gchar *tooltip_message,
        gint map_code,                  /* One of FPROMPT_MAP_TO_*. */
	gint width, gint height,
        guint flags,
	gpointer client_data,
	gchar *(*browse_cb)(gpointer, const gchar *),
        void (*apply_cb)(gpointer, const gchar *),
        void (*cancel_cb)(gpointer)
);
extern void FPromptMap(void);
extern void FPromptUnmap(void);
extern void FPromptShutdown(void);

#endif	/* FPROMPT_H */
