/***************************************************************************
                          hbciseg.cpp  -  description
                             -------------------
    begin                : Thu Jul 26 2001
    copyright            : (C) 2001 by fabian kaiser
    email                : fabian.kaiser@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/
/*
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef __declspec
# if BUILDING_DLL
#  define DLLIMPORT __declspec (dllexport)
# else /* Not BUILDING_DLL */
#  define DLLIMPORT __declspec (dllimport)
# endif /* Not BUILDING_DLL */
#else
# define DLLIMPORT
#endif



#include <string>
#include <list>

#include "hbcistring.h"
#include "user.h"
#include "seg.h"


namespace HBCI {

Seg::Seg(Pointer<Customer> cust) {
    _customer=cust;
    if (_customer.isValid()) {
        //_user=cust.ref().user();
        _bank=cust.ref().user().ref().bank();
        _hbciversion=_bank.ref().hbciVersion();
    }
    _customer.setDescription("Seg::_customer");
    //_user.setDescription("Seg::_user");
    _bank.setDescription("Seg::_bank");
    _segnumber=0;
}

Seg::Seg() {
}

Seg::~Seg(){
}

bool
Seg::parse_ktv(const string& de, 
		   string& accountNumber, 
		   string& accountSuffix, 
		   string& bankCode, int& countryCode)
{
    
    int spos = 0; 
    bool hasSuffix; 
    spos += String::nextDEG(de, spos).length() + 1; 
    spos += String::nextDEG(de, spos).length() + 1; 
    spos += String::nextDEG(de, spos).length() + 1; 
    hasSuffix = (! String::nextDEG(de, spos).empty()); 
    spos=0; 
    accountNumber = String::nextDEG(de, spos); 
    spos += String::nextDEG(de, spos).length() + 1; 
    if (hasSuffix) { 
        accountSuffix = String::nextDEG(de, spos); 
        spos += String::nextDEG(de, spos).length() + 1; 
    } 
    countryCode = atoi(String::nextDEG(de, spos).c_str()); 
    spos += String::nextDEG(de, spos).length() + 1; 
    bankCode = String::nextDEG(de, spos); 
    return true;
}


void Seg::segment_number(int &versionMin, int &versionMax, 
			     int hbciVersion, 
			     int min201, int max201, 
			     int min210, int max210, 
			     int min220, int max220) 
{
    if (hbciVersion == HBCI_VERSION_220) { 
	versionMin = min220; 
	versionMax = max220; 
    } else if (hbciVersion == HBCI_VERSION_210) { 
	versionMin = min210; 
	versionMax = max210; 
    } else if (hbciVersion == HBCI_VERSION_201) { 
	versionMin = min201; 
	versionMax = max201; 
    };
}

} // namespace HBCI
