/***************************************************************************
 $RCSfile: outbox.h,v $
                             -------------------
    cvs         : $Id: outbox.h,v 1.20 2002/08/14 22:32:07 cstim Exp $
    begin       : Sat Jun 08 2002
    copyright   : (C) 2001 by Martin Preuss
    email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/



#ifndef JOBQUEUE_H
#define JOBQUEUE_H

#ifdef __cplusplus
#include <list>
#include <openhbci/dllimport.h>
#include <openhbci/pointer.h>
#include <openhbci/customer.h>
#include <openhbci/bank.h>
/* Forward declarations */
namespace HBCI {
  class Outbox;
  class customerQueue;
  class bankQueue;
}

#include <openhbci/outboxjob.h>
#include <openhbci/api.h>

namespace HBCI {

#ifndef DOXYGEN_HIDE

/**
 * @short This queue holds all jobs for one customer.
 * @author Martin Preuss<martin@libchipcard.de>
 */
class DLLIMPORT customerQueue {
private:
    Pointer<Customer> _cust;
    list<Pointer<OutboxJob> > _jobs;
public:
    customerQueue(Pointer<Customer> c);
    ~customerQueue();
    void addJob(Pointer<OutboxJob> job);
    const list<Pointer<OutboxJob> > &jobs() const;
    Pointer<Customer> customer() const { return _cust;};
    void removeByState(OutboxJob_Status s);
    void removeByResult(OutboxJob_Result s);
    bool removeJob(Pointer<OutboxJob> job);
    bool empty() const;
    int sizeByResult(OutboxJob_Result s=HBCI_JOB_RESULT_NONE) const;
    int sizeByStatus(OutboxJob_Status s=HBCI_JOB_STATUS_NONE) const;
    bool allDialogJobs() const;
};


/*___________________________________________________________________________
 *AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 *                              bankQueue
 *YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY
 */



/**
 * @internal
 * @short This queue holds all jobs for one bank.
 * @author Martin Preuss<martin@libchipcard.de>
 */
class DLLIMPORT bankQueue {
private:
    Pointer<Bank> _bank;
    list<Pointer<customerQueue> > _custQueues;
public:
    bankQueue(Pointer<Bank> b);
    ~bankQueue();
    Pointer<Bank> bank() const { return _bank;};
    const list<Pointer<customerQueue> > &customerQueues() const;
    void addJob(Pointer<Customer> c,
                Pointer<OutboxJob> job);
    void removeByState(OutboxJob_Status s);
    void removeByResult(OutboxJob_Result s);
    bool removeJob(Pointer<OutboxJob> job);
    bool empty() const;
    int sizeByResult(OutboxJob_Result s=HBCI_JOB_RESULT_NONE) const;
    int sizeByStatus(OutboxJob_Status s=HBCI_JOB_STATUS_NONE) const;
    int customerCount() const;
    bool allDialogJobs() const;
};


#endif /* DOXYGEN_HIDE */



/*___________________________________________________________________________
 *AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 *                              Outbox
 *YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY
 */



/**
 * @short This is a queue for the OutboxJobs. 
 *
 * If you add a job it will automatically be sorted in the right
 * bank/customer queue. This way all jobs in this queue are sorted by
 * their bank and customer. This groups the jobs in a manner that
 * allows sending them with the least possible number of customer
 * switches (i.e. different PINs to be entered).  
 *
 * @author Martin Preuss<martin@libchipcard.de> */
class DLLIMPORT Outbox {
public:
    Outbox(const API *a);
    ~Outbox();

    /**
     * Add a job to the queue. This job will be sorted in according to
     * the bank and customer involved.
     * @author Martin Preuss<martin@libchipcard.de>
     */
    void addJob(Pointer<OutboxJob> job);

    /**
     * Remove all jobs with the given status from the queue.
     * @author Martin Preuss<martin@libchipcard.de>
     * @param s status to match (HBCI_JOB_STATUS_NONE will remove ALL jobs)
     */
    void removeByState(OutboxJob_Status s);

    /**
     * Remove all jobs with the given result from the queue.
     * @author Martin Preuss<martin@libchipcard.de>
     * @param s result to match (HBCI_JOB_RESULT_NONE will remove ALL jobs)
     */
    void removeByResult(OutboxJob_Result s);

    /**
     * Removes a given job.
     * @author Martin Preuss<martin@libchipcard.de>
     */
    void removeJob(Pointer<OutboxJob> job);

    /**
     * Returns the list of bank queues. There is one queue for each bank
     * involved.
     * @author Martin Preuss<martin@libchipcard.de>
     */
    const list<Pointer<bankQueue> > &bankQueues() const;

    bool empty() const;

    /**
     * Returns the number of jobs with the given result code.
     * @author Martin Preuss<martin@libchipcard.de>
     * @param s result code to look for (HBCI_JOB_RESULT_NONE matches all).
     */
    int sizeByResult(OutboxJob_Result s=HBCI_JOB_RESULT_NONE) const;

    /**
     * Returns the number of jobs with the given status code.
     * @param s status code to look for (HBCI_JOB_STATUS_NONE matches all).
     */
    int sizeByStatus(OutboxJob_Status s=HBCI_JOB_STATUS_NONE) const;

    /** 
     * Returns true, if this queue contains only dialog jobs
     * (i.e. OutboxJobs that handle the opening and closing of dialogs
     * by themselves). Returns false if any OutboxJob is a non-dialog one.
     */
    bool allDialogJobs() const;

    /**
     * Returns the number of banks involved.
     * @author Martin Preuss<martin@libchipcard.de>
     */
    int bankCount() const;

    /**
     * Returns the number of customers involved.
     * @author Martin Preuss<martin@libchipcard.de>
     */
    int customerCount() const;

    /**
     * Removes all jobs from the queue.
     * @author Martin Preuss<martin@libchipcard.de>
     */
    void clear();

    /**
     * Returns a list of all jobs in the queue (of all banks together).
     * @author Martin Preuss<martin@libchipcard.de>
     */
    list<Pointer<OutboxJob> > jobs() const;

    /**
     * Each job that gets enqueued will be assigned a unique id to.
     * To retrieve this id this method can be used. It is also used
     * by the Loader for storage.
     * @author Martin Preuss<martin@libchipcard.de>
     */
    DLLIMPORT static int nextId();

    /**
     * Set the next job id to be used. This should only be called
     * by Loader upon loading of the configuration file. Otherwise
     * jobids are not guaranteed to be unique.
     * @author Martin Preuss<martin@libchipcard.de>
     */
    DLLIMPORT static void setNextId(int i);

private:
    const API *_hbci;
    list<Pointer<bankQueue> > _banks;
    DLLIMPORT static int _nextId;

};

} /* namespace HBCI */

#endif /* __cplusplus */

#endif



