#include <stdio.h>

#include "wnlib.h"
#include "wnmem.h"

#include "wnvect.h"


#define LEN   10


void main(void)
{
  double *vect1,*vect2,*vect3;

  wn_gpmake("general_free");

  wn_make_vect(&vect1,LEN);
  wn_make_vect(&vect2,LEN);
  wn_make_vect(&vect3,LEN);

  wn_random_vect(vect1,LEN);
  wn_print_vect(vect1,LEN);
  wn_copy_vect(vect2,vect1,LEN);
  wn_print_vect(vect1,LEN);
  wn_random_vect(vect2,LEN);

  printf("v1.v2 = %lf\n",wn_dot_vects(vect1,vect2,LEN));
  printf("v1.v1 = %lf\n",wn_dot_vects(vect1,vect1,LEN));
  printf("norm2(v1) = %lf\n",wn_norm2_vect(vect1,LEN));
  printf("norm(v1) = %lf\n",wn_norm_vect(vect1,LEN));
  printf("corr(v1,v2)) = %lf\n",
	 wn_dot_vects(vect1,vect2,LEN)/
	 (wn_norm_vect(vect1,LEN)*wn_norm_vect(vect2,LEN)));

  wn_free_vect(vect1,LEN);

  wn_gpfree();
}

