/*
 * Copyright (c) 2003-2004 Benedikt Meurer <benny@xfce.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __LIBXFCE4UTIL_UTIL_H__
#define __LIBXFCE4UTIL_UTIL_H__

#include <libxfce4util/libxfce4util-config.h>
#include <libxfce4util/debug.h>

/* save way to get path to users home directory and files below */
extern G_CONST_RETURN gchar *xfce_get_homedir(void);

extern G_CONST_RETURN gchar *xfce_get_homefile_r(gchar *buffer,
		size_t length, const gchar *format, ...);

/* save way to get path to users ".xfce4" directory */
extern G_CONST_RETURN gchar *xfce_get_userdir(void);

extern G_CONST_RETURN gchar *xfce_get_userfile_r(gchar *buffer,
		size_t length, const gchar *format, ...);

#if defined(G_HAVE_ISO_VARARGS)

#define xfce_get_homefile(...)                             \
  (g_build_filename (xfce_get_homedir (), __VA_ARGS__))

#define xfce_get_userfile(...)                             \
  (g_build_filename (xfce_get_userdir (), __VA_ARGS__))

#elif defined(G_HAVE_GNUC_VARARGS)

#define xfce_get_homefile(first_element...)	               \
	(g_build_filename(xfce_get_homedir(),	## first_element))

#define xfce_get_userfile(first_element...)	               \
	(g_build_filename(xfce_get_userdir(),	## first_element))

#else
#error "Variable argument lists not support on your plattform."
#endif

#endif	/* __LIBXFCE4UTIL_UTIL_H__ */
