// -*- c++ -*-
#ifndef INCLUDED_MATH3D_MRECT_H
#define INCLUDED_MATH3D_MRECT_H
/*
 * Math3d - The 3D Computer Graphics Math Library
 * Copyright (C) 1996-2000 by J.E. Hoffmann <je-h@gmx.net>
 * All rights reserved.
 *
 * This program is  free  software;  you can redistribute it and/or modify it
 * under the terms of the  GNU Lesser General Public License  as published by 
 * the  Free Software Foundation;  either version 2.1 of the License,  or (at 
 * your option) any later version.
 *
 * This  program  is  distributed in  the  hope that it will  be useful,  but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or  FITNESS FOR A  PARTICULAR PURPOSE.  See the  GNU Lesser General Public  
 * License for more details.
 *
 * You should  have received  a copy of the GNU Lesser General Public License
 * along with  this program;  if not, write to the  Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: mrect.h,v 1.1 2000/10/09 17:55:51 jeh Exp $
 */

#ifndef INCLUDED_MATH3D_MATH3DDEF_H
#include <math3d/math3ddef.h>
#endif

namespace Math3d {
  
/**
 * 2d rectangle class.
 */
  class _CCMATH3D MRect {
    protected:
      double d_x;
      double d_y;
      double d_w;
      double d_h;
    public:
      MRect();
      MRect(double x, double y, double w, double h);
      MRect(double v[4]);
      
      void setRect(double x, double y, double w, double h);
      void setPos(double x, double y);
      void setSize(double w, double h);
      void setCoord(double x1, double y1, double x2, double y2);
      
      double x() const {return(d_x);}
      double y() const {return(d_y);}
      double width() const {return(d_w);}
      double height() const {return(d_h);}
      double x1() const {return(d_x);}
      double y1() const {return(d_y);}
      double x2() const {return(d_w+d_w);}
      double y2() const {return(d_y+d_h);}
  };
  
}
#endif // INCLUDED_MATH3D_MRECT_H

