/* move on mainscreen

   Written by Matthias Hensler
   Copyright WSPse 1999
   eMail: wsp@gmx.de

Created: 6/6/99
Updated: 6/9/99
*/

/* Copying:
   This program is free software; you can redistribute it and/or modify it under
   the terms of the GNU Gerneral Public License as published by the Free Soft-
   ware Foundation; either version 2 of License, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILTY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 675 Mass
   Ave, Cambridge, MA 02139, USA.
   */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <ncurses.h>
#include "mp3creat.h"

extern song_typ *lay_global_anchor[2];
extern song_typ *lay_top_anchor[2];
extern song_typ *lay_curr_anchor[2];
extern int lay_select_line[2];
extern int lay_act_side;
extern void draw_song_status(WINDOW *win, song_typ *song);
extern void draw_song_line(WINDOW *win, song_typ *song, BOOL marked, int line);
extern void fill_in_songs(WINDOW *win);
extern void fill_in_side(WINDOW *win, int side);

/* go one song down */
void song_move_down(WINDOW *win, BOOL do_refresh)
{
  int maxy, maxx;

  /* test if song follows */
  if(! lay_curr_anchor[lay_act_side]) return;
  if(lay_curr_anchor[lay_act_side]->next == NULL) return;
  
  getmaxyx(win, maxy, maxx);
  
  /* select box currently on bottom? */
  if(lay_select_line[lay_act_side] == maxy-9) {
    /* yes, increase top-anchor */
    lay_top_anchor[lay_act_side] = lay_top_anchor[lay_act_side]->next;
    fill_in_side(win, lay_act_side);
  } else {
    /* no, increase curr-anchor and line (and update) */
    draw_song_line(win, lay_curr_anchor[lay_act_side], FALSE, lay_select_line[lay_act_side]);
    lay_curr_anchor[lay_act_side] = lay_curr_anchor[lay_act_side]->next;
    lay_select_line[lay_act_side]++;
    draw_song_line(win, lay_curr_anchor[lay_act_side], TRUE, lay_select_line[lay_act_side]);
    draw_song_status(win, lay_curr_anchor[lay_act_side]);
  }

  if(do_refresh) wrefresh(win);
}

/* go one song up */
void song_move_up(WINDOW *win, BOOL do_refresh)
{
  /* test if there are previous song */
  if(! lay_curr_anchor[lay_act_side]) return;
  if(lay_curr_anchor[lay_act_side]->prev == NULL) return;

  /* select box currently on top? */
  if(lay_select_line[lay_act_side] == 1) {
    /* yes, decrease top-anchor */
    lay_top_anchor[lay_act_side] = lay_top_anchor[lay_act_side]->prev;
    fill_in_side(win, lay_act_side);
  } else {
    /* no, decrease curr-anchor and line (and update) */
    draw_song_line(win, lay_curr_anchor[lay_act_side], FALSE, lay_select_line[lay_act_side]);
    lay_curr_anchor[lay_act_side] = lay_curr_anchor[lay_act_side]->prev;
    lay_select_line[lay_act_side]--;
    draw_song_line(win, lay_curr_anchor[lay_act_side], TRUE, lay_select_line[lay_act_side]);
    draw_song_status(win, lay_curr_anchor[lay_act_side]);
  }

  if(do_refresh) wrefresh(win);
}

/* go to top */
void song_move_top(WINDOW *win, BOOL do_refresh)
{
  if(lay_select_line[lay_act_side] != 1) {
    /* go to top of screen */
    draw_song_line(win, lay_curr_anchor[lay_act_side], FALSE, lay_select_line[lay_act_side]);
    lay_select_line[lay_act_side] = 1;
    lay_curr_anchor[lay_act_side] = lay_top_anchor[lay_act_side];
    draw_song_line(win, lay_curr_anchor[lay_act_side], TRUE, 1);
    draw_song_status(win, lay_curr_anchor[lay_act_side]);
  } else if(lay_top_anchor[lay_act_side] != lay_global_anchor[lay_act_side]) {
    lay_top_anchor[lay_act_side] = lay_global_anchor[lay_act_side];
    fill_in_side(win, lay_act_side);
  }

  if(do_refresh) wrefresh(win);
}

/* go to bottom */
void song_move_bottom(WINDOW *win, BOOL do_refresh)
{
  int maxy, maxx;
  
  if(! lay_curr_anchor[lay_act_side]) return;
  if(lay_curr_anchor[lay_act_side]->next == NULL) return;
  
  getmaxyx(win, maxy, maxx);
  if(lay_select_line[lay_act_side] != maxy-9) {
    draw_song_line(win, lay_curr_anchor[lay_act_side], FALSE, lay_select_line[lay_act_side]);
    while(lay_select_line[lay_act_side] != maxy-9) {
      lay_curr_anchor[lay_act_side] = lay_curr_anchor[lay_act_side]->next;
      lay_select_line[lay_act_side]++;
      if(lay_curr_anchor[lay_act_side]->next == NULL) break;
    }
    draw_song_line(win, lay_curr_anchor[lay_act_side], TRUE, lay_select_line[lay_act_side]);
    draw_song_status(win, lay_curr_anchor[lay_act_side]);
  } else {
    while(lay_curr_anchor[lay_act_side]->next != NULL) {
      lay_top_anchor[lay_act_side]  = lay_top_anchor[lay_act_side]->next;
      lay_curr_anchor[lay_act_side] = lay_curr_anchor[lay_act_side]->next;
    }
    fill_in_side(win, lay_act_side);
  }

  if(do_refresh) wrefresh(win);
}

/* page up */
void song_move_pup(WINDOW *win, BOOL do_refresh)
{
  int i;
  int maxy, maxx;
  
  if(! lay_top_anchor[lay_act_side]) return;
  
  /* entry on top is top-entry?  ;-) */
  if(lay_top_anchor[lay_act_side]->prev == NULL) {
    /* only useful if select box isn't also on top */
    if(lay_select_line[lay_act_side] != 1) {
      song_move_top(win, do_refresh);
    }
    return;
  }
  
  getmaxyx(win, maxy, maxx);

  /* must go up maxy-9 positions */
  for(i=0;i<maxy-9;i++) {
    if(lay_top_anchor[lay_act_side]->prev != NULL)
      lay_top_anchor[lay_act_side] = lay_top_anchor[lay_act_side]->prev;
    else if(lay_select_line[lay_act_side] == 1) break;
    else
      lay_select_line[lay_act_side]--;
  }

  fill_in_side(win, lay_act_side);

  if(do_refresh) wrefresh(win);
}

/* page down */
void song_move_pdown(WINDOW *win, BOOL do_refresh)
{
  int i, maxy, maxx;
  BOOL fill;

  if(! lay_curr_anchor[lay_act_side]) return;
  
  /* if there are no next songs -> bye */
  if(lay_curr_anchor[lay_act_side]->next == NULL) return;
  
  fill = FALSE;
  getmaxyx(win, maxy, maxx);
  draw_song_line(win, lay_curr_anchor[lay_act_side], FALSE, lay_select_line[lay_act_side]);
  
  /* go down maxy-9 positions */
  for(i=0;i<maxy-9;i++) {
    if(lay_curr_anchor[lay_act_side]->next == NULL) break;
    /* if select box isn't on bottom */
    if(lay_select_line[lay_act_side] != maxy-9) {
      lay_curr_anchor[lay_act_side] = lay_curr_anchor[lay_act_side]->next;
      lay_select_line[lay_act_side]++;
    } else {
      fill = TRUE;
      lay_top_anchor[lay_act_side]  = lay_top_anchor[lay_act_side]->next;
      lay_curr_anchor[lay_act_side] = lay_curr_anchor[lay_act_side]->next;
    }
  }
  
  if(! fill) {
    /* its enough to mark line */
    draw_song_line(win, lay_curr_anchor[lay_act_side], TRUE, lay_select_line[lay_act_side]);
    draw_song_status(win, lay_curr_anchor[lay_act_side]);
  } else {
    /* must refill entries */
    fill_in_side(win, lay_act_side);
  }

  if(do_refresh) wrefresh(win);
}

