/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.output;

import base.drawable.Category;
import base.drawable.Composite;
import base.drawable.Drawable;
import base.drawable.Kind;
import base.drawable.Primitive;
import base.drawable.Topology;
import java.util.Date;
import java.util.HashMap;
import logformat.slog2.CategoryMap;
import logformat.slog2.LineIDMap;
import logformat.slog2.LineIDMapList;
import logformat.slog2.TraceName;
import logformat.slog2.output.OutputLog;
import logformat.slog2.output.TreeTrunk;
import logformat.trace.InputLog;

public class TraceToSlog2 {
    private static short num_children_per_node;
    private static int leaf_bytesize;
    private static String trace_filespec;
    private static String slog_filename;
    private static boolean enable_endtime_check;
    private static boolean continue_when_violation;
    private static String help_msg;

    public static final void main(String[] stringArray) {
        Kind kind;
        double d = Double.NEGATIVE_INFINITY;
        long l = Integer.MIN_VALUE;
        Drawable drawable = null;
        slog_filename = null;
        TraceToSlog2.parseCmdLineArgs(stringArray);
        if (slog_filename == null) {
            slog_filename = TraceName.getDefaultSLOG2Name(trace_filespec);
        }
        CategoryMap categoryMap = new CategoryMap();
        HashMap<Topology, Category> hashMap = new HashMap<Topology, Category>();
        LineIDMapList lineIDMapList = new LineIDMapList();
        long l2 = 0L;
        Date date = new Date();
        InputLog inputLog = new InputLog(trace_filespec);
        OutputLog outputLog = new OutputLog(slog_filename);
        if (leaf_bytesize > 0) {
            outputLog.setTreeLeafByteSize(leaf_bytesize);
        }
        if (num_children_per_node > 0) {
            outputLog.setNumChildrenPerNode(num_children_per_node);
        }
        TreeTrunk treeTrunk = new TreeTrunk(outputLog, hashMap);
        Date date2 = new Date();
        while ((kind = inputLog.peekNextKind()) != Kind.EOF) {
            double d2;
            Category category;
            if (kind == Kind.TOPOLOGY) {
                Topology topology = inputLog.getNextTopology();
                category = inputLog.getShadowCategoryForTopology(topology);
                categoryMap.put(new Integer(category.getIndex()), category);
                hashMap.put(topology, category);
                continue;
            }
            if (kind == Kind.YCOORDMAP) {
                LineIDMap lineIDMap = new LineIDMap(inputLog.getNextYCoordMap());
                lineIDMapList.add(lineIDMap);
                continue;
            }
            if (kind == Kind.CATEGORY) {
                category = inputLog.getNextCategory();
                categoryMap.put(new Integer(category.getIndex()), category);
                continue;
            }
            if (kind == Kind.PRIMITIVE) {
                Primitive primitive = inputLog.getNextPrimitive();
                primitive.resolveCategory(categoryMap);
                ++l2;
                if (enable_endtime_check) {
                    if (!primitive.isTimeOrdered()) {
                        System.out.println("**** Primitive Time Error ****");
                        if (!continue_when_violation) {
                            System.exit(1);
                        }
                    }
                    if (d > (d2 = primitive.getLatestTime())) {
                        System.err.println("**** Violation of Increasing Endtime Order ****\n\t Offended Drawable -> " + l + " : " + drawable + "\n" + "\t Offending Primitive -> " + l2 + " : " + primitive + "\n" + "   previous drawable endtime ( " + d + " ) " + " > current drawable endtiime ( " + d2 + " ) ");
                        if (!continue_when_violation) {
                            System.exit(1);
                        }
                    }
                    l = l2;
                    drawable = primitive;
                    d = d2;
                }
                treeTrunk.addDrawable(primitive);
                continue;
            }
            if (kind == Kind.COMPOSITE) {
                Composite composite = inputLog.getNextComposite();
                composite.resolveCategory(categoryMap);
                ++l2;
                if (enable_endtime_check) {
                    if (!composite.isTimeOrdered()) {
                        System.out.println("**** Composite Time Error ****");
                        if (!continue_when_violation) {
                            System.exit(1);
                        }
                    }
                    if (d > (d2 = composite.getLatestTime())) {
                        System.err.println("***** Violation of Increasing Endtime Order! *****\n\t Offended Drawable -> " + l + " : " + drawable + "\n" + "\t Offending Composite -> " + l2 + " : " + composite + "\n" + "   previous drawable endtime ( " + d + " ) " + " > current drawable endtiime ( " + d2 + " ) ");
                        if (!continue_when_violation) {
                            System.exit(1);
                        }
                    }
                    l = l2;
                    drawable = composite;
                    d = d2;
                }
                treeTrunk.addDrawable(composite);
                continue;
            }
            System.err.println("TraceToSlog2: Unrecognized return from peekNextKind() = " + kind);
        }
        treeTrunk.flushToFile();
        categoryMap.removeUnusedCategories();
        outputLog.writeCategoryMap(categoryMap);
        lineIDMapList.add(treeTrunk.getIdentityLineIDMap());
        outputLog.writeLineIDMapList(lineIDMapList);
        outputLog.close();
        inputLog.close();
        Date date3 = new Date();
        System.out.println("\n");
        System.out.println("Number of Drawables = " + l2);
        System.out.println("timeElapsed between 1 & 2 = " + (date2.getTime() - date.getTime()) + " msec");
        System.out.println("timeElapsed between 2 & 3 = " + (date3.getTime() - date2.getTime()) + " msec");
    }

    private static int parseByteSize(String string) {
        int n = Math.max(string.indexOf(107), string.indexOf(75));
        int n2 = Math.max(string.indexOf(109), string.indexOf(77));
        if (n > 0) {
            return Integer.parseInt(string.substring(0, n)) * 1024;
        }
        if (n2 > 0) {
            return Integer.parseInt(string.substring(0, n2)) * 1024 * 1024;
        }
        return Integer.parseInt(string);
    }

    private static void parseCmdLineArgs(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        enable_endtime_check = false;
        continue_when_violation = false;
        int n = 0;
        try {
            while (n < stringArray.length) {
                if (stringArray[n].startsWith("-")) {
                    String string;
                    if (stringArray[n].equals("-h") || stringArray[n].equals("--h") || stringArray[n].equals("-help") || stringArray[n].equals("--help")) {
                        System.out.println(help_msg);
                        stringBuffer2.append("-h ");
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-tc")) {
                        enable_endtime_check = true;
                        continue_when_violation = false;
                        stringBuffer.append("\n endtime_order_check_exit = true");
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-tcc")) {
                        enable_endtime_check = true;
                        continue_when_violation = true;
                        stringBuffer.append("\n endtime_order_check_stay = true");
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-nc")) {
                        string = stringArray[++n];
                        num_children_per_node = Short.parseShort(string);
                        stringBuffer.append("\n number_of_children_per_node = " + string);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-ls")) {
                        string = stringArray[++n];
                        leaf_bytesize = TraceToSlog2.parseByteSize(string);
                        stringBuffer.append("\n max_byte_size_of_leaf_node = " + string);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-o")) {
                        slog_filename = stringArray[++n].trim();
                        stringBuffer.append("\n output_filename = " + slog_filename);
                        ++n;
                        if (slog_filename.endsWith(".slog2")) continue;
                        System.err.println("Warning: The suffix of the output filename is NOT \".slog2\".");
                        continue;
                    }
                    stringBuffer2.append(stringArray[n] + " ");
                    ++n;
                    continue;
                }
                stringBuffer2.append(stringArray[n] + " ");
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (stringBuffer.length() > 0) {
                System.err.println(stringBuffer.toString());
            }
            System.err.println("Error occurs after option " + stringArray[n - 1] + ", " + TraceToSlog2.indexOrderStr(n) + " command line argument.");
            arrayIndexOutOfBoundsException.printStackTrace();
        }
        catch (NumberFormatException numberFormatException) {
            if (stringBuffer.length() > 0) {
                System.err.println(stringBuffer.toString());
            }
            String string = TraceToSlog2.indexOrderStr(n);
            System.err.println("Error occurs after option " + stringArray[n - 1] + ", " + TraceToSlog2.indexOrderStr(n) + " command line argument.  It needs a number.");
            numberFormatException.printStackTrace();
        }
        trace_filespec = stringBuffer2.toString().trim();
        if (trace_filespec == null) {
            System.err.println("This program needs a TRACE file specification string as part of the command line arguments.");
            System.err.println(help_msg);
            System.exit(1);
        }
    }

    private static String indexOrderStr(int n) {
        switch (n) {
            case 1: {
                return Integer.toString(n) + "st";
            }
            case 2: {
                return Integer.toString(n) + "nd";
            }
            case 3: {
                return Integer.toString(n) + "rd";
            }
        }
        return Integer.toString(n) + "th";
    }

    static {
        System.loadLibrary("TraceInput");
        num_children_per_node = 0;
        leaf_bytesize = 0;
        help_msg = "Usage: java slog2.output.TraceToSlog [options] trace_filename.\n options: \n\t [-h|--h|-help|--help]             \t Display HELP message.\n\t [-tc]                             \t Check increasing endtime order,\n\t                                   \t exit when 1st violation occurs.\n\t [-tcc]                            \t Check increasing endtime order,\n\t                                   \t continue when violations occur.\n\t [-nc number_of_children_per_node] \t Default value is 2.\n\t [-ls max_byte_size_of_leaf_node]  \t Default value is 65536.\n\t [-o output_filename_with_slog2_suffix]\n\n note: \"max_byte_size_of_leaf_node\" can be specified with suffix k, K, m or M,\n       where k or K stands for kilobyte, m or M stands for megabyte.\n       e.g. 64k means 65536 bytes.\n";
    }
}

