// array.c

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

#ifdef __GNUG__
#pragma implementation
#endif
#include "localdefs.h"
#include "array.h"

template <class T>
Array<T>::Array(int cols) : columns(cols) {
	array = new T[cols];
	T temp = 0;
	for(int i=0; i < columns; i++)
		array[i] = temp;
}

template <class T>
const Array<T> &
Array<T>::operator = (const Array<T>& rhs) {
	for(int i=0; i < columns && i < rhs.columns; i++)
		array[i] = rhs.array[i];
	return *this;
}

template <class T>
void
Array<T>::shiftLeft(int spaces) {
	register T *dest = array, *src = array + spaces - 1;
	register T* endPoint = array + columns;
	while(src < endPoint) { *dest++ = *src++; }
}

template <class T>
void
Array<T>::shiftRight(int spaces) {
	register T *dest = array + spaces - 1, *src = array;
	register T* endPoint = array + columns;
	while(dest < endPoint) { *dest++ = *src++; }
}

#if 0

TwoDimensionalArray::TwoDimensionalArray(int rws, int cols) : rows(rws) {
	arrays = new Array *[cols];
	for(int i = 0; i < rows; i++)
		arrays[i] = new Array(cols);
}

TwoDimensionalArray::~TwoDimensionalArray() {
	for(int i = 0; i < rows; i++)
		delete arrays[i];
	delete [] arrays;
}

const TwoDimensionalArray&
TwoDimensionalArray::operator = (const TwoDimensionalArray& rhs) {
	for(int i=0; i < rows && i < rhs.rows; i++)
		*arrays[i] = *rhs.arrays[i];
	return *this;
}

#endif

double **
create2DArray(int rows, int cols) {
	int ptrspace = rows * sizeof(double*);
	int rowspace = rows * sizeof(double);
	addr ptr = new char[(cols*rowspace) + ptrspace];
	double** arr = (double**) ptr;
	for(int row=0; row < rows; row++) {
		arr[row] = (double *) (ptr + ptrspace + (rowspace * row));
	}
	return arr;
}
