// reson.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Wrappers for 2-pole and 2-pole-1-zero recursive filters.

#ifndef RESON_H
#ifdef __GNUG__
#pragma interface
#endif
#define RESON_H

#include "processfun.h"

class ResonFilter : public SimpleFunction {
public:
	void set(double ctrFrq, double bWdth);
	redefined const char* message() { return "Filtering..."; }
protected:
	ResonFilter(Data* output, double fgain, bool needUndo);
	virtual void setCoeffs() = 0;
protected:
	double centerFreq;
	double bandWidth;
	double gain;
};

class Reson3 : public ResonFilter {
	typedef ResonFilter Super;
	friend class Reson3Requester;
public:
	enum GainMode { Unity = 0x1, UnityRMS = 0x2, NoRescale = 0x4 };
	Reson3(Data* output, double ctrFreq, double bWdth, GainMode=UnityRMS);
	Reson3(Data* output);
	redefined Modifier* create(class DataEditor*);
	redefined void operator () (double *input, int count);
	redefined void restoreState() { clear(); }
protected:
	redefined Requester* createRequester();
	redefined void initialize();
	redefined void setCoeffs();
private:
	void clear();
private:
	double coef0, coef1, coef2;
	double past[2];
	ChoiceValue gainMode;
};

class Reson4 : public ResonFilter {
	typedef ResonFilter Super;
public:
	Reson4(Data* output, double centerFreq, double bandWidth);
	redefined void operator () (double *input, int count);
	redefined void restoreState();
protected:
	redefined void initialize();
	redefined void setCoeffs();
private:
	void clear();
private:
	double coef0, coef1, coef2, coef3;
	double inPast[2];
	double outPast[2];
};

#endif

