// test_update_cnf.cpp : Defines the entry point for the console application.
//

#include "stdio.h"
#include "stdlib.h"
#include "myx_admin_public_interface.h"

void print_usage()
{
  printf("usage : test_update_cnf.exe <filename> <group> "
         "<file_gui_description> <version> <platform> <query_file>\n");
}

struct Changed_option_trace
{
  MYX_GUI_WIDGET * widget;
  unsigned char * old_value;
};
Changed_option_trace change_trace[2000];
Changed_option_trace * changed_trace_top= change_trace;
const size_t max_options= sizeof(change_trace)/sizeof(Changed_option_trace);

void change_value(MYX_GUI_DESCRIPTION * description,
                  const char * name, const char *value)
{
  MYX_GUI_PAGE * page= description->pages;
  MYX_GUI_PAGE * pages_end= page + description->pages_num;
  for (; page!=pages_end; page++)
  {
    MYX_GUI_GROUP * group= page->groups;
    MYX_GUI_GROUP * groups_end= group + page->groups_num;
    for (; group!=groups_end; group++)
    {
      MYX_GUI_WIDGET * widget= group->widgets;
      MYX_GUI_WIDGET * widgets_end= widget + group->widgets_num;
      for (; widget!=widgets_end; widget++)
      {
        if (!strcmp((const char*)widget->id,name))
        {
          changed_trace_top->widget= widget;
          changed_trace_top->old_value= widget->value;
          if ((changed_trace_top-change_trace)>max_options)
          {
            fprintf(stderr,"there are too many changed option "
                    "(should be less or equal than %u)\n",max_options);
            exit(-1);
          }
          changed_trace_top++;
          widget->value= (unsigned char*)value;
          widget->active= 1;
          return;
        }
      }
    }
  }
}

void change_options(MYX_GUI_DESCRIPTION * description, const char * filename)
{
  FILE *query_file= fopen(filename,"r");
  if (!query_file)
  {
    fprintf(stderr,"can't open query file \"%s\"\n",filename);
  }
  else
  {
    char name[200];
    char value[200];
    while (fgets(name, sizeof(name), query_file) &&
           fgets(value, sizeof(value), query_file))
    {
      size_t name_len= strlen(name);
      size_t value_len= strlen(value);
      if (name[name_len-1]!='\n' || value[value_len-1]!='\n')
        break;
      name[name_len-1]= 0;
      value[value_len-1]= 0;
      change_value(description,name,strdup(value));
    }
    fclose(query_file);
  }
}

void restore_options(MYX_GUI_DESCRIPTION * description)
{
  for (Changed_option_trace *o= change_trace; o!=changed_trace_top; o++)
  {
    free(o->widget->value);
    o->widget->value= o->old_value;
  }
}

int main(int argc, char* argv[])
{
  if (argc<7)
  {
    print_usage();
  }
  else
  {
    const char * filename= argv[1];
    const char * group= argv[2];
    const char * filename_gui_description= argv[3];
    const char * version= argv[4];
    MYX_ADMIN_LIB_ERROR error_code;
    MYX_PLATFORM platform= (MYX_PLATFORM)atoi(argv[5]);
    MYX_GUI_DESCRIPTION * description=
                             myx_get_gui_description(filename_gui_description,
                                                     version,platform,
                                                     &error_code,0,0);
    if (!description)
    {
      fprintf(stderr,"can't read gui description file \"%s\", error=%d\n",
              filename_gui_description,(int)error_code);
    }
    else
    {
      change_options(description,argv[6]);
      error_code= myx_update_mysql_cnf_file(description,filename,group);
      if (error_code!=MYX_ADMIN_NO_ERROR)
        fprintf(stderr,"update error=%d\n",(int)error_code);
      restore_options(description);
      myx_free_gui_description(description);
    }
  }
	return 0;
}

