/*
 * session-rtp.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1995-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/rtp/session-rtp.h,v 1.13 2002/02/03 04:15:47 lim Exp $
 */

#ifndef mash_sessioh_h
#define mash_sessioh_h

#include "net.h"
#include "rtp.h"
#include "transmitter-rtp.h"
#include "timer.h"

class Source;

class RTP_Session : public RTP_Transmitter, public SessionHandler {
    public:
	RTP_Session();
	virtual ~RTP_Session();
	virtual int command(int argc, const char*const* argv);
	virtual void recv(CtrlHandler*);
	virtual void recv(DataHandler*);
	virtual void announce(CtrlHandler*);
	virtual void send_report(CtrlHandler*, int bye, int app = 0);
	virtual inline void send_bye() { send_report(&ch_[0], 1); }
    protected:
	void demux(pktbuf*, u_int32_t addr);
	virtual int check_format(int fmt) const;
	virtual void transmit(pktbuf* pb);
	virtual void transmit_ctrl(pktbuf* pb);
	int build_bye(rtcphdr* rh, Source& local);
	int build_sdes(rtcphdr* rh, Source& s);
	u_char* build_sdes_item(u_char* p, int code, Source&);

	void parse_sr(rtcphdr* rh, int flags, u_char* ep,
		      Source* ps, u_int32_t addr, int layer);
	void parse_rr(rtcphdr* rh, int flags, u_char* ep,
		      Source* ps, u_int32_t addr, int layer);
	void parse_rr_records(u_int32_t ssrc, rtcp_rr* r, int cnt,
			      const u_char* ep, u_int32_t addr);
	int sdesbody(u_int32_t* p, u_char* ep, Source* ps,
		     u_int32_t addr, u_int32_t ssrc, int layer);
	void parse_sdes(rtcphdr* rh, int flags, u_char* ep, Source* ps,
			u_int32_t addr, u_int32_t ssrc, int layer);
	void parse_bye(rtcphdr* rh, int flags, u_char* ep, Source* ps);
	virtual void parse_app(rtcphdr* rh, int flags, u_char* ep, Source* ps);
	virtual int build_app(rtcphdr* rr, Source& ls, int we_sent);

	int parseopts(const u_char* bp, int cc, u_int32_t addr) const;
	int ckid(const char*, int len);

	u_int32_t alloc_srcid(u_int32_t addr) const;

	DataHandler dh_[NLAYER];
	CtrlHandler ch_[NLAYER];

	/*FIXME cleanup*/
	u_int badversion_;
	u_int badoptions_;
	u_int badfmt_;
	u_int badext_;
	u_int nrunt_;

	u_int32_t last_np_;
	u_int32_t sdes_seq_;

	int confid_;

	BufferPool* pool_;
};

class AudioSession : public RTP_Session {
};

class VideoSession : public RTP_Session {
public:
	VideoSession();
	virtual void parse_app(rtcphdr* rh, int flags, u_char* ep, Source* ps);
	virtual int build_app(rtcphdr* rr, Source& ls, int we_sent);
	virtual void announce(CtrlHandler*);
    protected:
	u_char* build_rtcp_thumbnail(rtcphdr* rr, Source& ls);
	virtual int command(int argc, const char*const* argv);
	int rtcp_thumbnail_;
};


#endif
