# archive-system.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/archive/archive-system.tcl,v 1.18 2002/02/03 04:25:07 lim Exp $


import SessionCatalog ArchiveSession/Record/RTP ArchiveSession/Record/Mediaboard ArchiveSession/Play/RTP
#import ArchiveSession/Record/Mediaboard ArchiveSession/Play/Mediaboard

#
# The core object that defines the public API for
# manipulating the MASH Archive system.  All details
# of the archive system architecture are hidden
# behind this API so that different implementations
# can be re-used across an application base.
#
Class ArchiveSystem
Class ArchiveSystem/Record -superclass ArchiveSystem
Class ArchiveSystem/Play -superclass ArchiveSystem

#
# The archive system constructor.  Initialize an object
# to interact with the archive repository in the file
# system in the directory named by <i>path</i>.
# If this directory does not exist, create it
# and initialize the new archive.
# If it cannot be created, return an error.
#
ArchiveSystem public init {} {
}

ArchiveSystem private check_dir dir {
    if ![file exists $dir] {
	catch "file mkdir $dir"
	if ![file isdirectory $dir] {
	    return "$dir: can't create"
	}
    } elseif ![file isdirectory $dir] {
	return "$dir: not a directory"
    }
    return ""
}

ArchiveSystem/Record private destroy {} {
    $self instvar sessions_
    foreach s $sessions_ {
	delete $s
    }
    $self next
}

#
# Create and open a new module named <i>name</i>
# in the archive system.
# If this module already exists, r1eturn an error.
# Otherwise, returns an empty string.
# If module already exists, overwrites it.
# FIXME should do coarse-grained locking of the
# directory (trivial to implement)
#
ArchiveSystem/Record public open { path module } {
    $self instvar catalog_ module_
    set err [$self check_dir $path]
    if { $err != "" } {
	return $err
    }
    set module_ $path/$module
    set err [$self check_dir $module_]
    if { $err != "" } {
	return $err
    }
    set catalog_ [new SessionCatalog]
    $catalog_ open $module_/cat.ctg w 0644
}

ArchiveSystem/Play public init {} {
	$self instvar sesslist_
	set sesslist_ ""
	$self next
}

ArchiveSystem/Play public open { path module } {
	set module_ $path/$module

	if ![file isdirectory $path] {
		return "$path: no such directory"
	}
	#if ![file isdirectory $module_] {
	#	return "$path/$module: no such module"
	#    }
	$self instvar catalog_
	set catalog_ [new SessionCatalog]
	#$catalog_ open $module_/cat.ctg
	$catalog_ open $module_
	$self scan_catalog
}

ArchiveSystem/Play public open {module} {
	set module_ $module

	if ![file isfile $module_] {
		return "$module_: no such file"
	}
	$self instvar catalog_
	set catalog_ [new SessionCatalog]
	$catalog_ open $module_
	$self scan_catalog
}

ArchiveSystem/Play public query_sessions {} {
	$self instvar sesslist_

	return $sesslist_

}

ArchiveSystem/Play private scan_catalog {} {

    $self instvar catalog_ start_ end_ srcs_ lts_ sesslist_
    catch "unset start_ end_"

    #FIXME why?
    if [catch "$catalog_ read" error] {
	return $error
    }
    #
    # Create a linked list of sources for each session
    # that exists in this archive module
    #
    foreach src [$catalog_ info streams] {
	    set sess [$catalog_ info session $src]
	    lappend srcs_($sess) $src
	    if {[lsearch $sesslist_ $sess]==-1} {
		    lappend sesslist_ [$catalog_ info session $src]
	    }
    }

    #FIXME just one?
    set lts_ [new LTS]
}

# FIXME should work for record too?
# schedule an event in the logical LTS time system
#
ArchiveSystem/Play private at { logical_time cmd } {
    #FIXME assume speed of 1.0
    $self instvar lts_ start_
    set diff [expr $logical_time - ([$lts_ now_logical] - $start_) ]
    if { $diff < 0 } {
	set diff 0
    }
    set ms [expr int(1000 * $diff + 0.5)]
    puts "$logical_time, [$lts_ now_logical], $ms"
    after $ms $cmd
}

#
# how to we precisely name each sub-session within the module?
# FIXME the catalog should return an object for a session and
# we should be able to query its properties (including media
# and protocol) but this info is not in the catalog file format...
#
ArchiveSystem/Play public play_session { spec media } {
    #FIXME why does recorder need media type? timestamped conversion?

    #
    # FIXME hack - because the catalog file doesn't have the media/proto
    # info, infer it from the session name.  also, this hack only
    # works for up to one session per media (i.e., we can't
    # have two separate video sessions in the same archive
    # module in this case)
    #
    $self instvar srcs_
    foreach s [array names srcs_] {
	if { [string first $media $s] >= 0 } {
	    #
	    # found a session of the desired media type
	    # create the playback objects are return
	    #
	    $self create_playback_session $spec $media $s
	    return 1
	}
    }
    return 0
}

ArchiveSystem/Play private destroy {} {
    $self instvar sessions_ streamlist_
    foreach s $sessions_ {
	delete $s
    }
}

#
# Create all of the objects necessary to replay a session stored...
# FIXME  finish comment.
# If an error is encountered, return a string describing the error.
# Otherwise, return an empty string.
#
ArchiveSystem/Play private create_playback_session { spec media sessionTag } {
	$self instvar start_ end_


    #FIXME hack - this info should be in catalog not in data files
    if { $media == "audio" || $media == "video" } {
	set protocol RTP
    } else {
	set protocol Mediaboard
    }
    set session [new ArchiveSession/Play/$protocol $media $spec]
    $self instvar sessions_
    lappend sessions_ $session
    $self instvar srcs_ start_ end_ catalog_ streamlist_

    # FIXME ArchiveFile is really a playback object?
    # (the dual of the recoder object?)
    set file [new ArchiveFile]
    foreach src $srcs_($sessionTag) {
	#FIXME data_hdr and index_hdr should be tcl objects
	set datafile [$catalog_ info datafile $src]
	set indexfile [$catalog_ info indexfile $src]
	if [catch {$file open $datafile} error] {
	    delete $file
	    return "$datafile: can't open"
	}
	if [catch {$file header data_hdr} error] {
	    delete $file
	    return "$datafile: bad header format"
	}
	$file close
	if [catch {$file open $indexfile} error] {
	    delete $file
	    return "$indexfile: can't open"
	}

	if [catch {$file header index_hdr} error] {
	    delete $file
	    return "$indexfile: bad header format"
	}
	$file close

	#FIXME these checks should not be necessary...
	foreach fld "protocol media cname name" {
	    if { $data_hdr($fld) != $index_hdr($fld) } {
		delete $file
		return \
			"data/index attribute mismatch\n\t(attr $fld, data $datafile, index $indexfil)"
	    }
	}

	#
	# Keep track of min start time and max end time
	# across all the archive files.
	#
	if ![info exists start_] {
	    set start_ $data_hdr(start)
	    set end_ $data_hdr(end)
	} else {
	    if { $data_hdr(start) < $start_ } {
		set start_ $data_hdr(start)
	    }
	    if { $data_hdr(end) > $end_ } {
		set end_ $data_hdr(end)
	    }
	}

	# FIXME these are memory leaks.  These need to be
	# accounted for and deleted when the object is deleted.
	set df [new ArchiveFile/Data]
	$df open $datafile
	set if [new ArchiveFile/Index]
	$if open $indexfile

	set stream [$session create_stream]
	$stream datafile $df
	$stream indexfile $if
	# FIXME
	# We use a separate LTS for all streams
	# because the current architecture does not enable
	# temporal manipultation on a stream granularity...
	# This should be fixed and then we can go back to
	# a single lts for all streams.
	$stream lts [new LTS]
	$session attach_stream $stream

	lappend streamlist_ $stream
    }
    # initialize lts
    $self rewind

    return ""
}

# This returns a variety of information about the playback session:
# start timestamp, end timestamp, session list, and media types

#ArchiveSystem/Play public get_info {} {
#	$self instvar start_ end_

#	set session(Start) $start_
#	set session(End) $end_
#	set session(sesslist) $sesslist
#
#	return $session
#}



ArchiveSystem/Play public get_mapping {} {
	$self instvar lts_ start_

	set system [$lts_ now_system]
	set logical [$lts_ now_logical]
	set offset [expr $logical - $start_]

	return "$system $offset"

}

ArchiveSystem/Play public get_start {} {
	$self instvar start_

	return $start_
}

ArchiveSystem/Play public get_end {} {
	$self instvar end_

	return $end_
}

ArchiveSystem/Play public rewind {} {
    $self goto 0
}

ArchiveSystem/Play public goto { t } {
    $self instvar start_ streamlist_ lts_
    $lts_ now_logical [expr $start_ + $t]
    foreach s $streamlist_ {
	[$s lts] now_logical [expr $start_ + $t - [$s set offset_]]
    }
}

ArchiveSystem/Play public start {} {
    $self instvar streamlist_ lts_
    $lts_ speed 1.0
    foreach s $streamlist_ {
	[$s lts] speed 1.0
    }
}

ArchiveSystem/Play public stop {} {
    $self instvar streamlist_ lts_
    $lts_ speed 0.0
    foreach s $streamlist_ {
	[$s lts] speed 0.0
    }
}

ArchiveSystem public close { } {
    $self instvar catalog_
    delete $catalog_
    unset catalog_
}

#
# Arrange to record an RTP session to the currently opened
# archive module.
#
ArchiveSystem public record_rtp_session { spec media tag } {
    #FIXME why does recorder need media type? timestampd conversion?
    set session [new ArchiveSession/Record/RTP $media $spec]
    $self instvar catalog_ module_
    $session catalog $catalog_
    $session save_in $module_
    $session session_id $tag\_$media
    #$session attach_observer $self
    #
    # keep list of sessions so we can tear them down gracefully
    #
    $self instvar sessions_
    lappend sessions_ $session
}

#
# Arrange to record an mediaboard session to the currently opened
# archive module.  FIXME this should only have to know about srm.
#
ArchiveSystem public record_mb_session { spec tag } {
    #FIXME why does recorder need media type? timestampd conversion?
    set session [new ArchiveSession/Record/Mediaboard mediaboard $spec]
    $self instvar catalog_ module_
    $session catalog $catalog_
    $session save_in $module_
    $session session_id $tag\_mb
    #$session attach_observer $self
    #
    # keep list of sessions so we can tear them down gracefully
    #
    $self instvar sessions_
    lappend sessions_ $session
}


#
# Arrange to record all a session's media to the currently opened
# archive module.
#
ArchiveSystem public record_program { program tag } {

    set session_list {}

    # Extract SDP information needed to record.
    set msg [$program base]
    set all_media [$msg set allmedia_]
    set num_media [llength $all_media]
    while { $num_media > 0 } {

	# Find the mediatype.
	set num_media [expr $num_media - 1]
	set media [lindex $all_media $num_media]
	set mediatype [string tolower [$media set mediatype_]]

	# Construct the spec which has the form, addr/port/fmt/ttl
	set fmt [$media set fmt_]
	set addr_and_ttl [split [$media set caddr_] /]
	set addr [lindex $addr_and_ttl 0]
	set ttl [lindex $addr_and_ttl 1]
	set port [$media set port_]
	set spec ""
	append spec $addr "/" $port "/" $fmt "/" $ttl

	# For now, only record audio and video sessions; don't
	# record whiteboard or text sessions because of a
	# smash problem.
	if { $mediatype == "audio" || $mediatype == "video" } {
	    $self record_rtp_session $spec $mediatype $tag
	} else {
		$self record_mb_session $spec $tag
	}
    }
}


#
# This method takes an SDP Program and writes the message information
# to the catalog file.
#
ArchiveSystem public write_announcement { program } {
    $self instvar catalog_
    $catalog_ write_sdp [[$program base] obj2str]
}


ArchiveSystem public write_info { info } {
    $self instvar catalog_
    $catalog_ write_info $info
}
