# DpTcl.tcl --
#
#       OTcl wrapper object for doing TclDP RPC communication.  This wraps
#       around mash-code/lib/tcl/dp-lib.tcl
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#
# Dummy stuff for import.
#

# Make sure dp-lib is loaded.  Previously, we source the file directly,
# which does not always work if we build outside the source directory.
import Dp

Class DpTcl

DpTcl instproc init {} {
}

Class DpServer

DpServer instproc init {port} {

    $self next

    $self instvar server_

    set server_ [dp_MakeRPCServer $port]
}

Class DpClient

DpClient instproc init {host port} {
    $self instvar client_

    $self next

    # set client to be the socket file descriptor
    set client_ [dp_MakeRPCClient $host $port]

    return $client_
}

#
# do an RPC and wait for the result
#
DpClient instproc do { args } {
    $self instvar client_

# this is the old way to do it - it's wrong!
# when you use eval, you will lose the argument groupings if you presubstitute,
#   you should use a list to create the arguments, check below
#    set cmd "dp_RPC $client_"
#    foreach arg $args {
#	set cmd "$cmd $arg"
#    }

    set cmd [list dp_RPC $client_]
    foreach arg $args {
	lappend cmd $arg
    }

    return [eval $cmd]
}

#
# do an RPC that doesn't expect a result, return immediately
#
DpClient instproc doNoWait { args } {

    $self instvar client_

    set cmd [list dp_RDO $client_]
    foreach arg $args {
	lappend cmd $arg
    }

    return [eval $cmd]
}

#
# close the connection by sending a signal to the server
#
DpClient instproc closeRPC {} {
    $self instvar client_

    set cmd "dp_CloseRPC $client_ "

    return [eval $cmd]
}
