# ui-asmon.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/mgamon/ui-asmon.tcl,v 1.9 2002/02/03 04:27:48 lim Exp $


import WidgetClass Icons VcrIcons ScrolledListbox SDPParser PaneManager

WidgetClass ASMonitorUI -default {
	{ *ScrolledListbox*Canvas.relief sunken }
	{ *ScrolledListbox*Canvas.borderWidth 1 }
	{ *ScrolledListbox.scrollbar both }
	{ *ScrolledListbox.bbox.highlightThickness 1 }
	{ *ScrolledListbox.Scrollbar.borderWidth 1 }
	{ *ScrolledListbox.Scrollbar.borderWidth 1 }
	{ *ScrolledListbox.Scrollbar.highlightThickness 1 }
	{ *ScrolledListbox.Scrollbar.width 10 }
	{ *ScrolledListbox*Canvas.width 170 }
	{ *ScrolledListbox*Canvas.height 140 }
	{ *HierarchicalListboxItem.borderWidth 1 }
	{ *HierarchicalListboxItem*font WidgetDefault(-boldfont) }
	{ *Button.borderWidth 1 }
	{ *Button.pady 0 }
}


ASMonitorUI proc.invoke {} {
	$self instvar atype_map_ atype_clr_
	set atype_map_(hm) "Host Managers"
	set atype_map_(srv) "Servents"
	set atype_map_(client) "Clients"
	set atype_map_(all) "All Agents"

	set atype_clr_(hm) blue
	set atype_clr_(srv) red
	set atype_clr_(client) darkgreen
	set atype_clr_(all) black
}

ASMonitorUI public destroy {} {
	$self instvar sdp_ agent_info_ agent_list_ paneMgr_
	delete $sdp_

	foreach name [array names agent_info_] {
		delete $agent_info_($name)
	}

	foreach name [array names agent_list_] {
		delete $agent_list_($name)
	}

	delete $paneMgr_(1)
	delete $paneMgr_(2)
	$self next
}


ASMonitorUI public build_widget {path} {
	$self instvar sdp_
	set sdp_ [new SDPParser]

	global mash
	set toplevel [winfo toplevel $path]
	wm title $toplevel "Active Service Monitor v$mash(version)"
	frame $path.bottom
	label $path.asctrl -text "Control Address: [$self get_option asCtrl]"\
			-anchor w
	button $path.quit -text "Quit" -command "exit" -font \
			[WidgetClass widget_default -boldfont]
	pack $path.asctrl -fill both -expand 1 -anchor w -side left \
			-in $path.bottom
	pack $path.quit -fill y -anchor w -side left -in $path.bottom
	pack $path.bottom -side bottom -fill x

	frame $path.encloser
	frame $path.left_encloser
	ASInfoWindow $path.default_info -relief sunken -borderwidth 1 \
			-width 200
	pack $path.default_info -fill both -expand 1 -side right

	frame $path.lb_frame
	ScrolledListbox $path.agenttypes -itemclass HierarchicalListboxItem \
			-browsecmd "$self select_agent_list"
	#pack $path.agenttypes -fill both -expand 1 -side top \
	#		-in $path.left_frame

	label $path.death_label -text "Send death packet to:" -anchor w
	button $path.death -text "All Agents" -command \
			"$self send_death_pkt" -anchor w
	pack $path.death_label -fill x -side top -anchor w -in $path.lb_frame
	pack $path.death -fill x -side top -in $path.lb_frame

	frame $path.frame
	pack $path.frame -fill both -expand 1 -side top -in $path.lb_frame

	$path.left_encloser configure -width 195 -height 320
	$self set paneMgr_(1) [new PaneManager $path.agenttypes \
			$path.lb_frame -in $path.left_encloser \
			-orient vertical -percent 0.4]

	#set w [expr [winfo reqwidth $path.left_frame] + \
	#		[winfo reqheight $path.default_info] + 4]
	#set h [expr [winfo reqheight $path.left_frame]]
	$path.encloser configure -width 400 -height 320

	pack $path.encloser -side top -fill both -expand 1
	$self set paneMgr_(2) [new PaneManager $path.left_encloser \
			$path.default_info -in $path.encloser \
			-orient horizontal -percent 0.4]
	$self agent_list hm ""
	$self agent_list srv ""
	$self agent_list client ""
	$self agent_list all ""

	$self instvar agentlists_
	$agentlists_(all) browse_me
	$path.agenttypes selection set -id all

	set o [$self get_option doLog]
	if { $o != "" } {
		$self instvar log_
		foreach a [split $o :] {
			set log_($a) 1
		}
	}
}


ASMonitorUI public application {a} {
	$self set appl_ $a
}


ASMonitorUI private send_death_pkt {} {
	$self instvar appl_

	set l [$self info path].agenttypes
	set sel [lindex [$l selection get] 0]
	if {$sel != {}} {
		set sel [split $sel ,]
		set atype [lindex $sel 0]
		set srv_name [lindex $sel 1]

		if { $atype != "client" } {
			if { [string match "MeGa*" $srv_name] } {
				set srv_name [string range $srv_name 6 end]
				$appl_ build_death $srv_name
			} elseif { $atype=="srv" } {
				if { $srv_name!="" } {
					$appl_ build_death srv
				} else {
					foreach m {audio video sdp mb srv} {
						$appl_ build_death $m
					}
				}
			} elseif { $atype=="hm" } {
				$appl_ build_death hm
			} elseif { $atype=="all" } {
				foreach m {audio video sdp mb hm srv} {
					$appl_ build_death $m
				}
			}
		}
	}
}


ASMonitorUI private select_agent_list {id} {
	$self instvar agentlists_
	if [info exists agentlists_($id)] {
		$agentlists_($id) browse_me
	}

	# update the death button
	set button [$self subwidget death]
	if [string match "client*" $id] {
		# disable the death button
		$button configure -state disabled -text "Client"
	} else {
		switch -exact -- $id {
			hm { set text "All Host Managers" }
			srv { set text "All Servents" }
			all { set text "All Agents" }
			default {
				if [string match "srv,MeGa: *" $id] {
					set text [string tolower [string range\
							$id 10 end]]
					set text "[string toupper [string \
							index $text 0]][string\
							range $text 1 end]\
							Agents"
				} else {
					set text "All Non-MeGa Agents"
				}
			}
		}
		$button configure -state normal -text $text
	}
}


ASMonitorUI public recv_msg {atype aspec addr srv_name srv_loc srv_inst \
		ssg_port agent_data delta} {
	$self instvar sdp_
	if {$srv_name=="MeGa"} {
		set sdp [$sdp_ parse $agent_data]
		set media [lindex [$sdp set allmedia_] 0]
		if { $media == "" } {return}
		set qualified_srv_name "$srv_name: [$media set mediatype_]"
	} else {
		set qualified_srv_name $srv_name
		set sdp ""
	}

	set a [$self agent_info $aspec $atype $qualified_srv_name]
	$a update $atype $aspec $addr $qualified_srv_name $srv_loc $srv_inst \
			$ssg_port $agent_data $sdp $delta
	if {$srv_name=="MeGa"} {
		delete $sdp
	}
}


ASMonitorUI public register {atype aspec addr srv_name srv_inst agent_data} {
	$self recv_msg $atype $aspec $addr $srv_name "" $srv_inst - \
			$agent_data ""
	$self instvar log_
	if [info exists log_($atype)] {
		puts "register: [gettimeofday] + $aspec $atype\
				$qualified_srv_name $addr"
	}
}


ASMonitorUI public unregister {atype aspec addr srv_name srv_inst agent_data} {
	$self instvar sdp_
	if {$srv_name=="MeGa"} {
		set agent_data [$sdp_ parse $agent_data]
		set media [lindex [$agent_data set allmedia_] 0]
		if { $media == "" } {
			delete $agent_data
			return
		}
		append srv_name ": [$media set mediatype_]"
		delete $agent_data
	}

	set a [$self agent_info $aspec $atype $srv_name]
	delete $a

	$self instvar log_
	if [info exists log_($atype)] {
		puts "unregister: [gettimeofday] + $aspec $atype\
				$srv_name $addr"
	}
}


ASMonitorUI public agent_info {aspec atype srv_name} {
	$self instvar agent_info_
	if ![info exists agent_info_($aspec)] {
		set agent_info_($aspec) [new ASAgentInfo $self $aspec $atype \
				$srv_name]
	}
	return $agent_info_($aspec)
}


ASMonitorUI public agent_list {atype srv_name} {
	$self instvar agent_list_

	if ![info exists agent_list_($atype,$srv_name)] {
		set agent_list_($atype,$srv_name) [new ASAgentList $self \
				$atype $srv_name]
	}

	return $agent_list_($atype,$srv_name)
}


Class ASAgentInfo

ASAgentInfo public init {ui aspec atype srv_name} {
	$self next
	$self instvar name_ ui_ windows_

	ASMonitorUI instvar atype_clr_
	set windows_ {}
	set ui_ $ui
	set name_(aspec) $aspec
	set name_(atype) $atype
	set name_(srv_name) $srv_name
	set list [$ui agent_list $atype $srv_name]
	$list insert $self $aspec $atype_clr_($atype)

	set glist [$ui agent_list $atype ""]
	if { $glist != $list } {
		$glist insert $self "$srv_name: $aspec" $atype_clr_($atype)
	}

	set glist [$ui agent_list all ""]
	if { $srv_name!={} } {
		set label "${srv_name}($atype): $aspec"
	} else { set label "$atype: $aspec" }
	$glist insert $self $label $atype_clr_($atype)

	# if no agent has been selected, select this one for detailed info
	if { [$ui_ subwidget default_info current]=={} } {
		$glist browse_agent $self
	}
}


ASAgentInfo public destroy {} {
	$self instvar ui_ name_ windows_ name_

	if { [lsearch $windows_ [$ui_ subwidget default_info info self]]!=-1} {
		$ui_ subwidget default_info attach {}
	}

	set list [$ui_ agent_list $name_(atype) $name_(srv_name)]
	$list delete $self

	if { $name_(srv_name)!={} } {
		if [$list is_empty] {
			delete $list
		}
	}

	set glist [$ui_ agent_list $name_(atype) ""]
	if { $glist != $list } {
		$glist delete $self
	}

	set glist [$ui_ agent_list all ""]
	$glist delete $self

	$ui_ instvar agent_info_
	unset agent_info_($name_(aspec))

	$self next
}


ASAgentInfo public attach {window} {
	$self instvar windows_
	lappend windows_ $window
}


ASAgentInfo public detach {window} {
	$self instvar windows_
	set idx [lsearch -exact $windows_ $window]
	if { $idx!=-1 } { set windows_ [lreplace $windows_ $idx $idx] }
}


ASAgentInfo public update {atype aspec addr srv_name srv_loc srv_inst ssg_port\
		agent_data sdp delta} {
	$self instvar fields_ prv_fields_

	# don't change atype aspec and srv_name
	set fields_(srv_loc) $srv_loc
	set fields_(srv_inst) $srv_inst
	set fields_(ssg_port) $ssg_port
	set fields_(agent_data) $agent_data
	set fields_(delta) $delta
	set fields_(last_heard) [gettimeofday ascii]
	set fields_(heard_from) $addr

	if { $sdp=={} } {
		set fields_(sdp) 0
	} else {
		set fields_(sdp) 1

		if { $atype=="srv" } {
			set prv_fields_(o) [join [$sdp field_value o] :]
			set prv_fields_(s) [join [$sdp field_value s] :]
			set prv_fields_(toolname) [$sdp attr_value tool]

			set prv_fields_(sessions) ""
			foreach media [$sdp set allmedia_] {
				set tmp [split [$media set caddr_] /]
				set caddr [lindex $tmp 0]/[$media set \
						port_]/[lindex $tmp 1]
				append prv_fields_(sessions) "\n$caddr"
			}
			set prv_fields_(sessions) [string range \
					$prv_fields_(sessions) 1 end]
		} elseif { $atype=="client" } {
			set prv_fields_(o) [join [$sdp field_value o] :]
			set prv_fields_(s) [join [$sdp field_value s] :]
			set prv_fields_(toolname) [$sdp attr_value tool]
			set prv_fields_(global) [$sdp set caddr_]
			set prv_fields_(local) [[$sdp set allmedia_] set \
					caddr_]

			set prv_fields_(bw) ""
			if [$sdp have_field b] {
				set bwval [$sdp set bwval_]
				set bwval [$self format_bps $bwval]
				set prv_fields_(bw) $bwval
			}
		}
	}

	$self instvar windows_
	foreach w $windows_ {
		$w update
	}
}


ASAgentInfo private format_bps b {
	set bps $b
	if { $bps < 1 } {
		set bps "0 bps"
	} elseif { $bps < 1000 } {
		set bps [format "%3.0f bps" $bps]
	} elseif { $bps < 1000000 } {
		set bps [format "%3.0f kb/s" [expr $bps / 1000.]]
	} else {
		set bps [format "%.1f Mb/s" [expr $bps / 1000000.]]
	}
	return $bps
}


Class ASAgentList
ASAgentList public init {ui atype srv_name} {
	$self next
	$self instvar widget_ ui_ agentlists_id_
	$ui instvar agentlists_

	set n [ASMonitorUI set atype_map_($atype)]
	set clr [ASMonitorUI set atype_clr_($atype)]
	if { $srv_name != "" } {
		append n "/$srv_name"
		$ui subwidget agenttypes insert after -id $atype \
				[list -id $atype,$srv_name {} $n]
		set agentlists_($atype,$srv_name) $self
		set agentlists_id_ $atype,$srv_name
	} else {
		$ui subwidget agenttypes insert end [list -id $atype \
				Icons(minimize) $n]
		set agentlists_($atype) $self
		set agentlists_id_ $atype
	}
	set w [$ui subwidget agenttypes info widget -id $agentlists_id_]
	$w configure -normalforeground $clr -selectforeground $clr

	set ui_ $ui
	option add *agentlist$self*borderWidth 1
	#option add *agentlist$self*font [WidgetClass widget_default -font]
	set widget_ [ScrolledListbox [$ui info path].agentlist$self -options \
			{ { bbox.height 140 } } \
			-browsecmd "$self browse_agent" \
			-command "$self browse_agent_new_window"]
}


ASAgentList public destroy {} {
	$self instvar ui_ agentlists_id_
	$ui_ instvar agent_list_
	unset agent_list_($agentlists_id_)

	$ui_ subwidget agenttypes delete -id $agentlists_id_
	$self next
}


ASAgentList public insert {info label clr} {
	$self instvar widget_
	$widget_ insert end "-id $info $label"
	set w [$widget_ info widget -id $info]
	$w configure -normalforeground $clr -selectforeground $clr
}


ASAgentList public delete {info} {
	$self instvar widget_
	$widget_ delete -id $info
}


ASAgentList public is_empty {} {
	$self instvar widget_
	if { [$widget_ info numelems] <= 0 } { return 1 } else { return 0 }
}


ASAgentList public browse_me { } {
	$self instvar ui_ widget_
	pack forget [pack slaves [$ui_ info path].frame]
	pack $widget_ -in [$ui_ info path].frame -fill both -expand 1

	if { [$widget_ info numelems] > 0 } {
		$self browse_agent [$widget_ info id 0]
	}
}


ASAgentList public browse_agent {id} {
	$self instvar widget_ ui_
	if { [lindex [$widget_ selection get] 0] != $id } {
		$widget_ selection set -id $id
	}

	$ui_ subwidget default_info attach $id $self
}


ASAgentList public browse_agent_new_window {id} {
	$self instvar widget_

	# create a new toplevel only if one doesn't already exist
	set w .agent_info_$id
	if [winfo exists $w] {
		wm deiconify $w
		return
	}

	$id instvar name_
	toplevel $w
	wm title $w "Agent Info: $name_(aspec) ($name_(atype):\
			$name_(srv_name))"
	ASInfoWindow $w.info
	pack $w.info -side top -fill both -expand 1
	button $w.dismiss -bd 1 -pady 0 -text "Dismiss" \
			-command "destroy $w"
	pack $w.dismiss -side right
	$w.info attach $id
	after "2000" delete $id
}


WidgetClass ASInfoWindow -default {
	{ *ScrolledWindow*Canvas.width 200 }
	{ *ScrolledWindow.scrollbar both }
	{ *ScrolledWindow.bbox.highlightThickness 1 }
	{ *ScrolledWindow.Scrollbar.borderWidth 1 }
	{ *ScrolledWindow.Scrollbar.borderWidth 1 }
	{ *ScrolledWindow.Scrollbar.highlightThickness 1 }
	{ *ScrolledWindow.Scrollbar.width 10 }
}


ASInfoWindow proc.invoke {} {
	$self instvar labels_
	set labels_(srv_loc)      "Service location"
	set labels_(srv_inst)     "Service instance"
	set labels_(ssg_port)     "SSG port"
	set labels_(last_heard)   "Last heard"
	set labels_(heard_from)   "Heard from"
	set labels_(delta)        "Delta"
	set labels_(agent_data)   "Agent data"
	set labels_(o)            "Agent ID"
	set labels_(s)            "Session ID"
	set labels_(toolname)     "Tool"
	set labels_(sessions)     "Sessions"
	set labels_(global)       "Global addr"
	set labels_(local)        "Local addr"
	set labels_(bw)           "Bandwidth"
}


ASInfoWindow public build_widget path {
	ScrolledWindow $path.scroll
	pack $path.scroll -fill both -expand 1

	set path [$path.scroll subwidget window]
	label $path.name -bd 1 -relief sunken -anchor w -foreground \
			[WidgetClass widget_default -disabledforeground] \
			-text "No agent exists"
	pack $path.name -fill x -side top
	frame $path.labels
	frame $path.values

	$self create_label srv_loc
	$self create_label srv_inst
	$self create_label ssg_port
	$self create_label last_heard
	$self create_label heard_from
	$self create_label delta
	$self create_label agent_data

	pack $path.labels -side left -anchor n
	pack $path.values -fill x -expand 1 -side left -anchor n
}


ASInfoWindow public destroy {} {
	$self instvar obj_
	if {[info exists obj_] && [ASAgentInfo info instances $obj_]==$obj_} {
		$obj_ detach $self
	}
	$self next
}


ASInfoWindow public create_label { name {after_id {}} } {
	ASInfoWindow instvar labels_
	set path [[$self info path].scroll subwidget window]
	label $path.labels.$name -text "$labels_($name):" -anchor w \
			-justify left -font [WidgetClass widget_default -font]
	label $path.$name -anchor w -justify left \
			-font [WidgetClass widget_default -font]
	if { $after_id=={} } {
		pack $path.labels.$name -fill x -anchor n -expand 1
		pack $path.$name -in $path.values -fill x -anchor n -expand 1
	} else {
		pack $path.labels.$name -fill x -anchor n -expand 1 \
				-before $path.labels.$after_id
		pack $path.$name -in $path.values -fill x -anchor n -expand 1\
				-before $path.$after_id
	}
}


ASInfoWindow public current {} {
	$self instvar obj_
	if [info exists obj_] { return $obj_ }  else { return {} }
}


ASInfoWindow public attach {obj {list {}}} {
	$self instvar obj_ list_
	if { [info exists list_] && $list_!={} && ($list_!=$list || \
			$obj_!=$obj) } {
		if { $list_!=$list } { [$list_ set widget_] selection clear }

		$obj_ instvar prv_fields_
		set path [[$self info path].scroll subwidget window]
		foreach name [array names prv_fields_] {
			if [winfo exists $path.$name] {
				destroy $path.labels.$name
				destroy $path.$name
			}
		}
	}
	if [info exists obj_] { $obj_ detach $self }

	if { $obj=={} } {
		set path [[$self info path].scroll subwidget window]
		$path.name configure -text "No agent exists" -foreground \
				[WidgetClass widget_default \
				-disabledforeground]
		$obj_ instvar fields_
		foreach name  [array names fields_] {
			if [winfo exists $path.$name] {
				$path.$name configure -text ""
			}
		}
		unset obj_
		unset list_
	} else {
		$obj attach $self
		set obj_ $obj
		set list_ $list

		$self update
	}
}


ASInfoWindow public update {} {
	$self instvar obj_
	$obj_ instvar name_ fields_ prv_fields_

	set path [$self info path]
	set path [$path.scroll subwidget window]
	if { $name_(srv_name)!={} } {
		set text "$name_(srv_name)($name_(atype)): $name_(aspec)"
	} else {
		set text "$name_(atype): $name_(aspec)"
	}
	$path.name configure -text $text -foreground \
			[ASMonitorUI set atype_clr_($name_(atype))]
	foreach name [array names fields_] {
		if [winfo exists $path.$name] {
			$path.$name configure -text $fields_($name)
		}
	}

	foreach name [array names prv_fields_] {
		if ![winfo exists $path.$name] {
			$self create_label $name delta
		}
		$path.$name configure -text $prv_fields_($name)
	}
}
