/*
 * BidderHouse.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 2001-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef BIDDERHOUSE_H
#define BIDDERHOUSE_H

#define BID_INTERVAL	33 	// how often to have a bid (in ms).
#define UPDATE_INTERVAL	1000 	// how often to have a bid (in ms).
#define MAX_STREAMS	10  	// max number of streams to handle.
#define MAX_BW_SECONDS	2	// max amount of saved bw (in bytes).
#define WAGE_FACTOR	1000	// inflate the wages so we don't have to worry about precision loss.
#define MAX_SAVED_MONEY	MAX_BW_SECONDS*(1000/BID_INTERVAL)*100*WAGE_FACTOR	// max amount of saved bw (in bytes).
#include <vector>
#include "tclcl.h"

#if __GNUC__ >= 3 || _MSC_VER
using namespace std;
#endif

class PipeRenderer;

class Bidder {
public:
  Bidder(int m, int w, int dw, int ds, int bw, PipeRenderer* ms): money(m), wage(w), diffsWant(dw), diffSize(ds), bandwidth(bw), msource(ms) { ;};

  int money;		// accumulated wealth of the source
  int wage;		// its income (based on slider)
  int diffsWant;	// how many diffs it wants to send
  int diffSize;		// average size of a diff, in bytes
  int bandwidth;	// bandwidth that this source is using in bps.
  PipeRenderer* msource;// link to the renderer.
};

class BidderHouse : public TclObject {
public:
  BidderHouse(int bw): bps(bw), bytesToSend(0) { ;};

  void addSource(PipeRenderer* msource);
  void setDiffCount(PipeRenderer* msource, int diffCount, int meanDiffSize);
  Bidder* lookupSource(PipeRenderer* msource);
  void giveBWtoSource(Bidder* source, int price);
  void lotterySort(int num_of_sources);
  void sellBandwidth();
  int  command(int argc, const char*const* argv);
  void getBandwidthUsage();
  void setPriority(PipeRenderer* msource, int percentage);
private:
  int bps;		// bits per second for the aggregate outgoing bw
  int bytesToSend;	// amount of bandwidth that is available to use now.
  vector<Bidder*> sources;
  Bidder* lottery_source[MAX_STREAMS]; 	// these three arrays are used to sort
  int lottery_units[MAX_STREAMS];	// and find the highest bidder
  int lottery_price[MAX_STREAMS];
};

#endif

