/*
 * combiner.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 2001-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _COMBINER_H
#define _COMBINER_H
#include <string.h>
#include "tclcl.h"
#include "renderer.h"

// this is a simple class for a list node...
class CombinerSourceNode {
public:
  CombinerSourceNode(char* s, int pos);
  char source[5]; 	// name of the source
  int pos;		// position of the source in the destination frame
  int width;		// its width (in pixels)
  int height;		// its height (in pixels)
  CombinerSourceNode* next; // the next node in the list
};

// this is the class that takes multiple streams as input and then
// combines them into one stream to hand off to a real encoder...
class Combiner : public TclObject {
public:
  Combiner();
  ~Combiner();
  int command(int argc, const char*const* argv);
  void recv(Buffer* b, char* source, int colorModel);
protected:
  Renderer* destination;	// the real encoder that we output to
  int width;			// the combined frame's width
  int height;			// the combined frame's height
  CombinerSourceNode* sources;	// list of all the sources.
  YuvFrame* frame_;		// our combined frame.
  u_int8_t* frame_data_;	// the data for our combined frame
};

// this is the Renderer class that receives one frame and then hands
// it off to the combiner. We need this to give a source name to
// each frame given to Combiner
class CombinerSource : public Renderer {
public:
  CombinerSource(Combiner* destination, const char* src, int color);
  void setcolor(int x) {};
  void recv(Buffer* b, int, int) {recv(b);};
  void recv(Buffer* b);
protected:
  Combiner* dest; 	// the combiner that we output to
  char src[10];		// the name of the source
  int colorModel;	// the colorModel of this source
};

#endif
